/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.classfile;

import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantNameAndType
extends Constant {
    private int name_index;
    private int signature_index;

    public ConstantNameAndType(int name_index, int signature_index) {
        super((byte)12);
        this.name_index = name_index;
        this.signature_index = signature_index;
    }

    public ConstantNameAndType(ConstantNameAndType c) {
        this(c.getNameIndex(), c.getSignatureIndex());
    }

    ConstantNameAndType(DataInputStream file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public void accept(Visitor v) {
        v.visitConstantNameAndType(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeShort(this.name_index);
        file.writeShort(this.signature_index);
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    public final void setSignatureIndex(int signature_index) {
        this.signature_index = signature_index;
    }

    public final String toString() {
        return String.valueOf(super.toString()) + "(name_index = " + this.name_index + ", signature_index = " + this.signature_index + ")";
    }
}

