/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.Constant;
import de.fub.bytecode.classfile.ConstantClass;
import de.fub.bytecode.classfile.ConstantPool;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.Type;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class CPInstruction
extends Instruction
implements Constants {
    protected int index;

    CPInstruction() {
    }

    protected CPInstruction(short tag, int index) {
        super(tag, (short)3);
        this.setIndex(index);
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.tag);
        out.writeShort(this.index);
    }

    public final int getIndex() {
        return this.index;
    }

    public Type getType(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        String name = cp.getConstantString(this.index, (byte)7);
        if (!name.startsWith("[")) {
            name = "L" + name + ";";
        }
        return Type.getType(name);
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.setIndex(bytes.readUnsignedShort());
        this.length = (short)3;
    }

    public void setIndex(int index) {
        if (index < 0) {
            throw new ClassGenException("Negative index value: " + index);
        }
        this.index = index;
    }

    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        String str = cp.constantToString(c);
        if (c instanceof ConstantClass) {
            str = str.replace('.', '/');
        }
        return String.valueOf(Constants.OPCODE_NAMES[this.tag]) + " " + str;
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + this.index;
    }
}

