/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.AccessFlags;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.ConstantValue;
import de.fub.bytecode.classfile.Field;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.Type;
import java.util.Vector;

public class FieldGen
extends AccessFlags
implements Constants {
    private Type type;
    private String name;
    private ConstantPoolGen cp;
    private int index = -1;
    private Vector attributes;

    public FieldGen(int access_flags, Type type, String name, ConstantPoolGen cp) {
        this.access_flags = access_flags;
        this.type = type;
        this.name = name;
        this.cp = cp;
    }

    public FieldGen(Field field, ConstantPoolGen cp) {
        this(field.getAccessFlags(), Type.getType(field.getSignature()), field.getName(), cp);
    }

    public void addAttribute(Attribute attr) {
        if (this.attributes == null) {
            this.attributes = new Vector();
        }
        this.attributes.addElement(attr);
    }

    public Attribute[] getAttributes() {
        if (this.attributes != null) {
            Object[] attrs = new Attribute[this.attributes.size()];
            this.attributes.copyInto(attrs);
            return attrs;
        }
        return null;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public Field getField() {
        String signature = this.type.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        if (this.index > 0) {
            if (this.isStatic()) {
                this.addAttribute(new ConstantValue(this.cp.addUtf8("ConstantValue"), 2, this.index, this.cp.getConstantPool()));
            } else {
                throw new ClassGenException("Only static fields may have an initial value!");
            }
        }
        return new Field(this.access_flags, name_index, signature_index, this.getAttributes(), this.cp.getConstantPool());
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.type.getSignature();
    }

    public Type getType() {
        return this.type;
    }

    public void removeAttribute(Attribute a) {
        this.attributes.removeElement(a);
    }

    public void setConstantPool(ConstantPoolGen cp) {
        this.cp = cp;
    }

    public void setInitValue(byte b) {
        if (b != 0) {
            this.index = this.cp.addInteger(b);
        }
    }

    public void setInitValue(char c) {
        if (c != '\u0000') {
            this.index = this.cp.addInteger(c);
        }
    }

    public void setInitValue(double d) {
        if (d != 0.0) {
            this.index = this.cp.addDouble(d);
        }
    }

    public void setInitValue(float f) {
        if ((double)f != 0.0) {
            this.index = this.cp.addFloat(f);
        }
    }

    public void setInitValue(int i) {
        if (i != 0) {
            this.index = this.cp.addInteger(i);
        }
    }

    public void setInitValue(long l) {
        if (l != 0L) {
            this.index = this.cp.addLong(l);
        }
    }

    public void setInitValue(String str) {
        if (str != null) {
            this.index = this.cp.addString(str);
        }
    }

    public void setInitValue(short s) {
        if (s != 0) {
            this.index = this.cp.addInteger(s);
        }
    }

    public void setInitValue(boolean b) {
        if (b) {
            this.index = this.cp.addInteger(1);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Type type) {
        this.type = type;
    }
}

