/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ALOAD;
import de.fub.bytecode.generic.ANEWARRAY;
import de.fub.bytecode.generic.ASTORE;
import de.fub.bytecode.generic.AllocationInstruction;
import de.fub.bytecode.generic.ArithmeticInstruction;
import de.fub.bytecode.generic.ArrayInstruction;
import de.fub.bytecode.generic.ArrayType;
import de.fub.bytecode.generic.BasicType;
import de.fub.bytecode.generic.CHECKCAST;
import de.fub.bytecode.generic.ClassGen;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.DLOAD;
import de.fub.bytecode.generic.DSTORE;
import de.fub.bytecode.generic.FLOAD;
import de.fub.bytecode.generic.FSTORE;
import de.fub.bytecode.generic.GETFIELD;
import de.fub.bytecode.generic.GETSTATIC;
import de.fub.bytecode.generic.ILOAD;
import de.fub.bytecode.generic.INVOKEINTERFACE;
import de.fub.bytecode.generic.INVOKESPECIAL;
import de.fub.bytecode.generic.INVOKESTATIC;
import de.fub.bytecode.generic.INVOKEVIRTUAL;
import de.fub.bytecode.generic.ISTORE;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionConstants;
import de.fub.bytecode.generic.InvokeInstruction;
import de.fub.bytecode.generic.LLOAD;
import de.fub.bytecode.generic.LSTORE;
import de.fub.bytecode.generic.LocalVariableInstruction;
import de.fub.bytecode.generic.MULTIANEWARRAY;
import de.fub.bytecode.generic.NEW;
import de.fub.bytecode.generic.NEWARRAY;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.PUTFIELD;
import de.fub.bytecode.generic.PUTSTATIC;
import de.fub.bytecode.generic.ReferenceType;
import de.fub.bytecode.generic.ReturnInstruction;
import de.fub.bytecode.generic.StackInstruction;
import de.fub.bytecode.generic.Type;

public class InstructionFactory
implements InstructionConstants {
    protected ClassGen cg;
    protected ConstantPoolGen cp;

    public InstructionFactory(ClassGen cg) {
        this.cg = cg;
        this.cp = cg.getConstantPool();
    }

    public static ArrayInstruction createArrayLoad(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConstants.BALOAD;
            }
            case 5: {
                return InstructionConstants.CALOAD;
            }
            case 9: {
                return InstructionConstants.SALOAD;
            }
            case 10: {
                return InstructionConstants.IALOAD;
            }
            case 6: {
                return InstructionConstants.FALOAD;
            }
            case 7: {
                return InstructionConstants.DALOAD;
            }
            case 11: {
                return InstructionConstants.LALOAD;
            }
            case 13: 
            case 14: {
                return InstructionConstants.AALOAD;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayStore(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConstants.BASTORE;
            }
            case 5: {
                return InstructionConstants.CASTORE;
            }
            case 9: {
                return InstructionConstants.SASTORE;
            }
            case 10: {
                return InstructionConstants.IASTORE;
            }
            case 6: {
                return InstructionConstants.FASTORE;
            }
            case 7: {
                return InstructionConstants.DASTORE;
            }
            case 11: {
                return InstructionConstants.LASTORE;
            }
            case 13: 
            case 14: {
                return InstructionConstants.AASTORE;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    private static final ArithmeticInstruction createBinaryDoubleOp(char op) {
        switch (op) {
            case '-': {
                return InstructionConstants.DSUB;
            }
            case '+': {
                return InstructionConstants.DADD;
            }
            case '*': {
                return InstructionConstants.DMUL;
            }
            case '/': {
                return InstructionConstants.DDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    private static final ArithmeticInstruction createBinaryFloatOp(char op) {
        switch (op) {
            case '-': {
                return InstructionConstants.FSUB;
            }
            case '+': {
                return InstructionConstants.FADD;
            }
            case '*': {
                return InstructionConstants.FMUL;
            }
            case '/': {
                return InstructionConstants.FDIV;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    private static final ArithmeticInstruction createBinaryIntOp(char first, String op) {
        switch (first) {
            case '-': {
                return InstructionConstants.ISUB;
            }
            case '+': {
                return InstructionConstants.IADD;
            }
            case '%': {
                return InstructionConstants.IREM;
            }
            case '*': {
                return InstructionConstants.IMUL;
            }
            case '/': {
                return InstructionConstants.IDIV;
            }
            case '&': {
                return InstructionConstants.IAND;
            }
            case '|': {
                return InstructionConstants.IOR;
            }
            case '^': {
                return InstructionConstants.IXOR;
            }
            case '<': {
                return InstructionConstants.ISHL;
            }
            case '>': {
                return op.equals(">>>") ? InstructionConstants.IUSHR : InstructionConstants.ISHR;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    private static final ArithmeticInstruction createBinaryLongOp(char first, String op) {
        switch (first) {
            case '-': {
                return InstructionConstants.LSUB;
            }
            case '+': {
                return InstructionConstants.LADD;
            }
            case '%': {
                return InstructionConstants.LREM;
            }
            case '*': {
                return InstructionConstants.LMUL;
            }
            case '/': {
                return InstructionConstants.LDIV;
            }
            case '&': {
                return InstructionConstants.LAND;
            }
            case '|': {
                return InstructionConstants.LOR;
            }
            case '^': {
                return InstructionConstants.LXOR;
            }
            case '<': {
                return InstructionConstants.LSHL;
            }
            case '>': {
                return op.equals(">>>") ? InstructionConstants.LUSHR : InstructionConstants.LSHR;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    public static ArithmeticInstruction createBinaryOperation(String op, Type type) {
        char first = op.toCharArray()[0];
        switch (type.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(first, op);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(first, op);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(first);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(first);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public Instruction createCast(Type src_type, Type dest_type) {
        if (src_type instanceof BasicType && dest_type instanceof BasicType) {
            byte dest = dest_type.getType();
            int src = src_type.getType();
            if (dest == 11 && (src == 5 || src == 8 || src == 9)) {
                src = 10;
            }
            String[] short_names = new String[]{"C", "F", "D", "B", "S", "I", "L"};
            String name = "de.fub.bytecode.generic." + short_names[src - 5] + "2" + short_names[dest - 5];
            Instruction i = null;
            try {
                i = (Instruction)Class.forName(name).newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not find instruction: " + name);
            }
            return i;
        }
        if (src_type instanceof ReferenceType && dest_type instanceof ReferenceType) {
            if (dest_type instanceof ArrayType) {
                return new CHECKCAST(this.cp.addArrayClass((ArrayType)dest_type));
            }
            return new CHECKCAST(this.cp.addClass(((ObjectType)dest_type).getClassName()));
        }
        throw new RuntimeException("Can not cast " + src_type + " to " + dest_type);
    }

    public CHECKCAST createCheckCast(ReferenceType t) {
        if (t instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)t));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)t));
    }

    public static StackInstruction createDup(int size) {
        return size == 2 ? InstructionConstants.DUP2 : InstructionConstants.DUP;
    }

    public static StackInstruction createDup_1(int size) {
        return size == 2 ? InstructionConstants.DUP2_X1 : InstructionConstants.DUP_X1;
    }

    public static StackInstruction createDup_2(int size) {
        return size == 2 ? InstructionConstants.DUP2_X2 : InstructionConstants.DUP_X2;
    }

    public GETFIELD createGetField(String class_name, String name, Type t) {
        return new GETFIELD(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public GETSTATIC createGetStatic(String class_name, String name, Type t) {
        return new GETSTATIC(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public InvokeInstruction createInvoke(String class_name, String name, Type ret_type, Type[] arg_types, short kind) {
        int nargs = 0;
        String signature = Type.getMethodSignature(ret_type, arg_types);
        int i = 0;
        while (i < arg_types.length) {
            nargs += arg_types[i].getSize();
            ++i;
        }
        int index = kind == 185 ? this.cp.addInterfaceMethodref(class_name, name, signature) : this.cp.addMethodref(class_name, name, signature);
        switch (kind) {
            case 183: {
                return new INVOKESPECIAL(index);
            }
            case 182: {
                return new INVOKEVIRTUAL(index);
            }
            case 184: {
                return new INVOKESTATIC(index);
            }
            case 185: {
                return new INVOKEINTERFACE(index, nargs + 1);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind:" + kind);
    }

    public static LocalVariableInstruction createLoad(Type type, int index) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(index);
            }
            case 6: {
                return new FLOAD(index);
            }
            case 7: {
                return new DLOAD(index);
            }
            case 11: {
                return new LLOAD(index);
            }
            case 13: 
            case 14: {
                return new ALOAD(index);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public NEW createNew(ObjectType t) {
        return new NEW(this.cp.addClass(t));
    }

    public NEW createNew(String s) {
        return this.createNew(new ObjectType(s));
    }

    public AllocationInstruction createNewArray(Type t, short dim) {
        if (dim == 1) {
            if (t instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)t));
            }
            if (t instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)t));
            }
            return new NEWARRAY(((BasicType)t).getType());
        }
        ArrayType at = t instanceof ArrayType ? (ArrayType)t : new ArrayType(t, (int)dim);
        return new MULTIANEWARRAY(this.cp.addArrayClass(at), dim);
    }

    public static Instruction createNull(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConstants.ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConstants.ICONST_0;
            }
            case 6: {
                return InstructionConstants.FCONST_0;
            }
            case 7: {
                return InstructionConstants.DCONST_0;
            }
            case 11: {
                return InstructionConstants.LCONST_0;
            }
            case 12: {
                return InstructionConstants.NOP;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static StackInstruction createPop(int size) {
        return size == 2 ? InstructionConstants.POP2 : InstructionConstants.POP;
    }

    public PUTFIELD createPutField(String class_name, String name, Type t) {
        return new PUTFIELD(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public PUTSTATIC createPutStatic(String class_name, String name, Type t) {
        return new PUTSTATIC(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public static ReturnInstruction createReturn(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConstants.ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConstants.IRETURN;
            }
            case 6: {
                return InstructionConstants.FRETURN;
            }
            case 7: {
                return InstructionConstants.DRETURN;
            }
            case 11: {
                return InstructionConstants.LRETURN;
            }
            case 12: {
                return InstructionConstants.RETURN;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static LocalVariableInstruction createStore(Type type, int index) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(index);
            }
            case 6: {
                return new FSTORE(index);
            }
            case 7: {
                return new DSTORE(index);
            }
            case 11: {
                return new LSTORE(index);
            }
            case 13: 
            case 14: {
                return new ASTORE(index);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static Instruction createThis() {
        return new ALOAD(0);
    }
}

