/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.generic.BranchHandle;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.CodeExceptionGen;
import de.fub.bytecode.generic.CompoundInstruction;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.LocalVariableGen;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.TargetLostException;
import de.fub.bytecode.util.ByteSequence;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class InstructionList
implements Constants,
Serializable {
    private InstructionHandle start = null;
    private InstructionHandle end = null;
    private int length = 0;
    private int[] byte_positions;

    public InstructionList() {
    }

    public InstructionList(BranchInstruction i) {
        this.append(i);
    }

    public InstructionList(CompoundInstruction c) {
        this.append(c.getInstructionList());
    }

    public InstructionList(Instruction i) {
        this.append(i);
    }

    public InstructionList(byte[] code) {
        ByteSequence bytes = new ByteSequence(code);
        InstructionHandle[] ihs = new InstructionHandle[code.length];
        int[] pos = new int[code.length];
        int count = 0;
        try {
            while (bytes.available() > 0) {
                int off;
                pos[count] = off = bytes.getIndex();
                Instruction i = Instruction.readInstruction(bytes);
                InstructionHandle ih = i instanceof BranchInstruction ? this.append((BranchInstruction)i) : this.append(i);
                ih.setPosition(off);
                ihs[count] = ih;
                ++count;
            }
        }
        catch (IOException e) {
            throw new ClassGenException(e.toString());
        }
        this.byte_positions = pos;
        int i = 0;
        while (i < count) {
            if (ihs[i] instanceof BranchHandle) {
                BranchInstruction bi = (BranchInstruction)ihs[i].instruction;
                int target = bi.position + bi.getIndex();
                InstructionHandle ih = InstructionList.findHandle(ihs, pos, count, target);
                if (ih == null) {
                    throw new ClassGenException("Couldn't find target instruction: " + bi);
                }
                bi.setTarget(ih);
                if (bi instanceof Select) {
                    Select s = (Select)bi;
                    int[] indices = s.getIndices();
                    int j = 0;
                    while (j < indices.length) {
                        target = bi.position + indices[j];
                        ih = InstructionList.findHandle(ihs, pos, count, target);
                        if (ih == null) {
                            throw new ClassGenException("Couldn't find instruction target: " + bi);
                        }
                        s.setTarget(j, ih);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public BranchHandle append(BranchInstruction i) {
        BranchHandle ih = BranchHandle.getBranchHandle(i);
        this.append(ih);
        return ih;
    }

    public InstructionHandle append(CompoundInstruction c) {
        return this.append(c.getInstructionList());
    }

    public InstructionHandle append(Instruction i) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i);
        this.append(ih);
        return ih;
    }

    public InstructionHandle append(Instruction i, CompoundInstruction c) {
        return this.append(i, c.getInstructionList());
    }

    public InstructionHandle append(Instruction i, Instruction j) {
        return this.append(i, new InstructionList(j));
    }

    public InstructionHandle append(Instruction i, InstructionList il) {
        InstructionHandle ih = this.findInstruction2(i);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i + " is not contained in this list.");
        }
        return this.append(ih, il);
    }

    private void append(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.prev = null;
            ih.next = null;
        } else {
            this.end.next = ih;
            ih.prev = this.end;
            ih.next = null;
            this.end = ih;
        }
        ++this.length;
    }

    public BranchHandle append(InstructionHandle ih, BranchInstruction i) {
        BranchHandle bh = BranchHandle.getBranchHandle(i);
        InstructionList il = new InstructionList();
        il.append(bh);
        this.append(ih, il);
        return bh;
    }

    public InstructionHandle append(InstructionHandle ih, CompoundInstruction c) {
        return this.append(ih, c.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle ih, Instruction i) {
        return this.append(ih, new InstructionList(i));
    }

    public InstructionHandle append(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle next = ih.next;
        InstructionHandle ret = il.start;
        ih.next = il.start;
        il.start.prev = ih;
        il.end.next = next;
        if (next != null) {
            next.prev = il.end;
        } else {
            this.end = il.end;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle append(InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = il.start;
            this.end = il.end;
            this.length = il.length;
            il.clear();
            return this.start;
        }
        return this.append(this.end, il);
    }

    private void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public boolean contains(Instruction i) {
        return this.findInstruction1(i) != null;
    }

    public boolean contains(InstructionHandle i) {
        if (i == null) {
            return false;
        }
        InstructionHandle ih = this.start;
        while (ih != null) {
            if (ih == i) {
                return true;
            }
            ih = ih.next;
        }
        return false;
    }

    public InstructionList copy() {
        Hashtable<InstructionHandle, InstructionHandle> map = new Hashtable<InstructionHandle, InstructionHandle>();
        InstructionList il = new InstructionList();
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i = ih.instruction;
            Instruction c = i.copy();
            map.put(ih, il.append(c));
            ih = ih.next;
        }
        InstructionHandle ih2 = this.start;
        InstructionHandle ch = il.start;
        while (ih2 != null) {
            Instruction i = ih2.instruction;
            Instruction c = ch.instruction;
            if (i instanceof BranchInstruction) {
                BranchInstruction bi = (BranchInstruction)i;
                BranchInstruction bc = (BranchInstruction)c;
                InstructionHandle itarget = bi.getTarget();
                bc.setTarget((InstructionHandle)map.get(itarget));
                if (bi instanceof Select) {
                    InstructionHandle[] itargets = ((Select)bi).getTargets();
                    InstructionHandle[] ctargets = ((Select)bc).getTargets();
                    int j = 0;
                    while (j < itargets.length) {
                        ctargets[j] = (InstructionHandle)map.get(itargets[j]);
                        ++j;
                    }
                }
            }
            ih2 = ih2.next;
            ch = ch.next;
        }
        return il;
    }

    public void delete(Instruction i) throws TargetLostException {
        InstructionHandle ih = this.findInstruction1(i);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i + " is not contained in this list.");
        }
        this.delete(ih);
    }

    public void delete(Instruction from, Instruction to) throws TargetLostException {
        InstructionHandle from_ih = this.findInstruction1(from);
        if (from_ih == null) {
            throw new ClassGenException("Instruction " + from + " is not contained in this list.");
        }
        InstructionHandle to_ih = this.findInstruction2(to);
        if (to_ih == null) {
            throw new ClassGenException("Instruction " + to + " is not contained in this list.");
        }
        this.delete(from_ih, to_ih);
    }

    public void delete(InstructionHandle ih) throws TargetLostException {
        this.remove(ih.prev, ih.next);
    }

    public void delete(InstructionHandle from, InstructionHandle to) throws TargetLostException {
        this.remove(from.prev, to.next);
    }

    public void dispose() {
        InstructionHandle ih = this.end;
        while (ih != null) {
            ih.dispose();
            ih = ih.prev;
        }
        this.clear();
    }

    public Enumeration elements() {
        return new Enumeration(this){
            private InstructionHandle ih;
            {
                this.ih = this$0.start;
            }

            public boolean hasMoreElements() {
                return this.ih != null;
            }

            public Object nextElement() {
                InstructionHandle i = this.ih;
                this.ih = this.ih.next;
                return i;
            }
        };
    }

    public InstructionHandle findHandle(int pos) {
        InstructionHandle[] ihs = this.getInstructionHandles();
        return InstructionList.findHandle(ihs, this.byte_positions, this.length, pos);
    }

    public static InstructionHandle findHandle(InstructionHandle[] ihs, int[] pos, int count, int target) {
        int l = 0;
        int r = count - 1;
        do {
            int i;
            int j;
            if ((j = pos[i = (l + r) / 2]) == target) {
                return ihs[i];
            }
            if (target < j) {
                r = i - 1;
                continue;
            }
            l = i + 1;
        } while (l <= r);
        return null;
    }

    private InstructionHandle findInstruction1(Instruction i) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            if (ih.instruction == i) {
                return ih;
            }
            ih = ih.next;
        }
        return null;
    }

    private InstructionHandle findInstruction2(Instruction i) {
        InstructionHandle ih = this.end;
        while (ih != null) {
            if (ih.instruction == i) {
                return ih;
            }
            ih = ih.prev;
        }
        return null;
    }

    public byte[] getByteCode() {
        this.setPositions();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            InstructionHandle ih = this.start;
            while (ih != null) {
                Instruction i = ih.instruction;
                i.dump(out);
                ih = ih.next;
            }
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
        return b.toByteArray();
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] ihs = new InstructionHandle[this.length];
        InstructionHandle ih = this.start;
        int i = 0;
        while (i < this.length) {
            ihs[i] = ih;
            ih = ih.next;
            ++i;
        }
        return ihs;
    }

    public int[] getInstructionPositions() {
        return this.byte_positions;
    }

    public int getLength() {
        return this.length;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public BranchHandle insert(BranchInstruction i) {
        BranchHandle ih = BranchHandle.getBranchHandle(i);
        this.insert(ih);
        return ih;
    }

    public InstructionHandle insert(CompoundInstruction c) {
        return this.insert(c.getInstructionList());
    }

    public InstructionHandle insert(Instruction i) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i);
        this.insert(ih);
        return ih;
    }

    public InstructionHandle insert(Instruction i, CompoundInstruction c) {
        return this.insert(i, c.getInstructionList());
    }

    public InstructionHandle insert(Instruction i, Instruction j) {
        return this.insert(i, new InstructionList(j));
    }

    public InstructionHandle insert(Instruction i, InstructionList il) {
        InstructionHandle ih = this.findInstruction1(i);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i + " is not contained in this list.");
        }
        return this.insert(ih, il);
    }

    private void insert(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.prev = null;
            ih.next = null;
        } else {
            this.start.prev = ih;
            ih.next = this.start;
            ih.prev = null;
            this.start = ih;
        }
        ++this.length;
    }

    public BranchHandle insert(InstructionHandle ih, BranchInstruction i) {
        BranchHandle bh = BranchHandle.getBranchHandle(i);
        InstructionList il = new InstructionList();
        il.append(bh);
        this.insert(ih, il);
        return bh;
    }

    public InstructionHandle insert(InstructionHandle ih, CompoundInstruction c) {
        return this.insert(ih, c.getInstructionList());
    }

    public InstructionHandle insert(InstructionHandle ih, Instruction i) {
        return this.insert(ih, new InstructionList(i));
    }

    public InstructionHandle insert(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle prev = ih.prev;
        InstructionHandle ret = il.start;
        ih.prev = il.end;
        il.end.next = ih;
        il.start.prev = prev;
        if (prev != null) {
            prev.next = il.start;
        } else {
            this.start = il.start;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle insert(InstructionList il) {
        if (this.isEmpty()) {
            this.append(il);
            return this.start;
        }
        return this.insert(this.start, il);
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    public void redirectBranches(InstructionHandle old_target, InstructionHandle new_target) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i = ih.getInstruction();
            if (i instanceof BranchInstruction) {
                BranchInstruction b = (BranchInstruction)i;
                InstructionHandle target = b.getTarget();
                if (target == old_target) {
                    b.setTarget(new_target);
                }
                if (b instanceof Select) {
                    InstructionHandle[] targets = ((Select)b).getTargets();
                    int j = 0;
                    while (j < targets.length) {
                        if (targets[j] == old_target) {
                            ((Select)b).setTarget(j, new_target);
                        }
                        ++j;
                    }
                }
            }
            ih = ih.next;
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] exceptions, InstructionHandle old_target, InstructionHandle new_target) {
        int i = 0;
        while (i < exceptions.length) {
            if (exceptions[i].getStartPC() == old_target) {
                exceptions[i].setStartPC(new_target);
            }
            if (exceptions[i].getEndPC() == old_target) {
                exceptions[i].setEndPC(new_target);
            }
            if (exceptions[i].getHandlerPC() == old_target) {
                exceptions[i].setHandlerPC(new_target);
            }
            ++i;
        }
    }

    public void redirectLocalVariables(LocalVariableGen[] lg, InstructionHandle old_target, InstructionHandle new_target) {
        int i = 0;
        while (i < lg.length) {
            InstructionHandle start = lg[i].getStart();
            InstructionHandle end = lg[i].getEnd();
            if (start == old_target) {
                lg[i].setStart(new_target);
            }
            if (end == old_target) {
                lg[i].setEnd(new_target);
            }
            ++i;
        }
    }

    private void remove(InstructionHandle prev, InstructionHandle next) throws TargetLostException {
        InstructionHandle first;
        InstructionHandle last;
        if (prev == null && next == null) {
            first = last = this.start;
            this.end = null;
            this.start = null;
        } else {
            if (prev == null) {
                first = this.start;
                this.start = next;
            } else {
                first = prev.next;
                prev.next = next;
            }
            if (next == null) {
                last = this.end;
                this.end = prev;
            } else {
                last = next.prev;
                next.prev = prev;
            }
        }
        first.prev = null;
        last.next = null;
        Vector<InstructionHandle> target_vec = new Vector<InstructionHandle>();
        InstructionHandle ih = first;
        while (ih != null) {
            ih.getInstruction().dispose();
            ih = ih.next;
        }
        StringBuffer buf = new StringBuffer("{ ");
        InstructionHandle ih2 = first;
        while (ih2 != null) {
            next = ih2.next;
            --this.length;
            if (ih2.hasTargeters()) {
                target_vec.addElement(ih2);
                buf.append(String.valueOf(ih2.toString(true)) + " ");
                ih2.prev = null;
                ih2.next = null;
            } else {
                ih2.dispose();
            }
            ih2 = next;
        }
        buf.append("}");
        if (!target_vec.isEmpty()) {
            Object[] targeted = new InstructionHandle[target_vec.size()];
            target_vec.copyInto(targeted);
            throw new TargetLostException((InstructionHandle[])targeted, buf.toString());
        }
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean check) {
        Instruction i;
        InstructionHandle ih;
        int max_additional_bytes = 0;
        int additional_bytes = 0;
        int index = 0;
        int count = 0;
        int[] pos = new int[this.length];
        if (check) {
            ih = this.start;
            while (ih != null) {
                i = ih.instruction;
                if (i instanceof BranchInstruction) {
                    Instruction inst = ((BranchInstruction)i).getTarget().instruction;
                    if (!this.contains(inst)) {
                        throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[i.tag] + ":" + inst + " not in instruction list");
                    }
                    if (i instanceof Select) {
                        InstructionHandle[] targets = ((Select)i).getTargets();
                        int j = 0;
                        while (j < targets.length) {
                            inst = targets[j].instruction;
                            if (!this.contains(inst)) {
                                throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[i.tag] + ":" + inst + " not in instruction list");
                            }
                            ++j;
                        }
                    }
                    if (!(ih instanceof BranchHandle)) {
                        throw new ClassGenException("Branch instruction " + Constants.OPCODE_NAMES[i.tag] + ":" + inst + " not contained in BranchHandle.");
                    }
                }
                ih = ih.next;
            }
        }
        ih = this.start;
        while (ih != null) {
            i = ih.instruction;
            ih.setPosition(index);
            pos[count++] = index;
            switch (i.getTag()) {
                case 167: 
                case 168: {
                    max_additional_bytes += 2;
                    break;
                }
                case 170: 
                case 171: {
                    max_additional_bytes += 3;
                    break;
                }
            }
            index += i.getLength();
            ih = ih.next;
        }
        InstructionHandle ih2 = this.start;
        while (ih2 != null) {
            additional_bytes += ih2.updatePosition(additional_bytes, max_additional_bytes);
            ih2 = ih2.next;
        }
        count = 0;
        index = 0;
        InstructionHandle ih3 = this.start;
        while (ih3 != null) {
            Instruction i2 = ih3.instruction;
            ih3.setPosition(index);
            pos[count++] = index;
            index += i2.getLength();
            ih3 = ih3.next;
        }
        this.byte_positions = pos;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringBuffer buf = new StringBuffer();
        InstructionHandle ih = this.start;
        while (ih != null) {
            buf.append(String.valueOf(ih.toString(verbose)) + "\n");
            ih = ih.next;
        }
        return buf.toString();
    }
}

