/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LOOKUPSWITCH
extends Select {
    LOOKUPSWITCH() {
    }

    public LOOKUPSWITCH(int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super((short)171, match, targets, target);
        this.length = (short)(9 + this.match_length * 8);
        this.fixed_length = this.length;
    }

    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        out.writeInt(this.match_length);
        int i = 0;
        while (i < this.match_length) {
            out.writeInt(this.match[i]);
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            out.writeInt(this.indices[i]);
            ++i;
        }
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        this.match_length = bytes.readInt();
        this.fixed_length = (short)(9 + this.match_length * 8);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        int i = 0;
        while (i < this.match_length) {
            this.match[i] = bytes.readInt();
            this.indices[i] = bytes.readInt();
            ++i;
        }
    }
}

