/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionTargeter;
import de.fub.bytecode.generic.Type;

public class LocalVariableGen
implements Constants,
InstructionTargeter {
    private int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;

    public LocalVariableGen(int index, String name, Type type, InstructionHandle start, InstructionHandle end) {
        if (index < 0 || index > 65535) {
            throw new ClassGenException("Invalid index index: " + index);
        }
        this.name = name;
        this.type = type;
        this.index = index;
        this.setStart(start);
        this.setStart(end);
    }

    public boolean containsTarget(InstructionHandle ih) {
        return this.start == ih || this.end == ih;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen l = (LocalVariableGen)o;
        return l.index == this.index && l.start == this.start && l.end == this.end;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getIndex() {
        return this.index;
    }

    public LocalVariable getLocalVariable(ConstantPoolGen cp) {
        int start_pc = this.start.getPosition();
        int length = this.end.getPosition() - start_pc;
        int name_index = cp.addUtf8(this.name);
        int signature_index = cp.addUtf8(this.type.getSignature());
        return new LocalVariable(start_pc, length, name_index, signature_index, this.index, cp.getConstantPool());
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.index;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public Type getType() {
        return this.type;
    }

    public void setEnd(InstructionHandle end) {
        BranchInstruction.notifyTarget(this.end, end, this);
        this.end = end;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSlot(int index) {
        this.index = index;
    }

    public void setStart(InstructionHandle start) {
        BranchInstruction.notifyTarget(this.start, start, this);
        this.start = start;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "LocalvariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.start == old_ih) {
            targeted = true;
            this.setStart(new_ih);
        }
        if (this.end == old_ih) {
            targeted = true;
            this.setEnd(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.start + ", " + this.end + "}");
        }
    }
}

