/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.Constants;
import de.fub.bytecode.classfile.AccessFlags;
import de.fub.bytecode.classfile.Attribute;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.CodeException;
import de.fub.bytecode.classfile.ExceptionTable;
import de.fub.bytecode.classfile.LineNumber;
import de.fub.bytecode.classfile.LineNumberTable;
import de.fub.bytecode.classfile.LocalVariable;
import de.fub.bytecode.classfile.LocalVariableTable;
import de.fub.bytecode.classfile.Method;
import de.fub.bytecode.generic.BranchInstruction;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.CodeExceptionGen;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.IfInstruction;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionHandle;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.LineNumberGen;
import de.fub.bytecode.generic.LocalVariableGen;
import de.fub.bytecode.generic.LocalVariableInstruction;
import de.fub.bytecode.generic.NOP;
import de.fub.bytecode.generic.ObjectType;
import de.fub.bytecode.generic.Select;
import de.fub.bytecode.generic.TargetLostException;
import de.fub.bytecode.generic.Type;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class MethodGen
extends AccessFlags
implements Constants {
    private String method_name;
    private String class_name;
    private Type return_type;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private ConstantPoolGen cp;
    private boolean strip_attributes;
    private Vector variable_vec = new Vector();
    private Vector line_number_vec = new Vector();
    private Vector attribute_vec = new Vector();
    private Vector exception_vec = new Vector();
    private Vector throws_vec = new Vector();
    private Vector code_attrs_vec = new Vector();

    public MethodGen(int access_flags, Type return_type, Type[] arg_types, String[] arg_names, String method_name, String class_name, InstructionList il, ConstantPoolGen cp) {
        this.access_flags = access_flags;
        this.return_type = return_type;
        this.arg_types = arg_types;
        this.arg_names = arg_names;
        this.method_name = method_name;
        this.class_name = class_name;
        this.il = il;
        this.cp = cp;
        if ((access_flags & 0x500) == 0) {
            InstructionHandle start = il.getStart();
            InstructionHandle end = il.getEnd();
            if (!this.isStatic() && class_name != null) {
                this.addLocalVariable("this", new ObjectType(class_name), start, end);
            }
            if (arg_types != null) {
                int i;
                int size = arg_types.length;
                if (arg_names != null) {
                    if (size != arg_names.length) {
                        throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + arg_names.length);
                    }
                } else {
                    arg_names = new String[size];
                    i = 0;
                    while (i < size) {
                        arg_names[i] = "arg" + i;
                        ++i;
                    }
                }
                i = 0;
                while (i < size) {
                    this.addLocalVariable(arg_names[i], arg_types[i], start, end);
                    ++i;
                }
            }
        }
    }

    public MethodGen(Method m, String class_name, ConstantPoolGen cp) {
        this(m.getAccessFlags(), Type.getReturnType(m.getSignature()), Type.getArgumentTypes(m.getSignature()), null, m.getName(), class_name, (m.getAccessFlags() & 0x500) == 0 ? new InstructionList(m.getCode().getCode()) : null, cp);
        Attribute[] attributes = m.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            Attribute a = attributes[i];
            if (a instanceof Code) {
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                CodeException[] ces = c.getExceptionTable();
                if (ces != null) {
                    int j = 0;
                    while (j < ces.length) {
                        CodeException ce = ces[j];
                        int type = ce.getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            c_type = new ObjectType(cp.getConstantPool().getConstantString(type, (byte)7));
                        }
                        int end_pc = ce.getEndPC();
                        int length = m.getCode().getCode().length;
                        if (length == end_pc) {
                            end_pc -= this.il.getEnd().getInstruction().getLength();
                        }
                        this.addExceptionHandler(this.il.findHandle(ce.getStartPC()), this.il.findHandle(end_pc), this.il.findHandle(ce.getHandlerPC()), c_type);
                        ++j;
                    }
                }
                Attribute[] c_attributes = c.getAttributes();
                int j = 0;
                while (j < c_attributes.length) {
                    a = c_attributes[j];
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln = ((LineNumberTable)a).getLineNumberTable();
                        int k = 0;
                        while (k < ln.length) {
                            LineNumber l = ln[k];
                            this.addLineNumber(this.il.findHandle(l.getStartPC()), l.getLineNumber());
                            ++k;
                        }
                    } else if (a instanceof LocalVariableTable) {
                        LocalVariable[] lv = ((LocalVariableTable)a).getLocalVariableTable();
                        int k = 0;
                        while (k < lv.length) {
                            LocalVariable l = lv[k];
                            InstructionHandle start = this.il.findHandle(l.getStartPC());
                            InstructionHandle end = this.il.findHandle(l.getStartPC() + l.getLength());
                            if (start == null) {
                                start = this.il.getStart();
                            }
                            if (end == null) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(l.getName(), Type.getType(l.getSignature()), l.getIndex(), start, end);
                            ++k;
                        }
                    } else {
                        System.err.println("Unknown Code attribute " + a + " ignored.");
                    }
                    ++j;
                }
            } else if (a instanceof ExceptionTable) {
                String[] names = ((ExceptionTable)a).getExceptionNames();
                int j = 0;
                while (j < names.length) {
                    this.addException(names[j]);
                    ++j;
                }
            } else {
                this.addAttribute(a);
            }
            ++i;
        }
    }

    public void addAttribute(Attribute a) {
        this.attribute_vec.addElement(a);
    }

    public void addCodeAttribute(Attribute a) {
        this.code_attrs_vec.addElement(a);
    }

    public void addException(String class_name) {
        this.throws_vec.addElement(class_name);
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exception_vec.addElement(c);
        return c;
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, String catch_type) {
        return this.addExceptionHandler(start_pc, end_pc, handler_pc, catch_type == null ? null : new ObjectType(catch_type));
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int src_line) {
        LineNumberGen l = new LineNumberGen(ih, src_line);
        this.line_number_vec.addElement(l);
        return l;
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end) {
        LocalVariableGen l;
        int i;
        byte t = type.getType();
        int add = type.getSize();
        if (slot + add > this.max_locals) {
            this.max_locals = slot + add;
        }
        if ((i = this.variable_vec.indexOf(l = new LocalVariableGen(slot, name, type, start, end))) >= 0) {
            this.variable_vec.setElementAt(l, i);
        } else {
            this.variable_vec.addElement(l);
        }
        return l;
    }

    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, this.max_locals, start, end);
    }

    public Type getArgType(int i) {
        return this.arg_types[i];
    }

    public Type[] getArgTypes() {
        return this.arg_types;
    }

    public Attribute[] getAttributes() {
        Object[] attributes = new Attribute[this.attribute_vec.size()];
        this.attribute_vec.copyInto(attributes);
        return attributes;
    }

    public String getClassName() {
        return this.class_name;
    }

    public Attribute[] getCodeAttributes() {
        Object[] attributes = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.copyInto(attributes);
        return attributes;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exception_vec.size();
        CodeException[] c_exc = new CodeException[size];
        try {
            int i = 0;
            while (i < size) {
                CodeExceptionGen c = (CodeExceptionGen)this.exception_vec.elementAt(i);
                c_exc[i] = c.getCodeException(this.cp);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return c_exc;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        Object[] cg = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.copyInto(cg);
        return cg;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen cp) {
        int size = this.throws_vec.size();
        int[] ex = new int[size];
        try {
            int i = 0;
            while (i < size) {
                ex[i] = cp.addClass((String)this.throws_vec.elementAt(i));
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public String[] getExceptions() {
        Object[] e = new String[this.throws_vec.size()];
        this.throws_vec.copyInto(e);
        return e;
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen cp) {
        int size = this.line_number_vec.size();
        LineNumber[] ln = new LineNumber[size];
        try {
            int i = 0;
            while (i < size) {
                ln[i] = ((LineNumberGen)this.line_number_vec.elementAt(i)).getLineNumber(cp);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public LineNumberGen[] getLineNumbers() {
        Object[] lg = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.copyInto(lg);
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        int i = 0;
        while (i < size) {
            lv[i] = lg[i].getLocalVariable(cp);
            ++i;
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.variable_vec.size();
        Object[] lg = new LocalVariableGen[size];
        this.variable_vec.copyInto(lg);
        int i = 0;
        while (i < size) {
            if (((LocalVariableGen)lg[i]).getStart() == null) {
                ((LocalVariableGen)lg[i]).setStart(this.il.getStart());
            }
            if (((LocalVariableGen)lg[i]).getEnd() == null) {
                ((LocalVariableGen)lg[i]).setEnd(this.il.getEnd());
            }
            ++i;
        }
        return lg;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public static int getMaxStack(ConstantPoolGen cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        int i = 0;
        while (i < et.length) {
            InstructionHandle handler_pc = et[i].getHandlerPC();
            if (handler_pc != null) {
                branchTargets.push(handler_pc, 1);
            }
            ++i;
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            Instruction instruction = ih.getInstruction();
            short tag = instruction.getTag();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    Select select = (Select)branch;
                    InstructionHandle[] targets = select.getTargets();
                    int i2 = 0;
                    while (i2 < targets.length) {
                        branchTargets.push(targets[i2], stackDepth);
                        ++i2;
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (tag == 168 || tag == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (tag == 191 || tag == 169 || tag >= 172 && tag <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public Method getMethod() {
        String signature = Type.getMethodSignature(this.return_type, this.arg_types);
        int name_index = this.cp.addUtf8(this.method_name);
        int signature_index = this.cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            this.addCodeAttribute(this.getLocalVariableTable(this.cp));
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            this.addCodeAttribute(this.getLineNumberTable(this.cp));
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        int i = 0;
        while (i < code_attrs.length) {
            attrs_len += code_attrs[i].getLength() + 6;
            ++i;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        if (this.il != null && !this.isAbstract()) {
            Code code = new Code(this.cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.max_stack, this.max_locals, byte_code, c_exc, code_attrs, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        if (this.throws_vec.size() > 0) {
            this.addAttribute(this.getExceptionTable(this.cp));
        }
        return new Method(this.access_flags, name_index, signature_index, this.getAttributes(), this.cp.getConstantPool());
    }

    public String getMethodName() {
        return this.method_name;
    }

    public String getMethodSignature() {
        return Type.getMethodSignature(this.return_type, this.arg_types);
    }

    public Type getReturnType() {
        return this.return_type;
    }

    public void removeAttribute(Attribute a) {
        this.attribute_vec.removeElement(a);
    }

    public void removeCodeAttribute(Attribute a) {
        this.code_attrs_vec.removeElement(a);
    }

    public void removeException(String c) {
        this.throws_vec.removeElement(c);
    }

    public void removeExceptionHandler(CodeExceptionGen c) {
        this.exception_vec.removeElement(c);
    }

    public void removeLineNumber(LineNumberGen l) {
        this.line_number_vec.removeElement(l);
    }

    public void removeLocalVariable(LocalVariableGen l) {
        this.variable_vec.removeElement(l);
    }

    /*
     * Unable to fully structure code
     */
    public void removeNOPs() {
        if (this.il != null) {
            ih = this.il.getStart();
            while (ih != null) {
                block7: {
                    next = ih.next;
                    if (next != null && ih.getInstruction() instanceof NOP) {
                        try {
                            this.il.delete(ih);
                            break block7;
                        }
                        catch (TargetLostException e) {
                            targets = e.getTargets();
                            i = 0;
                            ** while (i < targets.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            targeters = targets[i].getTargeters();
                            j = 0;
                            while (j < targeters.length) {
                                targeters[j].updateTarget(targets[i], next);
                                ++j;
                            }
                            ++i;
                            continue;
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setArgType(int i, Type type) {
        this.arg_types[i] = type;
    }

    public void setArgTypes(Type[] arg_types) {
        this.arg_types = arg_types;
    }

    public void setConstantPool(ConstantPoolGen cp) {
        this.cp = cp;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max = 0;
            if (this.arg_types != null) {
                int i = 0;
                while (i < this.arg_types.length) {
                    max += this.arg_types[i].getSize();
                    ++i;
                }
            }
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                int index;
                Instruction ins = ih.getInstruction();
                if (ins instanceof LocalVariableInstruction && (index = ((LocalVariableInstruction)ins).getIndex() + 1) > max) {
                    max = index;
                }
                ih = ih.getNext();
            }
            this.max_locals = max + 1;
        } else {
            this.max_locals = 0;
        }
    }

    public void setMaxLocals(int m) {
        this.max_locals = m;
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxStack(int m) {
        this.max_stack = m;
    }

    public void setMethodName(String method_name) {
        this.method_name = method_name;
    }

    public void setReturnType(Type return_type) {
        this.return_type = return_type;
    }

    public void stripAttributes(boolean flag) {
        this.strip_attributes = flag;
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }

    static final class BranchStack {
        Stack branchTargets = new Stack();
        Hashtable visitedTargets = new Hashtable();

        BranchStack() {
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = (BranchTarget)this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        private final BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private final boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }
}

