/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.BIPUSH;
import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.CompoundInstruction;
import de.fub.bytecode.generic.ConstantPoolGen;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.generic.InstructionConstants;
import de.fub.bytecode.generic.InstructionList;
import de.fub.bytecode.generic.LDC;
import de.fub.bytecode.generic.LDC2_W;
import de.fub.bytecode.generic.SIPUSH;
import de.fub.bytecode.generic.VariableLengthInstruction;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction,
InstructionConstants {
    private Instruction instruction;

    public PUSH(ConstantPoolGen cp, double value) {
        this.instruction = value == 0.0 ? InstructionConstants.DCONST_0 : (value == 1.0 ? InstructionConstants.DCONST_1 : new LDC2_W(cp.addDouble(value)));
    }

    public PUSH(ConstantPoolGen cp, float value) {
        this.instruction = (double)value == 0.0 ? InstructionConstants.FCONST_0 : ((double)value == 1.0 ? InstructionConstants.FCONST_1 : ((double)value == 2.0 ? InstructionConstants.FCONST_2 : new LDC(cp.addFloat(value))));
    }

    public PUSH(ConstantPoolGen cp, int value) {
        this.instruction = value >= -1 && value <= 5 ? InstructionConstants.INSTRUCTIONS[3 + value] : (value >= -128 && value <= 127 ? new BIPUSH((byte)value) : (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE ? new SIPUSH((short)value) : new LDC(cp.addInteger(value))));
    }

    public PUSH(ConstantPoolGen cp, long value) {
        this.instruction = value == 0L ? InstructionConstants.LCONST_0 : (value == 1L ? InstructionConstants.LCONST_1 : new LDC2_W(cp.addLong(value)));
    }

    public PUSH(ConstantPoolGen cp, Boolean value) {
        this(cp, (boolean)value);
    }

    public PUSH(ConstantPoolGen cp, Character value) {
        this(cp, (int)value.charValue());
    }

    public PUSH(ConstantPoolGen cp, Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (int)value.intValue()).instruction;
        } else if (value instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (double)value.doubleValue()).instruction;
        } else if (value instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (float)value.floatValue()).instruction;
        } else if (value instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (long)value.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + value);
        }
    }

    public PUSH(ConstantPoolGen cp, String value) {
        this.instruction = value == null ? InstructionConstants.ACONST_NULL : new LDC(cp.addString(value));
    }

    public PUSH(ConstantPoolGen cp, boolean value) {
        this.instruction = InstructionConstants.INSTRUCTIONS[3 + (value ? 1 : 0)];
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public final InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public String toString() {
        return String.valueOf(this.instruction.toString()) + " (PUSH)";
    }
}

