/*
 * Decompiled with CFR 0.152.
 */
package de.fub.bytecode.generic;

import de.fub.bytecode.generic.ClassGenException;
import de.fub.bytecode.generic.Instruction;
import de.fub.bytecode.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class RET
extends Instruction {
    private boolean wide;
    private int index;

    RET() {
    }

    public RET(int index) {
        super((short)169, (short)2);
        this.setIndex(index);
    }

    public void dump(DataOutputStream out) throws IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(this.tag);
        if (this.wide) {
            out.writeShort(this.index);
        } else {
            out.writeByte(this.index);
        }
    }

    public final int getIndex() {
        return this.index;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.wide = wide;
        if (wide) {
            this.index = bytes.readUnsignedShort();
            this.length = (short)4;
        } else {
            this.index = bytes.readUnsignedByte();
            this.length = (short)2;
        }
    }

    public final void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
        this.setWide();
    }

    private final void setWide() {
        this.wide = this.index > 255;
        this.length = this.wide ? (short)4 : (short)2;
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + this.index;
    }
}

