/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.CharIndexedCharArray;
import gnu.regexp.CharIndexedInputStream;
import gnu.regexp.CharIndexedString;
import gnu.regexp.CharIndexedStringBuffer;
import gnu.regexp.CharUnit;
import gnu.regexp.IntPair;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.RESyntax;
import gnu.regexp.REToken;
import gnu.regexp.RETokenAny;
import gnu.regexp.RETokenBackRef;
import gnu.regexp.RETokenChar;
import gnu.regexp.RETokenEnd;
import gnu.regexp.RETokenOneOf;
import gnu.regexp.RETokenPOSIX;
import gnu.regexp.RETokenRange;
import gnu.regexp.RETokenRepeated;
import gnu.regexp.RETokenStart;
import java.io.InputStream;
import java.util.Vector;

public class RE
extends REToken {
    private static final String s_version = "1.0.4";
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;
    private REToken firstToken;
    private REToken lastToken;
    private int m_numSubs;

    public static final String version() {
        return s_version;
    }

    private static final int getCharUnit(char[] cArray, int n, CharUnit charUnit) throws REException {
        charUnit.ch = cArray[n++];
        charUnit.bk = charUnit.ch == '\\';
        if (charUnit.bk) {
            if (n < cArray.length) {
                charUnit.ch = cArray[n++];
            } else {
                throw new REException("\\ at end of pattern.", 10, n);
            }
        }
        return n;
    }

    public boolean isMatch(Object object) {
        return this.isMatch(object, 0, 0);
    }

    public boolean isMatch(Object object, int n) {
        return this.isMatch(object, n, 0);
    }

    public boolean isMatch(Object object, int n, int n2) {
        return this.isMatchImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private final boolean isMatchImpl(CharIndexed charIndexed, int n, int n2) {
        int[] nArray = this.firstToken.match(charIndexed, 0, n2, new REMatch(this.m_numSubs, n));
        return nArray != null && charIndexed.charAt(nArray[0]) == '\uffff';
    }

    public int getNumSubs() {
        return this.m_numSubs;
    }

    void setUncle(REToken rEToken) {
        this.lastToken.setUncle(rEToken);
    }

    boolean chain(REToken rEToken) {
        super.chain(rEToken);
        this.lastToken.setUncle(rEToken);
        return true;
    }

    public int getMinimumLength() {
        int n = 0;
        REToken rEToken = this.firstToken;
        do {
            n += rEToken.getMinimumLength();
        } while ((rEToken = rEToken.m_next) != null);
        return n;
    }

    public REMatch[] getAllMatches(Object object) {
        return this.getAllMatches(object, 0, 0);
    }

    public REMatch[] getAllMatches(Object object, int n) {
        return this.getAllMatches(object, n, 0);
    }

    public REMatch[] getAllMatches(Object object, int n, int n2) {
        return this.getAllMatchesImpl(RE.makeCharIndexed(object, n), n, n2);
    }

    private final REMatch[] getAllMatchesImpl(CharIndexed charIndexed, int n, int n2) {
        Vector<REMatch> vector = new Vector<REMatch>();
        REMatch rEMatch = null;
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, null)) != null) {
            vector.addElement(rEMatch);
            n = rEMatch.getEndIndex();
            if (rEMatch.end[0] == 0) {
                ++n;
                charIndexed.move(1);
                continue;
            }
            charIndexed.move(rEMatch.end[0]);
        }
        Object[] objectArray = new REMatch[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    int[] match(CharIndexed charIndexed, int n, int n2, REMatch rEMatch) {
        int[] nArray = this.firstToken.match(charIndexed, n, n2, rEMatch);
        if (nArray != null) {
            if (this.m_subIndex > 0) {
                rEMatch.start[this.m_subIndex] = n;
                rEMatch.end[this.m_subIndex] = nArray[0];
            }
            int[] nArray2 = new int[]{};
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray3 = this.next(charIndexed, nArray[n3], n2, rEMatch);
                if (nArray3 != null) {
                    int[] nArray4 = new int[nArray2.length + nArray3.length];
                    System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
                    int n4 = 0;
                    while (n4 < nArray3.length) {
                        nArray4[nArray2.length + n4] = nArray3[n4];
                        ++n4;
                    }
                    nArray2 = nArray4;
                }
                ++n3;
            }
            return nArray2.length == 0 ? null : nArray2;
        }
        return null;
    }

    public REMatch getMatch(Object object) {
        return this.getMatch(object, 0, 0);
    }

    public REMatch getMatch(Object object, int n) {
        return this.getMatch(object, n, 0);
    }

    public REMatch getMatch(Object object, int n, int n2) {
        return this.getMatch(object, n, n2, null);
    }

    public REMatch getMatch(Object object, int n, int n2, StringBuffer stringBuffer) {
        return this.getMatchImpl(RE.makeCharIndexed(object, n), n, n2, stringBuffer);
    }

    REMatch getMatchImpl(CharIndexed charIndexed, int n, int n2, StringBuffer stringBuffer) {
        if (!charIndexed.isValid()) {
            return null;
        }
        REMatch rEMatch = new REMatch(this.m_numSubs, n);
        do {
            int[] nArray;
            if ((nArray = this.match(charIndexed, 0, n2, rEMatch)) != null) {
                rEMatch.end[0] = nArray[0];
                rEMatch.finish(charIndexed);
                return rEMatch;
            }
            rEMatch.clear(++n);
            if (stringBuffer == null) continue;
            stringBuffer.append(charIndexed.charAt(0));
        } while (charIndexed.move(1));
        return null;
    }

    public REMatchEnumeration getMatchEnumeration(Object object) {
        return this.getMatchEnumeration(object, 0, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n) {
        return this.getMatchEnumeration(object, n, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object object, int n, int n2) {
        return new REMatchEnumeration(this, RE.makeCharIndexed(object, n), n, n2);
    }

    public String substitute(Object object, String string) {
        return this.substitute(object, string, 0, 0);
    }

    public String substitute(Object object, String string, int n) {
        return this.substitute(object, string, n, 0);
    }

    public String substitute(Object object, String string, int n, int n2) {
        return this.substituteImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private final String substituteImpl(CharIndexed charIndexed, String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        REMatch rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer);
        if (rEMatch == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(rEMatch.substituteInto(string));
        if (charIndexed.move(rEMatch.end[0])) {
            do {
                stringBuffer.append(charIndexed.charAt(0));
            } while (charIndexed.move(1));
        }
        return stringBuffer.toString();
    }

    public String substituteAll(Object object, String string) {
        return this.substituteAll(object, string, 0, 0);
    }

    public String substituteAll(Object object, String string, int n) {
        return this.substituteAll(object, string, n, 0);
    }

    public String substituteAll(Object object, String string, int n, int n2) {
        return this.substituteAllImpl(RE.makeCharIndexed(object, n), string, n, n2);
    }

    private final String substituteAllImpl(CharIndexed charIndexed, String string, int n, int n2) {
        REMatch rEMatch;
        StringBuffer stringBuffer = new StringBuffer();
        while ((rEMatch = this.getMatchImpl(charIndexed, n, n2, stringBuffer)) != null) {
            stringBuffer.append(rEMatch.substituteInto(string));
            n = rEMatch.getEndIndex();
            if (rEMatch.end[0] == 0) {
                char c = charIndexed.charAt(0);
                if (c != '\uffff') {
                    stringBuffer.append(c);
                }
                charIndexed.move(1);
                continue;
            }
            charIndexed.move(rEMatch.end[0]);
        }
        return stringBuffer.toString();
    }

    private final void addToken(REToken rEToken) {
        if (rEToken == null) {
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = rEToken;
        } else if (this.lastToken.chain(rEToken)) {
            this.lastToken = rEToken;
        }
    }

    REToken setRepeated(REToken rEToken, int n, int n2, int n3) throws REException {
        if (rEToken == null) {
            throw new REException("repeat preceding token", 1, n3);
        }
        return new RETokenRepeated(rEToken, n, n2);
    }

    private static final int getPosixSet(char[] cArray, int n, StringBuffer stringBuffer) {
        int n2 = n;
        while (n2 < cArray.length - 1) {
            if (cArray[n2] == ':' && cArray[n2 + 1] == ']') {
                return n2 + 1;
            }
            stringBuffer.append(cArray[n2]);
            ++n2;
        }
        return n;
    }

    private final int getMinMax(char[] cArray, int n, IntPair intPair, RESyntax rESyntax) throws REException {
        if (n == cArray.length) {
            throw new REException("no matching brace", 3, n);
        }
        int n2 = 0;
        CharUnit charUnit = new CharUnit();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = RE.getCharUnit(cArray, n, charUnit)) != cArray.length && Character.isDigit(charUnit.ch)) {
            stringBuffer.append(charUnit.ch);
        }
        if (stringBuffer.length() == 0) {
            throw new REException("bad brace construct", 3, n);
        }
        int n3 = Integer.parseInt(stringBuffer.toString());
        if (charUnit.ch == '}' && rESyntax.get(11) ^ charUnit.bk) {
            n2 = n3;
        } else if (charUnit.ch == ',' && !charUnit.bk) {
            stringBuffer = new StringBuffer();
            while ((n = RE.getCharUnit(cArray, n, charUnit)) != cArray.length && Character.isDigit(charUnit.ch)) {
                stringBuffer.append(charUnit.ch);
            }
            if (charUnit.ch != '}' || !(rESyntax.get(11) ^ charUnit.bk)) {
                throw new REException("expected end of interval", 3, n);
            }
            n2 = stringBuffer.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(stringBuffer.toString());
        } else {
            throw new REException("invalid character in brace expression", 3, n);
        }
        intPair.first = n3;
        intPair.second = n2;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.dump(stringBuffer);
        return stringBuffer.toString();
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append('(');
        if (this.m_subIndex == 0) {
            stringBuffer.append("?:");
        }
        this.firstToken.dumpAll(stringBuffer);
        stringBuffer.append(')');
    }

    private static final CharIndexed makeCharIndexed(Object object, int n) {
        if (object instanceof String) {
            return new CharIndexedString((String)object, n);
        }
        if (object instanceof char[]) {
            return new CharIndexedCharArray((char[])object, n);
        }
        if (object instanceof StringBuffer) {
            return new CharIndexedStringBuffer((StringBuffer)object, n);
        }
        if (object instanceof InputStream) {
            return new CharIndexedInputStream((InputStream)object, n);
        }
        throw new IllegalArgumentException("Invalid class for input text");
    }

    public RE(Object object) throws REException {
        this(object, 0, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n) throws REException {
        this(object, n, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object object, int n, RESyntax rESyntax) throws REException {
        this(object, n, rESyntax, 0, 0);
    }

    private RE(REToken rEToken, REToken rEToken2, int n) {
        this.firstToken = rEToken;
        this.lastToken = rEToken2;
        this.m_numSubs = n;
    }

    /*
     * Unable to fully structure code
     */
    private RE(Object var1_1, int var2_2, RESyntax var3_3, int var4_4, int var5_5) throws REException {
        super();
        if (var1_1 instanceof String) {
            var6_6 = ((String)var1_1).toCharArray();
        } else if (var1_1 instanceof char[]) {
            var6_6 = (char[])var1_1;
        } else if (var1_1 instanceof StringBuffer) {
            var6_6 = new char[((StringBuffer)var1_1).length()];
            ((StringBuffer)var1_1).getChars(0, var6_6.length, var6_6, 0);
        } else {
            throw new IllegalArgumentException("Invalid class for pattern");
        }
        var7_7 = var6_6.length;
        this.m_subIndex = var4_4;
        this.m_numSubs = 0;
        var8_8 = null;
        this.lastToken = null;
        this.firstToken = null;
        var9_9 = (var2_2 & 2) > 0;
        var10_10 = 0;
        var11_11 = new CharUnit();
        var12_12 = new IntPair();
        var13_13 = null;
        while (var10_10 < var7_7) {
            block65: {
                var10_10 = RE.getCharUnit(var6_6, var10_10, var11_11);
                if ((var11_11.ch == '|' && var3_3.get(14) ^ var11_11.bk || var3_3.get(10) && var11_11.ch == '\n' && !var11_11.bk) && !var3_3.get(9)) {
                    if (var8_8 == null) {
                        var8_8 = new Vector<RE>();
                    }
                    this.addToken(var13_13);
                    var8_8.addElement(new RE(this.firstToken, this.lastToken, this.m_numSubs));
                    var13_13 = null;
                    this.lastToken = null;
                    this.firstToken = null;
                    continue;
                }
                if (var11_11.ch == '{' && var3_3.get(8) && var3_3.get(11) ^ var11_11.bk) {
                    if (var13_13 == null) {
                        throw new REException("{ without preceding token", 3, var10_10);
                    }
                    var10_10 = this.getMinMax(var6_6, var10_10, var12_12, var3_3);
                    if (var13_13.getMinimumLength() == 0 && var12_12.second == 0x7FFFFFFF) {
                        throw new REException("repeated argument may be empty", 1, var10_10);
                    }
                    var13_13 = this.setRepeated(var13_13, var12_12.first, var12_12.second, var10_10);
                    continue;
                }
                if (var11_11.ch != '[' || var11_11.bk) break block65;
                var15_15 = new Vector<REToken>();
                var16_17 = false;
                var17_18 = 0;
                if (var10_10 == var7_7) {
                    throw new REException("unmatched [", 4, var10_10);
                }
                var14_14 = var6_6[var10_10];
                if (var14_14 == 94) {
                    var16_17 = true;
                    if (++var10_10 == var7_7) {
                        throw new REException("no end of list", 4, var10_10);
                    }
                    var14_14 = var6_6[var10_10];
                }
                if (var14_14 != 93) ** GOTO lbl87
                var17_18 = var14_14;
                if (++var10_10 != var7_7) ** GOTO lbl87
                throw new REException("no end of list", 4, var10_10);
lbl-1000:
                // 1 sources

                {
                    if (var14_14 == 45) {
                        if (var17_18 != 0) {
                            if (++var10_10 == var7_7) {
                                throw new REException("no end of list", 4, var10_10);
                            }
                            var14_14 = var6_6[var10_10];
                            var15_15.addElement(new RETokenRange((char)var17_18, (char)var14_14, var9_9));
                            var17_18 = 0;
                        } else {
                            var17_18 = var14_14;
                        }
                    } else if (var14_14 == 92 && var3_3.get(0)) {
                        if (++var10_10 == var7_7) {
                            throw new REException("no end of list", 4, var10_10);
                        }
                        if (var17_18 != 0) {
                            var15_15.addElement(new RETokenChar((char)var17_18, var9_9));
                        }
                        var17_18 = var6_6[var10_10];
                    } else if (var14_14 == 91 && var3_3.get(2) && var10_10 + 1 < var7_7 && var6_6[var10_10 + '\u0001'] == ':') {
                        var18_19 = new StringBuffer();
                        var10_10 = RE.getPosixSet(var6_6, var10_10 + 2, var18_19);
                        var19_21 = RETokenPOSIX.intValue(var18_19.toString());
                        if (var19_21 != -1) {
                            var15_15.addElement(new RETokenPOSIX(var19_21, var9_9, false));
                        }
                    } else {
                        if (var17_18 != 0) {
                            var15_15.addElement(new RETokenChar((char)var17_18, var9_9));
                        }
                        var17_18 = var14_14;
                    }
                    ++var10_10;
lbl87:
                    // 3 sources

                    ** while ((var14_14 = var6_6[var10_10]) != 93)
                }
lbl88:
                // 1 sources

                ++var10_10;
                if (var17_18 != 0) {
                    var15_15.addElement(new RETokenChar((char)var17_18, var9_9));
                }
                this.addToken(var13_13);
                var15_15.trimToSize();
                var13_13 = new RETokenOneOf(var15_15, var16_17);
                continue;
            }
            if (var11_11.ch == '(' && var3_3.get(12) ^ var11_11.bk) {
                var15_16 = false;
                var16_17 = false;
                if (var10_10 + 1 < var7_7 && var6_6[var10_10] == '?') {
                    switch (var6_6[var10_10 + 1]) {
                        case ':': {
                            if (!var3_3.get(20)) break;
                            var15_16 = true;
                            var10_10 += 2;
                            break;
                        }
                        case '#': {
                            if (!var3_3.get(23)) break;
                            var16_17 = true;
                            break;
                        }
                    }
                }
                var17_18 = var10_10;
                var18_20 = var10_10;
                var19_21 = 0;
                while (!((var18_20 = RE.getCharUnit(var6_6, var17_18, var11_11)) <= 0 || var19_21 == 0 && var11_11.ch == ')' && var3_3.get(12) ^ var11_11.bk)) {
                    var17_18 = var18_20;
                    if (var17_18 >= var7_7) {
                        throw new REException("no end of subexpression", 8, var10_10 - 1);
                    }
                    if (var11_11.ch == '(' && var3_3.get(12) ^ var11_11.bk) {
                        ++var19_21;
                        continue;
                    }
                    if (var11_11.ch != ')' || !(var3_3.get(12) ^ var11_11.bk)) continue;
                    --var19_21;
                }
                if (var16_17) {
                    var10_10 = var18_20;
                    continue;
                }
                this.addToken(var13_13);
                if (!var15_16) {
                    ++var5_5;
                    ++this.m_numSubs;
                }
                var20_22 = var15_16 != false ? 0 : var5_5;
                var13_13 = new RE(String.valueOf(var6_6, var10_10, var17_18 - var10_10).toCharArray(), var2_2, var3_3, var20_22, var5_5);
                var5_5 += ((RE)var13_13).getNumSubs();
                this.m_numSubs += ((RE)var13_13).getNumSubs();
                var10_10 = var18_20;
                continue;
            }
            if (!var3_3.get(16) && var11_11.ch == ')' && var3_3.get(12) ^ var11_11.bk) {
                throw new REException("unmatched right paren", 7, var10_10);
            }
            if (var11_11.ch == '^' && !var11_11.bk) {
                this.addToken(var13_13);
                var13_13 = null;
                this.addToken(new RETokenStart((var2_2 & 8) > 0));
                continue;
            }
            if (var11_11.ch == '$' && !var11_11.bk) {
                this.addToken(var13_13);
                var13_13 = null;
                this.addToken(new RETokenEnd((var2_2 & 8) > 0));
                continue;
            }
            if (var11_11.ch == '.' && !var11_11.bk) {
                this.addToken(var13_13);
                var13_13 = new RETokenAny(var3_3.get(6) != false || (var2_2 & 4) > 0, var3_3.get(7));
                continue;
            }
            if (var11_11.ch == '*' && !var11_11.bk) {
                if (var13_13.getMinimumLength() == 0) {
                    throw new REException("repeated argument may be empty", 1, var10_10);
                }
                var13_13 = this.setRepeated(var13_13, 0, 0x7FFFFFFF, var10_10);
                continue;
            }
            if (var11_11.ch == '+' && !var3_3.get(9) && var3_3.get(1) == false ^ var11_11.bk) {
                if (var13_13.getMinimumLength() == 0) {
                    throw new REException("repeated argument may be empty", 1, var10_10);
                }
                var13_13 = this.setRepeated(var13_13, 1, 0x7FFFFFFF, var10_10);
                continue;
            }
            if (var11_11.ch == '?' && !var3_3.get(9) && var3_3.get(1) == false ^ var11_11.bk) {
                if (var13_13 == null) {
                    throw new REException("? without preceding token", 1, var10_10);
                }
                if (var13_13 instanceof RETokenRepeated && var3_3.get(18)) {
                    ((RETokenRepeated)var13_13).makeStingy();
                    continue;
                }
                var13_13 = this.setRepeated(var13_13, 0, 1, var10_10);
                continue;
            }
            if (var11_11.bk && Character.isDigit(var11_11.ch) && !var3_3.get(13)) {
                this.addToken(var13_13);
                var13_13 = new RETokenBackRef(Character.digit(var11_11.ch, 10), var9_9);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'A' && var3_3.get(22)) {
                this.addToken(var13_13);
                var13_13 = new RETokenStart(false);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'd' && var3_3.get(19)) {
                this.addToken(var13_13);
                var13_13 = new RETokenPOSIX(4, var9_9, false);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'D' && var3_3.get(19)) {
                this.addToken(var13_13);
                var13_13 = new RETokenPOSIX(4, var9_9, true);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'n') {
                this.addToken(var13_13);
                var13_13 = new RETokenChar('\n', false);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'r') {
                this.addToken(var13_13);
                var13_13 = new RETokenChar('\r', false);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 's' && var3_3.get(19)) {
                this.addToken(var13_13);
                var13_13 = new RETokenPOSIX(9, var9_9, false);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'S' && var3_3.get(19)) {
                this.addToken(var13_13);
                var13_13 = new RETokenPOSIX(9, var9_9, true);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 't') {
                this.addToken(var13_13);
                var13_13 = new RETokenChar('\t', false);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'w' && var3_3.get(19)) {
                this.addToken(var13_13);
                var13_13 = new RETokenPOSIX(0, var9_9, false);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'W' && var3_3.get(19)) {
                this.addToken(var13_13);
                var13_13 = new RETokenPOSIX(0, var9_9, true);
                continue;
            }
            if (var11_11.bk && var11_11.ch == 'Z' && var3_3.get(22)) {
                this.addToken(var13_13);
                var13_13 = new RETokenEnd(false);
                continue;
            }
            this.addToken(var13_13);
            var13_13 = new RETokenChar(var11_11.ch, var9_9);
        }
        this.addToken(var13_13);
        if (var8_8 != null) {
            var8_8.addElement(new RE(this.firstToken, this.lastToken, this.m_numSubs));
            var8_8.trimToSize();
            this.firstToken = this.lastToken = new RETokenOneOf(var8_8, false);
        }
    }
}

