/*
 * Decompiled with CFR 0.152.
 */
import de.fub.bytecode.Repository;
import de.fub.bytecode.classfile.ClassParser;
import de.fub.bytecode.classfile.Code;
import de.fub.bytecode.classfile.JavaClass;
import de.fub.bytecode.classfile.Method;
import java.io.IOException;

public class listclass {
    public static void main(String[] argv) {
        String[] file_name = new String[argv.length];
        int files = 0;
        boolean code = false;
        boolean constants = false;
        boolean verbose = true;
        String name = null;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].charAt(0) == '-') {
                if (argv[i].equals("-constants")) {
                    constants = true;
                } else if (argv[i].equals("-code")) {
                    code = true;
                } else if (argv[i].equals("-brief")) {
                    verbose = false;
                } else {
                    System.err.println("Unknown switch " + argv[i] + " ignored.");
                }
            } else {
                file_name[files++] = argv[i];
            }
            ++i;
        }
        try {
            if (files == 0) {
                System.err.println("list: No input files specified");
            } else {
                int i2 = 0;
                while (i2 < files) {
                    name = file_name[i2];
                    JavaClass java_class = Repository.lookupClass(name);
                    if (java_class == null) {
                        java_class = new ClassParser(name).parse();
                    }
                    System.out.println(java_class);
                    if (constants) {
                        System.out.println(java_class.getConstantPool());
                    }
                    if (code) {
                        listclass.printCode(java_class.getMethods(), verbose);
                    }
                    ++i2;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Couldn't find class " + name);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void printCode(Method[] methods, boolean verbose) {
        int i = 0;
        while (i < methods.length) {
            System.out.println(methods[i]);
            Code code = methods[i].getCode();
            if (code != null) {
                System.out.println(code.toString(verbose));
            }
            ++i;
        }
    }
}

