/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

import jas.AsciiCP;
import jas.CP;
import jas.Catchtable;
import jas.ClassCP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.ConstAttr;
import jas.DoubleCP;
import jas.ExceptAttr;
import jas.FieldCP;
import jas.FloatCP;
import jas.IincInsn;
import jas.Insn;
import jas.IntegerCP;
import jas.InterfaceCP;
import jas.InvokeinterfaceInsn;
import jas.Label;
import jas.LineTableAttr;
import jas.LocalVarEntry;
import jas.LocalVarTableAttr;
import jas.LongCP;
import jas.LookupswitchInsn;
import jas.MethodCP;
import jas.MultiarrayInsn;
import jas.StringCP;
import jas.TableswitchInsn;
import jas.Var;
import jas.jasError;
import jasmin.InsnInfo;
import jasmin.Scanner;
import jasmin.ScannerUtils;
import jasmin.parser;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassFile {
    String filename;
    ClassEnv class_env;
    String class_name;
    String source_name;
    Scanner scanner;
    String method_name;
    String method_signature;
    short method_access;
    ExceptAttr except_attr;
    Catchtable catch_table;
    LocalVarTableAttr var_table;
    LineTableAttr line_table;
    CodeAttr code;
    Hashtable labels;
    int line_label_count;
    int line_num;
    boolean auto_number;
    Vector switch_vec;
    int low_value;
    int high_value;
    static final String BGN_METHOD = "bgnmethod:";
    static final String END_METHOD = "endmethod:";
    int errors;

    void report_error(String string) {
        System.err.print(this.filename + ":");
        System.err.print(this.scanner.line_num);
        System.err.println(": " + string + ".");
        if (this.scanner.char_num >= 0) {
            System.err.println(this.scanner.line.toString());
            int n = 0;
            while (n < this.scanner.char_num) {
                if (this.scanner.line.charAt(n) == '\t') {
                    System.err.print("\t");
                } else {
                    System.err.print(" ");
                }
                ++n;
            }
            System.err.println("^");
        }
        ++this.errors;
    }

    void setSource(String string) {
        this.source_name = string;
    }

    void setClass(String string, short s) {
        this.class_name = string;
        this.class_env.setClass(new ClassCP(string));
        this.class_env.setClassAccess(s);
    }

    void setSuperClass(String string) {
        this.class_env.setSuperClass(new ClassCP(string));
    }

    void addInterface(String string) {
        this.class_env.addInterface(new ClassCP(string));
    }

    void addField(short s, String string, String string2, Object object) {
        if (object == null) {
            this.class_env.addField(new Var(s, new AsciiCP(string), new AsciiCP(string2), null));
            return;
        }
        CP cP = null;
        if (object instanceof Integer) {
            cP = new IntegerCP((Integer)object);
        } else if (object instanceof Float) {
            cP = new FloatCP(((Float)object).floatValue());
        } else if (object instanceof Double) {
            cP = new DoubleCP((Double)object);
        } else if (object instanceof Long) {
            cP = new LongCP((Long)object);
        } else if (object instanceof String) {
            cP = new StringCP((String)object);
        }
        this.class_env.addField(new Var(s, new AsciiCP(string), new AsciiCP(string2), new ConstAttr(cP)));
    }

    void newMethod(String string, String string2, int n) {
        this.labels = new Hashtable();
        this.method_name = string;
        this.code = null;
        this.except_attr = null;
        this.catch_table = null;
        this.var_table = null;
        this.line_table = null;
        this.line_label_count = 0;
        this.method_signature = string2;
        this.method_access = (short)n;
    }

    void endMethod() throws jasError {
        if (this.code != null) {
            this.plantLabel(END_METHOD);
            if (this.catch_table != null) {
                this.code.setCatchtable(this.catch_table);
            }
            if (this.var_table != null) {
                this.code.setLocalVarTable(this.var_table);
            }
            if (this.line_table != null) {
                this.code.setLineTable(this.line_table);
            }
        }
        this.class_env.addMethod(this.method_access, this.method_name, this.method_signature, this.code, this.except_attr);
        this.code = null;
        this.labels = null;
        this.method_name = null;
        this.code = null;
        this.except_attr = null;
        this.catch_table = null;
        this.line_table = null;
        this.var_table = null;
    }

    void plant(String string) throws jasError {
        InsnInfo insnInfo = (InsnInfo)InsnInfo.infoTable.get(string);
        this.autoNumber();
        if (insnInfo.args.equals("")) {
            this._getCode().addInsn(new Insn(insnInfo.opcode));
            return;
        }
        if (!insnInfo.name.equals("wide")) {
            throw new jasError("Missing arguments for instruction " + string);
        }
    }

    void plant(String string, int n, int n2) throws jasError {
        this.autoNumber();
        if (string.equals("iinc")) {
            this._getCode().addInsn(new IincInsn(n, n2));
            return;
        }
        throw new jasError("Bad arguments for instruction " + string);
    }

    void plant(String string, int n) throws jasError {
        InsnInfo insnInfo = (InsnInfo)InsnInfo.infoTable.get(string);
        CodeAttr codeAttr = this._getCode();
        this.autoNumber();
        if (insnInfo.args.equals("i")) {
            codeAttr.addInsn(new Insn(insnInfo.opcode, n));
            return;
        }
        if (insnInfo.args.equals("constant")) {
            codeAttr.addInsn(new Insn(insnInfo.opcode, new IntegerCP(n)));
            return;
        }
        if (insnInfo.args.equals("bigconstant")) {
            codeAttr.addInsn(new Insn(insnInfo.opcode, new LongCP(n)));
            return;
        }
        throw new jasError("Bad arguments for instruction " + string);
    }

    void plant(String string, Number number) throws jasError {
        InsnInfo insnInfo = (InsnInfo)InsnInfo.infoTable.get(string);
        CodeAttr codeAttr = this._getCode();
        this.autoNumber();
        if (insnInfo.args.equals("i") && number instanceof Integer) {
            codeAttr.addInsn(new Insn(insnInfo.opcode, number.intValue()));
            return;
        }
        if (insnInfo.args.equals("constant")) {
            if (number instanceof Integer || number instanceof Long) {
                codeAttr.addInsn(new Insn(insnInfo.opcode, new IntegerCP(number.intValue())));
                return;
            }
            if (number instanceof Float || number instanceof Double) {
                codeAttr.addInsn(new Insn(insnInfo.opcode, new FloatCP(number.floatValue())));
            }
            return;
        }
        if (insnInfo.args.equals("bigconstant")) {
            if (number instanceof Integer || number instanceof Long) {
                codeAttr.addInsn(new Insn(insnInfo.opcode, new LongCP(number.longValue())));
                return;
            }
            if (number instanceof Float || number instanceof Double) {
                codeAttr.addInsn(new Insn(insnInfo.opcode, new DoubleCP(number.doubleValue())));
            }
            return;
        }
        throw new jasError("Bad arguments for instruction " + string);
    }

    void plantString(String string, String string2) throws jasError {
        InsnInfo insnInfo = (InsnInfo)InsnInfo.infoTable.get(string);
        this.autoNumber();
        if (insnInfo.args.equals("constant")) {
            this._getCode().addInsn(new Insn(insnInfo.opcode, new StringCP(string2)));
            return;
        }
        throw new jasError("Bad arguments for instruction " + string);
    }

    void plant(String string, String string2, int n) throws jasError {
        InsnInfo insnInfo = (InsnInfo)InsnInfo.infoTable.get(string);
        CodeAttr codeAttr = this._getCode();
        this.autoNumber();
        if (insnInfo.args.equals("interface")) {
            String[] stringArray = ScannerUtils.splitClassMethodSignature(string2);
            codeAttr.addInsn(new InvokeinterfaceInsn(new InterfaceCP(stringArray[0], stringArray[1], stringArray[2]), n));
            return;
        }
        if (insnInfo.args.equals("marray")) {
            codeAttr.addInsn(new MultiarrayInsn(new ClassCP(string2), n));
            return;
        }
        throw new jasError("Bad arguments for instruction " + string);
    }

    void plant(String string, String string2) throws jasError {
        InsnInfo insnInfo = (InsnInfo)InsnInfo.infoTable.get(string);
        CodeAttr codeAttr = this._getCode();
        this.autoNumber();
        if (insnInfo.args.equals("method")) {
            String[] stringArray = ScannerUtils.splitClassMethodSignature(string2);
            codeAttr.addInsn(new Insn(insnInfo.opcode, new MethodCP(stringArray[0], stringArray[1], stringArray[2])));
            return;
        }
        if (insnInfo.args.equals("constant")) {
            codeAttr.addInsn(new Insn(insnInfo.opcode, new ClassCP(string2)));
            return;
        }
        if (insnInfo.args.equals("atype")) {
            int n = 0;
            if (string2.equals("boolean")) {
                n = 4;
            } else if (string2.equals("char")) {
                n = 5;
            } else if (string2.equals("float")) {
                n = 6;
            } else if (string2.equals("double")) {
                n = 7;
            } else if (string2.equals("byte")) {
                n = 8;
            } else if (string2.equals("short")) {
                n = 9;
            } else if (string2.equals("int")) {
                n = 10;
            } else if (string2.equals("long")) {
                n = 11;
            } else {
                throw new jasError("Bad array type: " + string);
            }
            codeAttr.addInsn(new Insn(insnInfo.opcode, n));
            return;
        }
        if (insnInfo.args.equals("label")) {
            codeAttr.addInsn(new Insn(insnInfo.opcode, this.getLabel(string2)));
            return;
        }
        if (insnInfo.args.equals("class")) {
            codeAttr.addInsn(new Insn(insnInfo.opcode, new ClassCP(string2)));
            return;
        }
        throw new jasError("Bad arguments for instruction " + string);
    }

    void plant(String string, String string2, String string3) throws jasError {
        InsnInfo insnInfo = (InsnInfo)InsnInfo.infoTable.get(string);
        CodeAttr codeAttr = this._getCode();
        this.autoNumber();
        if (insnInfo.args.equals("field")) {
            String[] stringArray = ScannerUtils.splitClassField(string2);
            codeAttr.addInsn(new Insn(insnInfo.opcode, new FieldCP(stringArray[0], stringArray[1], string3)));
            return;
        }
        throw new jasError("Bad arguments for instruction " + string);
    }

    void newLookupswitch() throws jasError {
        this.switch_vec = new Vector();
        this.autoNumber();
    }

    void addLookupswitch(int n, String string) throws jasError {
        this.switch_vec.addElement(new Integer(n));
        this.switch_vec.addElement(this.getLabel(string));
    }

    void endLookupswitch(String string) throws jasError {
        int n = this.switch_vec.size() >> 1;
        int[] nArray = new int[n];
        Label[] labelArray = new Label[n];
        Enumeration enumeration = this.switch_vec.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            nArray[n2] = (Integer)enumeration.nextElement();
            labelArray[n2] = (Label)enumeration.nextElement();
            ++n2;
        }
        this._getCode().addInsn(new LookupswitchInsn(this.getLabel(string), nArray, labelArray));
    }

    void newTableswitch(int n) throws jasError {
        this.newTableswitch(n, -1);
    }

    void newTableswitch(int n, int n2) throws jasError {
        this.switch_vec = new Vector();
        this.low_value = n;
        this.high_value = n2;
        this.autoNumber();
    }

    void addTableswitch(String string) throws jasError {
        this.switch_vec.addElement(this.getLabel(string));
    }

    void endTableswitch(String string) throws jasError {
        int n = this.switch_vec.size();
        Label[] labelArray = new Label[n];
        Enumeration enumeration = this.switch_vec.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            labelArray[n2] = (Label)enumeration.nextElement();
            ++n2;
        }
        if (this.high_value != -1 && this.high_value != this.low_value + n - 1) {
            this.report_error("tableswitch - given incorrect value for <high>");
        }
        this._getCode().addInsn(new TableswitchInsn(this.low_value, this.low_value + n - 1, this.getLabel(string), labelArray));
    }

    void setLine(int n) {
        this.line_num = n;
    }

    void autoNumber() throws jasError {
        if (this.auto_number) {
            this.addLineInfo(this.line_num);
        }
    }

    Label getLabel(String string) throws jasError {
        if (this.method_name == null) {
            throw new jasError("illegal use of label outside of method definition");
        }
        Label label = (Label)this.labels.get(string);
        if (label == null) {
            label = new Label(string);
            this.labels.put(string, label);
        }
        return label;
    }

    void plantLabel(String string) throws jasError {
        this._getCode().addInsn(this.getLabel(string));
    }

    void addVar(String string, String string2, String string3, String string4, int n) throws jasError {
        if (string == null) {
            string = BGN_METHOD;
        }
        if (string2 == null) {
            string2 = END_METHOD;
        }
        Label label = this.getLabel(string);
        Label label2 = this.getLabel(string2);
        if (this.var_table == null) {
            this.var_table = new LocalVarTableAttr();
        }
        this.var_table.addEntry(new LocalVarEntry(label, label2, string3, string4, n));
    }

    void addLineInfo(int n) throws jasError {
        String string = "L:" + this.line_label_count++;
        if (this.line_table == null) {
            this.line_table = new LineTableAttr();
        }
        this.plantLabel(string);
        this.line_table.addEntry(this.getLabel(string), n);
    }

    void addLine(int n) throws jasError {
        if (!this.auto_number) {
            this.addLineInfo(n);
        }
    }

    void addThrow(String string) throws jasError {
        if (this.method_name == null) {
            throw new jasError("illegal use of .throw outside of method definition");
        }
        if (this.except_attr == null) {
            this.except_attr = new ExceptAttr();
        }
        this.except_attr.addException(new ClassCP(string));
    }

    void addCatch(String string, String string2, String string3, String string4) throws jasError {
        if (this.method_name == null) {
            throw new jasError("illegal use of .catch outside of method definition");
        }
        if (this.catch_table == null) {
            this.catch_table = new Catchtable();
        }
        ClassCP classCP = string.equals("all") ? null : new ClassCP(string);
        this.catch_table.addEntry(this.getLabel(string2), this.getLabel(string3), this.getLabel(string4), classCP);
    }

    void setStackSize(short s) throws jasError {
        this._getCode().setStackSize(s);
    }

    void setVarSize(short s) throws jasError {
        this._getCode().setVarSize(s);
    }

    CodeAttr _getCode() throws jasError {
        if (this.method_name == null) {
            throw new jasError("illegal use of instruction outside of method definition");
        }
        if (this.code == null) {
            this.code = new CodeAttr();
            this.plantLabel(BGN_METHOD);
        }
        return this.code;
    }

    public void readJasmin(InputStream inputStream, String string, boolean bl) throws IOException, Exception {
        this.errors = 0;
        this.filename = string;
        this.source_name = string;
        this.auto_number = bl;
        this.class_env = new ClassEnv();
        this.scanner = new Scanner(inputStream);
        parser parser2 = new parser(this, this.scanner);
        parser2.parse();
    }

    public int errorCount() {
        return this.errors;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void write(OutputStream outputStream) throws IOException, jasError {
        this.class_env.setSource(this.source_name);
        this.class_env.write(new DataOutputStream(outputStream));
    }
}

