import java.io.*;

public class Loader extends ClassLoader {
    Loader(String _lname, ClassLoader _parent) {
	lname  = _lname;
	parent = _parent;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
	if (name.length()==1) {
	    System.out.println("-I- " + lname+".loadClass("+name+")");
	   try {
	    byte[] b = loadClassData(name);
	    System.out.println("-I- creating loader " + lname + name);
	    Loader L = new Loader(lname+name,this);
	    System.out.println("-I- " + lname+name+
			       ".defineClass("+name+")");
  	    return L.defineClass(name,b,0,b.length);
	  }
	  catch (Throwable e) {
	    return parent.loadClass(name);
	  }
        }
        else {
          return ClassLoader.getSystemClassLoader().loadClass(name);
        }
    }

    private byte[] loadClassData(String name) throws IOException {
	FileInputStream f = new FileInputStream(lname+"/"+name+".class");
	byte[] b = new byte[f.available()];
	f.read(b);
	return b;
    }

    public String getName() { return lname; }

    String      lname;
    ClassLoader parent;
}
