package de.fub.bytecode.generic;

/** 
 * ILOAD - Load int from local variable
 * Stack ... -> ..., result
 *
 * @version $Id: ILOAD.java,v 1.5 2000/04/19 08:47:09 dahm Exp $
 * @author  <A HREF="http://www.inf.fu-berlin.de/~dahm">M. Dahm</A>
 */
public class ILOAD extends LocalVariableInstruction implements PushInstruction {
  /**
   * Empty constructor needed for the Class.newInstance() statement in
   * Instruction.readInstruction(). Not to be used otherwise.
   */
  ILOAD() {
    super(ILOAD, ILOAD_0);
  }

  /** Load int from local variable
   * @param n index of local variable
   */
  public ILOAD(int n) {
    super(ILOAD, ILOAD_0, n);
  }
}

