function ITIP_kern(m,k,multi)
% ***********************************************************************
% *                                                                     *
% *             Information Theoretic Inequality Prover (ITIP)          *
% *                                                                     *
% *                   Raymond W. Yeung and Ying-On Yan                  *
% *                                                                     *
% *                              Version 3.0                            *
% *                    Last updated on August 10, 2001                  *
% *                          All rights reserved                        *
% *                                                                     *
% *         Please send comments and suggestions to the authors at:     *
% *               whyeung@ie.cuhk.edu.hk and yy26@cornell.edu           *
% *                                                                     *
% ***********************************************************************
warning off
global ITIP_result ITIP_display use_ZY98 ZY98_invoked
n=size(m,1);
if n<=1
	disp('Input must involve at least two non-redundant random variables.') ;
	return ;
end
ITIP_result=1;
[row,col,coef,nc,nr]=make_D(log2(n+1));
D=-full(sparse(row,col,coef,nc,nr));

check_ZY98=0;
if exist('use_ZY98')
	if use_ZY98==1
		check_ZY98=1;
		if log2(n+1) >= 4
			[row2,col2,coef2,nc2,nr2]=make_NS(log2(n+1));
			NS=-full(sparse(row2,col2,coef2,nc2,nr2));
			rNS=size(NS,1);
		else
			NS=[];
			rNS=0;
		end
	end
end

ZY98_invoked=0;
rk=size(k,1);
rD=size(D,1);
m=m';
obj=m(1:multi,:);
constr=m(multi+1:rk,:);
objtype=k(1:multi,:);
constrtype=k(multi+1:rk,:);
rk=rk-multi+1;
for j=1:multi
	m=[obj(j,:) ; constr];
	k=[objtype(j,:) ; constrtype];
	if rk==1
		if k(1)==0
			if sum(abs(m))~=0
				ITIP_result=0;
				break;
			end
		else
			if sum(abs(m))~=0
				x=lp(m',D,zeros(rD,1),-ones(n,1),ones(n,1),zeros(n,1)) ;
				if sum(abs(x))~=0
					if check_ZY98==1
						x2=lp(m',[D;NS],zeros(rD+rNS,1),-ones(n,1),ones(n,1),zeros(n,1)) ;
						ZY98_invoked=1;
					else
						x2=1;
					end

					if sum(abs(x2))~=0
						ITIP_result=0;
						break;
					end
				end
			end
		end
	else
		eq=find(k(2:rk)==0)+1 ;
		eqconstr=m(eq,:) ;
		ieconstr=-m(find(k(2:rk)==1)+1,:) ;
		Dn=[eqconstr;ieconstr;D] ;

		if sum(abs(m(1,:)))~=0 & rank(eqconstr)~=rank([eqconstr;m(1,:)])
			x=abs(lp(m(1,:)',Dn,zeros(rD+rk-1,1),-ones(n,1),ones(n,1),zeros(n,1),size(eq,1))) ;
			if k(1)==0
				x=x+abs(lp(-m(1,:)',Dn,zeros(rD+rk-1,1),-ones(n,1),ones(n,1),zeros(n,1),size(eq,1))) ;
			end

			if sum(x)~=0
				if check_ZY98==1
					x2=abs(lp(m(1,:)',[Dn;NS],zeros(rD+rNS+rk-1,1),-ones(n,1),ones(n,1),zeros(n,1),size(eq,1))) ;
					if k(1)==0
						x2=x2+abs(lp(-m(1,:)',[Dn;NS],zeros(rD+rNS+rk-1,1),-ones(n,1),ones(n,1),zeros(n,1),size(eq,1))) ;
					end
					ZY98_invoked=1 ;
				else
					x2=1 ;
				end

				if sum(x2)~=0
					ITIP_result=0 ;
					break ;
				end
			end
		end
	end
end
if exist('ITIP_display')
	if ITIP_display==0
		return
	end
end
if check_ZY98==1
	if ZY98_invoked==1
		disp('ZY98 has been invoked ...');
	else
		disp('ZY98 has not been invoked ...');
	end
end
if ITIP_result==1
	disp('True');
else
	disp('Not provable by ITIP');
end
