%{
/***********************************************************************
 *                                                                     *
 *             Information Theoretic Inequality Prover (ITIP)          *
 *                                                                     *
 *                   Raymond W. Yeung and Ying-On Yan                  *
 *                                                                     *
 *                              Version 3.0                            *
 *                    Last updated on August 10, 2001                  *
 *                          All rights reserved                        *
 *                                                                     *
 *         Please send comments and suggestions to the authors at:     *
 *               whyeung@ie.cuhk.edu.hk and yy26@cornell.edu           *
 *                                                                     *
 ***********************************************************************/
#include <math.h>
#include "mex.h"
#include <stdlib.h>
#include <string.h>
char argnumber,**arguments,status,itype,macrodetect,multi ;
int numofinput,extrainput ;

char *input,buffer[255],ncount,fcount,vcount,condflag ;
long int field[250],attribute,attrib[26],flag ;

char rvnames[26][27],rvnames2[26][27],name[60] ;

long int rvtag[26] ;
char rvtotal ;
long int tagmask ;

double number,*nptr ;
mxArray *mptr ;
int c,offset ;
struct EQN
{
	double coef ;
	long int variable ;
	struct EQN *next ;
} *eqn, *current, *boundary ;

struct EQNLIST
{
	struct EQN *eqn ;
	char argtype ;
	struct EQNLIST *next ;
} *arghead, *arglist ;

int delimiters[30], limcount ;
%}
%start lines
%%
lines   : eq
	| macro1 {fcount=0;macrodetect=1;}
	| macro2 {fcount=0;macrodetect=2;}
	| macro3 {fcount=0;macrodetect=3;}
        ;
digit	: '0' {buffer[ncount++]='0';}
	| '1' {buffer[ncount++]='1';}
	| '2' {buffer[ncount++]='2';}
	| '3' {buffer[ncount++]='3';}
	| '4' {buffer[ncount++]='4';}
	| '5' {buffer[ncount++]='5';}
	| '6' {buffer[ncount++]='6';}
	| '7' {buffer[ncount++]='7';}
	| '8' {buffer[ncount++]='8';}
	| '9' {buffer[ncount++]='9';}
	;
digitl	: digit
	| digitl digit
	;
number	: digitl {itype=1;}
	| digitl '.' {buffer[ncount++]='.';} digitl {itype=1;}
	| const {itype=0;}
	;
letter	: 'a' {buffer[ncount++]='a';}
	| 'b' {buffer[ncount++]='b';}
	| 'c' {buffer[ncount++]='c';}
	| 'd' {buffer[ncount++]='d';}
	| 'e' {buffer[ncount++]='e';}
	| 'f' {buffer[ncount++]='f';}
	| 'g' {buffer[ncount++]='g';}
	| 'h' {buffer[ncount++]='h';}
	| 'i' {buffer[ncount++]='i';}
	| 'j' {buffer[ncount++]='j';}
	| 'k' {buffer[ncount++]='k';}
	| 'l' {buffer[ncount++]='l';}
	| 'm' {buffer[ncount++]='m';}
	| 'n' {buffer[ncount++]='n';}
	| 'o' {buffer[ncount++]='o';}
	| 'p' {buffer[ncount++]='p';}
	| 'q' {buffer[ncount++]='q';}
	| 'r' {buffer[ncount++]='r';}
	| 's' {buffer[ncount++]='s';}
	| 't' {buffer[ncount++]='t';}
	| 'u' {buffer[ncount++]='u';}
	| 'v' {buffer[ncount++]='v';}
	| 'w' {buffer[ncount++]='w';}
	| 'x' {buffer[ncount++]='x';}
	| 'y' {buffer[ncount++]='y';}
	| 'z' {buffer[ncount++]='z';}
	;
letterl	: letter
	| letterl letter
	;
const	: letterl {buffer[ncount]='\0';
		   mptr = mexGetArray(buffer,"caller") ;
		   if(mptr!=NULL)
		   {
		   	nptr = mxGetPr(mptr) ;
		   	number = *nptr ;
		   	ncount = 0;
		   }
		   else
		   {
			mexPrintf("Undefined variable %s.\n",buffer) ;
			if(input[c]!='\0')
			     input[c]='@';
		   }}
	;
var	: entropy
	| minfo
	;
term	: var {number=1;}
	| '-' var {number= -1;}
	| number var {if(itype)
		      {buffer[ncount]='\0';number=atof(buffer);ncount=0;};}
	| '-' number var {if(itype)
			  {buffer[ncount]='\0';number= -atof(buffer);ncount=0;}
			  else
				  number= - number;}
	;
expr	: term {advance();}
	| expr '+' term {advance();}
	| expr '-' term {number= -number;advance();}
	;

eq	: expr '=' _TMP '0' {arglist->argtype=0;}
	| expr '<' '=' _TMP '0' {negate1();arglist->argtype=1;}
	| expr '>' '=' _TMP '0' {arglist->argtype=1;}
	| expr '=' _TMP expr {negate2();arglist->argtype=0;}
	| expr '<' '=' _TMP expr {negate1();arglist->argtype=1;}
	| expr '>' '=' _TMP expr {negate2();arglist->argtype=1;}
	;
_TMP	: /* empty */ {boundary=current;}
	;

rv	: 'A' {if(attrib[0])    attribute=attrib[0] ;
                else 		{attribute=flag;attrib[0]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='A';}}
	| 'B' {if(attrib[1])    attribute=attrib[1] ;
                else 		{attribute=flag;attrib[1]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='B';}}
	| 'C' {if(attrib[2])    attribute=attrib[2] ;
                else 		{attribute=flag;attrib[2]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='C';}}
	| 'D' {if(attrib[3])    attribute=attrib[3] ;
                else 		{attribute=flag;attrib[3]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='D';}}
	| 'E' {if(attrib[4])    attribute=attrib[4] ;
                else 		{attribute=flag;attrib[4]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='E';}}
	| 'F' {if(attrib[5])    attribute=attrib[5] ;
                else 		{attribute=flag;attrib[5]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='F';}}
	| 'G' {if(attrib[6])    attribute=attrib[6] ;
                else 		{attribute=flag;attrib[6]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='G';}}
	| 'H' {if(attrib[7])    attribute=attrib[7] ;
                else 		{attribute=flag;attrib[7]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='H';}}
	| 'I' {if(attrib[8])    attribute=attrib[8] ;
                else 		{attribute=flag;attrib[8]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='I';}}
	| 'J' {if(attrib[9])    attribute=attrib[9] ;
                else 		{attribute=flag;attrib[9]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='J';}}
	| 'K' {if(attrib[10])    attribute=attrib[10] ;
                else 		{attribute=flag;attrib[10]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='K';}}
	| 'L' {if(attrib[11])    attribute=attrib[11] ;
                else 		{attribute=flag;attrib[11]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='L';}}
	| 'M' {if(attrib[12])    attribute=attrib[12] ;
                else 		{attribute=flag;attrib[12]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='M';}}
	| 'N' {if(attrib[13])    attribute=attrib[13] ;
                else 		{attribute=flag;attrib[13]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='N';}}
	| 'O' {if(attrib[14])    attribute=attrib[14] ;
                else 		{attribute=flag;attrib[14]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='O';}}
	| 'P' {if(attrib[15])    attribute=attrib[15] ;
                else 		{attribute=flag;attrib[15]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='P';}}
	| 'Q' {if(attrib[16])    attribute=attrib[16] ;
                else 		{attribute=flag;attrib[16]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='Q';}}
	| 'R' {if(attrib[17])    attribute=attrib[17] ;
                else 		{attribute=flag;attrib[17]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='R';}}
	| 'S' {if(attrib[18])    attribute=attrib[18] ;
                else 		{attribute=flag;attrib[18]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='S';}}
	| 'T' {if(attrib[19])    attribute=attrib[19] ;
                else 		{attribute=flag;attrib[19]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='T';}}
	| 'U' {if(attrib[20])    attribute=attrib[20] ;
                else 		{attribute=flag;attrib[20]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='U';}}
	| 'V' {if(attrib[21])    attribute=attrib[21] ;
                else 		{attribute=flag;attrib[21]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='V';}}
	| 'W' {if(attrib[22])    attribute=attrib[22] ;
                else 		{attribute=flag;attrib[22]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='W';}}
	| 'X' {if(attrib[23])    attribute=attrib[23] ;
                else 		{attribute=flag;attrib[23]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='X';}}
	| 'Y' {if(attrib[24])    attribute=attrib[24] ;
                else 		{attribute=flag;attrib[24]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='Y';}}
	| 'Z' {if(attrib[25])    attribute=attrib[25] ;
                else 		{attribute=flag;attrib[25]=flag;flag=flag<<1;
			 	 rvnames[vcount++][0]='Z';}}
        ;

rvlist  : rv {field[fcount]=attribute;}
        | rvlist rv {field[fcount]|=attribute;}
        | rvlist ',' rv {field[fcount]|=attribute;}
        ;
rvcore  : rvlist ';' _ADDF rvlist
        | rvcore ';' _ADDF rvlist
        ;

entropy : 'H' '(' rvlist ')' {condflag=0;}
	| 'H' '(' rvlist _ADDF '|' rvlist ')' {condflag=1;}
	;

minfo	: 'I' '(' rvcore ')' {condflag=0;}
	| 'I' '(' rvcore '|' _ADDF rvlist ')' {condflag=1;}
	;

_ADDF   : /* empty */ {fcount++;}
        ;

macro1	: rvlist ':' _MAC1 rvlist
	;
macro2	: rvlist '.' _MAC1 rvlist
	| macro2 '.' _MAC2 rvlist
	;
macro3	: rvlist '/' _MAC1 rvlist '/' _MAC2 rvlist
	| macro3 '/' _MAC2 rvlist {extrainput++;}
	;
_MAC1	: /* empty */ {delimiters[0]=c;limcount=1;}
	;
_MAC2	: /* empty */ {delimiters[limcount++]=c;}
	;
%%
void expandmacro1()
{
	char temp[2048] ;
	input[delimiters[0]-1] = '|' ;
	temp[0] = 'H' ;
	temp[1] = '(' ;
	temp[2] = '\0' ;
	strcat(temp,input) ;
	strcat(temp,")=0") ;
	strcpy(input,temp) ;
	c = 0 ;
	yyparse() ;
}

void expandmacro2()
{
	char temp[2048] ;
	int l, j ;
	for(l=0;l<limcount;l++)
		input[delimiters[l]-1] = ' ' ;
	temp[0] = 'H' ;
	temp[1] = '(' ;
	temp[2] = '\0' ;
	strcat(temp,input) ;
	strcat(temp,")=H(") ;
	for(l=0,j=0;l<limcount;l++)
	{
		input[delimiters[l]-1] = '\0' ;
		strcat(temp,input+j) ;
		strcat(temp,")+H(") ;
		j = delimiters[l] ;
	}
	strcat(temp,input+j) ;
	strcat(temp,")") ;
	strcpy(input,temp) ;
	c = 0 ;
	yyparse() ;
}

void expandmacro3()
{
	char temp[2048], backup[2048], *p ;
	int l, j ;
	if(argnumber==0)
		multi = limcount - 1 ;

	strcpy(backup,input) ;
	for(l=0;l<limcount;l++)
		backup[delimiters[l]-1] = '\0' ;
	temp[0] = 'I' ;
	temp[1] = '(' ;
	p = temp + 2 ;
	for(l=1;l<limcount;l++)
	{
		*p = '\0' ;
		strcat(p,backup) ;
		strcat(p,";") ;
		strcat(p,backup+delimiters[l]) ;
		strcat(p,"|") ;
		strcat(p,backup+delimiters[l-1]) ;
		strcat(p,")=0") ;

		strcpy(input,temp) ;
		c = 0 ;
		yyparse() ;

		arglist->next = (struct EQNLIST *) mxCalloc(1,sizeof(struct EQNLIST)) ;
		arglist = arglist->next ;
		arglist->next = NULL ;

		if(l!=(limcount-1))
		{
			arglist->eqn = (struct EQN *) mxCalloc(1,sizeof(struct EQN)) ;
			eqn = arglist->eqn ;
			eqn->next = NULL ;
			current = eqn ;

			backup[delimiters[l-1]-1] = ' ' ;
		}
		else
			arglist->eqn = NULL ;
	}
}

void allocate()
{
	current->next = (struct EQN *) mxCalloc(1,sizeof(struct EQN)) ;
	current = current->next ;
	current->next = NULL ;
}

void advance()
{
	char tail,i,j,p,notdone ;
	long int mask,temp ;
	int bptr,bcount,btemp,bfinal ;
	tail = fcount ;
	if(condflag)
		tail-- ;
	notdone = 1 ;
	p = 0 ;
	for(j=1;j<=tail;j++)
	{
		for(i=0;i<=p;i++)
		{
			mask = field[i] & field[j] ;
			if(mask==field[i] || mask==field[j])
			{
				field[i] = mask ;
				break ;
			}
		}
		if(i>p)
			field[++p] = field[j] ;
	}	

	if(condflag)
	{
		mask = ~field[fcount] ;
		for(i=0;i<=p;i++)
		{
			temp = field[i] & mask ;
			if(temp)
				field[i] = temp ;
			else
			{
				notdone = 0 ;
				break ;
			}
		}
	}

	if(notdone)
	{
		if(!p)
		{
			if(condflag)
			{
				current->coef = number ;
				current->variable = field[0] | field[fcount] ;
				allocate() ;
				current->coef = - number ;
				current->variable = field[fcount] ;
			}
			else
			{
				current->coef = number ;
				current->variable = field[0] ;
			}
			allocate() ;
		}
		else
		{
			bfinal = (1L << (p+1)) - 1 ;
			if(condflag)
				mask = field[fcount] ;
			else
				mask = 0 ;

			for(bcount=1;bcount<=bfinal;bcount++)
			{
				btemp = (bcount & 0xFFFF) ^ (bcount >> 16) ;
				btemp = (btemp & 0xFF) ^ (btemp >> 8) ;
				btemp = (btemp & 0xF) ^ (btemp >> 4) ;
				btemp = (btemp & 0x3) ^ (btemp >> 2) ;
				btemp = (btemp & 0x1) ^ (btemp >> 1) ;

				temp = mask ;
				for(bptr=0;bptr<=p;bptr++)
					if(bcount & (1L << bptr))
						temp |= field[bptr] ;

				if(btemp)
					current->coef = number ;
				else
					current->coef = - number ;
				current->variable = temp ;

				allocate() ;
			}

			if(condflag)
			{
				current->coef = - number ;
				current->variable = mask ;
				allocate() ;
			}
		}
	}

	fcount = 0 ;
}

void negate1()
{
	current = eqn ;
	while(current!=boundary)
	{
		current->coef = - current->coef ;
		current = current->next ;
	}
}

void negate2()
{
	current = boundary ;
	while(current->next!=NULL)
	{
		current->coef= -current->coef ;
		current=current->next ;
	}
}

void free_eqn()
{
	struct EQN *temp ;
	int count ;

	for(count=0;count<numofinput;count++)
		mxFree(arguments[count]) ;
	mxFree(arguments) ;

	arglist = arghead ;
	while(arglist!=NULL)
	{
		current = arglist->eqn ;
		while(current!=NULL)
		{
			temp = current->next ;
			mxFree(current) ;
			current = temp ;
		}
		arghead = arglist ;
		arglist = arglist->next ;
		mxFree(arghead) ;
	}
}

void new_rv(tag)
long tag ;
{
	char index, oldtotal ;
	long part0, part1, part2 ;
	if(tag & tagmask)
	{
		tagmask = tagmask | tag ;
		oldtotal = rvtotal ;
		index = 0 ;
		while(tag)
		{
			if(index==oldtotal)
			{
				rvtag[rvtotal++] = tag ;
				tag = 0 ;
			}
			else
			{
				part0 = rvtag[index] & tag ;
				if(part0)
				{
					part1 = rvtag[index] & (~tag) ;
					part2 = (~rvtag[index]) & tag ;

					rvtag[index++] = part0 ;
					if(part1)
						rvtag[rvtotal++] = part1 ;
					tag = part2 ;
				}
				else
					index++ ;
			}
		}
	}
	else
	{
		tagmask = tagmask | tag ;
		rvtag[rvtotal++] = tag ;
	}
}

void reduce_rv()
{
	current = eqn ;
	while(current->next!=NULL)
	{
		new_rv(current->variable) ;
		current=current->next ;
	}
}

void split_rv(p)
long int *p ;
{
	char index ;
	long int current_bit, temp, output ;

	temp = *p ;
	output = 0 ;

	for(index=0,current_bit=1;index<rvtotal;index++,current_bit<<=1)
		if(temp & rvtag[index])
		{
			output = output | current_bit ;
			temp = temp & (~rvtag[index]) ;
		}

	*p = output ;
}

void map_rv()
{
	current = eqn ;
	while(current->next!=NULL)
	{
		split_rv(&(current->variable)) ;
		current=current->next ;
	}
}

void expand(coef)
double *coef ;
{
	current = eqn ;
	while(current->next!=NULL)
	{
		coef[current->variable] += current->coef ;
		current=current->next ;
	}
}

int yylex()
{
	while(input[c]==' ')
		c++ ;
        return(input[c++]) ;
}

int yyerror(s)
char *s;
{
        struct EQN *temp ;
        mexPrintf("%s\n",s) ;
	free_eqn() ;
	status = 1 ;
	return(-1) ;
}

#ifdef __STDC__
void mexFunction(nlhs,plhs,nrhs,prhs)
#else
mexFunction(nlhs,plhs,nrhs,prhs)
#endif
int nlhs,nrhs;
mxArray *plhs[];
const mxArray *prhs[];
{
	char temp, temp2, optim ;
	long b ;
	mxArray *inmatrix, *intype, *dummy[4], *rubbish[1] ;
	double *ptr ;

	if(nrhs < 1)
		mexErrMsgTxt("At least one input argument is needed.") ;

	numofinput = nrhs ;
	for(temp=0;temp<26;temp++)
	{
		attrib[temp] = 0 ;
		rvnames[temp][1] = '\0' ;
	}

	flag = 1 ;
	vcount = 0 ;
	status = 0 ;
	extrainput = 0 ;
	multi = 1 ;

	arguments = (char **) mxCalloc(1,sizeof(char *)*nrhs) ;
	arghead = (struct EQNLIST *) mxCalloc(1,sizeof(struct EQNLIST)) ;
	arglist = arghead ;
	arglist->eqn = NULL ;
	arglist->next = NULL ;

	for(argnumber=0;argnumber<nrhs;argnumber++)
	{
		ncount = 0 ;
		fcount = 0 ;
		c = 0 ;

		arguments[argnumber]=(char *) mxCalloc(1,2048) ;
		mxGetString(prhs[argnumber],arguments[argnumber],2048) ;
		input = arguments[argnumber] ;

		arglist->eqn = (struct EQN *) mxCalloc(1,sizeof(struct EQN)) ;
		eqn = arglist->eqn ;
		eqn->next = NULL ;
		current = eqn ;

		macrodetect = 0 ;
		yyparse() ;

		if(status)
			return ;

		switch(macrodetect)
		{
			case 1: expandmacro1() ; break ;
			case 2: expandmacro2() ; break ;
			case 3: expandmacro3() ;
		}
		

		if(macrodetect!=3)
		{

			arglist->next = (struct EQNLIST *) mxCalloc(1,sizeof(struct EQNLIST)) ;
			arglist = arglist->next ;
			arglist->eqn = NULL ;
			arglist->next = NULL ;
		}
	}

	optim = 1 ;
	mptr = mexGetArray("ITIP_optim","global") ;
	if(mptr!=NULL)
	{
		ptr = mxGetPr(mptr) ;
		if(*ptr==0)
			optim = 0 ;
	}

	if(optim)
	{
		rvtotal = 0 ;
		tagmask = 0 ;

		arglist = arghead ;
		while(arglist!=NULL)
		{
			if(arglist->eqn!=NULL)
			{
				eqn = arglist->eqn ;
				reduce_rv() ;
			}
			arglist = arglist->next ;
		}

		if(flag > 1L<<rvtotal)
		{
			arglist = arghead ;
			while(arglist!=NULL)
			{
				if(arglist->eqn!=NULL)
				{
					eqn = arglist->eqn ;
					map_rv() ;
				}
				arglist = arglist->next ;
			}
			flag = 1L<<rvtotal ;
		}
		else
			optim = 0 ;
	}

	inmatrix = mxCreateDoubleMatrix(flag-1,nrhs+extrainput,mxREAL) ;
	ptr = mxGetPr(inmatrix) ;

	argnumber = 0 ;
	arglist = arghead ;
	while(arglist!=NULL)
	{
		if(arglist->eqn!=NULL)
		{
			eqn = arglist->eqn ;
			expand(ptr+argnumber*(flag-1)-1) ;
		}
		argnumber++ ;
		arglist = arglist->next ;
	}

	intype = mxCreateDoubleMatrix(nrhs+extrainput,1,mxREAL) ;
	ptr = mxGetPr(intype) ;
	argnumber = 0 ;
	arglist = arghead ;
	while(arglist!=NULL)
	{
		if(arglist->eqn!=NULL)
			ptr[argnumber] = (double) arglist->argtype ;
		argnumber++ ;
		arglist = arglist->next ;
	}

	free_eqn() ;

	for(b=multi;b<=nrhs+extrainput-1;b++)
		if(ptr[b])
		{
			b=-1;
			break;
		}

	if(b==-1)
	{
		mexPrintf("All constraints must be equalities.\n") ;
		return ;
	}

	dummy[0] = inmatrix ;
	dummy[1] = intype ;
	dummy[2] = mxCreateDoubleMatrix(1,1,mxREAL) ;
	ptr = mxGetPr(dummy[2]) ;
	*ptr = multi ;

	mptr = mexGetArray("ITIP_parse","global") ;
	if(mptr==NULL)
		mexCallMATLAB(0,rubbish,3,dummy,"ITIP_kern") ;
	else
	{
		ptr = mxGetPr(mptr) ;
		if(*ptr==0)
			mexCallMATLAB(0,rubbish,3,dummy,"ITIP_kern") ;
	}

	if(nlhs>=3)
	{
		if(optim)
		{
			for(temp=0;temp<rvtotal;temp++)
				rvnames2[temp][0] = '\0' ;

			b = 1 ;
			for(temp=0;temp<vcount;temp++,b<<=1)
				for(temp2=0;temp2<rvtotal;temp2++)
				if(rvtag[temp2] & b)
				{
					strcat(rvnames2[temp2],rvnames[temp]) ;
					break ;
				}

			strcpy(name,rvnames2[0]) ;
			for(temp=1;temp<rvtotal;temp++)
			{
				strcat(name," ") ;
				strcat(name,rvnames2[temp]) ;
			}

		}
		else
		{
			strcpy(name,rvnames[0]) ;
			for(temp=1;temp<vcount;temp++)
			{
				strcat(name," ") ;
				strcat(name,rvnames[temp]) ;
			}
		}

		dummy[3] = mxCreateString(name) ;

		if(nlhs==4)
		{
			plhs[0] = inmatrix ;
			plhs[1] = intype ;
			plhs[2] = dummy[3] ;
			plhs[3] = dummy[2] ;
		}
		else
		{
			plhs[0] = inmatrix ;
			plhs[1] = intype ;
			plhs[2] = dummy[3] ;
			mxDestroyArray(dummy[2]) ;
		}
	}
	else
	{
		mxDestroyArray(dummy[0]) ;
		mxDestroyArray(dummy[1]) ;
		mxDestroyArray(dummy[2]) ;
	}
}
