/***********************************************************************
 *                                                                     *
 *             Information Theoretic Inequality Prover (ITIP)          *
 *                                                                     *
 *                   Raymond W. Yeung and Ying-On Yan                  *
 *                                                                     *
 *                              Version 3.0                            *
 *                    Last updated on August 10, 2001                  *
 *                          All rights reserved                        *
 *                                                                     *
 *         Please send comments and suggestions to the authors at:     *
 *               whyeung@ie.cuhk.edu.hk and yy26@cornell.edu           *
 *                                                                     *
 ***********************************************************************/

#include "mex.h"

double *row,*col,*coef ;
long int nvar,nrow,ncol ;

void make_D()
{
	long int index,count,i,j,s1,s2,mask,temp ;
	count = 0 ;

	for(index=1;index<=nvar;index++)
	{
		s1 = (1L << (index - 1)) ;
		row[count] = index ;
		col[count] = ncol ;
		coef[count++] = 1 ;
		row[count] = index ;
		col[count] = ncol - s1 ;
		coef[count++] = -1 ;
	}

	for(i=0;i<(nvar-1);i++)
		for(j=i+1;j<nvar;j++)
		{
			s1 = 1L << i ;
			s2 = 1L << j ;
			mask = s1 | s2 ;
			row[count] = index ;
			col[count] = s1 ;
			coef[count++] = 1 ;
			row[count] = index ;
			col[count] = s2 ;
			coef[count++] = 1 ;
			row[count] = index++ ;
			col[count] = mask ;
			coef[count++] = -1 ;
			for(temp=1;temp<=ncol;temp++)
				if(!(temp & mask))
				{
					row[count] = index ;
					col[count] = s1 | temp ;
					coef[count++] = 1 ;
					row[count] = index ;
					col[count] = s2 | temp ;
					coef[count++] = 1 ;
					row[count] = index ;
					col[count] = temp ;
					coef[count++] = -1 ;
					row[count] = index++ ;
					col[count] = s1 | s2 | temp ;
					coef[count++] = -1 ;
				}
		}
}

#ifdef __STDC__
void mexFunction(nlhs,plhs,nrhs,prhs)
#else
mexFunction(nlhs,plhs,nrhs,prhs)
#endif
int nlhs,nrhs;
mxArray *plhs[];
const mxArray *prhs[];
{
	double *ptr ;
	long s ;

	if(nrhs < 1)
		mexErrMsgTxt("One input argument is needed.") ;
	if(nlhs != 5)
		mexErrMsgTxt("Five output arguments are needed.") ;

	nvar = *mxGetPr(prhs[0]) ;
	ncol = (1L << nvar) - 1 ;
	nrow = nvar + nvar*(nvar-1)/2*(1L << (nvar-2)) ;
	s = 2*nvar+3*nvar*(nvar-1)/2+2*nvar*(nvar-1)*((1L << (nvar-2))-1) ;

	plhs[0] = mxCreateDoubleMatrix(s,1,mxREAL) ;
	plhs[1] = mxCreateDoubleMatrix(s,1,mxREAL) ;
	plhs[2] = mxCreateDoubleMatrix(s,1,mxREAL) ;
	plhs[3] = mxCreateDoubleMatrix(1,1,mxREAL) ;
	plhs[4] = mxCreateDoubleMatrix(1,1,mxREAL) ;

	row = mxGetPr(plhs[0]) ;
	col = mxGetPr(plhs[1]) ;
	coef = mxGetPr(plhs[2]) ;
	ptr = mxGetPr(plhs[3]) ;
	*ptr = nrow ;
	ptr = mxGetPr(plhs[4]) ;
	*ptr = ncol ;

	make_D() ;
}
