/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;

class genesisWriter {
    Vector points;
    String[] sectionTypes;
    int[] segPerTyp;
    StringBuffer sb1;
    StringBuffer sb2;
    NumberFormat form;
    boolean declaredSoma = false;
    boolean declaredDend = false;
    boolean declaredAxon = false;
    int isoma = -1;
    int iaxon = -1;
    int ndend;
    nlpoint psoma;
    nlpoint paxon;
    nlpoint ppaxon;
    boolean followAxon = false;
    boolean flat = false;
    int cwi;

    genesisWriter(Vector vector, String[] stringArray) {
        this.points = vector;
        this.sectionTypes = stringArray;
        this.form = NumberFormat.getInstance();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].startsWith("soma")) {
                this.isoma = n2;
            }
            if (stringArray[n2].startsWith("axon")) {
                this.iaxon = n2;
            }
            ++n2;
        }
        if (this.isoma < 0 || this.iaxon < 0) {
            System.out.println("warning - unknown segment types");
        }
    }

    public void setFlatStyle(boolean bl) {
        this.flat = bl;
    }

    private void ptappend(nlpoint nlpoint2) {
        this.sb2.append("  ");
        this.sb2.append(this.form.format(nlpoint2.x));
        this.sb2.append("  ");
        this.sb2.append(this.form.format(nlpoint2.y));
        this.sb2.append("  ");
        this.sb2.append(this.form.format(nlpoint2.z));
        this.sb2.append("  ");
        this.sb2.append(this.form.format(2.0 * nlpoint2.r));
        this.sb2.append(" \n");
    }

    private void relativeAppend(nlpoint nlpoint2, nlpoint nlpoint3) {
        if (nlpoint3 == null) {
            nlpoint3 = nlpoint2;
        }
        this.sb2.append("  ");
        this.sb2.append(this.form.format(nlpoint2.x - nlpoint3.x));
        this.sb2.append("  ");
        this.sb2.append(this.form.format(nlpoint2.y - nlpoint3.y));
        this.sb2.append("  ");
        this.sb2.append(this.form.format(nlpoint2.z - nlpoint3.z));
        this.sb2.append("  ");
        this.sb2.append(this.form.format(2.0 * nlpoint2.r));
        this.sb2.append(" \n");
    }

    public void recGenesisTrace(nlpoint nlpoint2, nlpoint nlpoint3, int n) {
        int n2;
        boolean bl = false;
        if (nlpoint3.identPoint == null) {
            n2 = 0;
            String string = "";
            if (nlpoint3.nlcode == this.isoma && this.psoma == null) {
                if (!this.declaredSoma) {
                    this.declaredSoma = true;
                    string = "*compt /library/compartment_sphere\n";
                    nlpoint3.name = "soma";
                    this.psoma = nlpoint3;
                    nlpoint3.iseg = 0;
                    n2 = 1;
                }
            } else if (nlpoint3.nlcode == this.iaxon) {
                if (!this.declaredAxon) {
                    nlpoint3.name = "a";
                    nlpoint3.iseg = 0;
                    this.declaredAxon = true;
                    string = "*compt /library/axon\n";
                    n2 = 1;
                }
            } else if (!this.declaredDend) {
                this.declaredDend = true;
                string = "*compt /library/compartment\n";
                this.ndend = 1;
                nlpoint3.name = "d" + this.ndend;
                nlpoint3.iseg = 0;
                n2 = 1;
            }
            if (!this.flat) {
                this.sb2.append(string);
            }
            String string2 = "";
            nlpoint nlpoint4 = nlpoint2;
            if (nlpoint2 != null && nlpoint2.identPoint != null) {
                nlpoint2 = nlpoint2.identPoint;
            }
            if (nlpoint2 == null) {
                string2 = nlpoint3.nlcode == this.isoma ? String.valueOf(nlpoint3.name) + " " : String.valueOf(nlpoint3.name) + "[" + nlpoint3.iseg + "] ";
                string2 = String.valueOf(string2) + "none";
            } else if (n2 != 0) {
                string2 = String.valueOf(nlpoint3.name) + "[" + nlpoint3.iseg + "] ";
                string2 = String.valueOf(string2) + (nlpoint2 == this.psoma ? " soma " : String.valueOf(nlpoint2.name) + "[" + nlpoint2.iseg + "] ");
            } else if (n == 0) {
                if (nlpoint2 == this.psoma) {
                    ++this.ndend;
                    nlpoint3.name = "d" + this.ndend;
                } else {
                    nlpoint3.name = nlpoint2.name;
                    nlpoint3.iseg = nlpoint2.iseg + 1;
                }
                string2 = String.valueOf(nlpoint3.name) + "[" + nlpoint3.iseg + "] ";
                string2 = String.valueOf(string2) + " . ";
            } else {
                if (nlpoint2 == this.psoma) {
                    ++this.ndend;
                    nlpoint3.name = "d" + this.ndend;
                } else {
                    nlpoint3.name = String.valueOf(nlpoint2.name) + "b" + n;
                }
                nlpoint3.iseg = 0;
                string2 = String.valueOf(nlpoint3.name) + "[" + nlpoint3.iseg + "] ";
                string2 = String.valueOf(string2) + (nlpoint2 == this.psoma ? " soma " : String.valueOf(nlpoint2.name) + "[" + nlpoint2.iseg + "] ");
            }
            if (!this.flat) {
                this.sb2.append(string2);
            }
            if (this.flat) {
                ++this.cwi;
                nlpoint3.writeIndex = this.cwi;
                this.sb2.append(String.valueOf(nlpoint3.writeIndex) + "_" + nlpoint3.nlcode + " ");
                if (nlpoint2 != null) {
                    this.sb2.append(String.valueOf(nlpoint2.writeIndex) + "_" + nlpoint2.nlcode + " ");
                } else {
                    this.sb2.append(" none ");
                }
            }
            if (bl) {
                this.ptappend(nlpoint3);
            } else {
                this.relativeAppend(nlpoint3, nlpoint4);
            }
        }
        nlpoint3.imark = 1;
        n2 = 0;
        int n3 = 0;
        while (n3 < nlpoint3.nnbr) {
            if (nlpoint3.pnbr[n3].imark == 0) {
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < nlpoint3.nnbr) {
            if (nlpoint3.pnbr[n5].imark == 0) {
                ++n4;
                nlpoint nlpoint5 = nlpoint3.pnbr[n5];
                if (nlpoint5.nlcode != this.iaxon || this.followAxon) {
                    this.recGenesisTrace(nlpoint3, nlpoint5, n2 == 1 ? 0 : n4);
                } else if (this.paxon == null && nlpoint5.nlcode == this.iaxon) {
                    this.ppaxon = nlpoint3;
                    this.paxon = nlpoint5;
                }
            }
            ++n5;
        }
    }

    public String hierarchicalString() {
        this.cwi = 0;
        if (this.points.size() < 2 || this.sectionTypes.length < 2 || !this.sectionTypes[1].equals("soma")) {
            System.out.println("error: null data or section types in genesisWriter");
            return "";
        }
        this.declaredSoma = false;
        this.declaredDend = false;
        this.declaredAxon = false;
        this.ndend = 0;
        this.psoma = null;
        nlpoint nlpoint2 = null;
        int n = this.points.size();
        this.segPerTyp = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nlpoint nlpoint3 = this.ithPoint(n2);
            if (nlpoint2 == null || nlpoint3.nlcode == this.isoma && nlpoint3.r > nlpoint2.r) {
                nlpoint2 = nlpoint3;
            }
            nlpoint3.imark = 0;
            ++n2;
        }
        if (nlpoint2 == null) {
            System.out.println("warning  - no soma segment found");
            nlpoint2 = this.ithPoint(0);
        }
        nlpoint2.name = "soma";
        nlpoint2.iseg = 0;
        int n3 = 0;
        while (n3 < nlpoint2.nnbr) {
            if (nlpoint2.pnbr[n3].nlcode == this.isoma) {
                System.out.println("warning - multiple points marked as soma");
                System.out.println("point of maximal radius taken as soma,  rest converted to dendrites");
            }
            ++n3;
        }
        this.sb1 = new StringBuffer();
        this.sb2 = new StringBuffer();
        this.followAxon = false;
        this.recGenesisTrace(null, nlpoint2, 0);
        if (this.paxon != null) {
            this.followAxon = true;
            this.recGenesisTrace(this.ppaxon, this.paxon, 0);
        }
        this.sb1.append("// Genesis hierarchical morphology written by cvapp  \n");
        this.sb1.append("// ");
        this.sb1.append(new Date().toString());
        this.sb1.append("\n");
        String[] stringArray = new String[]{" ", "*relative", " ", "*set_compt_param RM {RM}", "*set_compt_param RA {RA}", "*set_compt_param CM {CM}", "*set_global ELEAK {ELEAK}", "*set_global EREST_ACT {EREST_ACT}", " ", " "};
        int n4 = 0;
        while (n4 < stringArray.length) {
            this.sb1.append(stringArray[n4]);
            this.sb1.append("\n");
            ++n4;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sb1.toString());
        stringBuffer.append(this.sb2.toString());
        return stringBuffer.toString();
    }

    private String segmentName(int n) {
        String string = "";
        if (n >= 5) {
            string = "user" + this.form.format(n).trim();
        } else {
            if (n < 0) {
                System.out.println("warning: negative segment type converted to \"unknown\" ");
                n = 0;
            }
            string = this.sectionTypes[n];
        }
        return string;
    }

    private nlpoint ithPoint(int n) {
        return (nlpoint)this.points.elementAt(n);
    }
}

