/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class graphCanvas3
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener {
    graphData3 gd;
    int prefWidth;
    int prefHeight;
    int imw;
    int imh;
    Image im;
    Image imbuf;
    Graphics gdb;
    Graphics sbgdb;
    int xdown;
    int ydown;
    long pressTime;
    boolean[] Qvisited;
    boolean turnZoom = false;
    boolean rightButton = false;
    boolean middleButton = false;
    int tzx0;
    int tzx1;
    int tzy0;
    int tzy1;
    Font defaultFont = this.getFont();
    boolean leftButton = false;
    boolean rotate3 = false;
    double[][] lineList;
    double[][] pointList;
    int[][] echoArray;
    int pointsNeeded;
    int pointsGot;
    int[] chosenPoints;
    boolean echoMode = false;
    boolean pointGetting = false;
    int echoPoint = -1;
    int previousEchoPoint = -1;
    int downPoint = -1;
    boolean ignoreUp = false;
    doublePointer zCursor;
    doublePointer xScale;
    doublePointer yScale;
    doublePointer zScale;
    boolean controt = true;
    int dragMode;
    boolean wantDrag = false;
    boolean geomChange = false;
    boolean xorUpdate = false;
    boolean mdown = false;
    int lstx;
    int lsty;

    public graphCanvas3(int n, int n2, graphData3 graphData32) {
        this.setFont(this.defaultFont);
        this.prefWidth = n;
        this.prefHeight = n2;
        this.imw = n;
        this.imh = n2;
        this.gd = graphData32;
        this.Qvisited = new boolean[4];
        this.gd.setSize(n, n2);
        this.createImage(this.imw, this.imh);
        this.setScales();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setContinuousRotate(boolean bl) {
        this.controt = bl;
    }

    public void setScales() {
        this.xScale = new doublePointer(1.0);
        this.yScale = new doublePointer(1.0);
        this.zScale = new doublePointer(1.0);
    }

    public void setzCursor(doublePointer doublePointer2) {
        this.zCursor = doublePointer2;
    }

    public void setzScale(doublePointer doublePointer2) {
        this.zScale = doublePointer2;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.im == null || this.imw != dimension.width || this.imh != dimension.height) {
            this.imw = dimension.width;
            this.imh = dimension.height;
            if (this.imw > 0 && this.imh > 0) {
                this.im = this.createImage(this.imw, this.imh);
                this.gd.setSize(this.imw, this.imh);
            }
        }
        if (this.im != null) {
            this.gdb = this.im.getGraphics();
            this.realPaint(this.gdb);
            graphics.drawImage(this.im, 0, 0, this);
        }
    }

    public void realPaint(Graphics graphics) {
        if (this.gd.bgColor == null) {
            Color color = this.getBackground();
            this.gd.setBackground(color);
        }
        graphics.setFont(this.defaultFont);
        this.gd.fillBackground(graphics, this.gd.bgColor);
        this.myBackgroundPaint(graphics);
        this.gd.drawAxes(graphics, this.gd.bgColor);
        if (this.rotate3 && !this.controt) {
            if (this.imbuf != null) {
                graphics.drawImage(this.imbuf, 0, 0, this);
            }
            this.gd.drawCube(graphics);
            return;
        }
        this.myPaint(graphics);
        if (this.echoMode && this.geomChange && !this.mdown) {
            this.makeEchoArray();
        }
    }

    public void makeEchoArray() {
        int n = this.imw / 3 + 1;
        int n2 = this.imh / 3 + 1;
        if (this.echoArray == null || this.echoArray.length < n || this.echoArray[0].length < n2) {
            this.echoArray = new int[n][n2];
        }
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.echoArray[n3][n4] = -1;
                ++n4;
            }
            ++n3;
        }
        int n5 = this.pointList.length;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = this.gd.xOfP(this.pointList[n6]) / 3;
            int n8 = this.gd.yOfP(this.pointList[n6]) / 3;
            if (n7 > 0 && n7 < n - 2 && n8 > 0 && n8 < n2 - 2) {
                this.echoArray[n7 - 1][n8 - 1] = n6;
                this.echoArray[n7 - 1][n8] = n6;
                this.echoArray[n7 - 1][n8 + 1] = n6;
                this.echoArray[n7][n8 - 1] = n6;
                this.echoArray[n7][n8] = n6;
                this.echoArray[n7][n8 + 1] = n6;
                this.echoArray[n7 + 1][n8 - 1] = n6;
                this.echoArray[n7 + 1][n8] = n6;
                this.echoArray[n7 + 1][n8 + 1] = n6;
            }
            ++n6;
        }
        this.geomChange = false;
        this.echoPoint = this.echoArray[this.lstx / 3][this.lsty / 3];
    }

    public void update(Graphics graphics) {
        if (this.xorUpdate) {
            graphics.drawImage(this.im, 0, 0, this);
            this.myXorUpdate(graphics);
            return;
        }
        if (this.geomChange || !this.echoMode) {
            this.paint(graphics);
        }
        if (this.echoMode && this.echoPoint != this.previousEchoPoint) {
            graphics.drawImage(this.im, 0, 0, this);
            graphics.setColor(Color.red);
            if (this.echoPoint >= 0) {
                int n = this.gd.xOfP(this.pointList[this.echoPoint]);
                int n2 = this.gd.yOfP(this.pointList[this.echoPoint]);
                graphics.drawOval(n - 4, this.imh - n2 - 1 - 4, 9, 9);
                graphics.drawOval(n - 3, this.imh - n2 - 1 - 3, 7, 7);
                double[] dArray = this.pointList[this.echoPoint];
                String string = " " + this.mytrim(this.xScale.value() * dArray[0]) + " " + this.mytrim(this.yScale.value() * dArray[1]) + " " + this.mytrim(this.zScale.value() * dArray[2]);
                graphics.setColor(Color.white);
                graphics.setFont(this.getFont());
                graphics.drawString(string, 10, 20);
            }
        }
    }

    private String mytrim(double d) {
        return (" " + d + "       ").substring(1, 7);
    }

    public void getOnePoint() {
        this.getNPoints(1);
    }

    public void getTwoPoints() {
        this.getNPoints(2);
    }

    public void getNPoints(int n) {
        this.pointGetting = true;
        if (this.pointList == null) {
            System.out.println("need points list first - getOnePoint");
            return;
        }
        this.pointsNeeded = n;
        this.pointsGot = 0;
        this.echoMode = true;
        this.geomChange = true;
        this.repaint();
    }

    public void unsetPointGetting() {
        this.pointGetting = false;
        this.pointsNeeded = 0;
    }

    public void gotPoint(int[] nArray) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.gcMouseDrag(n, this.imh - n2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.gcMouseMove(n, this.imh - n2);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        long l = mouseEvent.getWhen();
        int n3 = mouseEvent.getModifiers();
        int n4 = 1;
        if (n3 == 16) {
            n4 = 1;
        } else if (n3 == 8) {
            n4 = 2;
        } else if (n3 == 4) {
            n4 = 3;
        } else if (n3 == 6 || n3 == 18 || n3 == 5 || n3 == 17) {
            n4 = 2;
        }
        this.mdown = true;
        this.gcMouseDown(n, this.imh - n2, l, n4);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        long l = mouseEvent.getWhen();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mdown = false;
        this.gcMouseUp(n, this.imh - n2, l);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.getKeyChar();
    }

    public void gcMouseMove(int n, int n2) {
        if (this.echoMode) {
            this.previousEchoPoint = this.echoPoint;
            this.echoPoint = -1;
            if (this.echoArray != null && n / 3 < this.echoArray.length && this.echoArray[n / 3] != null && n2 / 3 < this.echoArray[n / 3].length) {
                this.echoPoint = this.echoArray[n / 3][n2 / 3];
            }
            this.repaint();
        }
    }

    public void gcMouseDown(int n, int n2, long l, int n3) {
        this.xdown = n;
        this.ydown = n2;
        this.rightButton = n3 == 3;
        this.middleButton = n3 == 2;
        this.leftButton = n3 == 1;
        this.pressTime = l;
        this.downPoint = this.echoPoint;
        boolean bl = true;
        if (this.echoMode && this.echoPoint >= 0 && this.pointGetting) {
            int[] nArray = new int[this.pointsGot + 1];
            int n4 = 0;
            while (n4 < this.pointsGot) {
                nArray[n4] = this.chosenPoints[n4];
                ++n4;
            }
            this.chosenPoints = nArray;
            this.chosenPoints[this.pointsGot] = this.echoPoint;
            ++this.pointsGot;
            if (this.pointsGot == this.pointsNeeded) {
                this.echoMode = false;
                this.pointsNeeded = 0;
                this.pointsGot = 0;
                this.pointGetting = false;
                this.gotPoint(this.chosenPoints);
            }
        } else {
            this.rotate3 = false;
        }
        bl = this.myMouseDown(n, n2);
    }

    public void gcMouseUp(int n, int n2, long l) {
        boolean bl = true;
        this.xorUpdate = false;
        if (this.ignoreUp || this.downPoint >= 0) {
            bl = this.myMouseUp(n, n2);
        } else if (this.turnZoom) {
            this.turnZoom = false;
            this.gd.pixelSet();
        } else if (this.rotate3) {
            if (!this.controt) {
                this.gd.dragRotate(this.xdown, this.ydown, n, n2, this.rightButton);
                this.geomChange = true;
            }
            this.rotate3 = false;
            this.gd.pixelSet();
        } else {
            boolean bl2 = l - this.pressTime > 150L || this.rightButton;
            this.gd.panZoom(this.xdown, this.ydown, n, n2, bl2);
            this.geomChange = true;
        }
        this.gd.unsetRotInit();
        this.dragMode = 0;
        this.downPoint = -1;
        this.echoPoint = -1;
        this.lstx = n;
        this.lsty = n2;
        this.ignoreUp = false;
        this.repaint();
    }

    public void gcMouseDrag(int n, int n2) {
        boolean bl = true;
        if (this.downPoint >= 0) {
            bl = this.myMouseDrag(n, n2);
            return;
        }
        if (this.rotate3) {
            this.gd.dragRotate(this.xdown, this.ydown, n, n2, this.rightButton);
            this.geomChange = true;
            this.repaint();
            return;
        }
        if (this.turnZoom) {
            if ((n - this.tzx1) * (n - this.tzx1) + (n2 - this.tzy1) * (n2 - this.tzy1) > 64) {
                double d = (this.tzx1 - this.tzx0) * (n2 - this.tzy0) - (this.tzy1 - this.tzy0) * (n - this.tzx0);
                double d2 = Math.exp(0.16 * (d /= (double)((this.tzx1 - this.tzx0) * (this.tzx1 - this.tzx0) + (this.tzy1 - this.tzy0) * (this.tzy1 - this.tzy0))));
                this.gd.fixZoom(this.xdown, this.ydown, d2);
                this.repaint();
                this.tzx0 = this.tzx1;
                this.tzx1 = n;
                this.tzy0 = this.tzy1;
                this.tzy1 = n2;
                this.geomChange = true;
                return;
            }
        } else {
            if (this.leftButton && n > this.imw || n < 0 || n2 > this.imh || n2 < 0) {
                this.tzx0 = this.xdown;
                this.tzy0 = this.ydown;
                this.tzx1 = n;
                this.tzy1 = n2;
                this.turnZoom = true;
                return;
            }
            if ((this.rightButton || this.middleButton) && !this.rotate3) {
                this.imbuf = this.createImage(this.imw, this.imh);
                this.gdb = this.imbuf.getGraphics();
                this.gdb.drawImage(this.im, 0, 0, this);
                this.rotate3 = true;
            }
        }
    }

    public void myXorUpdate(Graphics graphics) {
    }

    public void myPaint(Graphics graphics) {
    }

    public void myBackgroundPaint(Graphics graphics) {
    }

    public boolean myMouseDown(int n, int n2) {
        return true;
    }

    public boolean myMouseUp(int n, int n2) {
        return true;
    }

    public boolean myMouseDrag(int n, int n2) {
        return true;
    }
}

