/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class neulucData {
    Vector points;
    double[][] lineList;
    double[][] pointList;
    int nseg;
    String sourceFileName;
    StringBuffer sb;
    StringBuffer sb1;
    StringBuffer sb2;
    StringBuffer sb3;
    boolean trustLineList = false;
    boolean trustPointList = false;
    int nLines;
    int nPoints;
    int rootpoint;
    boolean SWCwrite = false;
    boolean GENESISwrite = false;
    boolean HOCwrite = false;
    int cwi;
    double[] cdp = new double[3];
    int pcount;
    int maxType;
    boolean cleaning = false;
    int nremoved;
    NumberFormat form;
    boolean havePointNeedingRadius;
    nlpoint pointNeedingRadius;
    int[] usedTypes;
    String[] sectionTypes = new String[]{"undefined", "soma", "axon", "dendrite", "apical_dendrite", "custom-1", "custom-2", "custom-n"};
    String[] headerField = new String[]{"ORIGINAL_SOURCE", "CREATURE", "REGION", "FIELD/LAYER", "TYPE", "CONTRIBUTOR", "REFERENCE", "RAW", "EXTRAS", "SOMA_AREA", "SHRINKAGE_CORRECTION", "VERSION_NUMBER", "VERSION_DATE", "*********************************************"};
    String headerText = " ";

    neulucData() {
        this.points = new Vector();
        this.form = NumberFormat.getInstance();
    }

    public int getCode(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.sectionTypes.length) {
            if (string.equals(this.sectionTypes[n2])) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String string) {
        this.headerText = string;
        this.checkHeader();
    }

    public void updateHeaderText(String string) {
        StringTokenizer stringTokenizer;
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.headerText, "\n\r");
        int n = stringTokenizer2.countTokens();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer2.nextToken();
            stringTokenizer = new StringTokenizer(stringArray[n2], "# ");
            if (stringTokenizer.hasMoreTokens()) {
                stringArray2[n2] = stringTokenizer.nextToken();
            }
            ++n2;
        }
        stringTokenizer = new StringTokenizer(string, "\n\r");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = 0;
            while (n3 < n) {
                if (stringArray2[n3] != null && string2.indexOf(stringArray2[n3]) > 0) {
                    stringArray2[n3] = null;
                }
                ++n3;
            }
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        int n4 = 0;
        while (n4 < n) {
            if (stringArray2[n4] != null) {
                stringBuffer.append(stringArray[n4]);
                stringBuffer.append("\n");
            }
            ++n4;
        }
        this.headerText = stringBuffer.toString();
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String string) {
        this.sourceFileName = string;
    }

    public void rescale(double d, double d2, double d3) {
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n2);
            nlpoint2.x *= d;
            nlpoint2.y *= d2;
            nlpoint2.z *= d3;
            ++n2;
        }
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public double[] getScale() {
        this.checkHeader();
        double[] dArray = new double[3];
        StringTokenizer stringTokenizer = new StringTokenizer(this.headerText, "\r\n");
        boolean bl = false;
        while (!bl && stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf("SCALE");
            if (n <= 0) continue;
            bl = true;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(n + 5, string.length()));
            if (stringTokenizer2.countTokens() != 3) {
                System.out.println("cant parse shrinkage data in file header");
                System.out.println(string);
                continue;
            }
            dArray[0] = new Double(stringTokenizer2.nextToken());
            dArray[1] = new Double(stringTokenizer2.nextToken());
            dArray[2] = new Double(stringTokenizer2.nextToken());
        }
        return dArray;
    }

    public void setScale(double[] dArray) {
        double[] dArray2 = this.getScale();
        this.rescale(dArray[0] / dArray2[0], dArray[1] / dArray2[1], dArray[2] / dArray2[2]);
        StringTokenizer stringTokenizer = new StringTokenizer(this.headerText, "\r\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.indexOf("SCALE") > 0) {
                stringBuffer.append("# SCALE " + this.mytrim(dArray[0]) + " " + this.mytrim(dArray[1]) + " " + this.mytrim(dArray[2]) + "\n");
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        this.setHeaderText(stringBuffer.toString());
    }

    private String mytrim(double d) {
        return (" " + d + "       ").substring(1, 6);
    }

    public void fill(String[] stringArray, String string) {
        String string2 = string.substring(string.length() - 3, string.length());
        if (string2.equals("swc")) {
            this.fillFromSwcFile(stringArray);
        } else if (string2.equals("asc")) {
            int n = 0;
            int n2 = stringArray.length;
            int n3 = 1;
            while (n3 < 100 && n3 < n2) {
                if (stringArray[n3].trim().startsWith("[")) {
                    ++n;
                }
                ++n3;
            }
            if (n > 0) {
                this.fillFromNlFile(stringArray);
            } else {
                this.fillFromNl3File(stringArray);
            }
        } else {
            System.out.println("unknown file extension: " + string2);
            System.out.println("expecting .swc, or .asc (for NL v2 or v3)");
        }
        this.checkHeader();
    }

    private void checkHeader() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.headerText, "\n\r");
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.headerField.length;
        boolean[] blArray = new boolean[n];
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("#")) {
                int n2 = 0;
                while (n2 < n) {
                    if (string.indexOf(this.headerField[n2]) > 0) {
                        blArray[n2] = true;
                    }
                    if (string.indexOf("SCALE") > 0) {
                        bl = true;
                    }
                    ++n2;
                }
            }
            if (string.startsWith("#")) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("# ");
                stringBuffer.append(string);
            }
            stringBuffer.append("\n");
        }
        int n3 = 0;
        while (n3 < n) {
            if (!blArray[n3]) {
                stringBuffer.append("# ");
                stringBuffer.append(this.headerField[n3]);
                stringBuffer.append(" \n");
            }
            ++n3;
        }
        if (!bl) {
            stringBuffer.append("# SCALE 1.0 1.0 1.0 \n");
        }
        this.headerText = stringBuffer.toString();
    }

    public void fillFromSwcFile(String[] stringArray) {
        this.points.removeAllElements();
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[7];
        nlpoint nlpoint2 = null;
        nlpoint nlpoint3 = null;
        int n = 0;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            StringTokenizer stringTokenizer;
            String string = stringArray[n3];
            if (string.startsWith("#")) {
                stringBuffer.append(string);
                stringBuffer.append("\n");
            } else if (string.length() > 10 && (stringTokenizer = new StringTokenizer(string, ", ")).countTokens() == 7) {
                int n4 = 0;
                while (n4 < 7) {
                    dArray[n4] = Double.valueOf(stringTokenizer.nextToken());
                    ++n4;
                }
                int n5 = (int)dArray[0];
                int n6 = (int)dArray[1];
                double d = dArray[2];
                double d2 = dArray[3];
                double d3 = dArray[4];
                double d4 = dArray[5];
                int n7 = (int)dArray[6];
                if (n3 % 100 == 0) {
                    System.out.println(" " + n3 + " " + n5 + " " + d + " " + d2 + " " + d3);
                }
                if (n != n5 - 1) {
                    System.out.println("swc read error " + n5 + " " + n);
                }
                nlpoint2 = n7 > 0 ? (nlpoint)this.points.elementAt(n7 - 1) : null;
                nlpoint3 = new nlpoint(n, n6, nlpoint2, d, d2, d3, d4);
                this.points.addElement(nlpoint3);
                if (nlpoint2 != null) {
                    nlpoint2.addNeighbor(nlpoint3);
                }
                ++n;
            }
            ++n3;
        }
        System.out.println("read " + n + " points");
        this.enforceCommutativity();
        this.trustLineList = false;
        this.trustPointList = false;
        this.headerText = stringBuffer.toString();
    }

    private final int ptconv(int n) {
        int n2 = n;
        if (n == 1 || n == 2) {
            n2 = 3;
        } else if (n == 21 || n == 22) {
            n2 = 2;
        } else if (n == 41 || n == 42) {
            n2 = 1;
        } else if (n == 61 || n == 62) {
            n2 = 4;
        }
        return n2;
    }

    public void fillFromNlFile(String[] stringArray) {
        this.headerText = " ";
        this.points.removeAllElements();
        double[] dArray = new double[6];
        nlpoint nlpoint2 = null;
        nlpoint nlpoint3 = null;
        int n = 0;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (string.length() > 10 && string.substring(0, 1).equals("[")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "[](), ");
                int n4 = 0;
                while (n4 < 6) {
                    dArray[n4] = Double.valueOf(stringTokenizer.nextToken());
                    ++n4;
                }
                int n5 = (int)dArray[0];
                int n6 = (int)dArray[1];
                double d = dArray[2];
                double d2 = dArray[3];
                double d3 = dArray[4];
                double d4 = dArray[5];
                if (n3 % 100 == 0) {
                    System.out.println(" " + n3 + " " + n5 + " " + d + " " + d2 + " " + d3);
                }
                if (n5 != 0) {
                    if (n5 == 1) {
                        if (this.havePointNeedingRadius) {
                            this.pointNeedingRadius.r = d4;
                            this.havePointNeedingRadius = false;
                        }
                        nlpoint3 = new nlpoint(n, this.ptconv(n6), nlpoint2, d, d2, d3, d4);
                        this.points.addElement(nlpoint3);
                        nlpoint2.addNeighbor(nlpoint3);
                        nlpoint2 = nlpoint3;
                        ++n;
                    } else if (n5 != 10 && n5 != 33) {
                        if (n5 == 2) {
                            nlpoint nlpoint4 = this.havePointHere(d, d2, d3);
                            if (nlpoint4 == null) {
                                nlpoint3 = new nlpoint(n, this.ptconv(n6), d, d2, d3, d4);
                                this.points.addElement(nlpoint3);
                                nlpoint2 = nlpoint3;
                                ++n;
                            } else {
                                nlpoint2 = nlpoint4;
                            }
                            this.havePointNeedingRadius = true;
                            this.pointNeedingRadius = nlpoint2;
                        } else if (n5 != 3 && n5 != 5 && n5 != 32) {
                            System.out.println("unknown major code: " + n5);
                        }
                    }
                }
            }
            ++n3;
        }
        System.out.println("read " + n + " points");
        this.enforceCommutativity();
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public void fillFromNl3File(String[] stringArray) {
        new nl3parser().loadFile(stringArray, this);
    }

    public String write() {
        this.unwrite();
        this.SWCwrite = true;
        this.sb = new StringBuffer();
        this.sb.append(this.headerText);
        this.rootpoint = this.maxRadiusPoint();
        this.tracePoint(this.rootpoint);
        this.SWCwrite = false;
        String string = this.sb.toString();
        this.sb = null;
        return string;
    }

    public void unwrite() {
        this.GENESISwrite = false;
        this.SWCwrite = false;
        this.HOCwrite = false;
    }

    private void pt3dappend(nlpoint nlpoint2) {
        this.sb3.append("   pt3dadd(");
        this.sb3.append(this.form.format(nlpoint2.x));
        this.sb3.append(",");
        this.sb3.append(this.form.format(nlpoint2.y));
        this.sb3.append(",");
        this.sb3.append(this.form.format(nlpoint2.z));
        this.sb3.append(",");
        this.sb3.append(this.form.format(2.0 * nlpoint2.r));
        this.sb3.append(")\n");
    }

    private void offsetpt3dappend(nlpoint nlpoint2) {
        this.sb3.append("   pt3dadd(");
        this.sb3.append(this.form.format(nlpoint2.x));
        this.sb3.append(",");
        this.sb3.append(this.form.format(nlpoint2.y));
        this.sb3.append(",");
        this.sb3.append(this.form.format(nlpoint2.z + 0.01));
        this.sb3.append(",");
        this.sb3.append(this.form.format(2.0 * nlpoint2.r));
        this.sb3.append(")\n");
    }

    public void recHOCTrace(nlpoint nlpoint2, nlpoint nlpoint3, boolean[] blArray, boolean bl, int n) {
        nlpoint3.imark = 1;
        boolean bl2 = false;
        if (!blArray[nlpoint3.myIndex]) {
            blArray[nlpoint3.myIndex] = true;
            if (bl) {
                if (n == 0) {
                    this.sb2.append("connect dend[");
                    this.sb2.append(this.form.format(this.nseg - 1));
                    this.sb2.append("](0), ");
                    this.sb2.append("soma(0.5)\n");
                } else if (n > 0) {
                    this.sb2.append("connect dend[");
                    this.sb2.append(this.form.format(this.nseg - 1));
                    this.sb2.append("](0), ");
                    this.sb2.append("dend[");
                    this.sb2.append(this.form.format(n - 1));
                    this.sb2.append("](1)\n");
                }
                if (n < 0) {
                    this.sb3.append("soma {\n");
                } else {
                    this.sb3.append("dend[");
                    this.sb3.append(this.form.format(this.nseg - 1).trim());
                    this.sb3.append("] {\n");
                }
                if (nlpoint2 != null) {
                    this.pt3dappend(nlpoint2);
                } else {
                    this.offsetpt3dappend(nlpoint3);
                }
                ++this.nseg;
            }
            if (nlpoint3.nnbr == 1 && blArray[nlpoint3.pnbr[0].myIndex]) {
                this.pt3dappend(nlpoint3);
                this.sb3.append("}\n");
            } else if (nlpoint3.nnbr == 2 && blArray[nlpoint3.pnbr[0].myIndex] != blArray[nlpoint3.pnbr[1].myIndex]) {
                this.pt3dappend(nlpoint3);
            } else if (nlpoint3.nnbr == 0) {
                System.out.println("error - disconnected point " + nlpoint3.myIndex);
            } else {
                this.pt3dappend(nlpoint3);
                this.sb3.append("}\n");
                bl2 = true;
            }
            int n2 = this.nseg - 1;
            int n3 = nlpoint3.nnbr - 1;
            while (n3 >= 0) {
                nlpoint3.pnbr[n3].parent = nlpoint3;
                this.recHOCTrace(nlpoint3, nlpoint3.pnbr[n3], blArray, bl2, n2);
                --n3;
            }
        }
    }

    public void HOCtrace(int n) {
        this.enforceCommutativity();
        this.nseg = 0;
        if (this.pointList != null) {
            int n2 = this.points.size();
            boolean[] blArray = new boolean[n2];
            this.rootpoint = n;
            int n3 = 0;
            while (n3 < n2) {
                blArray[n3] = false;
                ++n3;
            }
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
            nlpoint2.parent = null;
            nlpoint2.writeIndex = 0;
            this.cwi = 1;
            this.recHOCTrace(null, (nlpoint)this.points.elementAt(n), blArray, true, -1);
            this.trustLineList = false;
            this.trustPointList = false;
        }
    }

    private int maxRadiusPoint() {
        int n = -1;
        this.maxType = 0;
        double d = -1.0;
        int n2 = this.points.size();
        int n3 = 0;
        while (n3 < n2) {
            double d2;
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n3);
            double d3 = nlpoint2.r;
            if (d2 > d) {
                n = n3;
                d = d3;
            }
            if (nlpoint2.nlcode > this.maxType) {
                this.maxType = nlpoint2.nlcode;
            }
            ++n3;
        }
        return n;
    }

    public String HOCwrite() {
        this.unwrite();
        this.HOCwrite = true;
        this.rootpoint = this.maxRadiusPoint();
        this.sb1 = new StringBuffer();
        this.sb2 = new StringBuffer();
        this.sb3 = new StringBuffer();
        this.HOCtrace(this.rootpoint);
        this.sb1.append("ndend = ");
        this.sb1.append(this.form.format(this.nseg - 1));
        this.sb1.append("\n");
        this.sb1.append("create soma, dend[ndend]\n");
        this.sb1.append("access soma\n");
        this.sb1.append("  \n");
        this.sb2.append("  \n");
        this.HOCwrite = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sb1.toString());
        stringBuffer.append(this.sb2.toString());
        stringBuffer.append(this.sb3.toString());
        return stringBuffer.toString();
    }

    public String HOCwriteNS() {
        this.unwrite();
        hocWriter hocWriter2 = new hocWriter(this.points, this.sectionTypes);
        return hocWriter2.hocString();
    }

    public String GENESISwriteHR() {
        this.unwrite();
        genesisWriter genesisWriter2 = new genesisWriter(this.points, this.sectionTypes);
        return genesisWriter2.hierarchicalString();
    }

    public String GENESISwrite() {
        this.unwrite();
        genesisWriter genesisWriter2 = new genesisWriter(this.points, this.sectionTypes);
        genesisWriter2.setFlatStyle(true);
        return genesisWriter2.hierarchicalString();
    }

    public String oldGENESISwrite() {
        this.unwrite();
        this.GENESISwrite = true;
        this.sb = new StringBuffer();
        this.sb.append("// genesis \n");
        this.sb.append("*cartesian \n");
        this.sb.append("*absolute \n");
        this.sb.append("*asymmetric \n");
        this.sb.append("*set_compt_param RM 1.0      //ohm*m^2\n");
        this.sb.append("*set_compt_param RA 1.0      //ohm*m \n");
        this.sb.append("*set_compt_param CM 0.03     //F/m^2 \n");
        this.sb.append("*set_compt_param EREST_ACT   -0.06   // volts \n");
        this.rootpoint = this.maxRadiusPoint();
        this.tracePoint(this.rootpoint);
        this.GENESISwrite = false;
        String string = this.sb.toString();
        this.sb = null;
        return string;
    }

    public void clean() {
        int n = 0;
        this.tracePoint(this.rootpoint);
        this.cleaning = true;
        do {
            this.nremoved = 0;
            this.tracePoint(this.rootpoint);
            this.removeFloating();
            System.out.println(" pass " + ++n + "  removed " + this.nremoved + " zero length branches");
        } while (this.nremoved != 0);
        this.cleaning = false;
    }

    public nlpoint havePointHere(double d, double d2, double d3) {
        double d4 = 100.0;
        int n = -1;
        nlpoint nlpoint2 = null;
        int n2 = this.points.size();
        int n3 = 0;
        while (n3 < n2) {
            nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n3);
            double d5 = (d - nlpoint3.x) * (d - nlpoint3.x) + (d2 - nlpoint3.y) * (d2 - nlpoint3.y) + (d3 - nlpoint3.z) * (d3 - nlpoint3.z);
            if (d5 < d4) {
                n = n3;
                d4 = d5;
            }
            ++n3;
        }
        if (d4 < 0.5) {
            nlpoint2 = (nlpoint)this.points.elementAt(n);
        }
        return nlpoint2;
    }

    public void reindexPoints() {
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            ((nlpoint)this.points.elementAt((int)n2)).myIndex = n2;
            ++n2;
        }
    }

    public void enforceCommutativity() {
        this.reindexPoints();
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n2);
            int n3 = 0;
            while (n3 < nlpoint2.nnbr) {
                nlpoint nlpoint3 = nlpoint2.pnbr[n3];
                boolean bl = false;
                int n4 = 0;
                while (n4 < nlpoint3.nnbr) {
                    if (nlpoint3.pnbr[n4] == nlpoint2) {
                        bl = true;
                    }
                    ++n4;
                }
                if (!bl) {
                    System.out.println("correcting non commuting link: " + nlpoint2.myIndex + " " + nlpoint3.myIndex);
                    nlpoint3.addNeighbor(nlpoint2);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void recAddLine(nlpoint nlpoint2, int[] nArray, boolean[] blArray) {
        blArray[nlpoint2.myIndex] = true;
        int n = 0;
        while (n < nlpoint2.nnbr) {
            nlpoint nlpoint3 = nlpoint2.pnbr[n];
            if (!blArray[nlpoint3.myIndex]) {
                int n2 = nArray[0];
                this.lineList[n2][0] = nlpoint2.x;
                this.lineList[n2][1] = nlpoint2.y;
                this.lineList[n2][2] = nlpoint2.z;
                this.lineList[n2][3] = nlpoint2.r;
                this.lineList[n2][4] = nlpoint3.x;
                this.lineList[n2][5] = nlpoint3.y;
                this.lineList[n2][6] = nlpoint3.z;
                this.lineList[n2][7] = nlpoint3.r;
                if (nlpoint2.shiftMark) {
                    double[] dArray = this.lineList[n2];
                    dArray[0] = dArray[0] + this.cdp[0];
                    double[] dArray2 = this.lineList[n2];
                    dArray2[1] = dArray2[1] + this.cdp[1];
                    double[] dArray3 = this.lineList[n2];
                    dArray3[2] = dArray3[2] + this.cdp[2];
                }
                if (nlpoint3.shiftMark) {
                    double[] dArray = this.lineList[n2];
                    dArray[4] = dArray[4] + this.cdp[0];
                    double[] dArray4 = this.lineList[n2];
                    dArray4[5] = dArray4[5] + this.cdp[1];
                    double[] dArray5 = this.lineList[n2];
                    dArray5[6] = dArray5[6] + this.cdp[2];
                }
                this.lineList[n2][8] = nlpoint2.imark >= 0 && nlpoint3.imark >= 0 ? 1.0 : -1.0;
                if (nlpoint2.nlcode == nlpoint3.nlcode) {
                    this.lineList[n2][9] = (double)nlpoint2.nlcode + 0.1;
                }
                nArray[0] = nArray[0] + 1;
                this.recAddLine(nlpoint3, nArray, blArray);
            }
            ++n;
        }
    }

    public double[][] getLineList() {
        int[] nArray = new int[2];
        if (this.lineList == null || !this.trustLineList) {
            int n = this.points.size();
            this.lineList = new double[n][10];
            boolean[] blArray = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                blArray[n2] = false;
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                if (!blArray[n3]) {
                    nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n3);
                    if (nlpoint2.myIndex != n3) {
                        System.out.println("indexing mismatch " + n3 + " " + nlpoint2.myIndex);
                    }
                    this.recAddLine(nlpoint2, nArray, blArray);
                }
                ++n3;
            }
            this.trustLineList = true;
            this.nLines = nArray[0];
        }
        return this.lineList;
    }

    public double[][] getPointList() {
        if (this.pointList == null || !this.trustPointList) {
            int n;
            this.nPoints = n = this.points.size();
            this.pointList = new double[n][5];
            int n2 = 0;
            while (n2 < n) {
                nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n2);
                this.pointList[n2][0] = nlpoint2.x;
                this.pointList[n2][1] = nlpoint2.y;
                this.pointList[n2][2] = nlpoint2.z;
                this.pointList[n2][3] = nlpoint2.r;
                this.pointList[n2][4] = nlpoint2.imark;
                if (nlpoint2.identPoint != null) {
                    this.pointList[n2][4] = 2.0;
                }
                ++n2;
            }
            this.trustPointList = true;
        }
        return this.pointList;
    }

    public void recTrace(nlpoint nlpoint2, boolean[] blArray) {
        nlpoint2.imark = 1;
        if (!blArray[nlpoint2.myIndex]) {
            int n;
            if (this.SWCwrite) {
                nlpoint2.writeIndex = this.cwi++;
                this.sb.append(" " + nlpoint2.writeIndex + " " + nlpoint2.nlcode + " ");
                this.sb.append(this.form.format(nlpoint2.x));
                this.sb.append(" ");
                this.sb.append(this.form.format(nlpoint2.y));
                this.sb.append(" ");
                this.sb.append(this.form.format(nlpoint2.z));
                this.sb.append(" ");
                this.sb.append(this.form.format(nlpoint2.r));
                this.sb.append(" ");
                this.sb.append(" " + (nlpoint2.parent != null ? nlpoint2.parent.writeIndex : -1) + " \n");
            }
            if (this.GENESISwrite && nlpoint2.identPoint == null) {
                nlpoint2.writeIndex = this.cwi++;
                this.sb.append(" " + nlpoint2.writeIndex + "_" + nlpoint2.nlcode + " ");
                if (nlpoint2.parent != null) {
                    if (nlpoint2.parent.identPoint == null) {
                        this.sb.append(String.valueOf(nlpoint2.parent.writeIndex) + "_" + nlpoint2.parent.nlcode + " ");
                    } else {
                        this.sb.append(String.valueOf(nlpoint2.parent.identPoint.writeIndex) + "_" + nlpoint2.parent.identPoint.nlcode + " ");
                    }
                } else {
                    this.sb.append(" none ");
                }
                this.sb.append(this.form.format(nlpoint2.x));
                this.sb.append(" ");
                this.sb.append(this.form.format(nlpoint2.y));
                this.sb.append(" ");
                this.sb.append(this.form.format(nlpoint2.z));
                this.sb.append(" ");
                this.sb.append(this.form.format(2.0 * nlpoint2.r));
                this.sb.append("\n");
            }
            boolean bl = true;
            if (this.cleaning && nlpoint2.parent != null && nlpoint2 != nlpoint2.parent && nlpoint2.pointSeparation(nlpoint2.parent) < 1.0E-6) {
                n = nlpoint2.parent.removeNeighbor(nlpoint2) ? 1 : 0;
                int n2 = 0;
                while (n2 < nlpoint2.nnbr) {
                    nlpoint2.parent.addNeighbor(nlpoint2.pnbr[n2]);
                    n = nlpoint2.pnbr[n2].removeNeighbor(nlpoint2) ? 1 : 0;
                    nlpoint2.pnbr[n2].addNeighbor(nlpoint2.parent);
                    nlpoint2.pnbr[n2].parent = nlpoint2.parent;
                    ++n2;
                }
                this.nullifyPoint(nlpoint2);
                ++this.nremoved;
                bl = false;
            }
            blArray[nlpoint2.myIndex] = true;
            if (bl) {
                n = nlpoint2.nnbr - 1;
                while (n >= 0) {
                    nlpoint2.pnbr[n].parent = nlpoint2;
                    this.recTrace(nlpoint2.pnbr[n], blArray);
                    --n;
                }
            }
        }
    }

    public void tracePoint(int n) {
        if (this.pointList != null) {
            int n2 = this.points.size();
            boolean[] blArray = new boolean[n2];
            this.rootpoint = n;
            int n3 = 0;
            while (n3 < n2) {
                blArray[n3] = false;
                ++n3;
            }
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
            nlpoint2.parent = null;
            nlpoint2.writeIndex = 0;
            this.cwi = 1;
            this.recTrace((nlpoint)this.points.elementAt(n), blArray);
            this.trustLineList = false;
            this.trustPointList = false;
        }
    }

    public void removeFloating() {
        int n = this.points.size();
        this.reindexPoints();
        int n2 = n - 1;
        while (n2 >= 0) {
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n2);
            if (nlpoint2.nnbr == 0) {
                this.points.removeElementAt(n2);
            }
            --n2;
        }
        this.reindexPoints();
    }

    public void separatePoints(int n, int n2) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n2);
        boolean bl = nlpoint2.removeNeighbor(nlpoint3);
        boolean bl2 = nlpoint3.removeNeighbor(nlpoint2);
        if (!bl && !bl2) {
            System.out.println("error: points were not neighbours");
            return;
        }
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public void joinPoints(int n, int n2) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n2);
        nlpoint2.addNeighbor(nlpoint3);
        nlpoint3.addNeighbor(nlpoint2);
        this.trustLineList = false;
    }

    public void mergePoints(int n, int n2) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n2);
        int n3 = 0;
        while (n3 < nlpoint2.nnbr) {
            nlpoint nlpoint4 = nlpoint2.pnbr[n3];
            nlpoint4.addNeighbor(nlpoint3);
            nlpoint3.addNeighbor(nlpoint4);
            ++n3;
        }
        this.removePoint(nlpoint2);
        this.trustLineList = false;
    }

    public void identifyPoints(int n, int n2) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n2);
        nlpoint2.addNeighbor(nlpoint3);
        nlpoint3.addNeighbor(nlpoint2);
        this.trustLineList = false;
        this.trustPointList = false;
        nlpoint2.identifyWith(nlpoint3);
    }

    public void addPoint(double[] dArray) {
        this.points.addElement(new nlpoint(this.points.size(), -1, dArray[0], dArray[1], dArray[2], dArray.length >= 4 ? dArray[3] : 1.0));
        this.reindexPoints();
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public void addSegment(double[] dArray, double[] dArray2) {
        nlpoint nlpoint2 = new nlpoint(this.points.size(), -1, dArray[0], dArray[1], dArray[2], dArray.length > 3 ? dArray[3] : 1.0);
        this.points.addElement(nlpoint2);
        nlpoint nlpoint3 = new nlpoint(this.points.size(), -1, dArray2[0], dArray2[1], dArray2[2], dArray2.length > 3 ? dArray2[3] : 1.0);
        this.points.addElement(nlpoint3);
        nlpoint2.addNeighbor(nlpoint3);
        nlpoint3.addNeighbor(nlpoint2);
        this.reindexPoints();
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public void addPoint(double[] dArray, int n) {
        nlpoint nlpoint2 = new nlpoint(this.points.size(), -1, dArray[0], dArray[1], dArray[2], dArray.length >= 3 ? dArray[3] : 1.0);
        if (n >= 0) {
            nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n);
            nlpoint2.addNeighbor(nlpoint3);
            nlpoint3.addNeighbor(nlpoint2);
        }
        this.points.addElement(nlpoint2);
        this.reindexPoints();
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public void addPoint(nlpoint nlpoint2, nlpoint nlpoint3, int n) {
        nlpoint2.nlcode = n;
        nlpoint2.myIndex = this.points.size();
        this.points.addElement(nlpoint2);
        if (nlpoint3 != null) {
            nlpoint3.addNeighbor(nlpoint2);
            nlpoint2.addNeighbor(nlpoint3);
        }
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public double[][] linesTo(int n) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        double[][] dArray = new double[nlpoint2.nnbr][8];
        int n2 = 0;
        while (n2 < nlpoint2.nnbr) {
            nlpoint nlpoint3 = nlpoint2.pnbr[n2];
            dArray[n2][0] = nlpoint3.x;
            dArray[n2][1] = nlpoint3.y;
            dArray[n2][2] = nlpoint3.z;
            dArray[n2][3] = nlpoint3.r;
            dArray[n2][4] = nlpoint2.x;
            dArray[n2][5] = nlpoint2.y;
            dArray[n2][6] = nlpoint2.z;
            dArray[n2][7] = nlpoint2.r;
            ++n2;
        }
        return dArray;
    }

    public void setPointRadius(double[] dArray, int n) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        nlpoint2.setRadius(dArray[3]);
        this.trustLineList = false;
        this.trustPointList = false;
    }

    private void markToShift(int n) {
        Enumeration enumeration = this.points.elements();
        while (enumeration.hasMoreElements()) {
            nlpoint nlpoint2 = (nlpoint)enumeration.nextElement();
            boolean bl = nlpoint2.shiftMark = nlpoint2.imark == n;
        }
    }

    public void setPointPosition(double[] dArray, int n) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        double[] dArray2 = new double[]{dArray[0] - nlpoint2.x, dArray[1] - nlpoint2.y, dArray[2] - nlpoint2.z};
        nlpoint2.setPosition(dArray);
        if (nlpoint2.imark == 1) {
            this.markToShift(1);
            nlpoint2.shiftMark = false;
            this.imposeShift(dArray2);
        }
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public void addPoint(int n, int n2) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n2);
        boolean bl = nlpoint2.removeNeighbor(nlpoint3);
        boolean bl2 = nlpoint3.removeNeighbor(nlpoint2);
        if (!bl && !bl2) {
            System.out.println("error: points were not neighbours");
            return;
        }
        nlpoint nlpoint4 = new nlpoint(this.points.size(), 1, 0.5 * (nlpoint2.x + nlpoint3.x), 0.5 * (nlpoint2.y + nlpoint3.y), 0.5 * (nlpoint2.z + nlpoint3.z), 0.5 * (nlpoint2.r + nlpoint3.r));
        this.points.addElement(nlpoint4);
        nlpoint2.addNeighbor(nlpoint4);
        nlpoint3.addNeighbor(nlpoint4);
        nlpoint4.addNeighbor(nlpoint2);
        nlpoint4.addNeighbor(nlpoint3);
        nlpoint4.imark = 1;
        this.reindexPoints();
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public void removePoint(int n) {
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        Enumeration enumeration = this.points.elements();
        while (enumeration.hasMoreElements()) {
            ((nlpoint)enumeration.nextElement()).removeNeighbor(nlpoint2);
        }
        this.points.removeElementAt(n);
        this.trustLineList = false;
        this.trustPointList = false;
        this.reindexPoints();
    }

    public void removePoint(nlpoint nlpoint2) {
        Enumeration enumeration = this.points.elements();
        while (enumeration.hasMoreElements()) {
            ((nlpoint)enumeration.nextElement()).removeNeighbor(nlpoint2);
        }
        this.points.removeElement(nlpoint2);
        this.trustLineList = false;
        this.trustPointList = false;
        this.reindexPoints();
    }

    public void nullifyPoint(nlpoint nlpoint2) {
        Enumeration enumeration = this.points.elements();
        while (enumeration.hasMoreElements()) {
            ((nlpoint)enumeration.nextElement()).removeNeighbor(nlpoint2);
        }
        nlpoint2.nnbr = 0;
    }

    public void recHideBranch(nlpoint nlpoint2) {
        --nlpoint2.imark;
        int n = 0;
        while (n < nlpoint2.nnbr) {
            nlpoint nlpoint3 = nlpoint2.pnbr[n];
            if (nlpoint3.imark == 2) {
                nlpoint3.imark = 1;
                this.recHideBranch(nlpoint3);
            } else {
                --nlpoint3.imark;
            }
            ++n;
        }
    }

    public void showLoops() {
        int n;
        nlpoint nlpoint2;
        int n2 = this.points.size();
        int n3 = 0;
        while (n3 < n2) {
            nlpoint2 = (nlpoint)this.points.elementAt(n3);
            nlpoint2.imark = nlpoint2.nnbr;
            ++n3;
        }
        int n4 = 1;
        while (n4 > 0) {
            n4 = 0;
            n = 0;
            while (n < n2) {
                nlpoint2 = (nlpoint)this.points.elementAt(n);
                if (nlpoint2.imark == 1) {
                    this.recHideBranch(nlpoint2);
                    ++n4;
                }
                ++n;
            }
            System.out.println("branch elimination " + n4);
        }
        n = 0;
        while (n < n2) {
            nlpoint2 = (nlpoint)this.points.elementAt(n);
            if (nlpoint2.imark <= 1) {
                nlpoint2.imark = -1;
            }
            ++n;
        }
        this.trustPointList = false;
        this.trustLineList = false;
    }

    public void clearTrace() {
        Enumeration enumeration = this.points.elements();
        while (enumeration.hasMoreElements()) {
            ((nlpoint)enumeration.nextElement()).imark = -1;
        }
        this.trustLineList = false;
        this.trustPointList = false;
    }

    public boolean recMarkSection(nlpoint nlpoint2, boolean[] blArray, int n, int n2) {
        boolean bl = false;
        if (nlpoint2.myIndex == n2) {
            bl = true;
            nlpoint2.imark = n;
        }
        if (!blArray[nlpoint2.myIndex]) {
            blArray[nlpoint2.myIndex] = true;
            int n3 = 0;
            while (n3 < nlpoint2.nnbr && !bl) {
                bl = this.recMarkSection(nlpoint2.pnbr[n3], blArray, n, n2);
                if (bl) {
                    nlpoint2.imark = n;
                }
                ++n3;
            }
        }
        return bl;
    }

    public void highlightSection(int n, int n2) {
        this.clearTrace();
        if (this.points != null) {
            int n3;
            int n4 = this.points.size();
            boolean[] blArray = new boolean[n4];
            this.rootpoint = n;
            int n5 = 0;
            while (n5 < n4) {
                blArray[n5] = false;
                ++n5;
            }
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(this.rootpoint);
            nlpoint2.imark = n3 = 1;
            boolean bl = this.recMarkSection(nlpoint2, blArray, n3, n2);
            if (!bl) {
                System.out.println("couldnt connect points");
            }
            this.trustPointList = false;
            this.trustLineList = false;
        }
    }

    public void highlightTree(int n, int n2) {
        this.clearTrace();
        int n3 = 1;
        if (this.points != null) {
            int n4 = this.points.size();
            boolean[] blArray = new boolean[n4];
            int n5 = 0;
            while (n5 < n4) {
                blArray[n5] = false;
                ++n5;
            }
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
            nlpoint2.imark = n3;
            blArray[n] = true;
            nlpoint2 = (nlpoint)this.points.elementAt(n2);
            this.recTrace(nlpoint2, blArray);
            this.trustPointList = false;
            this.trustLineList = false;
        }
    }

    public void highlightPoint(int n) {
        int n2 = 1;
        if (this.points != null) {
            this.points.size();
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
            nlpoint2.imark = n2;
            this.trustPointList = false;
            this.trustLineList = false;
        }
    }

    public void markHighlightedType(int n) {
        if (this.points != null) {
            int n2 = this.points.size();
            int n3 = 0;
            while (n3 < n2) {
                nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n3);
                if (nlpoint2.imark == 1) {
                    nlpoint2.nlcode = n;
                }
                ++n3;
            }
            this.trustPointList = false;
            this.trustLineList = false;
        }
    }

    public void deleteHighlighted() {
        if (this.points != null) {
            int n = this.points.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n2);
                if (nlpoint2.imark == 1) {
                    Enumeration enumeration = this.points.elements();
                    while (enumeration.hasMoreElements()) {
                        ((nlpoint)enumeration.nextElement()).removeNeighbor(nlpoint2);
                    }
                    this.points.removeElement(nlpoint2);
                }
                --n2;
            }
            this.trustPointList = false;
            this.trustLineList = false;
            this.reindexPoints();
        }
    }

    public void recMarkShiftPoints(nlpoint nlpoint2, boolean[] blArray, int n) {
        if (!blArray[nlpoint2.myIndex]) {
            blArray[nlpoint2.myIndex] = true;
            nlpoint2.imark = n;
            ++this.pcount;
            int n2 = 0;
            while (n2 < nlpoint2.nnbr) {
                this.recMarkShiftPoints(nlpoint2.pnbr[n2], blArray, n);
                ++n2;
            }
        }
    }

    public void markShiftPoints(int n) {
        int n2 = this.points.size();
        boolean[] blArray = new boolean[n2];
        this.rootpoint = n;
        int n3 = 0;
        while (n3 < n2) {
            blArray[n3] = false;
            ++n3;
        }
        nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n);
        blArray[n] = true;
        int[] nArray = new int[nlpoint2.nnbr];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < nlpoint2.nnbr) {
            this.pcount = 0;
            this.recMarkShiftPoints(nlpoint2.pnbr[n6], blArray, n6 + 10);
            nArray[n6] = this.pcount;
            if (this.pcount > n5) {
                n5 = this.pcount;
                n4 = n6;
            }
            ++n6;
        }
        System.out.println("dropping " + n4);
        int n7 = 0;
        while (n7 < this.points.size()) {
            nlpoint nlpoint3 = (nlpoint)this.points.elementAt(n7);
            if (nlpoint3.imark == n4 + 10) {
                nlpoint3.imark = -1;
                nlpoint3.shiftMark = false;
            } else {
                nlpoint3.imark = 1;
                nlpoint3.shiftMark = true;
            }
            ++n7;
        }
        this.trustLineList = false;
        this.trustPointList = false;
        System.out.println("marked shift points: " + nArray[0] + " " + nArray[1]);
    }

    public void setShift(double[] dArray) {
        this.cdp = dArray;
        this.trustLineList = false;
    }

    public void imposeShift(double[] dArray) {
        this.cdp = dArray;
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n2);
            if (nlpoint2.shiftMark) {
                nlpoint2.shift(this.cdp);
            }
            ++n2;
        }
        this.trustLineList = false;
        int n3 = 0;
        while (n3 < 3) {
            this.cdp[n3] = 0.0;
            ++n3;
        }
    }

    public void recMakeDG(nlpoint nlpoint2, boolean[] blArray, int[] nArray) {
        blArray[nlpoint2.myIndex] = true;
        int n = 0;
        int n2 = 0;
        while (n2 < nlpoint2.nnbr) {
            nlpoint nlpoint3 = nlpoint2.pnbr[n2];
            if (!blArray[nlpoint3.myIndex]) {
                nlpoint3.parent = nlpoint2;
                double d = Math.sqrt((nlpoint2.x - nlpoint3.x) * (nlpoint2.x - nlpoint3.x) + (nlpoint2.y - nlpoint3.y) * (nlpoint2.y - nlpoint3.y) + (nlpoint2.z - nlpoint3.z) * (nlpoint2.z - nlpoint3.z));
                nlpoint3.dgx = nlpoint2.dgx + d;
                nlpoint3.dgy = nArray[0];
                if (n > 0) {
                    nArray[0] = nArray[0] + 1;
                }
                ++n;
                this.recMakeDG(nlpoint3, blArray, nArray);
            }
            ++n2;
        }
    }

    public void makeDG() {
        if (this.points != null) {
            int n = this.points.size();
            int n2 = 0;
            double d = ((nlpoint)this.points.elementAt((int)n2)).r;
            int n3 = 0;
            while (n3 < n) {
                double d2 = ((nlpoint)this.points.elementAt((int)n3)).r;
                if (d2 > d) {
                    n2 = n3;
                    d = d2;
                }
                ++n3;
            }
            int[] nArray = new int[]{0};
            boolean[] blArray = new boolean[n];
            int n4 = 0;
            while (n4 < n) {
                blArray[n4] = false;
                ++n4;
            }
            nlpoint nlpoint2 = (nlpoint)this.points.elementAt(n2);
            nlpoint2.dgx = 0.0;
            nlpoint2.dgy = 0.0;
            this.recMakeDG(nlpoint2, blArray, nArray);
            this.trustPointList = false;
            this.trustLineList = false;
        }
    }
}

