/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;

class neuronEditorPanel
extends rsbPanel
implements ActionListener,
ItemListener {
    graphData3 neugd;
    neuronEditorCanvas neucan;
    rescalableFloatSlider rsfsxscale;
    rescalableFloatSlider rsfsyscale;
    rescalableFloatSlider rsfszscale;
    rescalableFloatSlider rsfszcursor;
    neulucData cell;
    doublePointer xscale;
    doublePointer yscale;
    doublePointer zscale;
    doublePointer zcursor;
    optionBar ob;
    String fdir = "";
    String frfile;
    String fwfile;
    boolean canReadFiles = true;
    boolean canWriteFiles = true;
    webCellBar wcb;
    popLabel markLabel;
    TextField markTF;
    PopupMenu typeMenu;
    String[] sectionTypes = new String[]{"undefined", "soma", "axon", "dendrite", "apical dendrite", "custom-1", "custom-2", "custom-n"};
    Checkbox cb1;
    Checkbox cb2;
    shrinkageCorrectionFrame shrinkageCorrectionF;
    headerFrame headerF;
    Panel pneucan;
    int markType;
    messageDialog messageD;
    Frame topF;

    neuronEditorPanel(int n, int n2, Font font) {
        String[] stringArray;
        Component component;
        this.neugd = new graphData3();
        this.neugd.setCenter((n - 60) / 2, (n2 - 60) / 2);
        this.neugd.setMargins(40, 25, 25, 20);
        this.neugd.setBackground(Color.black);
        this.neugd.setForeground(Color.white);
        this.neugd.setMargins(40, 20, 30, 20);
        this.neugd.setFont(font);
        this.typeMenu = new PopupMenu();
        int n3 = 0;
        while (n3 < this.sectionTypes.length) {
            this.typeMenu.add(new MenuItem(this.sectionTypes[n3]));
            ++n3;
        }
        this.add(this.typeMenu);
        this.neucan = new neuronEditorCanvas(n - 40, n2 - 120, this.neugd);
        this.neucan.setFont(font);
        this.zcursor = new doublePointer(0.02);
        this.rsfszcursor = new rescalableFloatSlider(rescalableFloatSlider.LOG, "red-green dz", this.zcursor, -3.0, 0.0);
        this.neucan.setzCursor(this.zcursor);
        this.rsfszcursor.setWatcher(this.neucan);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 9, 1, 1));
        panel.add(new Button("trace"));
        panel.add(new Button("find"));
        panel.add(new Button("clear"));
        panel.add(new Button("join"));
        panel.add(new Button("ident."));
        panel.add(new Button("merge"));
        panel.add(new Button("nodes"));
        panel.add(new Button("outlines"));
        panel.add(new Button("clean"));
        this.markLabel = new popLabel("as: unknown", this.typeMenu);
        this.markTF = new TextField("-1");
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(4, 1, 1, 2));
        sbPanel sbPanel2 = new sbPanel();
        sbPanel sbPanel3 = new sbPanel();
        sbPanel sbPanel4 = new sbPanel();
        sbPanel sbPanel5 = new sbPanel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        sbPanel2.setLayout(new GridLayout(3, 1, 1, 1));
        this.cb1 = new Checkbox("normal", true, checkboxGroup);
        sbPanel2.add(this.cb1);
        this.cb2 = new Checkbox("grow", false, checkboxGroup);
        sbPanel2.add(this.cb2);
        sbPanel2.add(new Button("add floating"));
        sbPanel3.setLayout(new GridLayout(4, 1, 1, 1));
        sbPanel3.add(new Button("cut"));
        sbPanel3.add(new Button("add between"));
        sbPanel3.add(new Button("remove"));
        sbPanel3.add(new Button("loops"));
        sbPanel4.setLayout(new GridLayout(4, 1, 1, 1));
        sbPanel4.add(new Label("select:"));
        sbPanel4.add(new Button("section"));
        sbPanel4.add(new Button("tree"));
        sbPanel4.add(new Button("points"));
        sbPanel5.add(new Button("delete"));
        sbPanel5.add(new Button("mark"));
        sbPanel5.setLayout(new GridLayout(4, 1, 1, 1));
        sbPanel5.add(this.markLabel);
        sbPanel5.add(this.markTF);
        panel2.add(sbPanel2);
        panel2.add(sbPanel3);
        panel2.add(sbPanel4);
        panel2.add(sbPanel5);
        this.cb1.addItemListener(this);
        this.cb2.addItemListener(this);
        this.markTF.addActionListener(this);
        int n4 = this.typeMenu.getItemCount() - 1;
        while (n4 >= 0) {
            MenuItem menuItem = this.typeMenu.getItem(n4);
            if (menuItem instanceof MenuItem) {
                menuItem.addActionListener(this);
            }
            --n4;
        }
        int n5 = panel2.getComponentCount() - 1;
        while (n5 >= 0) {
            Component component2 = panel2.getComponent(n5);
            if (component2 instanceof sbPanel) {
                component = (sbPanel)component2;
                int n6 = ((Container)component).getComponentCount() - 1;
                while (n6 >= 0) {
                    stringArray = ((Container)component).getComponent(n6);
                    if (stringArray instanceof Button) {
                        ((Button)stringArray).addActionListener(this);
                    }
                    --n6;
                }
            }
            --n5;
        }
        int n7 = panel.getComponentCount() - 1;
        while (n7 >= 0) {
            component = panel.getComponent(n7);
            if (component instanceof Button) {
                ((Button)component).addActionListener(this);
            }
            --n7;
        }
        component = new webCellBar(this);
        this.ob = new optionBar(this);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 1));
        panel3.add(component);
        panel3.add(this.ob);
        this.pneucan = new Panel();
        this.pneucan.setLayout(new BorderLayout());
        this.pneucan.add("North", panel);
        this.pneucan.add("Center", this.neucan);
        this.setLayout(new BorderLayout());
        this.add("North", panel3);
        this.add("East", panel2);
        this.add("Center", this.pneucan);
        this.add("South", this.rsfszcursor);
        this.headerF = new headerFrame();
        this.shrinkageCorrectionF = new shrinkageCorrectionFrame(this.neucan, this.headerF);
        stringArray = new String[]{"1 0  0 0 0     4  -1", "2 0  0 10 0    4  1", "3 0  10 20 0   2  2", "4 0 -10 20 0   2  2", "5 0  -15 30 0  1  4", "6 0  -5 30 0   1  4"};
        this.setCell(stringArray, "", "default.swc");
    }

    public void setParentFrame(Frame frame) {
        if (frame != null) {
            this.topF = frame;
            this.messageD = new messageDialog(frame);
        }
    }

    public void exit() {
        if (this.topF != null) {
            ((Component)this.topF).setVisible(false);
            this.topF.dispose();
        }
    }

    public void reverseVideo() {
        this.neucan.reverseVideo();
    }

    public void setCellWindow() {
        this.setNormal();
        if (!this.neucan.isShowing()) {
            this.pneucan.add("Center", this.neucan);
            this.doLayout();
            this.validate();
        }
    }

    public void setNormal() {
        this.cb1.setState(true);
        this.cb2.setState(false);
        this.neucan.setNormal();
    }

    public void setData(neulucData neulucData2) {
        this.cell = neulucData2;
        this.neucan.setData(this.cell);
    }

    public void setReadWrite(boolean bl, boolean bl2) {
        this.canReadFiles = bl;
        this.canWriteFiles = bl2;
    }

    public void shrinkageCorrect() {
        this.shrinkageCorrectionF.setCell(this.cell);
        ((Component)this.shrinkageCorrectionF).setVisible(true);
    }

    public void editHeader() {
        this.headerF.setCell(this.cell);
        ((Component)this.headerF).setVisible(true);
    }

    public void refresh() {
        this.neucan.repaint();
    }

    public String[] readStringArrayFromURL(URL uRL) {
        this.blockingMessageOn("reading URL", uRL.toString());
        String[] stringArray = urlString.readStringArrayFromURL(uRL);
        this.blockingMessageOff();
        return stringArray;
    }

    public void writeStringToFile(String string, String string2) {
        this.blockingMessageOn("writing " + string2);
        fileString.writeStringToFile(string, string2);
        this.blockingMessageOff();
    }

    public String[] readStringArrayFromFile(String string) {
        this.blockingMessageOn("reading " + string);
        String[] stringArray = fileString.readStringArrayFromFile(string);
        this.blockingMessageOff();
        return stringArray;
    }

    public void setCell(String[] stringArray, String string, String string2) {
        this.blockingMessageOn("parsing", String.valueOf(string) + string2);
        this.cell = new neulucData();
        this.cell.fill(stringArray, String.valueOf(string) + string2);
        stringArray = null;
        this.setData(this.cell);
        this.shrinkageCorrectionF.setCell(this.cell);
        this.headerF.setCell(this.cell);
        this.blockingMessageOff();
        this.cell.setSourceFileName(string2);
        this.ob.setFileNameLabel(this.cell.getSourceFileName());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            String string = ((Button)object).getLabel();
            this.processNameEvent(string);
            return;
        }
        if (object instanceof MenuItem) {
            String string = ((MenuItem)object).getLabel();
            string = actionEvent.getActionCommand();
            int n = -1;
            int n2 = 0;
            while (n2 < this.sectionTypes.length) {
                if (this.sectionTypes[n2].equals(string)) {
                    n = n2;
                }
                ++n2;
            }
            ((TextComponent)this.markTF).setText(new Integer(n).toString());
            if (n >= 0) {
                this.markType = n;
                int n3 = n;
                if (n3 >= this.sectionTypes.length) {
                    n3 = this.sectionTypes.length - 1;
                }
                this.markLabel.setText("as: " + this.sectionTypes[n3]);
                return;
            }
        } else if (object instanceof TextField) {
            int n;
            String string = this.markTF.getText();
            this.markType = n = Integer.valueOf(string).intValue();
            int n4 = n;
            if (n4 >= this.sectionTypes.length) {
                n4 = this.sectionTypes.length - 1;
            }
            this.markLabel.setText("as: " + this.sectionTypes[n4]);
            System.out.println("tf text " + string + this.sectionTypes[n4]);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            String string = (String)itemEvent.getItem();
            this.processNameEvent(string);
        }
    }

    public void processNameEvent(String string) {
        if (string.equals("trace")) {
            this.setNormal();
            this.neucan.trace();
            return;
        }
        if (string.equals("find")) {
            this.neucan.find();
            return;
        }
        if (string.equals("add between")) {
            this.setNormal();
            this.neucan.addNode();
            return;
        }
        if (string.equals("remove")) {
            this.setNormal();
            this.neucan.setRemoveMode();
            return;
        }
        if (string.equals("join")) {
            this.setNormal();
            this.neucan.join();
            return;
        }
        if (string.equals("merge")) {
            this.setNormal();
            this.neucan.merge();
            return;
        }
        if (string.equals("ident.")) {
            this.setNormal();
            this.neucan.ident();
            return;
        }
        if (string.equals("clear")) {
            this.setNormal();
            return;
        }
        if (string.equals("clean")) {
            this.setNormal();
            this.neucan.cleanCell();
            return;
        }
        if (string.equals("cut")) {
            this.setNormal();
            this.neucan.cut();
            return;
        }
        if (string.equals("drag")) {
            this.setNormal();
            this.neucan.drag();
            return;
        }
        if (string.equals("grow")) {
            this.neucan.grow();
            return;
        }
        if (string.equals("normal")) {
            this.setNormal();
            return;
        }
        if (string.equals("add floating")) {
            this.neucan.addFree();
            return;
        }
        if (string.equals("nodes")) {
            this.neucan.showPoints();
            return;
        }
        if (string.equals("outlines")) {
            this.neucan.showOutlines();
            return;
        }
        if (string.equals("loops")) {
            this.setNormal();
            this.neucan.showLoops();
            return;
        }
        if (string.equals("section")) {
            this.setNormal();
            this.neucan.highlightSection();
            return;
        }
        if (string.equals("points")) {
            this.setNormal();
            this.neucan.reallyShowPoints();
            this.neucan.markPoint();
            return;
        }
        if (string.equals("tree")) {
            this.setNormal();
            this.neucan.highlightTree();
            return;
        }
        if (string.equals("mark")) {
            if (this.cell != null) {
                this.cell.markHighlightedType(this.markType);
                this.neucan.clear();
                return;
            }
        } else if (string.equals("delete")) {
            if (this.cell != null) {
                this.cell.deleteHighlighted();
                this.neucan.clear();
                return;
            }
        } else if (string.equals("open")) {
            String[] stringArray;
            if (this.canReadFiles && (stringArray = fileString.getFileName2("r", this.fdir)) != null && stringArray[0] != null && stringArray[1] != null) {
                this.fdir = stringArray[0];
                this.frfile = stringArray[1];
                String[] stringArray2 = this.readStringArrayFromFile(String.valueOf(this.fdir) + this.frfile);
                this.setCell(stringArray2, this.fdir, this.frfile);
                return;
            }
        } else {
            if (string.equals("shrinkage correction")) {
                this.shrinkageCorrect();
                return;
            }
            if (string.equals("edit header")) {
                this.editHeader();
                return;
            }
            if (string.equals("save as swc")) {
                if (this.canWriteFiles) {
                    this.headerF.apply();
                    String[] stringArray = fileString.getFileName2("w", this.fdir);
                    if (stringArray != null && stringArray[0] != null) {
                        this.fdir = stringArray[0];
                        this.fwfile = stringArray[1];
                        this.blockingMessageOn("formatting as SWC");
                        this.writeStringToFile(this.cell.write(), String.valueOf(this.fdir) + this.fwfile);
                        return;
                    }
                } else {
                    System.out.println("file writing not allowed ");
                }
                return;
            }
            if (string.equals("save as Genesis - flat")) {
                if (this.canWriteFiles) {
                    String[] stringArray = fileString.getFileName2("w", this.fdir);
                    if (stringArray != null && stringArray[0] != null) {
                        this.fdir = stringArray[0];
                        this.fwfile = stringArray[1];
                        this.blockingMessageOn("formatting as GENESIS");
                        this.writeStringToFile(this.cell.GENESISwrite(), String.valueOf(this.fdir) + this.fwfile);
                        return;
                    }
                } else {
                    System.out.println("file writing not allowed ");
                }
                return;
            }
            if (string.startsWith("save as Genesis - hierar")) {
                if (this.canWriteFiles) {
                    String[] stringArray = fileString.getFileName2("w", this.fdir);
                    if (stringArray != null && stringArray[0] != null) {
                        this.fdir = stringArray[0];
                        this.fwfile = stringArray[1];
                        this.blockingMessageOn("formatting as GENESIS");
                        this.writeStringToFile(this.cell.GENESISwriteHR(), String.valueOf(this.fdir) + this.fwfile);
                        return;
                    }
                } else {
                    System.out.println("file writing not allowed ");
                }
                return;
            }
            if (string.startsWith("save as hoc (Neuron) - stru")) {
                if (this.canWriteFiles) {
                    String[] stringArray = fileString.getFileName2("w", this.fdir);
                    if (stringArray != null && stringArray[0] != null) {
                        this.fdir = stringArray[0];
                        this.fwfile = stringArray[1];
                        this.blockingMessageOn("formatting as HOC");
                        this.writeStringToFile(this.cell.HOCwrite(), String.valueOf(this.fdir) + this.fwfile);
                        return;
                    }
                } else {
                    System.out.println("file writing not allowed ");
                }
                return;
            }
            if (string.startsWith("save as hoc (Neuron) - name")) {
                if (this.canWriteFiles) {
                    String[] stringArray = fileString.getFileName2("w", this.fdir);
                    if (stringArray != null && stringArray[0] != null) {
                        this.fdir = stringArray[0];
                        this.fwfile = stringArray[1];
                        this.blockingMessageOn("formatting as HOC (named segments)");
                        this.writeStringToFile(this.cell.HOCwriteNS(), String.valueOf(this.fdir) + this.fwfile);
                        return;
                    }
                } else {
                    System.out.println("file writing not allowed ");
                }
                return;
            }
            if (string.equals("auto save as swc")) {
                if (this.canWriteFiles) {
                    this.headerF.apply();
                    this.fwfile = String.valueOf(this.frfile.substring(0, this.frfile.lastIndexOf("."))) + ".swc";
                    this.blockingMessageOn("formatting as SWC");
                    this.writeStringToFile(this.cell.write(), String.valueOf(this.fdir) + this.fwfile);
                    return;
                }
                System.out.println("file writing not allowed ");
                return;
            }
            System.out.println("button ? " + string);
        }
    }

    public void blockingMessageOn(String string) {
        this.messageD.setLabel1(string);
        Point point = this.getLocationOnScreen();
        ((Component)this.messageD).setLocation(point.x + 100, point.y + 20);
        this.messageD.showMessage();
    }

    public void blockingMessageOn(String string, String string2) {
        if (this.messageD != null) {
            this.messageD.setLabel1(string);
            this.messageD.setLabel2(string2);
            Point point = this.getLocationOnScreen();
            ((Component)this.messageD).setLocation(point.x + 100, point.y + 20);
            this.messageD.showMessage();
        }
    }

    public void blockingMessageOff() {
        if (this.messageD != null) {
            this.messageD.hideMessage();
        }
    }
}

