/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class graphData3 {
    int width = 100;
    int height = 100;
    int n_tickx = 5;
    int n_ticky = 4;
    boolean xVisible = true;
    boolean yVisible = true;
    double xLeft = -100.0;
    double xRight = 50.0;
    double yBottom = -0.01;
    double yTop = 1.05;
    double dpdx;
    double dpdy;
    int leftMargin = 10;
    int rightMargin = 20;
    int bottomMargin = 20;
    int topMargin = 20;
    boolean xRescalable = true;
    boolean yRescalable = true;
    int tickGridx = 2;
    int tickGridy = 2;
    Color bgColor;
    Color fgColor;
    Color gridColor;
    Color dataColor;
    boolean xLowDef;
    boolean yLowDef;
    boolean xUpDef;
    boolean yUpDef;
    double xLowLim;
    double yLowLim;
    double xUpLim;
    double yUpLim;
    boolean grey = false;
    boolean initialisedRotation = false;
    int x3c;
    int y3c;
    int z3c = 0;
    int zcen = 0;
    double[] cen3 = new double[3];
    double[][] m3 = new double[3][3];
    double[][] m3t = new double[3][3];
    double[][] m3sav = new double[3][3];
    double xScale = 1.0;
    double yScale = 1.0;
    double zScale = 1.0;
    Font axisFont;
    edgeCube edgeC = new edgeCube();
    int xcen;
    int ycen;
    double thax0;
    double r0;
    double thax1;
    double r1;
    Color[] lineColors;

    graphData3() {
        int n = 0;
        while (n < 3) {
            this.m3[n][n] = 1.0;
            ++n;
        }
        this.axisFont = new Font("8x13", 0, 12);
        this.lineColors = new Color[8];
        this.lineColors[0] = Color.white;
        this.lineColors[1] = Color.red;
        this.lineColors[2] = Color.gray;
        this.lineColors[3] = Color.green;
        this.lineColors[4] = Color.magenta;
        this.lineColors[5] = Color.cyan;
        this.lineColors[6] = Color.pink;
        this.lineColors[7] = Color.blue;
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.pixelSet();
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        if (this.bgColor.getGreen() + this.bgColor.getRed() + this.bgColor.getBlue() > 150) {
            this.gridColor = new Color(this.bgColor.getRGB() - 526368);
            return;
        }
        this.gridColor = new Color(this.bgColor.getRGB() + 0x1F2F1F);
    }

    public void setGrey() {
        this.grey = true;
    }

    public void setFont(Font font) {
        this.axisFont = font;
    }

    public void setNonGrey() {
        this.grey = false;
    }

    public void setForeground(Color color) {
        this.fgColor = color;
    }

    public void setDataColor(Color color) {
        this.dataColor = color;
    }

    public void clip(Graphics graphics) {
        graphics.clipRect(this.leftMargin, this.topMargin, this.width - this.leftMargin - this.rightMargin, this.height - this.topMargin - this.bottomMargin);
    }

    public void setRangeConstraints(Double d, Double d2, Double d3, Double d4) {
        this.xLowDef = d != null;
        if (this.xLowDef) {
            this.xLowLim = d;
        }
        if (this.yLowDef = d2 != null) {
            this.yLowLim = d2;
        }
        if (this.xUpDef = d3 != null) {
            this.xUpLim = d3;
        }
        if (this.yUpDef = d4 != null) {
            this.yUpLim = d4;
        }
        this.enforceRangeConstraints();
    }

    public void enforceRangeConstraints() {
        if (this.xLowDef) {
            if (this.xLeft < this.xLowLim) {
                this.xLeft = this.xLowLim;
            }
            if (this.xRight < this.xLowLim) {
                this.xRight = this.xLowLim;
            }
        }
        if (this.yLowDef) {
            if (this.yBottom < this.yLowLim) {
                this.yBottom = this.yLowLim;
            }
            if (this.yTop < this.yLowLim) {
                this.yTop = this.yLowLim;
            }
        }
        if (this.xUpDef) {
            if (this.xLeft > this.xUpLim) {
                this.xLeft = this.xUpLim;
            }
            if (this.xRight > this.xUpLim) {
                this.xRight = this.xUpLim;
            }
        }
        if (this.yUpDef) {
            if (this.yBottom > this.yUpLim) {
                this.yBottom = this.yUpLim;
            }
            if (this.yTop > this.yUpLim) {
                this.yTop = this.yUpLim;
            }
        }
    }

    public double[] getRange() {
        double[] dArray = new double[]{this.xLeft, this.xRight, this.yBottom, this.yTop};
        return dArray;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.pixelSet();
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        this.leftMargin = n;
        this.rightMargin = n2;
        this.topMargin = n4;
        this.bottomMargin = n3;
        this.pixelSet();
    }

    public void setCenter(int n, int n2) {
        this.x3c = n;
        this.y3c = n2;
    }

    public void setRescalable(boolean bl, boolean bl2) {
        this.xRescalable = bl;
        this.yRescalable = bl2;
    }

    public void setVisible(boolean bl, boolean bl2) {
        this.xVisible = bl;
        this.yVisible = bl2;
    }

    public void setTicks(int n, int n2) {
        this.n_tickx = n;
        this.n_ticky = n2;
    }

    public void fillBackground(Graphics graphics, Color color) {
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.width, this.height);
    }

    public void drawAxes(Graphics graphics, Color color) {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        int n6;
        double d;
        int[] nArray = new int[]{1, 2, 5};
        graphics.setColor(color.brighter());
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        graphics.drawRect(1, 1, this.width - 3, this.height - 3);
        graphics.setColor(color.darker());
        graphics.drawRect(0, 0, this.width - 2, this.height - 2);
        Color color2 = this.grey ? color.brighter() : this.fgColor;
        graphics.setColor(color2);
        graphics.setFont(this.axisFont);
        if (this.xVisible) {
            double d2 = 1.5 / (double)this.n_tickx * Math.abs(this.xRight - this.xLeft);
            d = Math.log(d2) / Math.log(10.0);
            n6 = (int)Math.floor(d);
            n5 = nArray[(int)(2.999 * (d - (double)n6))];
            d2 = Math.pow(10.0, n6) * (double)n5;
            if (this.xRight < this.xLeft) {
                d2 *= -1.0;
            }
            graphics.setColor(color2);
            n4 = (int)(0.5 + this.xLeft / d2);
            while (n4 <= (int)(this.xRight / d2)) {
                string = String.valueOf((double)n4 * d2);
                n3 = string.length();
                n3 = 3 - 4 * n3;
                if ((double)n4 * d2 < 0.0) {
                    n3 -= 4;
                }
                n2 = this.leftMargin + (int)(0.5 + this.dpdx * ((double)n4 * d2 - this.xLeft));
                graphics.drawString(string, n2 + n3, this.height - this.bottomMargin + 15);
                graphics.drawLine(n2, this.height - this.bottomMargin, n2, this.height - this.bottomMargin + 4);
                ++n4;
            }
            graphics.setColor(this.gridColor);
            n = (int)(this.xLeft / (d2 /= (double)this.tickGridx));
            while (n <= (int)(this.xRight / d2)) {
                n2 = this.leftMargin + (int)(0.5 + this.dpdx * ((double)n * d2 - this.xLeft));
                graphics.drawLine(n2, this.topMargin, n2, this.height - this.bottomMargin);
                ++n;
            }
        }
        if (this.yVisible) {
            int n7;
            double d3 = 1.5 / (double)this.n_ticky * Math.abs(this.yTop - this.yBottom);
            d = Math.log(d3) / Math.log(10.0);
            n6 = (int)Math.floor(d);
            n5 = nArray[(int)(2.999 * (d - (double)n6))];
            d3 = Math.pow(10.0, n6) * (double)n5;
            graphics.setColor(color2);
            if (this.yTop < this.yBottom) {
                d3 *= -1.0;
            }
            n4 = (int)(0.5 + this.yBottom / d3);
            while (n4 <= (int)(this.yTop / d3)) {
                string = String.valueOf((double)n4 * d3);
                n3 = -4 * string.length();
                n2 = this.leftMargin + n3;
                n7 = this.height - this.bottomMargin - (int)(0.5 + this.dpdy * ((double)n4 * d3 - this.yBottom));
                graphics.drawString(string, n2 + n3, n7 + 4);
                graphics.drawLine(this.leftMargin - 4, n7, this.leftMargin, n7);
                ++n4;
            }
            graphics.setColor(this.gridColor);
            n = (int)(this.yBottom / (d3 /= (double)this.tickGridy));
            while (n <= (int)(this.yTop / d3)) {
                n7 = this.bottomMargin + (int)(0.5 + this.dpdy * ((double)n * d3 - this.yBottom));
                graphics.drawLine(this.leftMargin, this.height - n7, this.width - this.rightMargin, this.height - n7);
                ++n;
            }
        }
        graphics.setColor(this.fgColor);
    }

    public void drawText(Graphics graphics, double d, double d2, String string) {
        int n = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n2 = this.height - (this.bottomMargin + (int)(this.dpdy * (d2 - this.yBottom)));
        graphics.drawString(string, n -= 6 * string.length(), n2 += 4);
    }

    public void drawCenteredText(Graphics graphics, double d, double d2, String string) {
        int n = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n2 = this.height - (this.bottomMargin + (int)(this.dpdy * (d2 - this.yBottom)));
        graphics.drawString(string, n -= 3 * string.length(), n2 += 4);
    }

    public void drawOffsetText(Graphics graphics, double d, double d2, int n, int n2, String string) {
        int n3 = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n4 = this.height - (this.bottomMargin + (int)(this.dpdy * (d2 - this.yBottom)));
        graphics.drawString(string, (n3 -= 6 * string.length()) + n, (n4 += 4) + n2);
    }

    public int xToPix(double d) {
        return this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
    }

    public int yToPix(double d) {
        return this.height - (this.bottomMargin + (int)(this.dpdy * (d - this.yBottom)));
    }

    public double[] toWorld(int n, int n2) {
        double[] dArray = new double[]{this.xLeft + (double)(n - this.leftMargin) / this.dpdx, this.yBottom + (double)(this.height - n2 - this.bottomMargin) / this.dpdy};
        return dArray;
    }

    public void drawData(Graphics graphics, double[] dArray, double[] dArray2, int n) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.leftMargin + (int)(this.dpdx * (dArray[n2] - this.xLeft));
            nArray[n2] = nArray[n2] < 0 ? 0 : nArray[n2];
            nArray[n2] = nArray[n2] > this.width ? this.width : nArray[n2];
            nArray2[n2] = this.height - (this.bottomMargin + (int)(this.dpdy * (dArray2[n2] - this.yBottom)));
            nArray2[n2] = nArray2[n2] < 0 ? 0 : nArray2[n2];
            nArray2[n2] = nArray2[n2] > this.height ? this.height : nArray2[n2];
            ++n2;
        }
        graphics.drawPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(Graphics graphics, double[] dArray, double[] dArray2, int n) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.leftMargin + (int)(this.dpdx * (dArray[n2] - this.xLeft));
            nArray[n2] = nArray[n2] < 0 ? 0 : nArray[n2];
            nArray[n2] = nArray[n2] > this.width ? this.width : nArray[n2];
            nArray2[n2] = this.height - (this.bottomMargin + (int)(this.dpdy * (dArray2[n2] - this.yBottom)));
            nArray2[n2] = nArray2[n2] < 0 ? 0 : nArray2[n2];
            nArray2[n2] = nArray2[n2] > this.height ? this.height : nArray2[n2];
            ++n2;
        }
        graphics.fillPolygon(nArray, nArray2, n);
    }

    public void drawData(Graphics graphics, float[] fArray, float[] fArray2, int n) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.leftMargin + (int)(this.dpdx * ((double)fArray[n2] - this.xLeft));
            nArray[n2] = nArray[n2] < 0 ? 0 : nArray[n2];
            nArray[n2] = nArray[n2] > this.width ? this.width : nArray[n2];
            nArray2[n2] = this.height - (this.bottomMargin + (int)(this.dpdy * ((double)fArray2[n2] - this.yBottom)));
            nArray2[n2] = nArray2[n2] < 0 ? 0 : nArray2[n2];
            nArray2[n2] = nArray2[n2] > this.height ? this.height : nArray2[n2];
            ++n2;
        }
        graphics.drawPolygon(nArray, nArray2, n);
    }

    public void drawData(Graphics graphics, float[] fArray, float[] fArray2, int[] nArray) {
        int n = nArray[1] - nArray[0];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.leftMargin + (int)(this.dpdx * ((double)fArray[nArray[0] + n2] - this.xLeft));
            nArray2[n2] = nArray2[n2] < 0 ? 0 : nArray2[n2];
            nArray2[n2] = nArray2[n2] > this.width ? this.width : nArray2[n2];
            nArray3[n2] = this.height - (this.bottomMargin + (int)(this.dpdy * ((double)fArray2[nArray[0] + n2] - this.yBottom)));
            nArray3[n2] = nArray3[n2] < 0 ? 0 : nArray3[n2];
            nArray3[n2] = nArray3[n2] > this.height ? this.height : nArray3[n2];
            ++n2;
        }
        graphics.drawPolygon(nArray2, nArray3, n);
    }

    public void fillRect(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n2 = this.topMargin + (int)(this.dpdy * (this.yTop - d4));
        int n3 = (int)(this.dpdx * (d3 - d)) + 1;
        int n4 = (int)(this.dpdy * (d4 - d2)) + 1;
        graphics.fillRect(n, n2, n3, n4);
    }

    public void fill3DRect(Graphics graphics, double d, double d2, double d3, double d4, int n) {
        int n2 = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n3 = this.topMargin + (int)(this.dpdy * (this.yTop - d4));
        int n4 = (int)(this.dpdx * (d3 - d));
        int n5 = (int)(this.dpdy * (d4 - d2));
        graphics.fillRect(n2, n3, n4, n5);
        if (n5 > n) {
            graphics.setColor(graphics.getColor().darker());
            int n6 = 0;
            while (n6 < n) {
                graphics.drawLine(n2 + n4 + n6, n3 + n6, n2 + n4 + n6, n3 + n5 - 1);
                ++n6;
            }
        }
    }

    public void fillCenteredOval(Graphics graphics, double d, double d2, int n, int n2) {
        int n3 = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n4 = this.topMargin + (int)(this.dpdy * (this.yTop - d2));
        graphics.fillOval(n3 - n / 2, n4 - n2 / 2, n, n2);
    }

    public void fillCenteredRect(Graphics graphics, double d, double d2, int n, int n2) {
        int n3 = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n4 = this.topMargin + (int)(this.dpdy * (this.yTop - d2));
        graphics.fillRect(n3 - n / 2, n4 - n2 / 2, n, n2);
    }

    public void fillOffsetCenteredOval(Graphics graphics, double d, double d2, int n, int n2, int n3, int n4) {
        int n5 = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n6 = this.topMargin + (int)(this.dpdy * (this.yTop - d2));
        graphics.fillOval(n5 - n3 / 2 + n, n6 - n4 / 2 + n2, n3, n4);
    }

    public void drawCenteredOval(Graphics graphics, double d, double d2, int n, int n2) {
        int n3 = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n4 = this.topMargin + (int)(this.dpdy * (this.yTop - d2));
        graphics.drawOval(n3 - n / 2, n4 - n2 / 2, n, n2);
    }

    public void drawCenteredRect(Graphics graphics, double d, double d2, int n, int n2) {
        int n3 = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        int n4 = this.topMargin + (int)(this.dpdy * (this.yTop - d2));
        graphics.drawRect(n3 - n / 2, n4 - n2 / 2, n, n2);
    }

    public void drawThickData(Graphics graphics, double[] dArray, double[] dArray2, int n, int n2) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = this.leftMargin + (int)(this.dpdx * (dArray[n3] - this.xLeft));
            nArray[n3] = nArray[n3] < 0 ? 0 : nArray[n3];
            nArray[n3] = nArray[n3] > this.width ? this.width : nArray[n3];
            nArray2[n3] = this.height - (this.bottomMargin + (int)(this.dpdy * (dArray2[n3] - this.yBottom)));
            nArray2[n3] = nArray2[n3] < 0 ? 0 : nArray2[n3];
            nArray2[n3] = nArray2[n3] > this.height ? this.height : nArray2[n3];
            ++n3;
        }
        graphics.drawPolygon(nArray, nArray2, n);
        int n4 = 1;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray3[n5] = nArray[n5] + n4;
                nArray4[n5] = nArray2[n5] + n4;
                ++n5;
            }
            graphics.drawPolygon(nArray, nArray4, n);
            graphics.drawPolygon(nArray3, nArray2, n);
            ++n4;
        }
    }

    public void drawLine(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = this.leftMargin + (int)(this.dpdx * (d - this.xLeft));
        n = n < 0 ? 0 : n;
        n = n > this.width ? this.width : n;
        int n2 = this.leftMargin + (int)(this.dpdx * (d3 - this.xLeft));
        n2 = n2 < 0 ? 0 : n2;
        n2 = n2 > this.width ? this.width : n2;
        int n3 = this.height - (this.bottomMargin + (int)(this.dpdy * (d2 - this.yBottom)));
        n3 = n3 < 0 ? 0 : n3;
        n3 = n3 > this.height ? this.height : n3;
        int n4 = this.height - (this.bottomMargin + (int)(this.dpdy * (d4 - this.yBottom)));
        n4 = n4 < 0 ? 0 : n4;
        n4 = n4 > this.height ? this.height : n4;
        graphics.drawLine(n, n3, n2, n4);
    }

    public void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawLine(graphics, (double)n, (double)n2, (double)n3, (double)n4);
    }

    public final int xOfP(double[] dArray) {
        int n = this.x3c + (int)(this.m3[0][0] * (this.xScale * dArray[0] - this.cen3[0]) + this.m3[0][1] * (this.yScale * dArray[1] - this.cen3[1]) + this.m3[0][2] * (this.zScale * dArray[2] - this.cen3[2]));
        return n;
    }

    public final int yOfP(double[] dArray) {
        int n = this.y3c + (int)(this.m3[1][0] * (this.xScale * dArray[0] - this.cen3[0]) + this.m3[1][1] * (this.yScale * dArray[1] - this.cen3[1]) + this.m3[1][2] * (this.zScale * dArray[2] - this.cen3[2]));
        return n;
    }

    public final int zOfP(double[] dArray) {
        int n = this.z3c + (int)(this.m3[2][0] * (this.xScale * dArray[0] - this.cen3[0]) + this.m3[2][1] * (this.yScale * dArray[1] - this.cen3[1]) + this.m3[2][2] * (this.zScale * dArray[2] - this.cen3[2]));
        return n;
    }

    public void drawLineList(Graphics graphics, double[][][] dArray) {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            double[] dArray2 = dArray[n2][0];
            double[] dArray3 = dArray[n2][1];
            int n3 = this.xOfP(dArray2);
            int n4 = this.yOfP(dArray2);
            int n5 = this.xOfP(dArray3);
            int n6 = this.yOfP(dArray3);
            boolean bl2 = bl = n3 > 0 && n3 < this.width && n4 > 0 && n4 < this.height || n5 > 0 && n5 < this.width && n6 > 0 && n6 < this.height;
            if (!bl) {
                double d = (double)n4 - (double)(n3 * (n6 - n4)) / (double)(n5 - n3);
                double d2 = (double)n4 + (double)((this.width - n3) * (n6 - n4)) / (double)(n5 - n3);
                boolean bl3 = bl = d > 0.0 && d < (double)this.height || d2 > 0.0 && d2 < (double)this.height;
            }
            if (bl = true) {
                graphics.drawLine(n3, this.height - n4, n5, this.height - n6);
            }
            ++n2;
        }
    }

    public void drawCube(Graphics graphics) {
        double d = (this.yTop - this.yBottom) / 2.0;
        if (d < 0.0) {
            d = -1.0 * d;
        }
        this.edgeC.offsetScaledDraw(graphics, this, d, this.cen3);
    }

    public void drawLineList9(Graphics graphics, double[][] dArray) {
        int n = this.lineColors.length;
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            boolean bl;
            int n4;
            dArray2[0] = dArray[n3][0];
            dArray2[1] = dArray[n3][1];
            dArray2[2] = dArray[n3][2];
            dArray3[0] = dArray[n3][4];
            dArray3[1] = dArray[n3][5];
            dArray3[2] = dArray[n3][6];
            if (dArray[n3][8] >= 0.0) {
                graphics.setColor(Color.yellow);
            } else if (dArray[n3][9] > 1.0) {
                n4 = (int)dArray[n3][9];
                if (n4 >= n) {
                    n4 = n - 1;
                }
                graphics.setColor(this.lineColors[n4]);
            } else {
                graphics.setColor(this.fgColor);
            }
            n4 = this.xOfP(dArray2);
            int n5 = this.yOfP(dArray2);
            int n6 = this.xOfP(dArray3);
            int n7 = this.yOfP(dArray3);
            boolean bl2 = bl = n4 > 0 && n4 < this.width && n5 > 0 && n5 < this.height || n6 > 0 && n6 < this.width && n7 > 0 && n7 < this.height;
            if (bl) {
                graphics.drawLine(n4, this.height - n5, n6, this.height - n7);
            }
            ++n3;
        }
    }

    public void drawAreaLineList9(Graphics graphics, double[][] dArray, Color color) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double d = (this.xRight - this.xLeft) / (double)(this.width - this.rightMargin - this.leftMargin);
        if (color != null) {
            graphics.setColor(color);
        }
        int n = dArray.length;
        int n2 = this.lineColors.length;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            dArray2[0] = dArray[n3][0];
            dArray2[1] = dArray[n3][1];
            dArray2[2] = dArray[n3][2];
            dArray3[0] = dArray[n3][4];
            dArray3[1] = dArray[n3][5];
            dArray3[2] = dArray[n3][6];
            if (color == null) {
                if (dArray[n3][8] >= 0.0) {
                    graphics.setColor(Color.yellow);
                } else if (dArray[n3][9] > 1.0) {
                    n4 = (int)dArray[n3][9];
                    if (n4 >= n2) {
                        n4 = n2 - 1;
                    }
                    graphics.setColor(this.lineColors[n4]);
                } else {
                    graphics.setColor(this.fgColor);
                }
            }
            n4 = this.xOfP(dArray2);
            int n5 = this.yOfP(dArray2);
            int n6 = this.xOfP(dArray3);
            int n7 = this.yOfP(dArray3);
            boolean bl = n4 > 0 && n4 < this.width && n5 > 0 && n5 < this.height || n6 > 0 && n6 < this.width && n7 > 0 && n7 < this.height;
            double d2 = dArray[n3][3];
            double d3 = dArray[n3][7];
            double d4 = 0.5 * (dArray[n3][3] + dArray[n3][7]);
            if (bl) {
                if (d4 < 0.75 * d) {
                    graphics.drawLine(n4, this.height - n5, n6, this.height - n7);
                } else {
                    double d5 = Math.sqrt((n7 - n5) * (n7 - n5) + (n6 - n4) * (n6 - n4));
                    double d6 = -d2 / d * (double)(n7 - n5) / d5;
                    double d7 = d2 / d * (double)(n6 - n4) / d5;
                    double d8 = -d3 / d * (double)(n7 - n5) / d5;
                    double d9 = d3 / d * (double)(n6 - n4) / d5;
                    nArray[0] = (int)((double)n4 - d6);
                    nArray[1] = (int)((double)n4 + d6);
                    nArray[2] = (int)((double)n6 + d8);
                    nArray[3] = (int)((double)n6 - d8);
                    nArray2[0] = this.height - (int)((double)n5 - d7);
                    nArray2[1] = this.height - (int)((double)n5 + d7);
                    nArray2[2] = this.height - (int)((double)n7 + d9);
                    nArray2[3] = this.height - (int)((double)n7 - d9);
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
            ++n3;
        }
    }

    public void drawRadiusLineList9(Graphics graphics, double[][] dArray, Color color) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double d = (this.xRight - this.xLeft) / (double)(this.width - this.rightMargin - this.leftMargin);
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            dArray2[0] = dArray[n2][0];
            dArray2[1] = dArray[n2][1];
            dArray2[2] = dArray[n2][2];
            dArray3[0] = dArray[n2][4];
            dArray3[1] = dArray[n2][5];
            dArray3[2] = dArray[n2][6];
            if (color == null) {
                if (dArray[n2][8] >= 0.0) {
                    graphics.setColor(Color.yellow);
                } else if (dArray[n2][9] > 0.0) {
                    if ((int)dArray[n2][9] == 1) {
                        graphics.setColor(Color.magenta);
                    } else if ((int)dArray[n2][9] == 2) {
                        graphics.setColor(Color.cyan);
                    }
                } else {
                    graphics.setColor(this.fgColor);
                }
            } else {
                graphics.setColor(color);
            }
            int n3 = this.xOfP(dArray2);
            int n4 = this.yOfP(dArray2);
            int n5 = this.xOfP(dArray3);
            int n6 = this.yOfP(dArray3);
            boolean bl = n3 > 0 && n3 < this.width && n4 > 0 && n4 < this.height || n5 > 0 && n5 < this.width && n6 > 0 && n6 < this.height;
            double d2 = dArray[n2][3];
            double d3 = dArray[n2][7];
            double d4 = 0.5 * (d2 + d3);
            if (bl) {
                int n7 = (n6 - n4) / 6;
                int n8 = (n5 - n3) / 6;
                graphics.drawLine(n3, this.height - n4, n3 + n8, this.height - (n4 + n7));
                graphics.drawLine(n5, this.height - n6, n5 - n8, this.height - (n6 - n7));
                double d5 = Math.sqrt((n6 - n4) * (n6 - n4) + (n5 - n3) * (n5 - n3));
                int n9 = (int)(-d2 / d * (double)(n6 - n4) / d5);
                int n10 = (int)(d2 / d * (double)(n5 - n3) / d5);
                int n11 = (int)(-d3 / d * (double)(n6 - n4) / d5);
                int n12 = (int)(d3 / d * (double)(n5 - n3) / d5);
                graphics.drawLine(n3 - n9, this.height - n4 + n10, n3 + n9, this.height - n4 - n10);
                graphics.drawLine(n5 - n11, this.height - n6 + n12, n5 + n11, this.height - n6 - n12);
                graphics.drawLine(n3 - n9, this.height - n4 + n10, n5 - n11, this.height - n6 + n12);
                graphics.drawLine(n3 + n9, this.height - n4 - n10, n5 + n11, this.height - n6 - n12);
            }
            ++n2;
        }
    }

    public void drawBlockLineList(Graphics graphics, double[][] dArray) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double d = (this.xRight - this.xLeft) / (double)(this.width - this.rightMargin - this.leftMargin);
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            dArray2[0] = dArray[n2][0];
            dArray2[1] = dArray[n2][1];
            dArray2[2] = dArray[n2][2];
            dArray3[0] = dArray[n2][4];
            dArray3[1] = dArray[n2][5];
            dArray3[2] = dArray[n2][6];
            int n4 = this.xOfP(dArray2);
            int n5 = this.yOfP(dArray2);
            int n6 = this.xOfP(dArray3);
            int n7 = this.yOfP(dArray3);
            double d2 = dArray[n2][3];
            double d3 = dArray[n2][7];
            double d4 = 0.5 * (d2 + d3);
            graphics.drawLine(n4, this.height - n5, n6, this.height - n7);
            double d5 = Math.sqrt((n7 - n5) * (n7 - n5) + (n6 - n4) * (n6 - n4));
            int n8 = (int)(-d2 / d * (double)(n7 - n5) / d5);
            int n9 = (int)(d2 / d * (double)(n6 - n4) / d5);
            int n10 = (int)(-d3 / d * (double)(n7 - n5) / d5);
            int n11 = (int)(d3 / d * (double)(n6 - n4) / d5);
            graphics.drawLine(n4 - n8, this.height - n5 + n9, n4 + n8, this.height - n5 - n9);
            graphics.drawLine(n6 - n10, this.height - n7 + n11, n6 + n10, this.height - n7 - n11);
            graphics.drawLine(n4 - n8, this.height - n5 + n9, n6 - n10, this.height - n7 + n11);
            graphics.drawLine(n4 + n8, this.height - n5 - n9, n6 + n10, this.height - n7 - n11);
            int n12 = n3 = (int)(d2 / d);
            graphics.drawOval(n4 - n3, this.height - n5 - n12, 2 * n3, 2 * n12);
            n12 = n3 = (int)(d3 / d);
            graphics.drawOval(n6 - n3, this.height - n7 - n12, 2 * n3, 2 * n12);
            ++n2;
        }
    }

    public void setScale(double d, double d2, double d3) {
        this.xScale = d;
        this.yScale = d2;
        this.zScale = d3;
    }

    public void drawRedGreenLineList9(Graphics graphics, double[][] dArray, double d) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            dArray2[0] = dArray[n2][0];
            dArray2[1] = dArray[n2][1];
            dArray2[2] = dArray[n2][2];
            dArray3[0] = dArray[n2][4];
            dArray3[1] = dArray[n2][5];
            dArray3[2] = dArray[n2][6];
            graphics.setColor(dArray[n2][8] >= 0.0 ? Color.yellow : this.fgColor);
            int n3 = this.xOfP(dArray2);
            int n4 = this.yOfP(dArray2);
            int n5 = this.zOfP(dArray2);
            int n6 = this.xOfP(dArray3);
            int n7 = this.yOfP(dArray3);
            int n8 = this.zOfP(dArray3);
            int n9 = (int)(d * (double)n5);
            int n10 = (int)(d * (double)n8);
            boolean bl2 = bl = n3 > 0 && n3 < this.width && n4 > 0 && n4 < this.height || n6 > 0 && n6 < this.width && n7 > 0 && n7 < this.height;
            if (bl) {
                graphics.setColor(Color.red);
                graphics.drawLine(n3 + n9, this.height - n4, n6 + n10, this.height - n7);
                graphics.setColor(Color.green);
                graphics.drawLine(n3, this.height - n4, n6, this.height - n7);
            }
            ++n2;
        }
    }

    public void drawRedGreenLineList2(Graphics graphics, Graphics graphics2, double[][] dArray, double d) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            dArray2[0] = dArray[n2][0];
            dArray2[1] = dArray[n2][1];
            dArray2[2] = dArray[n2][2];
            dArray3[0] = dArray[n2][4];
            dArray3[1] = dArray[n2][5];
            dArray3[2] = dArray[n2][6];
            int n3 = this.xOfP(dArray2);
            int n4 = this.yOfP(dArray2);
            int n5 = this.zOfP(dArray2);
            int n6 = this.xOfP(dArray3);
            int n7 = this.yOfP(dArray3);
            int n8 = this.zOfP(dArray3);
            int n9 = (int)(d * (double)n5);
            int n10 = (int)(d * (double)n8);
            boolean bl2 = bl = n3 > 0 && n3 < this.width && n4 > 0 && n4 < this.height || n6 > 0 && n6 < this.width && n7 > 0 && n7 < this.height;
            if (bl) {
                graphics.drawLine(n3 + n9, this.height - n4, n6 + n10, this.height - n7);
                graphics2.drawLine(n3, this.height - n4, n6, this.height - n7);
            }
            ++n2;
        }
    }

    public void drawAreaRedGreenLineList92(Graphics graphics, Graphics graphics2, double[][] dArray, double d) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        double d2 = (this.xRight - this.xLeft) / (double)(this.width - this.rightMargin - this.leftMargin);
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            dArray2[0] = dArray[n2][0];
            dArray2[1] = dArray[n2][1];
            dArray2[2] = dArray[n2][2];
            dArray3[0] = dArray[n2][4];
            dArray3[1] = dArray[n2][5];
            dArray3[2] = dArray[n2][6];
            int n3 = this.xOfP(dArray2);
            int n4 = this.yOfP(dArray2);
            int n5 = this.zOfP(dArray2);
            int n6 = this.xOfP(dArray3);
            int n7 = this.yOfP(dArray3);
            int n8 = this.zOfP(dArray3);
            int n9 = (int)(d * (double)n5);
            int n10 = (int)(d * (double)n8);
            boolean bl2 = bl = n3 > 0 && n3 < this.width && n4 > 0 && n4 < this.height || n6 > 0 && n6 < this.width && n7 > 0 && n7 < this.height;
            if (bl) {
                double d3 = 0.5 * (dArray[n2][3] + dArray[n2][7]);
                if (d3 < 0.75 * d2) {
                    graphics.drawLine(n3 + n9, this.height - n4, n6 + n10, this.height - n7);
                    graphics2.drawLine(n3, this.height - n4, n6, this.height - n7);
                } else {
                    double d4 = Math.sqrt((n7 - n4) * (n7 - n4) + (n6 - n3) * (n6 - n3));
                    double d5 = -d3 / d2 * (double)(n7 - n4) / d4;
                    double d6 = d3 / d2 * (double)(n6 - n3) / d4;
                    nArray[0] = (int)((double)(n3 + n9) - d5);
                    nArray[1] = (int)((double)(n3 + n9) + d5);
                    nArray[2] = (int)((double)(n6 + n10) + d5);
                    nArray[3] = (int)((double)(n6 + n10) - d5);
                    nArray2[0] = this.height - (int)((double)n4 - d6);
                    nArray2[1] = this.height - (int)((double)n4 + d6);
                    nArray2[2] = this.height - (int)((double)n7 + d6);
                    nArray2[3] = this.height - (int)((double)n7 - d6);
                    graphics.fillPolygon(nArray, nArray2, 4);
                    nArray[0] = (int)((double)n3 - d5);
                    nArray[1] = (int)((double)n3 + d5);
                    nArray[2] = (int)((double)n6 + d5);
                    nArray[3] = (int)((double)n6 - d5);
                    graphics2.fillPolygon(nArray, nArray2, 4);
                }
            }
            ++n2;
        }
    }

    public void drawAreaRedGreenLineList9(Graphics graphics, double[][] dArray, double d) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            dArray2[0] = dArray[n2][0];
            dArray2[1] = dArray[n2][1];
            dArray2[2] = dArray[n2][2];
            dArray3[0] = dArray[n2][4];
            dArray3[1] = dArray[n2][5];
            dArray3[2] = dArray[n2][6];
            graphics.setColor(dArray[n2][8] >= 0.0 ? Color.yellow : this.fgColor);
            int n3 = this.xOfP(dArray2);
            int n4 = this.yOfP(dArray2);
            int n5 = this.zOfP(dArray2);
            int n6 = this.xOfP(dArray3);
            int n7 = this.yOfP(dArray3);
            int n8 = this.zOfP(dArray3);
            int n9 = (int)(d * (double)n5);
            int n10 = (int)(d * (double)n8);
            boolean bl2 = bl = n3 > 0 && n3 < this.width && n4 > 0 && n4 < this.height || n6 > 0 && n6 < this.width && n7 > 0 && n7 < this.height;
            if (bl) {
                graphics.setColor(Color.red);
                graphics.drawLine(n3 + n9, this.height - n4, n6 + n10, this.height - n7);
                graphics.setColor(Color.green);
                graphics.drawLine(n3, this.height - n4, n6, this.height - n7);
            }
            ++n2;
        }
    }

    public void drawPointList(Graphics graphics, double[][] dArray) {
        double[] dArray2 = new double[3];
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.xOfP(dArray[n2]);
            int n4 = this.yOfP(dArray[n2]);
            graphics.setColor(dArray[n2][4] <= 0.0 ? Color.blue : (dArray[n2][4] == 2.0 ? Color.green : Color.cyan));
            if (n3 > 0 && n3 < this.width && n4 > 0 && n4 < this.height) {
                graphics.fillOval(n3 - 3, this.height - n4 - 3, 7, 7);
            }
            ++n2;
        }
    }

    public void rotate3init(int n, int n2) {
        double[] dArray = new double[]{n - this.x3c, n2 - this.y3c, this.zcen - this.z3c};
        double[] dArray2 = this.rotInv(dArray);
        this.cen3[0] = this.cen3[0] + dArray2[0];
        this.cen3[1] = this.cen3[1] + dArray2[1];
        this.cen3[2] = this.cen3[2] + dArray2[2];
        this.x3c = n;
        this.y3c = n2;
        this.z3c = this.zcen;
        int n3 = 0;
        while (n3 < 3) {
            int n4 = 0;
            while (n4 < 3) {
                this.m3sav[n3][n4] = this.m3[n3][n4];
                ++n4;
            }
            ++n3;
        }
        this.initialisedRotation = true;
    }

    public void unsetRotInit() {
        this.initialisedRotation = false;
    }

    public void rotateXY(double d, double d2) {
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d2);
        this.m3[0][0] = d5 * this.m3sav[0][0] - d4 * d6 * this.m3sav[1][0] + d3 * d6 * this.m3sav[2][0];
        this.m3[0][1] = d5 * this.m3sav[0][1] - d4 * d6 * this.m3sav[1][1] + d3 * d6 * this.m3sav[2][1];
        this.m3[0][2] = d5 * this.m3sav[0][2] - d4 * d6 * this.m3sav[1][2] + d3 * d6 * this.m3sav[2][2];
        this.m3[1][0] = 0.0 * this.m3sav[0][0] + d3 * this.m3sav[1][0] + d4 * this.m3sav[2][0];
        this.m3[1][1] = 0.0 * this.m3sav[0][1] + d3 * this.m3sav[1][1] + d4 * this.m3sav[2][1];
        this.m3[1][2] = 0.0 * this.m3sav[0][2] + d3 * this.m3sav[1][2] + d4 * this.m3sav[2][2];
        this.m3[2][0] = -d6 * this.m3sav[0][0] - d4 * d5 * this.m3sav[1][0] + d3 * d5 * this.m3sav[2][0];
        this.m3[2][1] = -d6 * this.m3sav[0][1] - d4 * d5 * this.m3sav[1][1] + d3 * d5 * this.m3sav[2][1];
        this.m3[2][2] = -d6 * this.m3sav[0][2] - d4 * d5 * this.m3sav[1][2] + d3 * d5 * this.m3sav[2][2];
    }

    public void axisRotate(double d, double d2, double[][] dArray, double[][] dArray2) {
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d2);
        int n = 0;
        while (n < 3) {
            dArray2[0][n] = (d3 * d3 + d4 * d5 * d4) * dArray[0][n] + (d3 * d4 - d4 * d5 * d3) * dArray[1][n] + -d6 * d4 * dArray[2][n];
            dArray2[1][n] = (d4 * d3 - d3 * d5 * d4) * dArray[0][n] + (d4 * d4 + d3 * d5 * d3) * dArray[1][n] + d3 * d6 * dArray[2][n];
            dArray2[2][n] = d6 * d4 * dArray[0][n] + -d6 * d3 * dArray[1][n] + d5 * dArray[2][n];
            ++n;
        }
    }

    public void zRotate(double d, double[][] dArray, double[][] dArray2) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 0;
        while (n < 3) {
            dArray2[0][n] = d2 * dArray[0][n] + d3 * dArray[1][n];
            dArray2[1][n] = -d3 * dArray[0][n] + d2 * dArray[1][n];
            dArray2[2][n] = dArray[2][n];
            ++n;
        }
    }

    public void dragRotate(int n, int n2, int n3, int n4, boolean bl) {
        double d;
        double d2;
        double d3 = 3.14159;
        if (!this.initialisedRotation) {
            this.xcen = this.leftMargin + (this.width - this.leftMargin - this.rightMargin) / 2;
            this.ycen = this.bottomMargin + (this.height - this.topMargin - this.bottomMargin) / 2;
            this.rotate3init(this.xcen, this.ycen);
            d2 = n3 - this.xcen;
            d = n4 - this.ycen;
            this.thax0 = Math.atan2(d2, -d);
            this.r0 = Math.sqrt(d2 * d2 + d * d) / (double)this.width;
            this.r0 = d3 * (1.0 / (1.0 + Math.exp(6.0 * this.r0)) - 0.5);
        }
        d2 = n3 - this.xcen;
        d = n4 - this.ycen;
        this.thax1 = Math.atan2(d2, -d);
        this.r1 = Math.sqrt(d2 * d2 + d * d) / (double)this.width;
        this.r1 = d3 * (1.0 / (1.0 + Math.exp(6.0 * this.r1)) - 0.5);
        if (bl) {
            this.axisRotate(this.thax0 + d3, this.r0, this.m3sav, this.m3t);
            this.axisRotate(this.thax1, this.r1, this.m3t, this.m3);
            return;
        }
        this.zRotate(-Math.atan2(n - this.xcen, n2 - this.ycen), this.m3sav, this.m3t);
        this.zRotate(Math.atan2(d2, d), this.m3t, this.m3);
    }

    public void panZoom(int n, int n2, int n3, int n4, boolean bl) {
        if (Math.abs(n3 - n) + Math.abs(n4 - n2) > 5) {
            this.x3c += n3 - n;
            this.y3c += n4 - n2;
        } else {
            this.fixZoom(n3, n4, bl ? 0.6666666666666666 : 1.5);
        }
        this.pixelSet();
    }

    public void fixZoom(int n, int n2, double d) {
        if (n2 < this.height - this.topMargin && n < this.width - this.rightMargin) {
            double[] dArray = new double[]{n - this.x3c, n2 - this.y3c, this.zcen - this.z3c};
            double[] dArray2 = this.rotInv(dArray);
            this.cen3[0] = this.cen3[0] + dArray2[0];
            this.cen3[1] = this.cen3[1] + dArray2[1];
            this.cen3[2] = this.cen3[2] + dArray2[2];
            this.x3c = n;
            this.y3c = n2;
            this.z3c = this.zcen;
            if (n >= this.leftMargin && n2 >= this.bottomMargin) {
                int n3 = 0;
                while (n3 < 3) {
                    int n4 = 0;
                    while (n4 < 3) {
                        double[] dArray3 = this.m3[n3];
                        int n5 = n4++;
                        dArray3[n5] = dArray3[n5] * d;
                    }
                    ++n3;
                }
            }
        }
        if (n2 > this.height - this.topMargin) {
            this.tickGridx += d < 1.0 ? -1 : 1;
        }
        if (n > this.width - this.rightMargin) {
            this.tickGridy += d < 1.0 ? -1 : 1;
        }
    }

    public void setRange(double d, double d2, double d3, double d4) {
        int n;
        this.cen3[0] = 0.5 * (d + d2);
        this.cen3[1] = 0.5 * (d3 + d4);
        this.cen3[2] = 0.0;
        this.x3c = this.width / 2;
        this.y3c = this.height / 2;
        this.z3c = 0;
        double[] dArray = new double[]{d2, d4, 0.0};
        int n2 = 0;
        while (n2 < 3) {
            n = 0;
            while (n < 3) {
                this.m3[n2][n] = 0.0;
                ++n;
            }
            this.m3[n2][n2] = 1.0;
            ++n2;
        }
        n = this.xOfP(dArray);
        int n3 = this.yOfP(dArray);
        double d5 = 1.0 + Math.sqrt((n - this.width / 2) * (n - this.width / 2) + (n3 - this.height / 2) * (n3 - this.height / 2));
        double d6 = Math.sqrt(this.width * this.width / 4 + this.height * this.height / 4);
        double d7 = d6 / d5;
        int n4 = 0;
        while (n4 < 3) {
            int n5 = 0;
            while (n5 < 3) {
                double[] dArray2 = this.m3[n4];
                int n6 = n5++;
                dArray2[n6] = dArray2[n6] * d7;
            }
            ++n4;
        }
        this.pixelSet();
    }

    public void setZorigin(double[] dArray) {
        this.zcen = this.zOfP(dArray);
    }

    public void pixelSet() {
        double[] dArray = new double[]{this.leftMargin - this.x3c, this.bottomMargin - this.y3c, this.zcen - this.z3c};
        double[] dArray2 = this.rotInv(dArray);
        dArray[0] = this.width - this.rightMargin - this.x3c;
        dArray[1] = this.bottomMargin - this.y3c;
        dArray[2] = this.zcen - this.z3c;
        double[] dArray3 = this.rotInv(dArray);
        dArray[0] = this.leftMargin - this.x3c;
        dArray[1] = this.height - this.topMargin - this.y3c;
        dArray[2] = this.zcen - this.z3c;
        double[] dArray4 = this.rotInv(dArray);
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < 3) {
            d += (dArray3[n] - dArray2[n]) * (dArray3[n] - dArray2[n]);
            d2 += (dArray4[n] - dArray2[n]) * (dArray4[n] - dArray2[n]);
            ++n;
        }
        d = Math.sqrt(d);
        d2 = Math.sqrt(d2);
        dArray[0] = 0.0;
        dArray[1] = 0.0;
        dArray[2] = 0.0;
        int n2 = this.xOfP(dArray);
        int n3 = this.yOfP(dArray);
        this.xRight = d * (double)(this.width - this.rightMargin - n2) / (double)(this.width - this.rightMargin - this.leftMargin);
        this.xLeft = this.xRight - d;
        this.yTop = d2 * (double)(this.height - this.topMargin - n3) / (double)(this.height - this.topMargin - this.bottomMargin);
        this.yBottom = this.yTop - d2;
        this.dpdx = (double)(this.width - this.leftMargin - this.rightMargin) / (this.xRight - this.xLeft);
        this.dpdy = (double)(this.height - this.topMargin - this.bottomMargin) / (this.yTop - this.yBottom);
    }

    public double[] rotInv(double[] dArray) {
        double[] dArray2 = new double[3];
        double d = this.m3[0][0] * (this.m3[1][1] * this.m3[2][2] - this.m3[2][1] * this.m3[1][2]) - this.m3[0][1] * (this.m3[1][0] * this.m3[2][2] - this.m3[2][0] * this.m3[1][2]) + this.m3[0][2] * (this.m3[1][0] * this.m3[2][1] - this.m3[2][0] * this.m3[1][1]);
        dArray2[0] = (this.m3[0][1] * (this.m3[1][2] * dArray[2] - this.m3[2][2] * dArray[1]) - this.m3[0][2] * (this.m3[1][1] * dArray[2] - this.m3[2][1] * dArray[1]) + dArray[0] * (this.m3[1][1] * this.m3[2][2] - this.m3[2][1] * this.m3[1][2])) / d;
        dArray2[1] = -(this.m3[0][0] * (this.m3[1][2] * dArray[2] - this.m3[2][2] * dArray[1]) - this.m3[0][2] * (this.m3[1][0] * dArray[2] - this.m3[2][0] * dArray[1]) + dArray[0] * (this.m3[1][0] * this.m3[2][2] - this.m3[2][0] * this.m3[1][2])) / d;
        dArray2[2] = (this.m3[0][0] * (this.m3[1][1] * dArray[2] - this.m3[2][1] * dArray[1]) - this.m3[0][1] * (this.m3[1][0] * dArray[2] - this.m3[2][0] * dArray[1]) + dArray[0] * (this.m3[1][0] * this.m3[2][1] - this.m3[2][0] * this.m3[1][1])) / d;
        double[] dArray3 = new double[3];
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                int n3 = n;
                dArray3[n3] = dArray3[n3] + this.m3[n][n2] * dArray2[n2];
                ++n2;
            }
            ++n;
        }
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < 3) {
            d2 += (dArray[n4] - dArray3[n4]) * (dArray[n4] - dArray3[n4]);
            ++n4;
        }
        if (d2 > 1.0E-4) {
            System.out.println("Error inv arg: " + dArray[0] + " " + dArray[1] + " " + dArray[2]);
            System.out.println("inv res: " + dArray2[0] + " " + dArray2[1] + " " + dArray2[2]);
            System.out.println("inv m*res: " + dArray3[0] + " " + dArray3[1] + " " + dArray3[2]);
        }
        return dArray2;
    }

    public double[] worldToPixel3(double[] dArray) {
        double[] dArray2 = new double[]{this.xOfP(dArray), this.yOfP(dArray), this.zOfP(dArray)};
        return dArray2;
    }

    public double[] pixel3ToWorld(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0] - (double)this.x3c, dArray[1] - (double)this.y3c, dArray[2] - (double)this.z3c};
        double[] dArray3 = this.rotInv(dArray2);
        dArray3[0] = dArray3[0] / this.xScale + this.cen3[0];
        dArray3[1] = dArray3[1] / this.yScale + this.cen3[1];
        dArray3[2] = dArray3[2] / this.zScale + this.cen3[2];
        return dArray3;
    }
}

