/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class neuronEditorCanvas
extends graphCanvas3
implements ActionListener {
    neulucData cell;
    static int TRACE = 1;
    static int CUT = 2;
    static int JOIN = 3;
    static int REMOVENODE = 4;
    static int ADDNODE = 5;
    static int MARKSECTION = 6;
    static int HIGHLIGHTSECTION = 7;
    static int HIGHLIGHTTREE = 8;
    static int HIGHLIGHTPOINTS = 9;
    static int MERGE = 10;
    static int IDENT = 11;
    String[] gotPointActionStrings = new String[]{" ", "click the point to trace from", "click ends of segment to cut", "click the two points to be joined", "click node(s) to be deleted", "click ends of segment in which to add node", "select ends of section", "select ends of section", "select two points on base of tree, lower first", "click desired points", "click point to be removed and then its replacement", "click dummy point and then the point to identify it with"};
    String[] growModeInstructions = new String[]{"press mouse on a node and drag (holding button down)", "left button - new point", "middle or left + shift key - move point", "right button - change radius"};
    int gotPointAction;
    boolean showPoints = false;
    boolean showOutlines = false;
    static int SREDGREEN = 1;
    static int SPROJECTION = 2;
    static int AREDGREEN = 3;
    static int APROJECTION = 4;
    static int SOLIDBLUE = 5;
    int view = 2;
    int lastView = 2;
    static int BRANCHDRAG = 20;
    static int POINTDRAG = 21;
    int dragPoint;
    double[] dragOrig;
    double[] cdp;
    int[] pmark;
    boolean gotMarks = false;
    Image imred;
    Image imgreen;
    int imrgw;
    int imrgh;
    Graphics gr;
    Graphics gg;
    int[] bufred;
    int[] bufgreen;
    Image imageRG;
    boolean revvid = true;
    boolean growMode = false;
    boolean freeAdd = false;
    double[][] prevLines;
    double[][] newLines;
    double[] growpt;

    neuronEditorCanvas(int n, int n2, graphData3 graphData32) {
        super(n, n2, graphData32);
        this.setSize(n, n2);
        this.cdp = new double[3];
        this.pmark = new int[2];
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("neucan action event?");
    }

    public void reverseVideo() {
        this.revvid = !this.revvid;
        this.repaint();
    }

    public void setData(neulucData neulucData2) {
        this.cell = neulucData2;
        this.repaint();
    }

    public void setView(int n) {
        this.view = n;
        this.lastView = n;
        this.repaint();
    }

    public void find() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.lineList != null) {
            int n = this.lineList.length;
            int n2 = 0;
            while (n2 < n) {
                double[] dArray = this.lineList[n2];
                if (d4 > dArray[0]) {
                    d4 = dArray[0];
                }
                if (d2 < dArray[0]) {
                    d2 = dArray[0];
                }
                if (d3 > dArray[1]) {
                    d3 = dArray[1];
                }
                if (d < dArray[1]) {
                    d = dArray[1];
                }
                ++n2;
            }
        }
        this.gd.setRange(d4 - 20.0, d2 + 20.0, d3 - 20.0, d + 20.0);
        this.repaint();
    }

    public void myPaint(Graphics graphics) {
        if (this.cell != null) {
            this.lineList = this.cell.getLineList();
            this.pointList = this.cell.getPointList();
        }
        if (this.lineList != null) {
            Dimension dimension;
            this.gd.setScale(this.xScale.value(), this.yScale.value(), this.zScale.value());
            if (this.view == SPROJECTION) {
                this.gd.drawLineList9(graphics, this.lineList);
            } else if (this.view == SREDGREEN) {
                dimension = this.getSize();
                if (this.imred == null || this.imrgw != dimension.width || this.imrgh != dimension.height) {
                    this.imrgw = dimension.width;
                    this.imrgh = dimension.height;
                    if (this.imrgw > 0 && this.imrgh > 0) {
                        this.imred = this.createImage(this.imrgw, this.imrgh);
                        this.imgreen = this.createImage(this.imrgw, this.imrgh);
                    }
                }
                if (this.imred != null && this.imgreen != null) {
                    this.gr = this.imred.getGraphics();
                    this.gg = this.imgreen.getGraphics();
                    this.gr.setColor(this.revvid ? Color.white : Color.black);
                    this.gg.setColor(this.revvid ? Color.white : Color.black);
                    this.gr.fillRect(0, 0, this.imrgw, this.imrgh);
                    this.gg.fillRect(0, 0, this.imrgw, this.imrgh);
                    this.gr.setColor(this.revvid ? Color.magenta : Color.red);
                    this.gg.setColor(this.revvid ? Color.cyan : Color.green);
                    this.gd.drawRedGreenLineList2(this.gr, this.gg, this.lineList, this.zCursor.value());
                    graphics.setPaintMode();
                    graphics.drawImage(this.imred, 0, 0, this);
                    graphics.setColor(this.revvid ? Color.white : Color.white);
                    graphics.setXORMode(this.revvid ? Color.white : Color.black);
                    graphics.drawImage(this.imgreen, 0, 0, this);
                }
            } else if (this.view == AREDGREEN) {
                dimension = this.getSize();
                if (this.imred == null || this.imrgw != dimension.width || this.imrgh != dimension.height) {
                    this.imrgw = dimension.width;
                    this.imrgh = dimension.height;
                    if (this.imrgw > 0 && this.imrgh > 0) {
                        this.imred = this.createImage(this.imrgw, this.imrgh);
                        this.imgreen = this.createImage(this.imrgw, this.imrgh);
                    }
                }
                if (this.imred != null && this.imgreen != null) {
                    this.gr = this.imred.getGraphics();
                    this.gg = this.imgreen.getGraphics();
                    this.gr.setColor(this.revvid ? Color.white : Color.black);
                    this.gg.setColor(this.revvid ? Color.white : Color.black);
                    this.gr.fillRect(0, 0, this.imrgw, this.imrgh);
                    this.gg.fillRect(0, 0, this.imrgw, this.imrgh);
                    this.gr.setColor(this.revvid ? Color.magenta : Color.red);
                    this.gg.setColor(this.revvid ? Color.cyan : Color.green);
                    this.gd.drawAreaRedGreenLineList92(this.gr, this.gg, this.lineList, this.zCursor.value());
                    graphics.setPaintMode();
                    graphics.drawImage(this.imred, 0, 0, this);
                    graphics.setColor(this.revvid ? Color.white : Color.white);
                    graphics.setXORMode(this.revvid ? Color.white : Color.black);
                    graphics.drawImage(this.imgreen, 0, 0, this);
                }
            } else if (this.view == APROJECTION) {
                this.gd.drawAreaLineList9(graphics, this.lineList, null);
            } else if (this.view == SOLIDBLUE) {
                this.gd.drawAreaLineList9(graphics, this.lineList, Color.blue);
            }
            if (this.showOutlines) {
                this.gd.drawRadiusLineList9(graphics, this.lineList, Color.yellow);
            }
        }
        if ((this.view == SPROJECTION || this.view == APROJECTION) && this.pointList != null && this.showPoints) {
            this.gd.drawPointList(graphics, this.pointList);
        }
        graphics.setColor(Color.cyan);
        if (this.gotPointAction >= 0) {
            graphics.drawString(this.gotPointActionStrings[this.gotPointAction], 10, 35);
            return;
        }
        if (this.growMode) {
            int n = 0;
            while (n < this.growModeInstructions.length) {
                graphics.drawString(this.growModeInstructions[n], 10, 35 + 13 * n);
                if (this.newLines != null) {
                    graphics.setColor(Color.cyan);
                    this.gd.drawBlockLineList(graphics, this.newLines);
                }
                ++n;
            }
        }
    }

    public void trace() {
        this.pointList = this.cell.getPointList();
        this.getOnePoint();
        this.gotPointAction = TRACE;
    }

    public void join() {
        this.pointList = this.cell.getPointList();
        this.getTwoPoints();
        this.gotPointAction = JOIN;
    }

    public void merge() {
        this.pointList = this.cell.getPointList();
        this.getTwoPoints();
        this.gotPointAction = MERGE;
    }

    public void ident() {
        this.pointList = this.cell.getPointList();
        this.getTwoPoints();
        this.gotPointAction = IDENT;
    }

    public void highlightSection() {
        this.pointList = this.cell.getPointList();
        this.getTwoPoints();
        this.gotPointAction = HIGHLIGHTSECTION;
    }

    public void highlightTree() {
        this.pointList = this.cell.getPointList();
        this.getTwoPoints();
        this.gotPointAction = HIGHLIGHTTREE;
    }

    public void cut() {
        this.pointList = this.cell.getPointList();
        this.getTwoPoints();
        this.gotPointAction = CUT;
    }

    public void grow() {
        this.setGrowMode();
        this.geomChange = true;
        this.repaint();
    }

    public void forceRepaint() {
        this.geomChange = true;
        this.repaint();
    }

    public void addFree() {
        this.setGrowMode();
        this.freeAdd = true;
        this.ignoreUp = true;
        this.repaint();
    }

    public void drag() {
        this.pointList = this.cell.getPointList();
        this.getOnePoint();
        this.gotPointAction = BRANCHDRAG;
    }

    public void addNode() {
        this.pointList = this.cell.getPointList();
        this.getTwoPoints();
        this.gotPointAction = ADDNODE;
    }

    public void removeNode() {
        this.pointList = this.cell.getPointList();
        this.getOnePoint();
        this.gotPointAction = REMOVENODE;
    }

    public void markPoint() {
        this.pointList = this.cell.getPointList();
        this.getOnePoint();
        this.gotPointAction = HIGHLIGHTPOINTS;
    }

    public void setRemoveMode() {
        this.removeNode();
    }

    public void showPoints() {
        this.showPoints = !this.showPoints;
        this.geomChange = true;
        if (this.growMode) {
            this.geomChange = true;
        }
        this.repaint();
    }

    public void showOutlines() {
        this.showOutlines = !this.showOutlines;
        this.geomChange = true;
        if (this.growMode) {
            this.geomChange = true;
        }
        this.repaint();
    }

    public void reallyShowPoints() {
        this.showPoints = true;
        this.repaint();
    }

    public void showLoops() {
        this.pointList = this.cell.getPointList();
        this.cell.showLoops();
        this.showPoints = false;
        this.repaint();
    }

    public void clear() {
        this.gotPointAction = -1;
        if (this.pointList != null) {
            this.echoMode = false;
            this.cell.clearTrace();
            this.repaint();
        }
    }

    public void cleanCell() {
        this.cell.clean();
        this.repaint();
    }

    public void setNormal() {
        this.restoreView();
        this.xorUpdate = false;
        this.clear();
        this.repaint();
    }

    public void restoreView() {
        this.view = this.lastView;
        this.growMode = false;
        this.echoMode = false;
    }

    public void setGrowMode() {
        this.dragMode = POINTDRAG;
        this.showOutlines = true;
        this.unsetPointGetting();
        this.gotPointAction = -1;
        this.echoMode = true;
        this.geomChange = true;
        this.makeEchoArray();
        this.growMode = true;
    }

    public void gotPoint(int[] nArray) {
        if (this.gotPointAction == TRACE) {
            this.cell.tracePoint(nArray[0]);
            this.trace();
            this.repaint();
            return;
        }
        if (this.gotPointAction == CUT) {
            this.cell.separatePoints(nArray[0], nArray[1]);
            this.repaint();
            return;
        }
        if (this.gotPointAction == JOIN) {
            this.cell.joinPoints(nArray[0], nArray[1]);
            this.cell.tracePoint(nArray[0]);
            this.join();
            this.repaint();
            return;
        }
        if (this.gotPointAction == MERGE) {
            this.cell.mergePoints(nArray[0], nArray[1]);
            this.merge();
            this.repaint();
            return;
        }
        if (this.gotPointAction == IDENT) {
            this.cell.identifyPoints(nArray[0], nArray[1]);
            this.ident();
            this.repaint();
            return;
        }
        if (this.gotPointAction == MARKSECTION) {
            this.pmark[0] = nArray[0];
            this.pmark[1] = nArray[1];
            this.gotMarks = true;
            this.repaint();
            return;
        }
        if (this.gotPointAction == HIGHLIGHTSECTION) {
            this.pmark[0] = nArray[0];
            this.pmark[1] = nArray[1];
            this.gotMarks = true;
            this.cell.highlightSection(nArray[0], nArray[1]);
            this.repaint();
            return;
        }
        if (this.gotPointAction == HIGHLIGHTTREE) {
            this.pmark[0] = nArray[0];
            this.pmark[1] = nArray[1];
            this.gotMarks = true;
            this.cell.highlightTree(nArray[0], nArray[1]);
            this.repaint();
            return;
        }
        if (this.gotPointAction == HIGHLIGHTPOINTS) {
            this.cell.highlightPoint(nArray[0]);
            this.repaint();
            this.markPoint();
            return;
        }
        if (this.gotPointAction == ADDNODE) {
            this.cell.addPoint(nArray[0], nArray[1]);
            this.repaint();
            return;
        }
        if (this.gotPointAction == REMOVENODE) {
            this.cell.removePoint(nArray[0]);
            this.repaint();
            this.removeNode();
            return;
        }
        if (this.gotPointAction == BRANCHDRAG) {
            this.dragPoint = nArray[0];
            this.cell.markShiftPoints(nArray[0]);
            this.dragMode = BRANCHDRAG;
            this.wantDrag = true;
            this.dragOrig = this.pointList[this.dragPoint];
            int n = 0;
            while (n < 3) {
                this.cdp[n] = 0.0;
                ++n;
            }
            this.cell.setShift(this.cdp);
            this.repaint();
        }
    }

    public void myXorUpdate(Graphics graphics) {
        int n = this.newLines.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 4) {
                this.newLines[n2][4 + n3] = this.growpt[n3];
                ++n3;
            }
            ++n2;
        }
        graphics.setColor(Color.green);
        if (this.newLines != null && this.newLines.length > 0) {
            this.gd.drawBlockLineList(graphics, this.newLines);
        } else {
            System.out.println("drawing nothing...?");
        }
        this.prevLines = this.newLines;
    }

    public boolean myMouseDown(int n, int n2) {
        if (this.growMode && this.downPoint >= 0) {
            this.xorUpdate = true;
            this.dragOrig = this.pointList[this.downPoint];
            this.growpt = new double[4];
            this.growpt[0] = this.dragOrig[0];
            this.growpt[1] = this.dragOrig[1];
            this.growpt[2] = this.dragOrig[2];
            this.growpt[3] = this.dragOrig[3];
            if (this.leftButton) {
                this.newLines = new double[1][8];
                int n3 = 0;
                while (n3 < 4) {
                    this.newLines[0][n3] = this.dragOrig[n3];
                    ++n3;
                }
            } else {
                this.newLines = this.cell.linesTo(this.downPoint);
            }
            this.repaint();
        } else if (this.freeAdd) {
            this.freeAdd = false;
            double[] dArray = new double[]{n, n2, 0.0};
            double[] dArray2 = this.gd.pixel3ToWorld(dArray);
            dArray[1] = n2 - 15;
            double[] dArray3 = this.gd.pixel3ToWorld(dArray);
            this.cell.addSegment(dArray2, dArray3);
            this.geomChange = true;
            this.repaint();
        }
        return true;
    }

    public boolean myMouseUp(int n, int n2) {
        this.freeAdd = false;
        if (this.growMode && this.downPoint >= 0 && this.growpt != null) {
            if (this.leftButton) {
                this.cell.addPoint(this.growpt, this.downPoint);
            } else if (this.middleButton) {
                this.cell.setPointPosition(this.growpt, this.downPoint);
            } else if (this.rightButton) {
                this.cell.setPointRadius(this.growpt, this.downPoint);
            }
        } else if (this.dragMode == BRANCHDRAG) {
            this.cell.imposeShift(this.cdp);
            this.wantDrag = false;
            this.dragMode = -1;
        }
        this.geomChange = true;
        this.xorUpdate = false;
        this.newLines = null;
        this.repaint();
        return true;
    }

    public boolean myMouseDrag(int n, int n2) {
        double d = n - this.xdown;
        double d2 = n2 - this.ydown;
        if (this.growMode && this.downPoint >= 0) {
            if (this.growpt == null) {
                System.out.println("error - dragging null point in grow mode");
            } else {
                double[] dArray = this.gd.worldToPixel3(this.dragOrig);
                dArray[0] = dArray[0] + d;
                dArray[1] = dArray[1] + d2;
                double[] dArray2 = this.gd.pixel3ToWorld(dArray);
                if (this.rightButton) {
                    this.growpt[3] = Math.sqrt((this.dragOrig[0] - dArray2[0]) * (this.dragOrig[0] - dArray2[0]) + (this.dragOrig[1] - dArray2[1]) * (this.dragOrig[1] - dArray2[1]) + (this.dragOrig[2] - dArray2[2]) * (this.dragOrig[2] - dArray2[2]));
                } else {
                    this.growpt[0] = dArray2[0];
                    this.growpt[1] = dArray2[1];
                    this.growpt[2] = dArray2[2];
                }
                this.repaint();
            }
        } else if (this.downPoint >= 0 && this.dragMode == BRANCHDRAG) {
            double[] dArray = this.gd.worldToPixel3(this.dragOrig);
            dArray[0] = dArray[0] + d;
            dArray[1] = dArray[1] + d2;
            double[] dArray3 = this.gd.pixel3ToWorld(dArray);
            int n3 = 0;
            while (n3 < 3) {
                this.cdp[n3] = dArray3[n3] - this.dragOrig[n3];
                ++n3;
            }
            this.cell.setShift(this.cdp);
            this.repaint();
        } else if (this.dragMode == POINTDRAG) {
            System.out.println("point drag with no point???");
        }
        return true;
    }
}

