/*
 * Decompiled with CFR 0.152.
 */
class nl3Object {
    static int AXON = 1;
    static int DENDRITE = 2;
    static int APICAL = 3;
    static int PROPERTY = 4;
    static int POINT = 5;
    static int CONTOUR = 6;
    static int LABEL = 7;
    static int ANON = 8;
    static int BRANCHSEP = 9;
    int itype = -1;
    double x = 0.0;
    double y = 0.0;
    double z = 0.0;
    double r = 0.0;
    int nno = 0;
    String qtxt;
    String txt;
    nl3Object[] obs;
    int nob;

    nl3Object() {
    }

    public void addText(String string) {
        if (this.txt == null) {
            this.txt = string;
            return;
        }
        this.txt = String.valueOf(this.txt) + " ";
        this.txt = String.valueOf(this.txt) + string;
    }

    public void addQtext(String string) {
        if (this.qtxt == null) {
            this.qtxt = string;
        } else {
            System.out.println("multiple quoted stings in nl3 object?? " + this.qtxt + " " + string);
            this.qtxt = String.valueOf(this.qtxt) + " ";
            this.qtxt = String.valueOf(this.qtxt) + string;
        }
        if (this.nob == 0) {
            this.itype = CONTOUR;
        }
        if (this.nob == 1) {
            this.itype = LABEL;
        }
    }

    public void addDouble(double d) {
        if (this.nno == 0) {
            this.x = d;
        } else if (this.nno == 1) {
            this.y = d;
        } else if (this.nno == 2) {
            this.z = d;
        } else if (this.nno == 3) {
            this.r = 0.5 * d;
        }
        ++this.nno;
        this.itype = POINT;
    }

    public void addObject(nl3Object nl3Object2) {
        if (this.obs == null) {
            this.obs = new nl3Object[4];
        }
        if (this.nob >= this.obs.length) {
            nl3Object[] nl3ObjectArray = new nl3Object[2 * this.nob];
            int n = 0;
            while (n < this.nob) {
                nl3ObjectArray[n] = this.obs[n];
                ++n;
            }
            this.obs = nl3ObjectArray;
        }
        this.obs[this.nob] = nl3Object2;
        ++this.nob;
    }

    public void tidy(int n) {
        boolean bl = false;
        if (this.itype < 0) {
            if (this.obs == null) {
                this.itype = PROPERTY;
            } else {
                int n2 = 0;
                while (n2 < this.obs.length && this.itype < 0) {
                    nl3Object nl3Object2 = this.obs[n2];
                    if (nl3Object2 != null && nl3Object2.itype == PROPERTY) {
                        bl = true;
                        String string = nl3Object2.txt;
                        if (string == null) {
                            System.out.println("error: property with null text? " + nl3Object2.x + " " + nl3Object2.qtxt + " " + nl3Object2.nob + "   at " + n);
                        } else if (string.startsWith("axon")) {
                            this.itype = AXON;
                        } else if (string.startsWith("apical")) {
                            this.itype = APICAL;
                        } else if (string.startsWith("dendrite")) {
                            this.itype = DENDRITE;
                        }
                    }
                    ++n2;
                }
            }
        }
        if (this.itype < 0) {
            if (bl) {
                System.out.println("warning - unknown nl3 object " + this.txt + " " + this.qtxt + " " + this.nob);
            }
            this.itype = ANON;
        }
    }
}

