#Maciej Lazarewicz (c) 2001 mlazarew@gmu.edu

#This program is transleating swc files into NEURON hoc file
#Anywhere a diameter of sequential compartments is the same, they are lumpted into one section
#One section is either composed from 2 nodes and diameters can be different or more nodes create section but with the same diameter.
#All pt3d geometrical information are kept

BEGIN {
    last_ind=-1
	last_diam=-1
	close_prev=0
	type[1]="soma"
	type[2]="axon"
	type[3]="basal"
	type[4]="apical"
	type[5]="custom1"
	type[6]="custom2"
	type[7]="custom3"
	type[8]="unknown"
	print "//Output from filter swc2hoc"
	print "//Filter produces sections within constant diameter, dosen't touch pt3d info"
	print "//Author of this filter: 2001 Maciej Lazarewicz (mlazarew@gmu.edu)"
	print "//"
	print "//========================================================================="
	print "//"
}

#If not comment
$1 != "#" {
#Check if type of compartments is valid [1-7]
    if(!($2>0 && $2<8)) {
	printf("Type of compartment #%d is incorrect: %s\n",$1,$2) > "/dev/stderr"
	printf("Compartment is will have unknown type !\n") > "/dev/stderr"
#If type of compartment is not valid set it to type 8
	$2=8
    }
#Put data in tables
#Type of compartment
    type_comp[$1]=$2
#x,y,z location
    x[$1]=$3
    y[$1]=$4
    z[$1]=$5
#diameter
    diam[$1]=$6
#Parent compartment
    ref[$1]=$7
#Number of children for parent
    bif[$7]++
#Warn about nodes with more then 2 children
    if(bif[$7]>2) printf("In this model you have node %d with: %d branches\n", $7 ,bif[$7]) > "/dev/stderr"
}

#Rewrite comments deleting characters #x1a
$1=="#" { 
    $1="//" 
    gsub("\x1a","")
    printf("%s\n",$0)
}

#--------------------------------------------------------------------------------
END {
#We assumed that in swc lines contains compartments with numbers increasing by 1, so last number of compartment is also the amount of compartments in swc, put it into nl
    nl=$1
#Go through all swc compartments
    for(i=1;i<=nl;i++) {
#If parents ID is -1, treat this compartment as first in structure
	if(ref[i]==-1) {
	    ind_comp[i]=-1
	} else 
	{   
#If parent ID is not previous compartment, it means that new branch is starting, make new section
#If parent diameter is different from this diameter, make new section 
#If parent is the first in the structure, make new section
#If parent type is different from this type, make new section
#If parent has more then 1 child, make new section
	    if ( (i-1)!=ref[i] || diam[i]!=diam[i-1] || ref[i-1]==-1 || type_comp[i]!=type_comp[i-1] || bif[i-1]>1 ) { 
#Make new section
#num_seg - amount of segments of given type
#ind - index of section of type type_comp[i]
		ind=++num_seg[type_comp[i]]
#comp_n - number of points describing geometry in section indexed by type and ind
		comp_n[type_comp[i],ind]=1
#comp_ref_n - parent ID of section indexed by type and ind 
		comp_ref_n[type_comp[i],ind]=ref[i]
#comp_diam - diameter of section indexed by type and ind, number of point
		comp_diam[type_comp[i],ind,comp_n[type_comp[i],ind]]=diam[ref[i]]
#comp_beg -  ID of section indexed by type and ind
		comp_beg[type_comp[i],ind]=i
#x,y,z of comp_n point describing the geometry of section indexed by type and ind
#this x,y,x are location of the first point describing section, and values come from parents last point
		comp_x[type_comp[i],ind,comp_n[type_comp[i],ind]]=x[ref[i]]
		comp_y[type_comp[i],ind,comp_n[type_comp[i],ind]]=y[ref[i]]
		comp_z[type_comp[i],ind,comp_n[type_comp[i],ind]]=z[ref[i]]
#		print type_comp[i], ind 
	    }

#Add one more point describing geometry to section indexed by type and ind
	    ind_comp[i]=ind
#Increase number of points in section indexed by type and ind
	    comp_n[type_comp[i],ind]++
#comp_diam - diameter of section indexed by type and ind, number of point
	    comp_diam[type_comp[i],ind,comp_n[type_comp[i],ind]]=diam[i]
#x,y,z of the n-th point of section indexed by type and ind
	    comp_x[type_comp[i],ind,comp_n[type_comp[i],ind]]=x[i]
	    comp_y[type_comp[i],ind,comp_n[type_comp[i],ind]]=y[i]
	    comp_z[type_comp[i],ind,comp_n[type_comp[i],ind]]=z[i]
	}
    }

#--------------------------------------------------------------------------------
#Creating sections
#Go through all types 1-8
    for(i=1;i<=8;i++) {
#If amount of sections of particular type if >0 then create appropriate number of sections
	if(num_seg[i]>0) { 
	    printf("create %s[%d]\n",type[i],num_seg[i])
	}
    }

#--------------------------------------------------------------------------------
#Clear pt3d structures and add points to pt3d 
#Go through all types
    for(i=1;i<=8;i++) {
#Go through all sections of type
	for(j=1;j<=num_seg[i];j++) {
#comp_ref - type and index of parent section
	    comp_ref[i,j]=sprintf("%s[%d]",type[type_comp[comp_ref_n[i,j]]],ind_comp[comp_ref_n[i,j]]-1)
#Access section type index
	    printf("\naccess %s[%d]\n",type[i],j-1)
#clean pt3d
	    printf("pt3dclear()\n")
#Go through all points in section
	    for(k=1;k<=comp_n[i,j];k++) {
#Add particular pt3d points
		printf("pt3dadd(%g,%g,%g,%g)\n",comp_x[i,j,k],comp_y[i,j,k],comp_z[i,j,k],comp_diam[i,j,k])
	    }
	}
    }

#--------------------------------------------------------------------------------
#Now connect sections together
    l=0
    print ""
#Go through all types
    for(i=1;i<=8;i++) {
#Go through all sections among types
	for(j=1;j<=num_seg[i];j++) {
#Check if section is connected to the origin point ( begin of the first section)
#If not go ahead
	 if(ref[comp_ref_n[i,j]]!=-1) {
#Connect
	     printf("connect %s[%d](0), %s(1)\n",type[i],j-1,comp_ref[i,j])
	 }
	 else
#If parent is the origin save type and index
	 {
	     last_con[l++]=sprintf("%s[%d]",type[i],j-1)
#	     printf("%s\n",last_con[l-1])>"/dev/stderr"
	 }
	}
    }
#Noe connect begins of all sections with parents at origin point together
    for(i=1;i<l;i++) {
	printf("connect %s(0),%s(0)\n",last_con[i],last_con[0]) 
	printf("I will join at origins compartments: %s(0),%s(0)\n",last_con[i],last_con[0]) > "/dev/stderr"
    }
}

