/*
 * Decompiled with CFR 0.152.
 */
package phy.acq;

import java.util.Vector;
import phy.acq.DataObserver;
import phy.acq.ParamSupport;
import phy.acq.PhyBean;

public class DataObservable
implements PhyBean,
DataObserver {
    private boolean changed = false;
    private Vector obs = new Vector();
    private DataObserver[] arr = new DataObserver[2];

    public synchronized void addObserver(DataObserver dataObserver) {
        if (!this.obs.contains(dataObserver)) {
            this.obs.addElement(dataObserver);
        }
    }

    public synchronized void deleteObserver(DataObserver dataObserver) {
        this.obs.removeElement(dataObserver);
    }

    public void notifyObservers() {
        int n = 0;
        DataObservable dataObservable = this;
        synchronized (dataObservable) {
            if (!this.hasChanged()) {
                return;
            }
            n = this.obs.size();
            if (n > this.arr.length) {
                this.arr = new DataObserver[n];
            }
            this.obs.copyInto(this.arr);
            this.clearChanged();
        }
        for (int i = n - 1; i >= 0; --i) {
            if (this.arr[i] == null) continue;
            this.arr[i].update(this);
        }
    }

    public synchronized void deleteObservers() {
        this.obs.removeAllElements();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public void informObservers() {
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized int countObservers() {
        return this.obs.size();
    }

    public void setPropertyAsText(String string, String string2) {
        ParamSupport.setPropertyAsText(this, string, string2);
        this.informObservers();
    }

    public void setProperty(String string, Object object) {
        ParamSupport.setProperty(this, string, object);
        this.informObservers();
    }

    public Object getProperty(String string) {
        return ParamSupport.getProperty(this, string);
    }

    public String getPropertyAsText(String string) {
        return ParamSupport.getPropertyAsText(this, string);
    }

    public double getDoubleProperty(String string) {
        return (Double)this.getProperty(string);
    }

    public void setDoubleProperty(String string, double d) {
        this.setProperty(string, new Double(d));
    }

    public void update(DataObservable dataObservable) {
        this.informObservers();
    }
}

