/*
 * Decompiled with CFR 0.152.
 */
package phy.acq;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import phy.acq.DataObservable;
import phy.acq.DataSrc;
import phy.acq.ParamSupport;
import phy.util.ActionEventSupport;
import phy.util.DataPoint;
import phy.util.DataSequence;
import phy.util.PhyTools;
import phy.util.Timer;

public class Simulator
extends DataObservable
implements ActionListener {
    protected DataSrc source;
    protected boolean running = true;
    protected boolean paused = false;
    protected Timer timer;
    public double slowMotion = 1.0;
    protected double time = 0.0;
    protected long timeOrigin = 0L;
    private long timePause = 0L;
    protected double tMax = 0.0;
    protected boolean integrating = false;
    protected double integrationStep = 0.1;
    protected DataSequence dataSequence = new DataSequence(0.1);
    protected Vector listeData = new Vector();
    ActionEventSupport actionEventSupport = new ActionEventSupport();
    private double lastTime = 0.0;

    public void setDataSrc(DataSrc dataSrc) {
        this.source = dataSrc;
    }

    public DataSrc getDataSrc() {
        return this.source;
    }

    public boolean isRunning() {
        return this.running && !this.paused;
    }

    public void setRunning(boolean bl) {
        if (bl != this.running) {
            this.running = bl;
            if (this.running) {
                this.reset();
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        if (bl) {
            this.pause();
        } else {
            this.resume();
        }
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setSlowMotion(double d) {
        this.timeOrigin = System.currentTimeMillis() - (long)Math.rint(d * this.getSystemTime() * (double)1000);
        this.slowMotion = d;
    }

    public double getSlowMotion() {
        return this.slowMotion;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public double getTMax() {
        return this.tMax;
    }

    public void setTMax(double d) {
        this.tMax = d;
    }

    public void setIntegrating(boolean bl) {
        this.integrating = bl;
    }

    public boolean isIntegrating() {
        return this.integrating;
    }

    public void setIntegrationStep(double d) {
        this.integrationStep = d;
        this.setIntegrating(true);
    }

    public double getIntegrationStep() {
        return this.integrationStep;
    }

    public DataSequence getDataSequence() {
        return this.dataSequence;
    }

    public void setTimeStep(double d) {
        this.getDataSequence().setTimeStep(d);
    }

    public Simulator() {
        this.resetTimeOrigin();
    }

    public Simulator(DataSrc dataSrc) {
        this();
        this.setDataSrc(dataSrc);
    }

    public void reset() {
        this.resetTimeOrigin();
        if (this.source != null) {
            this.setTimeSource(this.getTime());
            this.source.reset();
        }
        this.dataSequence.reset();
    }

    public void pause() {
        if (!this.isPaused()) {
            this.setTime(this.getSystemTime());
            this.updateDataSequence();
            if (this.source != null) {
                this.setTimeSource(this.getTime());
            }
            this.paused = true;
            if (this.getTime() > this.getTMax() && this.getTMax() > 0.0) {
                this.setRunning(false);
                this.setRunning(true);
            }
            this.setTime();
            this.informObservers();
            this.timePause = System.currentTimeMillis();
        }
    }

    public void resume() {
        if (this.isPaused()) {
            this.paused = false;
            this.timeOrigin += System.currentTimeMillis() - this.timePause;
            this.setTime();
        }
    }

    public boolean containsData(String string) {
        for (int i = 0; i < this.getDataSize(); ++i) {
            if (!this.getDataName(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void registerData(String string) {
        if (!this.containsData(string)) {
            this.listeData.addElement(string);
            int n = string.indexOf("(");
            if (n >= 0) {
                int n2 = string.indexOf(")");
                this.registerData(string.substring(n + 1, n2));
            }
        }
    }

    public String getDataName(int n) {
        return (String)this.listeData.elementAt(n);
    }

    public int getDataSize() {
        return this.listeData.size();
    }

    public void setTime() {
        this.setTime(this.getSystemTime());
        if (this.source != null) {
            this.setTimeSource(this.getTime());
        }
    }

    public double getTime() {
        return this.time;
    }

    public double getSystemTime() {
        return (double)(System.currentTimeMillis() - this.timeOrigin) / 1000.0 / this.getSlowMotion();
    }

    protected void resetTimeOrigin() {
        this.timePause = this.timeOrigin = System.currentTimeMillis();
        this.setTime(0.0);
    }

    public void setNewTime(double d) {
        this.timeOrigin = System.currentTimeMillis() - (long)(d * (double)1000 * this.getSlowMotion());
        this.timePause = System.currentTimeMillis();
        this.setTime();
    }

    public void updateDataSequence() {
        if (this.dataSequence.isFull()) {
            return;
        }
        if (this.getDataSize() > 0 && this.getTime() > this.dataSequence.getTimeEnd()) {
            double d = (this.getTime() - this.dataSequence.getTimeEnd()) / this.dataSequence.getTimeStep();
            int n = 1;
            while ((double)n < d) {
                double d2 = this.dataSequence.getTimeNext();
                if (this.getTMax() > 0.0 && d2 > this.getTMax() + this.dataSequence.getTimeStep()) break;
                this.setTimeSource(d2);
                this.putDataPoint();
                ++n;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME") && this.isRunning()) {
            this.setTime(this.getSystemTime());
            this.updateDataSequence();
            if (this.source != null) {
                this.setTimeSource(this.getTime());
            }
            this.informObservers();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PhyTools.issueMessage(String.valueOf("propertyChange desapprouv\u00e9 in Simulator ").concat(String.valueOf(propertyChangeEvent.getPropertyName())));
        this.source.setProperty(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
        this.informObservers();
    }

    public void informObservers() {
        super.informObservers();
        this.actionEventSupport.fireRefreshEvent();
    }

    public void setPropertyAsText(String string, String string2) {
        if (!string.equals("SlowMotion")) {
            ParamSupport.setPropertyAsText(this.getDataSrc(), string, string2);
        } else {
            ParamSupport.setPropertyAsText(this, string, string2);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void setProperty(String string, Object object) {
        if (!string.equals("SlowMotion")) {
            ParamSupport.setProperty(this.getDataSrc(), string, object);
        } else {
            ParamSupport.setProperty(this, string, object);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Object getProperty(String string) {
        if (!string.equals("SlowMotion")) {
            return ParamSupport.getProperty(this.getDataSrc(), string);
        }
        return ParamSupport.getProperty(this, string);
    }

    public String getPropertyAsText(String string) {
        if (!string.equals("SlowMotion")) {
            return ParamSupport.getPropertyAsText(this.getDataSrc(), string);
        }
        return ParamSupport.getPropertyAsText(this, string);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        PhyTools.issueMessage("DISAPPROVED : Mieux vaut utilis\u00e9 Simulator.addObserver()");
        this.actionEventSupport.addActionListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionEventSupport.removeActionListener(actionListener);
    }

    protected void setTimeSource(double d) {
        if (this.isIntegrating() && d - this.lastTime > 1.1 * this.getIntegrationStep()) {
            int n = 1;
            while ((double)n < (d - this.lastTime) / this.getIntegrationStep() - 0.1) {
                this.source.setTime(this.lastTime + (double)n * this.getIntegrationStep());
                ++n;
            }
        }
        this.source.setTime(d);
        this.lastTime = d;
    }

    protected void putDataPoint() {
        String string;
        int n;
        DataPoint dataPoint = new DataPoint();
        for (n = 0; n < this.getDataSize(); ++n) {
            string = this.getDataName(n);
            if (string.indexOf(40) >= 0) continue;
            dataPoint.put(string, this.source.getDoubleProperty(string));
        }
        for (n = 0; n < this.getDataSize(); ++n) {
            string = this.getDataName(n);
            int n2 = string.indexOf(40);
            if (n2 < 0) continue;
            int n3 = string.indexOf(")");
            String string2 = string.substring(0, n2).toUpperCase();
            String string3 = string.substring(n2 + 1, n3);
            if (!string2.equals("DIFF") || this.dataSequence.size() <= 0) continue;
            double d = this.source.getDoubleProperty(string3);
            double d2 = this.dataSequence.getData(string3, this.dataSequence.getLastIndex());
            dataPoint.put(string, (d - d2) / this.dataSequence.getTimeStep());
        }
        this.dataSequence.putDataPoint(dataPoint);
    }

    public double getData(String string) {
        PhyTools.issueMessage("OBSOLETE");
        return 0.0;
    }
}

