/*
 * Decompiled with CFR 0.152.
 */
package phy.applet;

import java.applet.AppletStub;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import phy.util.CrackedString;
import phy.util.FileToolkit;
import phy.util.PhyTools;
import phy.util.PhysicApplet;
import phy.util.SoundPlayer;
import phy.util.TimeEvent;

public class AppletHolder
extends PhysicApplet
implements Runnable,
Serializable,
AppletStub,
ActionListener {
    transient PhysicApplet applet;
    protected String paramBgnd = "";
    protected String language = "FR";
    protected boolean autoRun = true;
    protected String commandLine = "";
    private PrintStream streamConsole;
    private PrintStream streamFile;
    protected String errorString = null;
    private String qcmStatus;
    protected transient String imagePath;
    protected transient Image backgroundImage;
    protected transient String backgroundImageName;
    protected transient ActionListener actionListener;
    public static boolean firstTime = true;
    protected String timeLineString;

    public PhysicApplet getApplet() {
        return this.applet;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setApplet() {
        this.setApplet(this.commandLine);
    }

    public void setApplet(String string) {
        String string2;
        PhyTools.issueMessage(String.valueOf("setApplet ").concat(String.valueOf(string)));
        this.commandLine = string;
        if (this.applet != null) {
            try {
                this.applet.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeAll();
            try {
                this.applet.destroy();
            }
            catch (Exception exception) {}
        } else {
            this.removeAll();
        }
        this.applet = null;
        System.gc();
        this.qcmStatus = "XXXXXXXXXXXX";
        int n = string.indexOf(" ");
        String string3 = null;
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1, string.length()).trim();
        }
        if (string2.equals("") || string2.equals("null")) {
            return;
        }
        PhyTools.issueMessage(String.valueOf(String.valueOf(String.valueOf("Memoire utilisee : ").concat(String.valueOf(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()))).concat(String.valueOf("/"))).concat(String.valueOf(Runtime.getRuntime().totalMemory())));
        PhyTools.issueMessage(String.valueOf("Nouvelle applet : ").concat(String.valueOf(string)));
        try {
            PhyTools.issueMessage(String.valueOf("Number of threads : ").concat(String.valueOf(Thread.activeCount())));
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup().getParent();
            PhyTools.issueMessage(String.valueOf("Group : ").concat(String.valueOf(threadGroup.activeCount())));
        }
        catch (Exception exception) {
            PhyTools.issueMessage("Impossible d'acc\u00e9der aux threads");
        }
        try {
            try {
                this.applet = (PhysicApplet)Class.forName(String.valueOf("phy.applet.").concat(String.valueOf(string2))).newInstance();
            }
            catch (Exception exception) {
                this.errorString = String.valueOf("Error : ").concat(String.valueOf(exception));
                this.applet = (PhysicApplet)Class.forName(String.valueOf("phy.").concat(String.valueOf(string2))).newInstance();
                this.initErrorString();
            }
            this.applet.setStub(this);
            this.applet.addActionListener(this);
        }
        catch (Exception exception) {
            this.applet = null;
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Exception ").concat(String.valueOf(exception))).concat(String.valueOf(" lors de la cr\u00e9ation de "))).concat(String.valueOf(string2)));
            this.repaint();
        }
        if (this.applet != null) {
            this.applet.setAutoSequencing(false);
            this.applet.setImagePath(this.imagePath);
            this.applet.setBackgroundImage(this.backgroundImage);
            this.applet.setBackgroundImageName(this.backgroundImageName);
            PhysicApplet.setLanguage(this.language);
            FileToolkit.setApplet(this);
            if (string3 != null) {
                this.applet.setParamList(string3);
            } else {
                this.applet.setParamList("");
            }
            this.addApplet();
            this.applet.init();
            this.applet.initApplet();
            SoundPlayer.setSilent(false);
            this.validate();
            this.applet.start();
            this.errorString = null;
        }
    }

    protected void addApplet() {
        if (this.applet != null) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.applet, "Center");
        }
    }

    public void setLogFile(String string) {
        if (string == null || string.length() == 0) {
            System.out.println(String.valueOf("Console output in ").concat(String.valueOf(string)));
            PhyTools.setDebug(false);
            if (this.streamFile == null) {
                return;
            }
            try {
                System.setOut(this.streamConsole);
                this.streamFile = null;
            }
            catch (Exception exception) {
                System.out.println(String.valueOf("Exception ").concat(String.valueOf(exception)));
            }
        } else {
            if (this.streamConsole == null) {
                this.streamConsole = System.out;
            }
            try {
                this.streamFile = new PrintStream(new FileOutputStream(new File(string)), true);
                System.setOut(this.streamFile);
                System.setErr(this.streamFile);
                PhyTools.setDebug(true);
                PhyTools.issueMessage("Physique Interactive, version 1.0 (03/12/99)");
                PhyTools.issueMessage(String.valueOf("Machine Java : ").concat(String.valueOf(System.getProperty("java.version"))));
                PhyTools.issueMessage(String.valueOf("ClassPath : ").concat(String.valueOf(System.getProperty("java.class.path"))));
                PhyTools.issueMessage(String.valueOf("Vendor : ").concat(String.valueOf(System.getProperty("java.vendor"))));
                PhyTools.issueMessage(String.valueOf("Home : ").concat(String.valueOf(System.getProperty("java.home"))));
            }
            catch (Exception exception) {
                System.out.println(String.valueOf("Exception ").concat(String.valueOf(exception)));
            }
        }
    }

    public void setCommand(String string) {
        if (string.startsWith("BACKGROUND")) {
            int n = string.indexOf(" ");
            if (n >= 0) {
                this.setBackgroundImage(string.substring(n).trim());
            }
        } else if (this.applet != null) {
            if (string.equals("START")) {
                if (this.qcmStatus.charAt(9) == 'X') {
                    this.qcmStatus = String.valueOf(this.qcmStatus.substring(0, 9)).concat(String.valueOf("S"));
                    this.startShow();
                }
            } else if (string.equals("INIT")) {
                this.applet.initApplet();
            } else if (string.startsWith("ERROR")) {
                int n = string.indexOf(" ");
                if (n >= 0) {
                    int n2 = -1;
                    try {
                        n2 = Integer.valueOf(string.substring(n).trim()) - 1;
                    }
                    catch (Exception exception) {
                        System.out.println(String.valueOf("Exception ").concat(String.valueOf(exception)));
                    }
                    if (n2 >= 0 && n2 < 10) {
                        this.qcmStatus = String.valueOf(String.valueOf(this.qcmStatus.substring(0, n2)).concat(String.valueOf("F"))).concat(String.valueOf(this.qcmStatus.substring(n2 + 1)));
                        this.applet.setQCMStatus(this.qcmStatus);
                    }
                }
            } else if (string.startsWith("DONE")) {
                int n = string.indexOf(" ");
                if (n >= 0) {
                    int n3 = -1;
                    try {
                        n3 = Integer.valueOf(string.substring(n).trim()) - 1;
                    }
                    catch (Exception exception) {
                        System.out.println(String.valueOf("Exception ").concat(String.valueOf(exception)));
                    }
                    if (n3 >= 0 && n3 < 10) {
                        this.qcmStatus = String.valueOf(String.valueOf(this.qcmStatus.substring(0, n3)).concat(String.valueOf("T"))).concat(String.valueOf(this.qcmStatus.substring(n3 + 1)));
                        this.applet.setQCMStatus(this.qcmStatus);
                    }
                }
            } else {
                this.applet.actionPerformed(new ActionEvent(this, 1001, string));
            }
        }
    }

    public String getParam(String string) {
        if (this.applet != null) {
            return this.applet.getParam(string);
        }
        return "";
    }

    public boolean isComplete() {
        if (this.applet != null) {
            return this.applet.isComplete();
        }
        return true;
    }

    public String getMessageUncomplete() {
        if (this.applet != null) {
            return this.applet.getMessageUncomplete();
        }
        return "";
    }

    public void setImagePath(String string) {
        PhyTools.issueMessage(String.valueOf("Image path : ").concat(String.valueOf(string)));
        this.imagePath = string;
        if (this.applet != null) {
            this.applet.setImagePath(string);
        } else {
            FileToolkit.setImagePath(string);
        }
    }

    public void startShow() {
        if (this.applet != null) {
            this.applet.startShow();
        }
    }

    public void setBackgroundImage(String string) {
        this.backgroundImageName = string;
        this.backgroundImage = string == null || string.length() == 0 ? null : FileToolkit.loadImage(string);
        this.repaint();
    }

    public Image getBackgroundImage() {
        if (this.backgroundImage == null && this.backgroundImageName != null) {
            this.backgroundImage = FileToolkit.loadImage(this.backgroundImageName);
        }
        return this.backgroundImage;
    }

    public void paint(Graphics graphics) {
        String string;
        super.paint(graphics);
        graphics.setColor(Color.yellow);
        if (this.backgroundImage != null) {
            graphics.drawImage(this.backgroundImage, 0, 0, this);
            graphics.setColor(Color.black);
        }
        if (this.errorString != null && (string = this.errorString) != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics.stringWidth(string) > this.getSize().width && string.indexOf(" ") >= 0) {
                String string2 = string.substring(0, string.indexOf(" "));
                String string3 = string.substring(string.indexOf(" ") + 1);
                graphics.drawString(string2, (this.getSize().width - fontMetrics.stringWidth(string2)) / 2, this.getSize().height / 2 - 10);
                graphics.drawString(string3, (this.getSize().width - fontMetrics.stringWidth(string3)) / 2, this.getSize().height / 2 + 10);
            } else {
                graphics.drawString(string, (this.getSize().width - fontMetrics.stringWidth(string)) / 2, this.getSize().height / 2);
            }
        }
    }

    public void update(Graphics graphics) {
        if (this.backgroundImage != null) {
            this.paint(graphics);
        } else {
            super.update(graphics);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("SET")) {
            String string2 = null;
            int n = string.indexOf(" ");
            if (n >= 0) {
                string2 = string.substring(n + 1).trim();
            }
            this.setApplet(string2);
        } else if (actionEvent.getSource() instanceof PhysicApplet) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        } else {
            String string3 = null;
            int n = string.indexOf(" ");
            if (n >= 0) {
                string3 = string.substring(n + 1).trim();
            } else if (string.startsWith("APPLET") && string3 != null) {
                this.setCommand(string3);
            } else if (string.startsWith("IMAGEPATH")) {
                this.setImagePath(string3);
            } else if (string.startsWith("BACKGROUND")) {
                this.setBackgroundImage(string3);
            } else if (string.equals("REWIND")) {
                if (this.applet != null) {
                    this.applet.initApplet();
                }
                this.timeLine.reset();
                if (this.timeLineString != null) {
                    this.setEventSequence(this.timeLineString);
                }
            } else {
                PhyTools.issueMessage("ERREUR : message non correct");
            }
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void initErrorString() {
        this.errorString = this.language.equals("FR") ? "Chargement en cours ..." : "Loading applet ...";
    }

    public void init() {
        this.setBackground(Color.black);
        PhyTools.issueMessage(String.valueOf("Machine Java : ").concat(String.valueOf(System.getProperty("java.version"))));
        PhyTools.issueMessage(String.valueOf("Vendor : ").concat(String.valueOf(System.getProperty("java.vendor"))));
        if (this.getParameter("bgnd") != null) {
            this.paramBgnd = this.getParameter("bgnd");
        }
        if (this.getParameter("lang") != null) {
            this.language = this.getParameter("lang");
        }
        if (this.getParameter("autoRun") != null) {
            this.autoRun = false;
        }
        this.initErrorString();
        if (firstTime) {
            System.out.println("");
            if (this.language.equals("FR")) {
                System.out.println("Bienvenue dans MECANIQUE QUANTIQUE 1.01");
                System.out.println("");
                if (PhyTools.getVersion() > 1) {
                    System.out.println("Vous pouvez d\u00e9sactiver l'apparition syst\u00e9matique de cette fen\u00eatre intitul\u00e9e\n\"Java console\" \u00e0 l'aide des propri\u00e9t\u00e9s de Java plug-in, accessibles dans\nle panneau de configuration de votre ordinateur.");
                }
            } else {
                System.out.println("Welcome to Quantum Mechanics 1.01");
                System.out.println("");
                if (PhyTools.getVersion() > 1) {
                    System.out.println("The display of this \"Java console\" window can be disabled using the Java\nplug-in setup program which you will find in the configuration panel of your\ncomputer.");
                }
            }
            firstTime = false;
        }
    }

    public void start() {
        PhyTools.issueMessage("AppletHolder start");
        Thread thread = new Thread(this);
        thread.start();
        PhyTools.issueMessage("start done");
    }

    public void stop() {
        if (this.applet != null) {
            try {
                this.applet.stop();
                SoundPlayer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.removeAll();
            try {
                this.applet.destroy();
            }
            catch (Exception exception) {}
        } else {
            this.removeAll();
        }
        this.applet = null;
        if (this.timeLine != null) {
            this.timeLine.end();
        }
        if (this.timer != null) {
            this.timer.end();
        }
        System.gc();
    }

    public void run() {
        try {
            String string;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.paramBgnd.length() > 0) {
                this.setBackgroundImage(this.paramBgnd);
            }
            if ((string = this.getParameter("commandLine")) != null) {
                this.commandLine = string;
            }
            if (this.commandLine.length() > 0) {
                PhyTools.issueMessage(String.valueOf("Commande : ").concat(String.valueOf(this.commandLine)));
                this.setApplet(this.commandLine);
            }
            this.timeLineString = this.getParameter("timeLine");
            if (!this.autoRun) {
                this.applet.flushApplet();
            } else if (this.timeLineString != null) {
                this.timeLine.reset();
                this.setEventSequence(this.timeLineString);
            }
        }
        catch (Exception exception) {
            System.out.println(String.valueOf("Erreur lors du chargement : ").concat(String.valueOf(exception)));
            this.errorString = "Download error";
        }
    }

    public void rewindApplet() {
        if (this.applet != null) {
            this.applet.initApplet();
        }
        if (this.timeLineString != null) {
            this.setEventSequence(this.timeLineString);
        }
    }

    public void processTimeEvent(TimeEvent timeEvent) {
        block5: {
            block9: {
                block6: {
                    TimeEvent timeEvent2;
                    block8: {
                        block7: {
                            block4: {
                                PhyTools.issueMessage(String.valueOf("Event : ").concat(String.valueOf(timeEvent.getActionCommand())));
                                if (!timeEvent.getActionCommand().startsWith("APPLET REMOTE_MOUSE MOVE ")) break block4;
                                CrackedString crackedString = new CrackedString(timeEvent.getActionCommand());
                                double d = crackedString.getDouble(5);
                                int n = 100;
                                if (PhysicApplet.getComputerSpeed() == 1) {
                                    n = 200;
                                }
                                int n2 = (int)Math.floor(d / (double)n);
                                double d2 = (crackedString.getDouble(3) - (double)this.applet.getXRemoteMouse()) / (double)(n2 - 1);
                                double d3 = (crackedString.getDouble(4) - (double)this.applet.getYRemoteMouse()) / (double)(n2 - 1);
                                long l = timeEvent.getTime();
                                for (int i = 0; i < n2; ++i) {
                                    this.addTimeEvent((long)Math.floor((double)l + Math.min((double)(i * n), d)), String.valueOf(String.valueOf(String.valueOf("APPLET REMOTE_MOUSE XY ").concat(String.valueOf((double)this.applet.getXRemoteMouse() + (double)i * d2))).concat(String.valueOf(" "))).concat(String.valueOf((double)this.applet.getYRemoteMouse() + (double)i * d3)));
                                }
                                break block5;
                            }
                            if (!timeEvent.getActionCommand().startsWith("APPLET")) break block6;
                            String string = timeEvent.getActionCommand().substring(6).trim();
                            timeEvent2 = new TimeEvent(timeEvent, string);
                            if (timeEvent2.getActionListener() == null) break block7;
                            timeEvent2.getActionListener().actionPerformed(timeEvent2);
                            break block5;
                        }
                        if (!timeEvent2.getType().equals("PCE")) break block8;
                        timeEvent2.getPCListener().propertyChange(timeEvent2.getPCE());
                        break block5;
                    }
                    if (this.applet == null) break block5;
                    this.applet.actionPerformed(timeEvent2);
                    break block5;
                }
                if (!timeEvent.getActionCommand().equals("REWIND")) break block9;
                if (this.applet != null) {
                    this.applet.initApplet();
                }
                this.timeLine.reset();
                if (this.timeLineString == null) break block5;
                this.setEventSequence(this.timeLineString);
                break block5;
            }
            if (!timeEvent.getActionCommand().startsWith("AGENT ") && !timeEvent.getActionCommand().startsWith("PLAY ")) break block5;
            String string = timeEvent.getActionCommand().substring(5).trim();
            int n = string.indexOf(" ");
            if (n >= 0) {
                string = string.substring(0, n).trim();
            }
            SoundPlayer.play(string);
        }
    }

    public void appletResize(int n, int n2) {
    }

    public String processZero(String string) {
        String string2 = "";
        long l = 0L;
        long l2 = 0L;
        do {
            String string3;
            int n;
            if ((n = string.indexOf(",")) >= 0) {
                string3 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            } else {
                string3 = string;
                string = "";
            }
            CrackedString crackedString = new CrackedString(string3);
            if (crackedString.getNFields() <= 1) continue;
            long l3 = Integer.valueOf(crackedString.getField(0)).longValue() + l;
            if (crackedString.getField(1).equals("AGENT") || crackedString.getField(1).equals("PLAY")) {
                if (!crackedString.getField(2).equals("WAIT")) {
                    l2 = l3 + SoundPlayer.getDuration(crackedString.getField(2));
                    SoundPlayer.load(crackedString.getField(2));
                }
                string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(string2).concat(String.valueOf(l3))).concat(String.valueOf(" "))).concat(String.valueOf(crackedString.getTail(1, ' ')))).concat(String.valueOf(", "));
                continue;
            }
            if (crackedString.getField(1).equals("ZEROWAIT") || crackedString.getField(1).equals("AGENTSYNC")) {
                l = Math.max(l3, l2);
                continue;
            }
            string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(string2).concat(String.valueOf(l3))).concat(String.valueOf(" "))).concat(String.valueOf(crackedString.getTail(1, ' ')))).concat(String.valueOf(", "));
        } while (string.length() > 0);
        return string2;
    }
}

