/*
 * Decompiled with CFR 0.152.
 */
package phy.applet.quantacd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import phy.graphe.BufferedPanel;
import phy.graphe.DrawableEquation;
import phy.graphe.DrawableObject;
import phy.quanta.HarmonicAbstract;
import phy.quanta.HarmonicOscillator;
import phy.quanta.HarmonicViewerPotential;
import phy.util.AbsoluteLayout;
import phy.util.PhysicApplet;

public class HermiteFunctions
extends HarmonicAbstract {
    public void init() {
        super.init();
        this.oscillator = new HarmonicOscillator();
        this.oscillator.initNNiveaux(9);
        this.oscillator.setMeanEnergy(-1.0);
        this.initSimulator();
        this.getSimulator().setDataSrc(this.oscillator);
        this.getSimulator().pause();
        this.viewerPotential = new HarmonicViewerPotential(this.getSimulator());
        this.viewerPotential.setMouseActive(false);
        this.viewerPotential.setName("Potential");
        this.viewerEquation = new BufferedPanel();
        if (PhysicApplet.getLanguage().equals("FR")) {
            this.viewerEquation.addDrawableObject("EQ1", (DrawableObject)new DrawableEquation("\\mbox{Fonctions de Hermite}", new Point(100, 15), 7), Color.cyan);
            this.viewerEquation.addDrawableObject("EQ3", new DrawableEquation("\\mbox{Unit\u00e9 de longueur : } \\sqrt{\\frac{\\hbar}{m\\omega}}", new Point(25, 110), 4));
            this.viewerEquation.addDrawableObject("EQ4", new DrawableEquation("\\mbox{Unit\u00e9 d'\u00e9nergie : } \\hbar \\omega", new Point(25, 150), 4));
        } else {
            this.viewerEquation.addDrawableObject("EQ1", (DrawableObject)new DrawableEquation("\\mbox{Hermite Functions}", new Point(100, 15), 7), Color.cyan);
            this.viewerEquation.addDrawableObject("EQ3", new DrawableEquation("\\mbox{Length unit : } \\sqrt{\\frac{\\hbar}{m\\omega}}", new Point(25, 110), 4));
            this.viewerEquation.addDrawableObject("EQ4", new DrawableEquation("\\mbox{Energy unit : } \\hbar \\omega", new Point(25, 150), 4));
        }
        this.viewerEquation.addDrawableObject("EQ2", (DrawableObject)new DrawableEquation("\\frac{1}{2} \\brackett{x^2 - \\frac{d^2}{d x^2}} \\Phi_n(x) = \\epsilon_n \\Phi_n(x)", new Point(15, 50), 4), Color.yellow);
        this.viewerEquation.addDrawableObject("EQ5", (DrawableObject)new DrawableEquation("\\epsilon_n = n + \\frac{1}{2}", new Point(100, 210), 3), Color.yellow);
        this.viewerEquation.addDrawableObject("EQ6", (DrawableObject)new DrawableEquation("\\Phi_n(x) = C_n exp \\brackett{-\\frac{x^2}{2}} H_n(x)", new Point(100, 250), 3), Color.yellow);
        this.viewerEquation.setName("Equation");
        this.setLayout(new AbsoluteLayout());
        this.add((Component)this.viewerPotential, new Rectangle(0, 0, 400, 320));
        this.add((Component)this.viewerEquation, new Rectangle(401, 0, 199, 320));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("SHOW GRAPH")) {
            this.viewerPotential.setVisible(true);
            this.validate();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void initApplet() {
        super.initApplet();
        this.viewerEquation.clearFlags("EQ1,EQ2,EQ3,EQ4,EQ5,EQ6");
        this.viewerEquation.repaint();
        this.viewerPotential.setNLevelsShown(0);
        this.viewerPotential.setVisible(false);
        this.validate();
    }

    public void flushApplet() {
        this.viewerEquation.setFlags("EQ1,EQ2,EQ3,EQ4,EQ5,EQ6");
        this.viewerEquation.repaint();
        this.viewerPotential.clearFlags("EVEN,ODD");
        this.viewerPotential.setNLevelsShown(8);
        this.viewerPotential.setVisible(true);
        this.validate();
    }
}

