/*
 * Decompiled with CFR 0.152.
 */
package phy.applet.quantacd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import phy.control.NavigationPanel;
import phy.function.SineFunction;
import phy.graphe.BufferedPanel;
import phy.graphe.DrawableEquation;
import phy.graphe.LayeredPanel;
import phy.quanta.QuantumSuperpositionAbstract;
import phy.quanta.StationaryState;
import phy.quanta.StationaryStateViewer;
import phy.quanta.SuperpositionViewer;

public class QuantumSuperposition3
extends QuantumSuperpositionAbstract {
    BufferedPanel panel;

    public void init() {
        BufferedPanel bufferedPanel;
        super.init();
        this.initSimulator();
        this.getSimulator().pause();
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.setToolBar(new NavigationPanel());
        this.initPlayButton();
        this.getToolBar().add(this.getPlayButton());
        this.stationaryState1 = new StationaryState();
        this.stationaryState1.setOmega(1.0);
        this.viewer1 = new StationaryStateViewer(this.stationaryState1, new SineFunction(1));
        this.stationaryState2 = new StationaryState();
        this.stationaryState2.setOmega(4.0);
        this.viewer2 = new StationaryStateViewer(this.stationaryState2, new SineFunction(2));
        this.viewer1.getViewer().addDrawableObject(new DrawableEquation("\\phi_1(x)", new Point(3, 3), 4, Color.gray));
        this.viewer2.getViewer().addDrawableObject(new DrawableEquation("\\phi_2(x)", new Point(3, 1), 4, Color.gray));
        this.superposition = new SuperpositionViewer(this.viewer1, this.viewer2);
        this.stationaryState1.addActionListener(this.superposition);
        this.stationaryState2.addActionListener(this.superposition);
        if (this.superposition.getComponent(1) instanceof BufferedPanel) {
            bufferedPanel = (BufferedPanel)this.superposition.getComponent(1);
            bufferedPanel.setName("StagePanel");
        }
        this.stationaryState1.setState(1.0 / Math.sqrt(2.0), 0.0);
        this.stationaryState2.setState(1.0 / Math.sqrt(2.0), 0.0);
        bufferedPanel = new LayeredPanel();
        bufferedPanel.setLayout(new GridLayout(3, 1));
        bufferedPanel.add(this.viewer1);
        bufferedPanel.add(this.viewer2);
        bufferedPanel.add(this.superposition);
        LayeredPanel layeredPanel = new LayeredPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)layeredPanel, "Center");
        this.setDefaultListener(bufferedPanel);
        layeredPanel.setLayout(new BorderLayout());
        layeredPanel.add((Component)bufferedPanel, "Center");
        layeredPanel.add((Component)this.getToolBar(), "South");
        this.getSimulator().getTimer().addActionListener(this);
        this.disableToolBar();
        this.setRewindable(false);
    }

    public void flushApplet() {
        this.actionPerformed("REMOTE_MOUSE OFF");
        this.actionPerformed("MOUSE ON");
        this.enableToolBar();
    }
}

