/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import phy.control.HotPoint;

public class HotCurve
extends HotPoint {
    Polygon polygon;
    double abscisse;

    public HotCurve(Polygon polygon, double d) {
        super(50, 50);
        this.polygon = polygon;
        this.abscisse = d;
        this.computeHotPoint();
    }

    protected void computeHotPoint() {
        int n = (int)Math.floor(this.abscisse * (double)this.polygon.npoints);
        double d = this.abscisse * (double)this.polygon.npoints - (double)n;
        Point point = new Point(this.polygon.xpoints[n], this.polygon.ypoints[n]);
        int n2 = n + 1;
        if (n2 >= this.polygon.npoints) {
            n2 = 0;
        }
        Point point2 = new Point(this.polygon.xpoints[n2], this.polygon.ypoints[n2]);
        super.setXY((int)Math.rint((double)point.x * (1.0 - d) + (double)point2.x * d), (int)Math.rint((double)point.y * (1.0 - d) + (double)point2.y * d));
    }

    public void setXY(int n, int n2) {
        super.setXY(n, n2);
        double d = this.closestPointTo(this.polygon.xpoints, this.polygon.ypoints);
        this.abscisse = d / ((double)this.polygon.npoints - 0.0);
        this.computeHotPoint();
    }

    public void paint(Graphics graphics, boolean bl) {
        super.paint(graphics, bl);
        if (bl) {
            graphics.drawPolygon(this.polygon);
        }
    }

    public double getAbscisse() {
        return this.abscisse;
    }
}

