/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import phy.control.HotSpot;
import phy.util.MathTools;

public class HotSlope
extends HotSpot {
    protected int x0;
    protected int y0;
    protected double angle = 0.0;

    public double getAngle() {
        return this.angle;
    }

    public HotSlope(int n, int n2, double d) {
        this.x0 = n;
        this.y0 = n2;
        this.angle = d;
    }

    public int distanceTo(int n, int n2) {
        return (int)Math.rint(Math.abs((double)(n - this.x0) * Math.sin(this.angle) - (double)(n2 - this.y0) * Math.cos(this.angle)) + (double)50 * Math.exp(-Math.sqrt(MathTools.sqr(n - this.x0) + MathTools.sqr(n2 - this.y0)) / (double)50));
    }

    public void paint(Graphics graphics, boolean bl) {
        double d = Math.cos(this.angle);
        double d2 = Math.sin(this.angle);
        if (bl) {
            graphics.setColor(Color.yellow);
        } else {
            graphics.setColor(Color.red);
        }
        Rectangle rectangle = new Rectangle(0, 0, 1000, 1000);
        if (Math.abs(d) < Math.abs(d2)) {
            Point point = new Point((int)Math.rint((double)this.x0 + (double)(rectangle.y - this.y0) * d / d2), rectangle.y);
            Point point2 = new Point((int)Math.rint((double)this.x0 + (double)(rectangle.y + rectangle.height - this.y0) * d / d2), rectangle.y + rectangle.height);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            graphics.drawLine(point.x - 1, point.y, point2.x - 1, point2.y);
            graphics.drawLine(point.x + 1, point.y, point2.x + 1, point2.y);
        } else {
            Point point = new Point(rectangle.x, (int)Math.rint((double)this.y0 + (double)(rectangle.x - this.x0) * d2 / d));
            Point point3 = new Point(rectangle.x + rectangle.width, (int)Math.rint((double)this.y0 + (double)(rectangle.x + rectangle.width - this.x0) * d2 / d));
            graphics.drawLine(point.x, point.y, point3.x, point3.y);
            graphics.drawLine(point.x, point.y - 1, point3.x, point3.y - 1);
            graphics.drawLine(point.x, point.y + 1, point3.x, point3.y + 1);
        }
    }

    public int getX() {
        return this.x0;
    }

    public int getY() {
        return this.y0;
    }

    public void setXY(int n, int n2) {
        double d = Math.atan2(n2 - this.y0, n - this.x0);
        double d2 = Math.atan2(this.y0 - n2, this.x0 - n);
        this.angle = Math.abs(d - this.angle) < Math.abs(d2 - this.angle) ? d : d2;
    }
}

