/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.PhyButton;
import phy.util.ActionEventSupport;

public class NavigationPanel
extends Panel
implements ActionListener {
    boolean with3D = true;
    int thickness3D = 1;
    ActionEventSupport actionEventSupport = new ActionEventSupport();

    public NavigationPanel() {
        this.setForeground(Color.black);
        this.setBackground(Color.lightGray);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        this.setLayout(flowLayout);
    }

    public void set3D(boolean bl) {
        this.with3D = bl;
    }

    public Insets insets() {
        if (this.with3D) {
            return new Insets(4, 3, 4, 3);
        }
        return new Insets(0, 0, 0, 0);
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        if (!this.with3D) {
            return;
        }
        int n2 = this.getSize().width;
        int n3 = this.getSize().height;
        graphics.setColor(Color.darkGray);
        graphics.fillRect(0, n3 - this.thickness3D, n2, this.thickness3D);
        graphics.fillRect(n2 - this.thickness3D, 0, this.thickness3D, n3 - 1);
        graphics.setColor(Color.white);
        for (n = 0; n < this.thickness3D; ++n) {
            graphics.drawLine(n, n, n2 - n - 1, n);
        }
        graphics.setColor(Color.white);
        for (n = 0; n < this.thickness3D; ++n) {
            graphics.drawLine(n, n, n, n3 - n - 1);
        }
        graphics.setColor(this.getForeground());
    }

    public void addButton(PhyButton phyButton) {
        this.add(phyButton);
        phyButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionEventSupport.fireActionEvent(actionEvent);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionEventSupport.addActionListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionEventSupport.removeActionListener(actionListener);
    }
}

