/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.MemoryImageSource;

public class PhyButton
extends Panel
implements MouseListener,
Runnable {
    boolean mouseDown = false;
    boolean selected = false;
    int hImage;
    int wImage;
    String actionCommand;
    String[] source;
    protected Thread thread;
    protected boolean autoRepeat = false;
    protected boolean fireOnDown = false;
    protected boolean enabled = true;
    ActionListener actionListener;
    static String[] sourceMiniExit = new String[]{"        ", "        ", "xx   xx ", " xx xx  ", "  xxx   ", " xx xx  ", "xx   xx ", "        "};
    static String[] sourceMiniUp = new String[]{"        ", "        ", "   x    ", "  xxx   ", " xxxxx  ", "xxxxxxx ", "        ", "        "};
    static String[] sourceMiniDown = new String[]{"        ", "        ", "xxxxxxx ", " xxxxx  ", "  xxx   ", "   x    ", "        ", "        "};
    static String[] sourcePlay = new String[]{"                ", "                ", "    x           ", "    xx          ", "    xxx         ", "    xxxx        ", "    xxxxx       ", "    xxxxxx      ", "    xxxxxxx     ", "    xxxxxx      ", "    xxxxx       ", "    xxxx        ", "    xxx         ", "    xx          ", "    x           ", "                "};
    static String[] sourcePause = new String[]{"                ", "                ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "    xxx  xxx    ", "                "};
    static String[] sourceNext = new String[]{"                ", "                ", "    x     xx    ", "    xx    xx    ", "    xxx   xx    ", "    xxxx  xx    ", "    xxxxx xx    ", "    xxxxxxxx    ", "    xxxxxxxx    ", "    xxxxxxxx    ", "    xxxxx xx    ", "    xxxx  xx    ", "    xxx   xx    ", "    xx    xx    ", "    x     xx    ", "                "};
    static String[] sourcePrev = new String[]{"                ", "                ", "    xx     x    ", "    xx    xx    ", "    xx   xxx    ", "    xx  xxxx    ", "    xx xxxxx    ", "    xxxxxxxx    ", "    xxxxxxxx    ", "    xxxxxxxx    ", "    xx xxxxx    ", "    xx  xxxx    ", "    xx   xxx    ", "    xx    xx    ", "    xx     x    ", "                "};
    static String[] sourcePgup = new String[]{"                ", "                ", "       x        ", "      xxx       ", "     xxxxx      ", "    xxxxxxx     ", "   xxxxxxxxx    ", "       x        ", "       x        ", "   xxxxxxxxx    ", "       x        ", "   xxxxxxxxx    ", "       x        ", "   xxxxxxxxx    ", "                ", "                "};
    static String[] sourcePgdn = new String[]{"                ", "                ", "   xxxxxxxxx    ", "       x        ", "   xxxxxxxxx    ", "       x        ", "   xxxxxxxxx    ", "       x        ", "       x        ", "   xxxxxxxxx    ", "    xxxxxxx     ", "     xxxxx      ", "      xxx       ", "       x        ", "                ", "                "};
    static String[] sourceAutoX = new String[]{"                ", "                ", "                ", "                ", "                ", "   x       x    ", "  xx       xx   ", " xxxxxxxxxxxxx   ", " xxxxxxxxxxxxx  ", "  xx       xx   ", "   x       x    ", "                ", "                ", "                ", "                ", "                "};
    static String[] sourceAutoY = new String[]{"                ", "                ", "       xx       ", "     xxxxxx     ", "       xx       ", "       xx       ", "       xx       ", "       xx       ", "       xx       ", "       xx       ", "       xx       ", "       xx       ", "       xx       ", "     xxxxxx     ", "       xx       ", "                "};
    static String[] sourceAutoXY = new String[]{"                ", "                ", "       xx       ", "     xxxxxx     ", "       xx       ", "    x  xx  x    ", "   xx  xx  xx   ", "  xxxxxxxxxxxx  ", " xxxxxxxxxxxxxx ", "  xxxxxxxxxxxx  ", "   xx  xx  xx   ", "    x  xx  x    ", "       xx       ", "     xxxxxx     ", "       xx       ", "                "};
    static String[] sourceVoid = new String[]{"                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                ", "                "};
    Image image;

    public void setAutoRepeat(boolean bl) {
        this.autoRepeat = bl;
    }

    public boolean isAutoRepeat() {
        return this.autoRepeat;
    }

    public void setFireOnDown(boolean bl) {
        this.fireOnDown = bl;
    }

    public boolean isFireOnDown() {
        return this.fireOnDown;
    }

    public boolean isButtonEnabled() {
        return this.enabled;
    }

    public void setButtonEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.image = null;
            this.repaint();
        }
    }

    public PhyButton(String string) {
        this.addMouseListener(this);
        this.setButtonType(string);
    }

    public void setButtonType(String string) {
        this.actionCommand = string;
        this.initImage();
    }

    void initImage() {
        this.source = this.actionCommand.equals("PLAY") ? sourcePlay : (this.actionCommand.equals("PAUSE") ? sourcePause : (this.actionCommand.equals("NEXT") ? sourceNext : (this.actionCommand.equals("PREV") ? sourcePrev : (this.actionCommand.equals("PGUP") ? sourcePgup : (this.actionCommand.equals("PGDN") ? sourcePgdn : (this.actionCommand.equals("MINI_UP") ? sourceMiniUp : (this.actionCommand.equals("MINI_DOWN") ? sourceMiniDown : (this.actionCommand.equals("EXIT") ? sourceMiniExit : (this.actionCommand.equals("AUTO_X") ? sourceAutoX : (this.actionCommand.equals("AUTO_Y") ? sourceAutoY : (this.actionCommand.equals("AUTO_XY") ? sourceAutoXY : (this.actionCommand.equals("START") ? sourceVoid : sourcePlay))))))))))));
        this.hImage = this.source.length;
        this.wImage = this.source[0].length();
        this.image = null;
    }

    protected void buildImage() {
        Color color = this.getForeground();
        if (!this.isButtonEnabled()) {
            color = Color.gray;
        }
        int n = 0xFF000000 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        Color color2 = this.getBackground();
        int n2 = 0xFF000000 | color2.getRed() << 16 | color2.getGreen() << 8 | color2.getBlue();
        int[] nArray = new int[this.wImage * this.hImage];
        for (int i = 0; i < this.hImage; ++i) {
            for (int j = 0; j < this.wImage; ++j) {
                nArray[i * this.wImage + j] = this.source[i].charAt(j) == 'x' ? n : n2;
            }
        }
        this.image = this.getToolkit().createImage(new MemoryImageSource(this.wImage, this.hImage, nArray, 0, this.wImage));
    }

    public void paint(Graphics graphics) {
        if (this.image == null) {
            this.buildImage();
        }
        this.drawBorders(graphics);
        int n = (this.getSize().width - this.wImage) / 2 + 1;
        int n2 = (this.getSize().height - this.hImage) / 2;
        if (this.selected && this.isButtonEnabled()) {
            n += 2;
            n2 += 2;
        }
        graphics.drawImage(this.image, n, n2, this);
    }

    void drawBorders(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (!this.selected || !this.isButtonEnabled()) {
            graphics.setColor(Color.darkGray);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.fillRect(0, n2 - 2, n, 2);
        graphics.fillRect(n - 2, 0, 2, n2 - 2);
        if (this.selected && this.isButtonEnabled()) {
            graphics.setColor(Color.darkGray);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.setColor(this.getForeground());
    }

    public Dimension getPreferredSize() {
        if (this.wImage > 10) {
            return new Dimension(23, 23);
        }
        return new Dimension(this.wImage + 4, this.hImage + 4);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mouseDown) {
            this.selected = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseDown) {
            this.selected = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = true;
        this.selected = true;
        this.repaint();
        if (this.isAutoRepeat()) {
            this.startAutoRepeatThread();
        } else if (this.isFireOnDown()) {
            this.fireActionEvent();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selected && this.isButtonEnabled() && !this.isAutoRepeat() && !this.isFireOnDown()) {
            this.fireActionEvent();
        }
        this.mouseDown = false;
        this.selected = false;
        this.repaint();
    }

    public void mouseDown() {
        this.mouseDown = true;
        this.selected = true;
        this.repaint();
        if (this.isFireOnDown()) {
            this.fireActionEvent();
        }
    }

    public void mouseUp() {
        this.mouseDown = false;
        this.selected = false;
        this.repaint();
        if (!this.isFireOnDown()) {
            this.fireActionEvent();
        }
    }

    public synchronized void fireActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void startAutoRepeatThread() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        this.fireActionEvent();
        int n = 0;
        while (this.selected) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n > 6 && this.selected && this.isButtonEnabled()) {
                this.fireActionEvent();
            }
            ++n;
        }
    }
}

