/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.TabsPanelControl;
import phy.graphe.BufferedPanel;

public class TabsPanel
extends BufferedPanel
implements ActionListener {
    protected int tabCornerRadius = 0;
    protected CardLayout cardLayout = new CardLayout();
    protected BufferedPanel panelHolder = new BufferedPanel();
    protected TabsPanelControl panelControl = new TabsPanelControl();
    protected String currentPage = "";

    public void setTabCornerRadius(int n) {
        this.tabCornerRadius = n;
        if (this.tabCornerRadius > 0) {
            this.setBackgroundTransparent(true);
            this.panelHolder.setBackgroundTransparent(true);
        }
    }

    public TabsPanelControl getPanelControl() {
        return this.panelControl;
    }

    public Container getCurrentPanel() {
        return (Container)this.panelHolder.getComponent(this.panelControl.getCurrentTab());
    }

    public TabsPanel() {
        this(0);
    }

    public TabsPanel(int n) {
        this.panelControl.setSide(n);
        this.panelHolder.setLayout(this.cardLayout);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add((Component)this.panelHolder, "Center");
        if (n == 0) {
            this.add((Component)this.panelControl, "South");
        } else {
            this.add((Component)this.panelControl, "North");
        }
        this.panelControl.addActionListener(this);
    }

    public String getPage() {
        return this.currentPage;
    }

    public void setPage(String string) {
        this.cardLayout.show(this.panelHolder, string);
        this.panelControl.setPage(string);
        this.currentPage = string;
    }

    public void addPage(String string, Container container) {
        this.addPage(string, string, container);
    }

    public void addPage(String string, String string2, Container container) {
        this.panelHolder.add(string, container);
        this.panelControl.addTab(string, string2);
        if (container instanceof BufferedPanel) {
            ((BufferedPanel)container).setCornerRadius(this.tabCornerRadius);
            container.setName(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setPage(actionEvent.getActionCommand());
    }
}

