/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import phy.control.TabControl;
import phy.graphe.BufferedPanel;
import phy.util.ActionEventSupport;

public class TabsPanelControl
extends BufferedPanel {
    protected boolean enabled = true;
    protected boolean autoSwitch = false;
    protected int style = 0;
    protected int side = 0;
    protected Vector tab = new Vector();
    protected String current;
    protected int currentTab = 0;
    protected int widthTab = 10;
    protected ActionEventSupport actionEventSupport = new ActionEventSupport(this);
    protected int rollover = -1;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setAutoSwitch(boolean bl) {
        this.autoSwitch = bl;
    }

    public boolean isAutoSwitch() {
        return this.autoSwitch;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public void setSide(int n) {
        this.side = n;
    }

    public int getSide() {
        return this.side;
    }

    public int getCurrentTab() {
        return this.currentTab;
    }

    public void build() {
        BufferedPanel bufferedPanel;
        if (this.getParent() instanceof BufferedPanel && (bufferedPanel = (BufferedPanel)this.getParent()).isBackgroundTransparent()) {
            this.setBackgroundTransparent(true);
        }
        this.setMouseActive(true);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.getStyle() == 0 ? 18 : 30;
        return dimension;
    }

    public void addTab(String string) {
        this.addTab(string, string);
    }

    public void addTab(String string, String string2) {
        TabControl tabControl = new TabControl(string, string2);
        tabControl.setStyle(this.getStyle());
        tabControl.setSide(this.getSide());
        this.tab.addElement(tabControl);
        if (this.current == null) {
            this.setPage(string);
        }
    }

    protected TabControl getTabControl(int n) {
        return (TabControl)this.tab.elementAt(n);
    }

    public void setPage(String string) {
        this.current = string;
        this.repaint();
    }

    public void sizeHasChanged() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.tab.size(); ++n) {
            n2 = Math.max(n2, this.graphics.getStringWidth(((TabControl)this.tab.elementAt(n)).getText()));
        }
        this.widthTab = n2 + 20;
        for (n = 0; n < this.tab.size(); ++n) {
            TabControl tabControl = this.getTabControl(n);
            if (this.getStyle() == 0) {
                tabControl.setBorder(n * this.widthTab, -3, this.widthTab, this.getSize().height + 3);
            } else if (this.getStyle() == 1) {
                tabControl.setBorder(n * this.widthTab + 5, 4, this.widthTab, this.getSize().height - 12);
            }
            tabControl.setBackgroundColor(this.getBackground());
            tabControl.setBorderColor(Color.lightGray);
            tabControl.setBackgroundColor(Color.lightGray);
            tabControl.setBorderColor(Color.black);
        }
    }

    public void paintCore() {
        int n;
        int n2 = -1;
        for (n = 0; n < this.tab.size(); ++n) {
            TabControl tabControl = this.getTabControl(n);
            String string = tabControl.getName();
            if (string.equals(this.current)) {
                n2 = n;
                continue;
            }
            tabControl.paint(this.graphics.getGraphics(), false, n == this.rollover && this.isEnabled());
        }
        if (this.getStyle() == 1 && this.tab.size() > 0) {
            n = this.getTabControl((int)0).getBorder().y + this.getTabControl((int)0).getBorder().height - 1;
            this.graphics.getGraphics().setColor(Color.lightGray.brighter());
            this.graphics.getGraphics().drawLine(0, n, this.getWidth(), n);
        }
        if (n2 >= 0) {
            this.getTabControl(n2).paint(this.graphics.getGraphics(), true, this.rollover == n2 && this.isEnabled());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getX() / this.widthTab;
        if (n >= 0 && n < this.tab.size()) {
            this.currentTab = n;
            if (this.isAutoSwitch()) {
                this.setPage(this.getTabControl(n).getName());
            }
            this.actionEventSupport.fireActionEvent(this.getTabControl(n).getName());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.widthTab;
        this.rollover = n >= 0 && n < this.tab.size() ? n : -1;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.rollover = -1;
        this.repaint();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionEventSupport.addActionListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionEventSupport.removeActionListener(actionListener);
    }
}

