/*
 * Decompiled with CFR 0.152.
 */
package phy.dynaplot;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;

public class PlotDataSet {
    double[] xData;
    public double[][] zData = null;
    double[][] multipleX = null;
    public int nPoints;
    int nCurves;
    public String title = null;
    public String xLabel = null;
    public String yLabel = null;
    public boolean dataReady = false;
    InputStream is = null;
    Reader reader = null;
    StreamTokenizer st;
    int fileType;
    public int iPoint;
    protected boolean loadInProgress = false;

    public PlotDataSet(int n, int n2) {
        this.resize(n, n2);
    }

    public int getNCurves() {
        return this.nCurves;
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public boolean isLoadInProgress() {
        return this.loadInProgress;
    }

    public void resize(int n, int n2) {
        this.nPoints = n2;
        this.nCurves = n;
        if (n2 > 0) {
            this.xData = new double[n2];
            this.zData = new double[n][n2];
            this.FillX(0.0, 1.0);
            this.clear();
            this.dataReady = true;
        }
    }

    void closeFile() {
        try {
            if (this.is != null) {
                this.is.close();
            } else if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public PlotDataSet(InputStream inputStream) throws Exception {
        this.is = inputStream;
        this.st = new StreamTokenizer(new BufferedInputStream(inputStream, 4000));
        this.st.eolIsSignificant(true);
        this.st.commentChar(91);
        this.st.ordinaryChar(95);
        this.st.wordChars(32, 32);
        this.st.wordChars(39, 39);
        boolean bl = false;
        this.fileType = this.st.nextToken() == 64 ? 1 : 0;
    }

    public PlotDataSet(Reader reader) throws Exception {
        this.reader = reader;
        this.st = new StreamTokenizer(reader);
        this.st.eolIsSignificant(true);
        this.st.commentChar(91);
        this.st.ordinaryChar(95);
        this.st.wordChars(32, 32);
        this.st.wordChars(39, 39);
        boolean bl = false;
        this.fileType = this.st.nextToken() == 64 ? 1 : 0;
    }

    public void LoadFile(boolean bl) {
        this.loadInProgress = true;
        if (this.is != null || this.reader != null) {
            switch (this.fileType) {
                case 0: {
                    this.ReadPlainFile(this.st);
                    this.loadInProgress = false;
                    this.dataReady = true;
                    break;
                }
                case 1: {
                    this.ReadDataFile(this.st);
                    if (!bl) break;
                    while (this.ReadDataFileCore()) {
                    }
                    this.loadInProgress = false;
                    this.dataReady = true;
                }
            }
        }
    }

    void ReadDataFile(StreamTokenizer streamTokenizer) {
        boolean bl = false;
        try {
            this.title = "Ascii data file";
            if (streamTokenizer.nextToken() == -3 && streamTokenizer.sval.compareTo("ASCII") == 0) {
                while (streamTokenizer.nextToken() != 10) {
                }
                while (streamTokenizer.nextToken() != 64) {
                    if (streamTokenizer.ttype == -3) {
                        if (streamTokenizer.sval.compareTo("NPoints") == 0) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.nextToken() == -2) {
                                this.nPoints = (int)streamTokenizer.nval;
                            }
                        } else if (streamTokenizer.sval.compareTo("NCurves") == 0) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.nextToken() == -2) {
                                this.nCurves = (int)streamTokenizer.nval;
                            }
                        } else if (streamTokenizer.sval.compareTo("XTVector") == 0) {
                            streamTokenizer.nextToken();
                            if (streamTokenizer.nextToken() == -3 && streamTokenizer.sval.compareTo("True") == 0) {
                                bl = true;
                            }
                        } else if (streamTokenizer.sval.compareTo("Title") == 0) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            this.title = streamTokenizer.sval;
                        } else if (streamTokenizer.sval.compareTo("XLabel") == 0) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            this.xLabel = streamTokenizer.sval;
                        } else if (streamTokenizer.sval.compareTo("YLabel") == 0) {
                            streamTokenizer.nextToken();
                            streamTokenizer.nextToken();
                            this.yLabel = streamTokenizer.sval;
                        }
                        while (streamTokenizer.ttype != 10) {
                            streamTokenizer.nextToken();
                        }
                    }
                    while (streamTokenizer.ttype != 10) {
                        streamTokenizer.nextToken();
                    }
                }
                while (streamTokenizer.ttype != 10) {
                    streamTokenizer.nextToken();
                }
                if (bl) {
                    while (streamTokenizer.nextToken() != 10) {
                    }
                }
                this.xData = new double[this.nPoints];
                this.zData = new double[this.nCurves][this.nPoints];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.iPoint = 0;
    }

    public boolean ReadDataFileCore() {
        if (this.dataReady) {
            return false;
        }
        long l = System.currentTimeMillis();
        try {
            while (this.iPoint < this.nPoints && System.currentTimeMillis() < l + (long)100) {
                while (this.st.nextToken() != -2) {
                }
                this.xData[this.iPoint] = this.st.nval;
                for (int i = 0; i < this.nCurves; ++i) {
                    while (this.st.nextToken() != -2) {
                    }
                    this.zData[i][this.iPoint] = this.st.nval;
                }
                ++this.iPoint;
            }
            if (this.iPoint >= this.nPoints) {
                this.closeFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.iPoint >= this.nPoints) {
            this.loadInProgress = false;
            this.dataReady = true;
            return false;
        }
        return true;
    }

    void ReadPlainFile(StreamTokenizer streamTokenizer) {
        streamTokenizer.pushBack();
        this.nCurves = -1;
        this.nPoints = 0;
        int n = 1024;
        int n2 = 2048;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n2];
        double[][] dArray3 = null;
        try {
            int n3;
            block7: while (true) {
                switch (streamTokenizer.nextToken()) {
                    case -1: {
                        break block7;
                    }
                    default: {
                        break block7;
                    }
                    case -3: {
                        break block7;
                    }
                    case -2: {
                        dArray2[this.nPoints] = streamTokenizer.nval;
                        if (dArray3 == null) {
                            this.nCurves = 0;
                            while (streamTokenizer.nextToken() == -2) {
                                dArray[this.nCurves] = streamTokenizer.nval;
                                ++this.nCurves;
                            }
                            dArray3 = new double[this.nCurves][n2];
                            for (n3 = 0; n3 < this.nCurves; ++n3) {
                                dArray3[n3][0] = dArray[n3];
                            }
                        } else {
                            n3 = 0;
                            while (streamTokenizer.nextToken() == -2) {
                                if (n3 >= this.nCurves) {
                                    n3 = -1;
                                    break;
                                }
                                dArray3[n3][this.nPoints] = streamTokenizer.nval;
                                ++n3;
                            }
                            if (n3 != this.nCurves) break block7;
                        }
                        ++this.nPoints;
                        continue block7;
                    }
                }
                break;
            }
            this.xData = new double[this.nPoints];
            this.zData = new double[this.nCurves][this.nPoints];
            for (n3 = 0; n3 < this.nPoints; ++n3) {
                this.xData[n3] = dArray2[n3];
                for (int i = 0; i < this.nCurves; ++i) {
                    this.zData[i][n3] = dArray3[i][n3];
                }
            }
            this.closeFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double X(int n) {
        return this.xData[n];
    }

    public double X(int n, int n2) {
        if (this.multipleX == null) {
            return this.xData[n2];
        }
        return this.multipleX[n][n2];
    }

    public double Z(int n, int n2) {
        return this.zData[n][n2];
    }

    public void FillX(double d, double d2) {
        for (int i = 0; i < this.nPoints; ++i) {
            this.xData[i] = d + (d2 - d) * (double)i / (double)(this.nPoints - 1);
        }
    }

    public void clear() {
        for (int i = 0; i < this.nCurves; ++i) {
            for (int j = 0; j < this.nPoints; ++j) {
                this.zData[i][j] = 0.0;
            }
        }
    }
}

