/*
 * Decompiled with CFR 0.152.
 */
package phy.dynaplot;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import phy.dynaplot.PlotDataSet;
import phy.graphe.BufferedPanel;
import phy.util.DoublePoint;
import phy.util.MathTools;
import phy.util.PhysicApplet;

public class PlotWindow
extends BufferedPanel {
    public String xLabel = "";
    public String yLabel = "";
    public String title = "";
    public PlotDataSet dataSet = null;
    boolean useMouse = false;
    int currentCurve = 0;
    double animationIndex = 0.0;
    boolean paintAbout = false;
    public int sleepTime = 100;
    public int endTime = 0;
    public boolean autoscaleUponLoading = true;
    protected boolean showAxis = true;
    String message = null;
    public boolean running = false;
    boolean firstTime = true;
    double xx1;
    double xx2;
    int nTicksX = 11;
    int nTicksY = 11;
    boolean imageValid = false;
    boolean shouldRepaintInside = false;
    boolean initialized = false;
    protected Point anchor;
    boolean newData = false;
    long lastTime;
    public boolean realTime = false;
    public double step;
    public boolean loadInProgress = false;
    public String prefix = "";
    public String suffix = "";
    public double scaleFactor = 1.0;
    public double scaleDisplay = 1.0;
    int lastPointX = 0;
    int lastPointY = 0;
    boolean curvePainted = false;
    boolean showCurves = true;
    int style = 0;
    protected boolean thickLine = false;

    public boolean isCurvePainted() {
        return this.curvePainted;
    }

    public void setCurvePainted(boolean bl) {
        this.curvePainted = bl;
    }

    public void setShowCurves(boolean bl) {
        this.showCurves = bl;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public void setThickLine(boolean bl) {
        this.thickLine = bl;
    }

    public boolean isThickLine() {
        return this.thickLine;
    }

    boolean dataReady() {
        if (this.dataSet == null) {
            return false;
        }
        return this.dataSet.dataReady;
    }

    public void UseMouse() {
        this.useMouse = true;
    }

    public PlotWindow() {
        this.graphics.setLeftMargin(40);
        this.graphics.setRightMargin(20);
        this.graphics.setBottomMargin(35);
        this.graphics.setTopMargin(20);
    }

    public PlotWindow(PlotDataSet plotDataSet) {
        this();
        this.dataSet = plotDataSet;
    }

    public void setDataSet(PlotDataSet plotDataSet) {
        this.dataSet = plotDataSet;
        this.newData = true;
        if (this.dataSet != null && this.dataSet.dataReady) {
            this.updateDataSet();
        }
    }

    public void updateDataSet() {
        if (this.dataSet == null) {
            return;
        }
        if (this.autoscaleUponLoading) {
            this.computeAutoXY();
        }
        if (this.dataSet.title != null) {
            this.title = this.dataSet.title;
        }
        if (this.dataSet.xLabel != null) {
            this.xLabel = this.dataSet.xLabel;
        }
        if (this.dataSet.yLabel != null) {
            this.yLabel = this.dataSet.yLabel;
        }
        this.sizeHasChanged();
    }

    public void computeAutoX() {
        double d;
        double d2 = d = this.dataSet.X(0);
        for (int i = 0; i < this.dataSet.nPoints; ++i) {
            d = Math.min(d, this.dataSet.X(i));
            d2 = Math.max(d2, this.dataSet.X(i));
        }
        this.graphics.setWindow(d, this.graphics.getY1(), d2, this.graphics.getY2());
    }

    public void computeAutoY() {
        double d = 1.0E30;
        double d2 = -1.0E30;
        for (int i = 0; i < this.dataSet.nPoints; ++i) {
            if (!(this.dataSet.X(i) > Math.min(this.graphics.getX1(), this.graphics.getX2())) || !(this.dataSet.X(i) < Math.max(this.graphics.getX1(), this.graphics.getX2()))) continue;
            for (int j = 0; j < this.dataSet.nCurves; ++j) {
                d = Math.min(d, this.dataSet.Z(j, i));
                d2 = Math.max(d2, this.dataSet.Z(j, i));
            }
        }
        this.graphics.setWindow(this.graphics.getX1(), d, this.graphics.getX2(), d2);
    }

    void computeAutoXY() {
        double d;
        double d2;
        double d3 = d2 = this.dataSet.X(0);
        double d4 = d = this.dataSet.Z(0, 0);
        for (int i = 0; i < this.dataSet.nPoints; ++i) {
            d2 = Math.min(d2, this.dataSet.X(i));
            d3 = Math.max(d3, this.dataSet.X(i));
            for (int j = 0; j < this.dataSet.nCurves; ++j) {
                d = Math.min(d, this.dataSet.Z(j, i));
                d4 = Math.max(d4, this.dataSet.Z(j, i));
            }
        }
        this.graphics.setWindow(d2, d, d3, d4);
    }

    public double getXMin() {
        return this.graphics.getX1();
    }

    public double getXMax() {
        return this.graphics.getX2();
    }

    public double getYMin() {
        return this.graphics.getY1();
    }

    public double getYMax() {
        return this.graphics.getY2();
    }

    public void AutoXY() {
        this.computeAutoXY();
        this.refresh();
    }

    public void AutoX() {
        this.computeAutoX();
        this.refresh();
    }

    public void AutoY() {
        this.computeAutoY();
        this.refresh();
    }

    public void paintCore() {
        if (!this.dataReady() && this.dataSet != null) {
            this.graphics.setColor(this.getBackground());
            this.graphics.setColor(this.getForeground());
            this.graphics.getGraphics().drawString(PhysicApplet.getWord("PleaseWait"), 20, 50);
            this.graphics.getGraphics().drawRect(20, this.getHeight() / 2 - 11, this.getWidth() - 40 + 1, 21);
            this.graphics.setColor(Color.blue);
            this.graphics.getGraphics().fillRect(21, this.getHeight() / 2 - 10, (int)((double)this.dataSet.iPoint / (double)this.dataSet.nPoints * (double)(this.getWidth() - 40)), 20);
            return;
        }
        if (this.showAxis) {
            this.graphics.setColor(this.getForeground());
            this.graphics.drawStringRBPixel(this.title, this.graphics.getXVuport() + this.graphics.getWVuport(), this.graphics.getYVuport() - 4);
            this.graphics.drawStringCBPixel(this.xLabel, this.graphics.getXVuport() + this.graphics.getWVuport() / 2, this.getHeight() - 4);
            this.graphics.getGraphics().drawString(this.yLabel, this.graphics.getXVuport(), this.graphics.getYVuport() - 4);
            this.plotXAxis();
            this.plotYAxis();
        }
        this.paintCorePlot();
        this.imageValid = true;
        this.shouldRepaintInside = false;
        if (this.isMouseDown() && this.useMouse) {
            this.graphics.getGraphics().drawRect(Math.min(this.anchor.x, this.getXMouse()), Math.min(this.anchor.y, this.getYMouse()), Math.abs(this.getXMouse() - this.anchor.x), Math.abs(this.getYMouse() - this.anchor.y));
        }
    }

    protected void plotXAxis() {
        for (int i = 0; i < this.nTicksX; ++i) {
            double d = this.getXMin() + (this.getXMax() - this.getXMin()) * (double)i / (double)(this.nTicksX - 1);
            d = (double)Math.round(d * (double)100) / 100.0;
            int n = this.graphics.getXVuport() + this.graphics.getWVuport() * i / (this.nTicksX - 1);
            String string = MathTools.formatte(d, 1);
            this.graphics.drawStringCTPixel(string, n, this.graphics.getYVuport() + this.graphics.getHVuport() + 2);
        }
    }

    protected void plotYAxis() {
        for (int i = 0; i < this.nTicksY; ++i) {
            double d = this.getYMin() + (this.getYMax() - this.getYMin()) * (double)i / (double)(this.nTicksY - 1);
            d = (double)Math.round(d * (double)100) / 100.0;
            int n = this.graphics.getYVuport() + this.graphics.getHVuport() - this.graphics.getHVuport() * i / (this.nTicksY - 1);
            String string = MathTools.formatte(d);
            this.graphics.drawStringRCPixel(string, this.graphics.getXVuport() - 3, n);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.anchor = new Point(this.getXMouse(), this.getYMouse());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.useMouse) {
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        double d;
        super.mouseReleased(mouseEvent);
        if (!this.useMouse) {
            return;
        }
        double d2 = this.xUser(this.anchor.x);
        double d3 = this.xUser(this.getXMouse());
        double d4 = this.yUser(this.anchor.y);
        if (d4 > (d = this.yUser(this.getYMouse()))) {
            double d5 = d4;
            d4 = d;
            d = d5;
        }
        d2 = Math.max(d2, Math.min(this.getXMin(), this.getXMax()));
        d2 = Math.min(d2, Math.max(this.getXMin(), this.getXMax()));
        d3 = Math.max(d3, Math.min(this.getXMin(), this.getXMax()));
        d3 = Math.min(d3, Math.max(this.getXMin(), this.getXMax()));
        d4 = Math.max(d4, Math.min(this.getYMin(), this.getYMax()));
        d4 = Math.min(d4, Math.max(this.getYMin(), this.getYMax()));
        d = Math.max(d, Math.min(this.getYMin(), this.getYMax()));
        d = Math.min(d, Math.max(this.getYMin(), this.getYMax()));
        if (d2 != d3 && d4 != d) {
            this.graphics.setWindow(d2, d4, d3, d);
            this.refresh();
        }
    }

    public void sizeHasChanged() {
        if (this.graphics.getWVuport() > 20) {
            this.nTicksX = this.idealNTicks(this.getXMin(), this.getXMax(), this.graphics.getWVuport() / 50);
            this.graphics.setXAxis(this.xx1, this.xx2);
            this.nTicksY = this.idealNTicks(this.getYMin(), this.getYMax(), this.graphics.getHVuport() / 30);
            this.graphics.setYAxis(this.xx1, this.xx2);
        }
    }

    public void paintCorePlot() {
        if (this.dataSet != null && this.showCurves) {
            switch (this.style) {
                case 0: 
                case 2: {
                    for (int i = 0; i < this.dataSet.nCurves; ++i) {
                        this.paintCurve(i);
                    }
                    break;
                }
                case 1: {
                    this.paintCurve(this.currentCurve);
                    this.graphics.setColor(this.getForeground());
                    this.graphics.setColor(Color.yellow);
                    this.graphics.drawString(String.valueOf(String.valueOf(String.valueOf(this.prefix).concat(String.valueOf(MathTools.formatte(this.animationIndex * this.scaleFactor, 1, 4)))).concat(String.valueOf(this.suffix))).concat(String.valueOf(" ")), new DoublePoint(this.graphics.getX2(), this.graphics.getY2()), 5);
                }
            }
        }
        if (this.showAxis) {
            this.graphics.setColor(this.getForeground());
            this.plotXTicks();
            this.plotYTicks();
            this.graphics.getGraphics().drawRect(this.graphics.getXVuport(), this.graphics.getYVuport(), this.graphics.getWVuport(), this.graphics.getHVuport());
        }
    }

    public boolean setCurveColor(int n) {
        int n2 = n % 6;
        if (this.style == 1 || this.style == 2) {
            n2 = 0;
        }
        switch (n2) {
            case 0: {
                this.graphics.setColor(Color.yellow);
                break;
            }
            case 1: {
                this.graphics.setColor(Color.blue);
                break;
            }
            case 2: {
                this.graphics.setColor(Color.orange);
                break;
            }
            case 3: {
                this.graphics.setColor(Color.magenta);
                break;
            }
            case 4: {
                this.graphics.setColor(Color.cyan);
                break;
            }
            case 5: {
                this.graphics.setColor(Color.green);
            }
        }
        return true;
    }

    void paintCurve(int n) {
        if (!this.setCurveColor(n)) {
            return;
        }
        double d = this.animationIndex - Math.floor(this.animationIndex);
        if (d == 0.0) {
            if (this.curvePainted) {
                double[] dArray = new double[this.dataSet.nPoints];
                double[] dArray2 = new double[this.dataSet.nPoints];
                for (int i = 0; i < this.dataSet.nPoints; ++i) {
                    dArray[i] = this.dataSet.X(i);
                    dArray2[i] = this.dataSet.Z(n, i);
                }
                this.graphics.fillPolygon(dArray, dArray2);
            } else {
                for (int i = 1; i < this.dataSet.nPoints; ++i) {
                    if (this.isThickLine()) {
                        this.graphics.drawLineThick(this.dataSet.X(i - 1), this.dataSet.Z(n, i - 1), this.dataSet.X(i), this.dataSet.Z(n, i));
                        continue;
                    }
                    this.graphics.drawLine(this.dataSet.X(i - 1), this.dataSet.Z(n, i - 1), this.dataSet.X(i), this.dataSet.Z(n, i));
                }
            }
        } else {
            for (int i = 1; i < this.dataSet.nPoints; ++i) {
                if (this.isThickLine()) {
                    this.graphics.drawLineThick(this.dataSet.X(i - 1), this.dataSet.Z(n, i - 1) * (1.0 - d) + this.dataSet.Z(n + 1, i - 1) * d, this.dataSet.X(i), this.dataSet.Z(n, i) * (1.0 - d) + this.dataSet.Z(n + 1, i) * d);
                    continue;
                }
                this.graphics.drawLine(this.dataSet.X(i - 1), this.dataSet.Z(n, i - 1) * (1.0 - d) + this.dataSet.Z(n + 1, i - 1) * d, this.dataSet.X(i), this.dataSet.Z(n, i) * (1.0 - d) + this.dataSet.Z(n + 1, i) * d);
            }
        }
    }

    protected void plotXTicks() {
        for (int i = 0; i < this.nTicksX; ++i) {
            int n = this.graphics.getXVuport() + this.graphics.getWVuport() * i / (this.nTicksX - 1);
            this.graphics.getGraphics().drawLine(n, this.graphics.getYVuport() + this.graphics.getHVuport() - 1, n, this.graphics.getYVuport() + this.graphics.getHVuport() - 6);
        }
    }

    protected void plotYTicks() {
        for (int i = 0; i < this.nTicksY; ++i) {
            int n = this.yScreen(this.getYMin() + (this.getYMax() - this.getYMin()) * (double)i / ((double)this.nTicksY - 1.0));
            this.graphics.getGraphics().drawLine(this.graphics.getXVuport(), n, this.graphics.getXVuport() + 6, n);
        }
    }

    int idealNTicks(double d, double d2, int n) {
        double d3;
        double[] dArray = new double[]{0.05, 0.1, 0.2, 0.25, 0.5, 1.0, 2.0, 2.5, 5.0, 10.0};
        double d4 = d2 - d;
        int n2 = 11;
        double d5 = Math.pow(10.0, Math.log(Math.abs(d4)) / Math.log(10.0) - Math.floor((Math.log(Math.abs(d4)) - Math.log(1.2)) / Math.log(10.0)));
        int n3 = 0;
        double d6 = (double)10 * Math.abs((d2 -= d4 / (double)1000) - (d += d4 / (double)1000));
        for (int i = 0; i < 10; ++i) {
            d3 = dArray[i] * d4 / d5;
            this.xx1 = Math.floor(d / Math.abs(d3)) * Math.abs(d3);
            this.xx2 = Math.floor(d2 / Math.abs(d3)) * Math.abs(d3);
            if (d4 > 0.0) {
                this.xx2 += d3;
            } else {
                this.xx1 -= d3;
            }
            n2 = (int)Math.abs((this.xx2 - this.xx1) / d3 + 0.2) + 1;
            if (n2 > n || !(Math.abs(this.xx2 - this.xx1) < d6)) continue;
            n3 = i;
            d6 = Math.abs(this.xx2 - this.xx1);
        }
        d3 = dArray[n3] * d4 / d5;
        this.xx1 = Math.floor(d / Math.abs(d3)) * Math.abs(d3);
        this.xx2 = Math.floor(d2 / Math.abs(d3)) * Math.abs(d3);
        if (d4 > 0.0) {
            this.xx2 += d3;
        } else {
            this.xx1 -= d3;
        }
        n2 = (int)Math.abs((this.xx2 - this.xx1) / d3 + 0.2) + 1;
        return n2;
    }

    public void invalidateImage() {
        this.imageValid = false;
    }

    public void refresh() {
        this.invalidateImage();
        this.repaint();
    }

    void repaintInside() {
        this.shouldRepaintInside = true;
        this.repaint();
    }

    void nextCurve() {
        ++this.currentCurve;
        if (this.currentCurve >= this.dataSet.nCurves) {
            this.currentCurve = 0;
        }
    }

    public void rewind() {
        this.currentCurve = 0;
        this.animationIndex = 0.0;
    }

    void nextFrame(double d) {
        this.animationIndex += d;
        this.currentCurve = (int)Math.floor(this.animationIndex);
        if (this.animationIndex > (double)(this.dataSet.nCurves - 1)) {
            this.rewind();
        }
    }

    public void setAnimationIndex(double d) {
        this.animationIndex = Math.min(d, (double)(this.dataSet.nCurves - 1));
        this.currentCurve = (int)Math.floor(this.animationIndex);
    }

    public void setFrame(double d) {
        this.animationIndex = d;
        this.currentCurve = (int)Math.floor(this.animationIndex);
        if (this.animationIndex > (double)(this.dataSet.nCurves - 1)) {
            this.rewind();
        }
    }
}

