/*
 * Decompiled with CFR 0.152.
 */
package phy.function;

import phy.function.CurveInterface;
import phy.function.Function;
import phy.util.DoublePoint;

public class Curve
implements CurveInterface {
    protected double[] xArray;
    double[] yArray;
    protected int nPoints;
    protected Function function;

    public double[] getXArray() {
        return this.xArray;
    }

    public double[] getYArray() {
        return this.yArray;
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public void setNPoints(int n) {
        if (n != this.nPoints) {
            this.nPoints = n;
            this.xArray = new double[n];
            this.yArray = new double[n];
        }
    }

    public void setFunction(Function function) {
        this.function = function;
        this.refresh();
    }

    public Function getFunction() {
        return this.function;
    }

    public double getX(int n) {
        return this.xArray[n];
    }

    public double getY(int n) {
        return this.yArray[n];
    }

    public void setY(int n, double d) {
        this.yArray[n] = d;
    }

    public DoublePoint getPoint(int n) {
        return new DoublePoint(this.getX(n), this.getY(n));
    }

    public void calibrate(double d, double d2) {
        for (int i = 0; i < this.nPoints; ++i) {
            this.xArray[i] = d + (double)i * (d2 - d) / (double)(this.nPoints - 1);
            this.yArray[i] = 0.0;
        }
        this.refresh();
    }

    public double getMaxY() {
        if (this.getNPoints() == 0) {
            return 0.0;
        }
        double d = this.getY(0);
        for (int i = 1; i < this.getNPoints(); ++i) {
            d = Math.max(d, this.getY(i));
        }
        return d;
    }

    public double getMinY() {
        if (this.getNPoints() == 0) {
            return 0.0;
        }
        double d = this.getY(0);
        for (int i = 1; i < this.getNPoints(); ++i) {
            d = Math.min(d, this.getY(i));
        }
        return d;
    }

    public boolean isAvailable(int n) {
        return n >= 0 && n < this.getNPoints();
    }

    public void refresh() {
        if (this.function != null) {
            for (int i = 0; i < this.nPoints; ++i) {
                this.yArray[i] = this.function.getValue(this.getX(i));
            }
        }
    }

    public Curve() {
    }

    public Curve(int n, double d, double d2) {
        this();
        this.setNPoints(n);
        this.calibrate(d, d2);
    }
}

