/*
 * Decompiled with CFR 0.152.
 */
package phy.function;

import phy.function.Function;
import phy.util.MathTools;

public class HyperGaussian
implements Function {
    protected double a = 1.0;
    protected double b = 0.0;
    protected int n = 1;
    protected double x0 = 1.0;

    public void setA(double d) {
        this.a = d;
    }

    public void setB(double d) {
        this.b = d;
    }

    public void setN(int n) {
        this.n = n;
    }

    public void setX0(double d) {
        this.x0 = d;
    }

    public HyperGaussian() {
    }

    public HyperGaussian(int n, double d) {
        this();
        this.setN(n);
        this.setX0(d);
    }

    public HyperGaussian(int n, double d, double d2) {
        this(n, d);
        this.setA(d2);
    }

    public HyperGaussian(int n, double d, double d2, double d3) {
        this(n, d);
        this.setA(d2);
        this.setB(d3);
    }

    public double getValue(double d) {
        return this.a * Math.exp(-Math.pow(MathTools.sqr(d / this.x0), this.n)) + this.b;
    }
}

