/*
 * Decompiled with CFR 0.152.
 */
package phy.function;

import phy.function.Function;

public class TabulatedFunction
implements Function {
    protected double xMin = 0.0;
    protected double xMax = 1.0;
    protected int nPoints = 100;
    protected double[] data;
    protected int iSearch = 0;

    public int getNPoints() {
        return this.nPoints;
    }

    public double getStep() {
        return (this.xMax - this.xMin) / (double)(this.nPoints - 1);
    }

    public void setData(int n, double d) {
        this.data[n] = d;
    }

    public double getData(int n) {
        return this.data[n];
    }

    public double getX(int n) {
        return (double)n / ((double)this.nPoints - 1.0) * (this.xMax - this.xMin) + this.xMin;
    }

    public TabulatedFunction(int n, double d, double d2) {
        this.nPoints = n;
        this.data = new double[n];
        this.xMin = d;
        this.xMax = d2;
    }

    public double getValue(double d) {
        double d2 = (d - this.xMin) / (this.xMax - this.xMin) * (double)(this.nPoints - 1);
        if (d2 < 0.0) {
            return this.data[0];
        }
        if (d2 > (double)(this.nPoints - 1)) {
            return this.data[this.nPoints - 1];
        }
        int n = (int)Math.floor(d2);
        double d3 = d2 - (double)n;
        return (1.0 - d3) * this.data[n] + d3 * this.data[n + 1];
    }

    public void integrate() {
        double d = this.data[0];
        this.data[0] = 0.0;
        for (int i = 1; i < this.nPoints; ++i) {
            double d2 = this.data[i - 1] + d * this.getStep();
            d = this.data[i];
            this.data[i] = d2;
        }
    }

    public void mul(double d) {
        int n = 0;
        while (n < this.nPoints) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * d;
        }
    }

    public double searchX(double d) {
        if (d < 0.0) {
            return this.getX(0);
        }
        if (d >= 1.0) {
            return this.getX(this.nPoints - 1);
        }
        if (this.getData(this.iSearch) > d) {
            System.out.println("WARNING : Reset search in TabulatedFunction");
            this.iSearch = 0;
        }
        while (this.iSearch + 1 < this.nPoints && this.getData(this.iSearch + 1) < d) {
            ++this.iSearch;
        }
        double d2 = this.getX(this.iSearch);
        double d3 = this.getX(this.iSearch + 1);
        double d4 = this.getData(this.iSearch);
        double d5 = this.getData(this.iSearch + 1);
        return d2 + (d3 - d2) * (d - d4) / (d5 - d4);
    }
}

