/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Vector;
import phy.acq.DataObservable;
import phy.acq.DataObserver;
import phy.acq.ParamSupport;
import phy.acq.PhyBean;
import phy.control.HotCross;
import phy.control.HotSlope;
import phy.control.HotSpot;
import phy.control.HotSpotVector;
import phy.control.TabsPanel;
import phy.graphe.DrawableObject;
import phy.graphe.ImageSet;
import phy.graphe.PhyGraphics;
import phy.util.AbsoluteLayout;
import phy.util.ActionEventSupport;
import phy.util.CrackedString;
import phy.util.FileToolkit;
import phy.util.MathTools;
import phy.util.PhyTools;
import phy.util.PhysicApplet;
import phy.util.Point3D;
import phy.util.RotationMatrix;
import phy.util.TimeEvent;

public class BufferedPanel
extends Panel
implements MouseListener,
MouseMotionListener,
ActionListener,
PhyBean,
DataObserver {
    protected int inset = 0;
    protected Image backImage;
    protected String cornerFileName;
    protected ImageSet cornerImageSet;
    protected boolean doubleBuffering = true;
    protected Image offscreenImage = null;
    public PhyGraphics graphics = new PhyGraphics();
    protected Point origin = new Point(0, 0);
    Vector graphicsVector = new Vector();
    protected Hashtable flagTable = new Hashtable();
    protected Font defaultFont = PhysicApplet.getDefaultFont();
    protected Vector vectorDrawableObjects = new Vector();
    protected Vector vectorNameObjects = new Vector();
    protected Vector vectorPositionObjects = new Vector();
    protected int cornerRadius = 0;
    Image backgroundImage = null;
    public PhyGraphics backgroundGraphics;
    protected boolean backgroundInUse = false;
    protected boolean backgroundTransparent = false;
    protected boolean mouseActive = true;
    protected boolean mouse3D = false;
    protected double rotationAngleX = 0.0;
    protected double rotationAngleY = 0.0;
    protected boolean mouseRemote = false;
    protected Image imageMouseRemote;
    protected int xMouse = -1;
    private int xMousePressed = -1;
    protected int yMouse = -1;
    private int yMousePressed = -1;
    protected Point prevMousePoint;
    private boolean flagMouseDown = false;
    boolean helpMode = false;
    HotSpotVector hotSpotVector = new HotSpotVector();
    int currentHotSpot = -1;
    protected boolean sizeBeingChanged = true;
    protected boolean neverPainted = true;
    protected boolean altDown = false;
    protected boolean controlDown = false;
    protected boolean shiftDown = false;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    ActionEventSupport actionEventSupport = new ActionEventSupport(this);

    public void setInset(int n) {
        this.inset = n;
    }

    public int getInset() {
        return this.inset;
    }

    public Insets getInsets() {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    public void setBackImage(Image image) {
        this.backImage = image;
    }

    public Image getBackImage() {
        return this.backImage;
    }

    public void setCornerFileName(String string) {
        this.cornerFileName = string;
    }

    public String getCornerFileName() {
        return this.cornerFileName;
    }

    public boolean isDoubleBuffering() {
        return this.doubleBuffering;
    }

    public void setDoubleBuffering(boolean bl) {
        this.doubleBuffering = bl;
    }

    public PhyGraphics getPhyGraphics() {
        return this.graphics;
    }

    public void setPhyGraphics(PhyGraphics phyGraphics) {
        this.graphics = phyGraphics;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public int getXOrigin() {
        return this.getOrigin().x;
    }

    public int getYOrigin() {
        return this.getOrigin().y;
    }

    public void setOrigin(Point point) {
        this.origin = point;
    }

    public PhyGraphics getGraphics(int n) {
        if (n == 0) {
            return this.graphics;
        }
        for (int i = this.graphicsVector.size(); i < n; ++i) {
            this.graphicsVector.addElement(new PhyGraphics());
        }
        return (PhyGraphics)this.graphicsVector.elementAt(n - 1);
    }

    public int getNGraphics() {
        return this.graphicsVector.size() + 1;
    }

    public void setFlag(String string) {
        if (!this.flagTable.containsKey(string)) {
            this.flagTable.put(string, new Object());
        }
    }

    public void setFlags(String string) {
        CrackedString crackedString = new CrackedString(string, ',');
        for (int i = 0; i < crackedString.getNFields(); ++i) {
            this.setFlag(crackedString.getField(i).trim());
        }
    }

    public void clearFlag(String string) {
        if (this.flagTable.containsKey(string)) {
            this.flagTable.remove(string);
        }
    }

    public void clearFlags(String string) {
        CrackedString crackedString = new CrackedString(string, ',');
        for (int i = 0; i < crackedString.getNFields(); ++i) {
            this.clearFlag(crackedString.getField(i).trim());
        }
    }

    public void clearFlags() {
        this.flagTable.clear();
    }

    public boolean isFlagSet(String string) {
        return this.flagTable.containsKey(string);
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public int getNDrawableObjects() {
        return this.vectorDrawableObjects.size();
    }

    public DrawableObject getDrawableObject(int n) {
        return (DrawableObject)this.vectorDrawableObjects.elementAt(n);
    }

    public int getPositionDrawableObject(int n) {
        return (Integer)this.vectorPositionObjects.elementAt(n);
    }

    public void addDrawableObject(DrawableObject drawableObject) {
        this.addDrawableObject(null, drawableObject);
    }

    public void addDrawableObject(DrawableObject drawableObject, int n) {
        this.addDrawableObject(null, drawableObject, n);
    }

    public void addDrawableObject(String string, DrawableObject drawableObject) {
        this.addDrawableObject(string, drawableObject, 0);
    }

    public void addDrawableObject(String string, DrawableObject drawableObject, Color color) {
        this.addDrawableObject(string, drawableObject);
        drawableObject.setColor(color);
    }

    public void addDrawableObject(String string, DrawableObject drawableObject, int n) {
        this.vectorDrawableObjects.addElement(drawableObject);
        this.vectorPositionObjects.addElement(new Integer(n));
        if (string != null) {
            this.vectorNameObjects.addElement(string.intern());
            this.setFlag(string.intern());
        } else {
            this.vectorNameObjects.addElement(null);
        }
    }

    public void removeAllDrawableObjects() {
        this.vectorDrawableObjects.removeAllElements();
        this.vectorPositionObjects.removeAllElements();
        this.vectorNameObjects.removeAllElements();
    }

    public boolean isObjectVisible(int n) {
        Object e = this.vectorNameObjects.elementAt(n);
        return e == null || this.isFlagSet((String)e);
    }

    public void setCornerRadius(int n) {
        this.cornerRadius = n;
        if (this.cornerRadius > 0) {
            this.setBackgroundTransparent(true);
        }
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public void setBackgroundInUse(boolean bl) {
        this.backgroundInUse = bl;
    }

    public boolean isBackgroundInUse() {
        return this.backgroundInUse;
    }

    public void setBackgroundTransparent(boolean bl) {
        this.backgroundTransparent = bl;
    }

    public boolean isBackgroundTransparent() {
        return this.backgroundTransparent;
    }

    public void setMouseActive(boolean bl) {
        this.mouseActive = bl;
        if (this.isMouseActive()) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
            if (this.currentHotSpot >= 0) {
                this.currentHotSpot = -1;
                this.repaint();
            }
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
            ((BufferedPanel)this.getComponent(i)).setMouseActive(bl);
        }
    }

    public boolean isMouseActive() {
        return this.mouseActive && !this.isMouseRemote();
    }

    public void setLightSourcePosition(Point3D point3D) {
        this.graphics.setLightSourcePosition(point3D);
    }

    public void setMouse3D(boolean bl) {
        this.mouse3D = bl;
        this.setMouseActive(true);
    }

    public boolean isMouse3D() {
        return this.mouse3D;
    }

    public void setRotationAngleX(double d) {
        this.rotationAngleX = d;
    }

    public double getRotationAngleX() {
        return this.rotationAngleX;
    }

    public void setRotationAngleY(double d) {
        this.rotationAngleY = d;
    }

    public double getRotationAngleY() {
        return this.rotationAngleY;
    }

    public void xRotateDeg(double d) {
        this.graphics.getRotationMatrix().xRotate(d * Math.PI / (double)180);
    }

    public void yRotateDeg(double d) {
        this.graphics.getRotationMatrix().yRotate(d * Math.PI / (double)180);
    }

    public void clearRotation() {
        this.graphics.getRotationMatrix().init();
        this.setRotationAngleX(0.0);
        this.setRotationAngleY(0.0);
    }

    public void setMouseRotationX(double d) {
        this.actionPerformed(new ActionEvent(this, 1001, String.valueOf("ROTATE X ").concat(String.valueOf(d))));
    }

    public void setMouseRotationY(double d) {
        this.actionPerformed(new ActionEvent(this, 1001, String.valueOf("ROTATE Y ").concat(String.valueOf(d))));
    }

    public void setMouseRemote(boolean bl) {
        this.mouseRemote = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
            ((BufferedPanel)this.getComponent(i)).setMouseRemote(bl);
        }
    }

    public boolean isMouseRemote() {
        return this.mouseRemote;
    }

    public void remoteMouseOff() {
        this.mouseReleased();
        this.setMouseRemote(false);
    }

    public void setXMouse(int n) {
        this.xMouse = n;
        this.updateMouseComponents();
    }

    public int getXMouse() {
        return this.xMouse;
    }

    public int getXMousePressed() {
        return this.xMousePressed;
    }

    public int getYMousePressed() {
        return this.yMousePressed;
    }

    public void setYMouse(int n) {
        this.yMouse = n;
        this.updateMouseComponents();
    }

    public int getYMouse() {
        return this.yMouse;
    }

    public void setXYMouse(int n, int n2) {
        this.xMouse = n;
        this.yMouse = n2;
        this.updateMouseComponents();
    }

    protected void updateMouseComponents() {
        if (this.isMouseRemote()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
                BufferedPanel bufferedPanel = (BufferedPanel)this.getComponent(i);
                bufferedPanel.setXYMouse(this.getXMouse() - bufferedPanel.getBounds().x, this.getYMouse() - bufferedPanel.getBounds().y);
            }
        }
    }

    public Point getMousePoint() {
        return new Point(this.getXMouse(), this.getYMouse());
    }

    public Point getMousePressedPoint() {
        return new Point(this.xMousePressed, this.yMousePressed);
    }

    public void setPrevMousePoint(Point point) {
        this.prevMousePoint = point;
    }

    public Point getPrevMousePoint() {
        return this.prevMousePoint;
    }

    public boolean isMouseDown() {
        return this.flagMouseDown;
    }

    public void setHelpMode(boolean bl) {
        System.out.println("helpMode disapproved");
        if (bl != this.helpMode) {
            this.helpMode = bl;
            this.repaint();
        }
    }

    public boolean getHelpMode() {
        return this.helpMode;
    }

    public BufferedPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(new AbsoluteLayout());
    }

    public int getCurrentHotSpotIndex() {
        return this.currentHotSpot;
    }

    public void setCurrentHotSpotIndex(int n) {
        this.currentHotSpot = n;
    }

    public void addHotSpot(HotSpot hotSpot) {
        this.hotSpotVector.addElement(hotSpot);
    }

    public HotSpotVector getHotSpotVector() {
        return this.hotSpotVector;
    }

    public HotSpot getHotSpot(int n) {
        return this.hotSpotVector.getHotSpot(n);
    }

    public HotSpot getCurrentHotSpot() {
        if (this.currentHotSpot >= 0) {
            return this.hotSpotVector.getHotSpot(this.currentHotSpot);
        }
        return null;
    }

    public void setZoom(double d) {
        this.graphics.setZoom(d);
    }

    public double getZoom() {
        return this.graphics.getZoom();
    }

    public void setWindow(double d, double d2, double d3, double d4) {
        this.graphics.setWindow(d, d2, d3, d4);
    }

    public void setXAxis(double d, double d2) {
        this.graphics.setXAxis(d, d2);
    }

    public double getX1() {
        return this.graphics.getX1();
    }

    public double getX2() {
        return this.graphics.getX2();
    }

    public double getY1() {
        return this.graphics.getY1();
    }

    public double getY2() {
        return this.graphics.getY2();
    }

    public void setYAxis(double d, double d2) {
        this.graphics.setYAxis(d, d2);
    }

    public int xScreen(double d) {
        return this.graphics.xScreen(d);
    }

    public int yScreen(double d) {
        return this.graphics.yScreen(d);
    }

    public double xUser(int n) {
        return this.graphics.xUser(n);
    }

    public double yUser(int n) {
        return this.graphics.yUser(n);
    }

    public int getWidth() {
        if (PhyTools.getVersion() > 1) {
            return super.getWidth();
        }
        return this.graphics.getWidth();
    }

    public int getHeight() {
        if (PhyTools.getVersion() > 1) {
            return super.getHeight();
        }
        return this.graphics.getHeight();
    }

    public int getXCenter() {
        return this.graphics.getWidth() / 2;
    }

    public int getYCenter() {
        return this.graphics.getHeight() / 2;
    }

    public boolean isSizeBeingChanged() {
        return this.sizeBeingChanged;
    }

    public void setSizeBeingChanged(boolean bl) {
        this.sizeBeingChanged = bl;
    }

    public void setOrthonorme(boolean bl) {
        this.graphics.setOrthonorme(bl);
    }

    public boolean isSizeValid() {
        return this.graphics.getWidth() == this.getSize().width && this.graphics.getHeight() == this.getSize().height;
    }

    public void checkSizeIsCorrect() {
        int n;
        boolean bl = this.isSizeValid();
        if (!bl) {
            this.setSizeBeingChanged(true);
            if (this.isDoubleBuffering()) {
                this.offscreenImage = this.createImage(this.getSize().width, this.getSize().height);
                this.graphics.setGraphics(this.offscreenImage.getGraphics());
                this.graphics.setSize(this.getSize());
            } else {
                this.graphics.setGraphics(this.getGraphics());
                this.graphics.setSize(this.getSize());
            }
            this.graphics.computeWindowParameter();
            for (n = 1; n < this.getNGraphics(); ++n) {
                this.getGraphics(n).setGraphics(this.graphics.getGraphics().create());
                this.getGraphics(n).setSize(this.getSize());
                this.getGraphics(n).computeWindowParameter();
            }
        }
        if (this.neverPainted) {
            this.neverPainted = false;
            if (this.getCornerFileName() != null) {
                this.cornerImageSet = new ImageSet(this.getCornerFileName(), 4);
            }
            this.build();
        }
        if (!bl) {
            this.sizeHasChanged();
            if (this.graphics.getGraphics() != null) {
                this.graphics.getGraphics().translate(this.getXOrigin(), this.getYOrigin());
            }
            for (n = 0; n < this.getNGraphics(); ++n) {
                this.getGraphics(n).computeWindowParameter();
            }
            this.setSizeBeingChanged(false);
            this.initHotSpots();
            if (this.isBackgroundInUse()) {
                if (this.backgroundGraphics == null) {
                    this.backgroundGraphics = new PhyGraphics(this.graphics);
                }
                this.backgroundImage = this.createImage(this.getSize().width, this.getSize().height);
                this.backgroundGraphics.setGraphics(this.backgroundImage.getGraphics());
                if (this.isBackgroundTransparent()) {
                    this.drawBackImage(this.backgroundGraphics);
                }
                this.paintBackground();
            }
        }
    }

    protected void drawBackImage(PhyGraphics phyGraphics) {
        if (this.getParent() instanceof BufferedPanel) {
            Image image = ((BufferedPanel)this.getParent()).getBackImage();
            if (image != null) {
                phyGraphics.getGraphics().drawImage(image, -this.getBounds().x, -this.getBounds().y, this);
            } else {
                phyGraphics.setColor(this.getParent().getBackground());
                phyGraphics.getGraphics().fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.getCornerRadius() > 0) {
                phyGraphics.setColor(this.getBackground());
                phyGraphics.getGraphics().fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 2 * this.getCornerRadius(), 2 * this.getCornerRadius());
                if (this.getParent() != null && this.getParent().getParent() instanceof TabsPanel) {
                    phyGraphics.getGraphics().fillRect(0, this.getHeight() - 2 * this.getCornerRadius(), 2 * this.getCornerRadius(), 2 * this.getCornerRadius());
                }
            }
        } else if (this.getParent() instanceof PhysicApplet) {
            Image image = ((PhysicApplet)this.getParent()).getBackgroundImage();
            if (image != null) {
                phyGraphics.getGraphics().drawImage(image, -this.getBounds().x, -this.getBounds().y, this);
            } else {
                phyGraphics.getGraphics().clearRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.getCornerRadius() > 0) {
                phyGraphics.setColor(this.getBackground());
                phyGraphics.getGraphics().fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 2 * this.getCornerRadius(), 2 * this.getCornerRadius());
            }
        }
    }

    public void doLayout() {
        if (this.getSize().width > 0 && this.isBackgroundTransparent() && this.getBackImage() == null) {
            Image image = null;
            if (this.getParent() instanceof BufferedPanel) {
                image = ((BufferedPanel)this.getParent()).getBackImage();
            } else if (this.getParent() instanceof PhysicApplet) {
                image = ((PhysicApplet)this.getParent()).getBackgroundImage();
            }
            if (image != null) {
                Image image2 = this.createImage(this.getSize().width, this.getSize().height);
                image2.getGraphics().drawImage(image, -this.getBounds().x, -this.getBounds().y, null);
                this.setBackImage(image2);
            }
        }
        super.doLayout();
    }

    public void paint(Graphics graphics) {
        Color color;
        int n;
        super.paint(graphics);
        this.checkSizeIsCorrect();
        if (this.backgroundImage != null) {
            this.graphics.getGraphics().drawImage(this.backgroundImage, -this.getXOrigin(), -this.getYOrigin(), this);
        } else if (this.isBackgroundTransparent()) {
            this.drawBackImage(this.graphics);
        } else {
            this.graphics.clear();
        }
        this.graphics.setFont(this.getDefaultFont());
        if (this.getNDrawableObjects() > 0) {
            for (n = 0; n < this.getNDrawableObjects(); ++n) {
                if (this.getPositionDrawableObject(n) != 1 || !this.isObjectVisible(n)) continue;
                color = this.graphics.getColor();
                if (this.getDrawableObject(n).getColor() != null) {
                    this.graphics.setColor(this.getDrawableObject(n).getColor());
                }
                this.getDrawableObject(n).paint(this.graphics);
                this.graphics.setColor(color);
            }
        }
        this.paintCore();
        if (this.cornerImageSet != null) {
            this.graphics.getGraphics().drawImage(this.cornerImageSet.getFrame(0), 0, 0, null);
            this.graphics.getGraphics().drawImage(this.cornerImageSet.getFrame(1), 0, this.getHeight() - this.cornerImageSet.getFrame(1).getHeight(null), null);
            this.graphics.getGraphics().drawImage(this.cornerImageSet.getFrame(2), this.getWidth() - this.cornerImageSet.getFrame(2).getWidth(null), this.getHeight() - this.cornerImageSet.getFrame(2).getHeight(null), null);
            this.graphics.getGraphics().drawImage(this.cornerImageSet.getFrame(3), this.getWidth() - this.cornerImageSet.getFrame(3).getWidth(null), 0, null);
        }
        if (this.getNDrawableObjects() > 0) {
            for (n = 0; n < this.getNDrawableObjects(); ++n) {
                if (this.getPositionDrawableObject(n) != 0 || !this.isObjectVisible(n)) continue;
                color = this.graphics.getColor();
                if (this.getDrawableObject(n).getColor() != null) {
                    this.graphics.setColor(this.getDrawableObject(n).getColor());
                }
                this.getDrawableObject(n).paint(this.graphics);
                this.graphics.setColor(color);
            }
        }
        if (this.currentHotSpot >= 0) {
            HotSpot hotSpot = this.hotSpotVector.getHotSpot(this.currentHotSpot);
            boolean bl = this.graphics.isClipping();
            if (hotSpot instanceof HotSlope || hotSpot instanceof HotCross) {
                this.graphics.setClipping(true);
                hotSpot.paint(this.graphics.getGraphics(), this.isMouseDown());
                this.graphics.setClipping(bl);
            } else {
                hotSpot = this.hotSpotVector.getHotSpot(this.currentHotSpot);
                hotSpot.paint(this.graphics.getGraphics(), this.isMouseDown());
            }
        }
        if (this.isMouseRemote()) {
            if (this.imageMouseRemote == null) {
                this.imageMouseRemote = FileToolkit.makeHandCursorImage();
            }
            if (this.imageMouseRemote != null) {
                this.graphics.getGraphics().drawImage(this.imageMouseRemote, this.getXMouse() - 4, this.getYMouse(), this);
            } else {
                this.graphics.fillDisk(new Point(this.getXMouse(), this.getYMouse()), 3);
            }
        }
        this.setBackImage(this.offscreenImage);
        graphics.drawImage(this.offscreenImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isMouseActive()) {
            return;
        }
        if (this.currentHotSpot >= 0 && !this.isMouseDown()) {
            this.currentHotSpot = -1;
            this.hotSpotApproached();
            this.repaint();
        }
    }

    public boolean isAltDown() {
        return this.altDown;
    }

    public boolean isControlDown() {
        return this.controlDown;
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.altDown = mouseEvent.isAltDown();
        this.controlDown = mouseEvent.isControlDown();
        this.shiftDown = mouseEvent.isShiftDown();
        if (this.isAltDown() && PhyTools.isDebug()) {
            PhyTools.issueMessage(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("position = [").concat(String.valueOf(mouseEvent.getX() - this.getXOrigin()))).concat(String.valueOf("("))).concat(String.valueOf(mouseEvent.getX() - this.getXOrigin() + this.getBounds().x))).concat(String.valueOf(" "))).concat(String.valueOf(this.graphics.xUser(mouseEvent.getX() - this.getXOrigin())))).concat(String.valueOf("),"))).concat(String.valueOf(mouseEvent.getY() - this.getYOrigin()))).concat(String.valueOf("("))).concat(String.valueOf(mouseEvent.getY() - this.getYOrigin() + this.getBounds().y))).concat(String.valueOf(" "))).concat(String.valueOf(this.graphics.yUser(mouseEvent.getY() - this.getYOrigin())))).concat(String.valueOf(")]")));
        }
        if (!this.isMouseActive()) {
            return;
        }
        this.xMouse = mouseEvent.getX() - this.getXOrigin();
        this.yMouse = mouseEvent.getY() - this.getYOrigin();
        this.mousePressedInternal();
    }

    protected void mousePressedInternal() {
        this.mousePressed();
        this.setPrevMousePoint(new Point(this.getMousePoint()));
    }

    protected void mousePressed() {
        this.flagMouseDown = true;
        this.xMousePressed = this.xMouse;
        this.yMousePressed = this.yMouse;
        this.findCurrentHotSpot(this.xMouse, this.yMouse);
        if (this.currentHotSpot >= 0) {
            this.hotSpotAction(this.currentHotSpot);
            if (this.currentHotSpot >= 0 && this.getCurrentHotSpot().isSelectable()) {
                this.repaint();
            }
        }
        if (this.isMouseRemote()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!this.getComponent(i).getBounds().contains(this.xMouse, this.yMouse) || !(this.getComponent(i) instanceof BufferedPanel)) continue;
                ((BufferedPanel)this.getComponent(i)).mousePressed();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isMouseActive()) {
            return;
        }
        this.xMouse = mouseEvent.getX() - this.getXOrigin();
        this.yMouse = mouseEvent.getY() - this.getYOrigin();
        this.mouseReleased();
    }

    protected void mouseReleased() {
        this.flagMouseDown = false;
        this.controlDown = false;
        this.shiftDown = false;
        this.altDown = false;
        this.mouseReleasedEnd();
        if (this.currentHotSpot >= 0) {
            this.hotSpotReleased(this.currentHotSpot);
        }
        this.currentHotSpot = -1;
        if (this.isMouseRemote()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
                ((BufferedPanel)this.getComponent(i)).mouseReleased();
            }
        }
    }

    public void mouseReleasedEnd() {
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isMouseActive()) {
            return;
        }
        this.xMouse = MathTools.minMax(mouseEvent.getX(), this.graphics.getXVuport(), this.graphics.getXVuport() + this.graphics.getWVuport() - 1) - this.getXOrigin();
        this.yMouse = MathTools.minMax(mouseEvent.getY(), this.graphics.getYVuport(), this.graphics.getYVuport() + this.graphics.getHVuport() - 1) - this.getYOrigin();
        this.mouseDraggedInternal();
    }

    protected void mouseDraggedInternal() {
        this.mouseDragged();
        this.setPrevMousePoint(new Point(this.getMousePoint()));
    }

    protected void mouseDragged() {
        if (this.currentHotSpot >= 0 && this.xMouse >= 0 && this.xMouse < this.getWidth() && this.yMouse >= 0 && this.yMouse < this.getHeight()) {
            if (this.getCurrentHotSpot().isMotionRelative()) {
                this.getCurrentHotSpot().setXY(this.getXMouse() - this.getPrevMousePoint().x, this.getYMouse() - this.getPrevMousePoint().y);
            } else {
                this.getCurrentHotSpot().setXY(this.xMouse, this.yMouse);
            }
            this.hotSpotHasMoved(this.currentHotSpot);
        } else if (this.isMouse3D()) {
            RotationMatrix rotationMatrix = new RotationMatrix();
            rotationMatrix.xRotate((double)((this.getPrevMousePoint().y - this.getYMouse()) * 2) * Math.PI / (double)this.getHeight());
            rotationMatrix.yRotate((double)((this.getXMouse() - this.getPrevMousePoint().x) * 2) * Math.PI / (double)this.getWidth());
            this.graphics.getRotationMatrix().mul(rotationMatrix);
            this.repaint();
        }
        if (this.isMouseRemote()) {
            this.repaint();
        }
        if (this.isMouseRemote()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!(this.getComponent(i) instanceof BufferedPanel) || !((BufferedPanel)this.getComponent(i)).isMouseDown()) continue;
                ((BufferedPanel)this.getComponent(i)).mouseDraggedInternal();
            }
        }
    }

    protected void findCurrentHotSpot(int n, int n2) {
        int n3 = 50;
        this.currentHotSpot = -1;
        for (int i = 0; i < this.hotSpotVector.size(); ++i) {
            int n4 = this.hotSpotVector.getHotSpot(i).weightedDistanceTo(n, n2);
            if (n4 >= n3) continue;
            this.currentHotSpot = i;
            n3 = n4;
        }
        if (n3 > 1000) {
            this.currentHotSpot = -1;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.isMouseActive()) {
            return;
        }
        this.setXYMouse(mouseEvent.getX() - this.getXOrigin(), mouseEvent.getY() - this.getYOrigin());
        this.mouseMoved();
    }

    protected void mouseMoved() {
        int n = this.currentHotSpot;
        this.findCurrentHotSpot(this.getXMouse(), this.getYMouse());
        if (n != this.currentHotSpot) {
            this.hotSpotApproached();
            this.repaint();
        } else if (this.isMouseRemote()) {
            this.repaint();
        }
        if (this.isMouseRemote()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
                ((BufferedPanel)this.getComponent(i)).mouseMoved();
            }
        }
    }

    public void paintCore() {
    }

    public void paintBackground() {
    }

    public void build() {
    }

    public void sizeHasChanged() {
    }

    public void initHotSpots() {
    }

    public void hotSpotHasMoved(int n) {
    }

    public void hotSpotReleased(int n) {
    }

    public void hotSpotApproached() {
    }

    public void hotSpotAction(int n) {
    }

    public void refresh() {
        this.repaint();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
            ((BufferedPanel)this.getComponent(i)).refresh();
        }
    }

    public void update(DataObservable dataObservable) {
        this.refresh();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CrackedString crackedString = new CrackedString(actionEvent.getActionCommand());
        if (crackedString.getField(0).equals("MOUSE")) {
            if (crackedString.getField(1).equals("OFF")) {
                this.setMouseActive(false);
            } else {
                this.setMouseActive(true);
            }
        } else if (crackedString.getField(0).equals("REMOTE_MOUSE")) {
            if (!this.isMouseRemote()) {
                this.setMouseRemote(true);
            }
            if (crackedString.getField(1).equals("X")) {
                this.setXMouse(crackedString.getInt(2));
                if (this.isMouseDown()) {
                    this.mouseDraggedInternal();
                } else {
                    this.mouseMoved();
                }
            } else if (crackedString.getField(1).equals("Y")) {
                this.setYMouse(crackedString.getInt(2));
                if (this.isMouseDown()) {
                    this.mouseDraggedInternal();
                } else {
                    this.mouseMoved();
                }
            } else if (crackedString.getField(1).equals("XY")) {
                this.setXYMouse(crackedString.getInt(2), crackedString.getInt(3));
                if (this.isMouseDown()) {
                    this.mouseDraggedInternal();
                } else {
                    this.mouseMoved();
                }
            } else if (crackedString.getField(1).equals("DOWN")) {
                if (crackedString.getNFields() > 2) {
                    if (crackedString.getField(2).equals("CONTROL")) {
                        this.controlDown = true;
                    } else if (crackedString.getField(2).equals("SHIFT")) {
                        this.shiftDown = true;
                    }
                }
                this.mousePressedInternal();
                this.repaint();
            } else if (crackedString.getField(1).equals("UP")) {
                this.mouseReleased();
                this.repaint();
            } else if (crackedString.getField(1).equals("OFF")) {
                this.mouseReleased();
                this.setMouseRemote(false);
                this.repaint();
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    this.getComponent(i).repaint();
                }
            }
        } else if (crackedString.getField(0).equals("ROTATE")) {
            if (crackedString.getField(1).equals("X")) {
                double d = crackedString.getDouble(2) * Math.PI / (double)180;
                this.graphics.getRotationMatrix().xRotate(d - this.getRotationAngleX());
                this.setRotationAngleX(d);
                this.repaint();
            } else if (crackedString.getField(1).equals("Y")) {
                double d = crackedString.getDouble(2) * Math.PI / (double)180;
                this.graphics.getRotationMatrix().yRotate(d - this.getRotationAngleY());
                this.setRotationAngleY(d);
                this.repaint();
            }
        } else if (crackedString.getField(0).equals("SHOW")) {
            if (crackedString.getNFields() > 2) {
                Component component = this.searchComponent(crackedString.getField(2));
                if (component != null && component instanceof BufferedPanel) {
                    ((BufferedPanel)component).setFlag(crackedString.getField(1).intern());
                }
                component.repaint();
            } else if (crackedString.getNFields() > 1) {
                this.setFlag(crackedString.getField(1).intern());
                this.repaint();
            } else {
                this.setVisible(true);
                this.getParent().validate();
            }
        } else if (crackedString.getField(0).equals("HIDE")) {
            if (crackedString.getNFields() > 2) {
                Component component = this.searchComponent(crackedString.getField(2));
                if (component != null && component instanceof BufferedPanel) {
                    ((BufferedPanel)component).clearFlag(crackedString.getField(1).intern());
                }
                component.repaint();
            } else if (crackedString.getNFields() > 1) {
                this.clearFlag(crackedString.getField(1).intern());
                this.repaint();
            } else {
                this.setVisible(false);
                this.getParent().validate();
            }
        } else if (actionEvent.getActionCommand().equals("REFRESH") || actionEvent instanceof TimeEvent) {
            this.refresh();
        }
    }

    public Component searchComponent(String string) {
        int n;
        if (this.getName().equals(string)) {
            return this;
        }
        for (n = 0; n < this.getComponentCount(); ++n) {
            if (!this.getComponent(n).getName().equals(string)) continue;
            return this.getComponent(n);
        }
        for (n = 0; n < this.getComponentCount(); ++n) {
            Component component;
            if (!(this.getComponent(n) instanceof BufferedPanel) || (component = ((BufferedPanel)this.getComponent(n)).searchComponent(string)) == null) continue;
            return component;
        }
        return null;
    }

    public void setPropertyAsText(String string, String string2) {
        ParamSupport.setPropertyAsText(this, string, string2);
        this.refresh();
    }

    public void setProperty(String string, Object object) {
        ParamSupport.setProperty(this, string, object);
        this.refresh();
    }

    public Object getProperty(String string) {
        return ParamSupport.getProperty(this, string);
    }

    public String getPropertyAsText(String string) {
        return ParamSupport.getPropertyAsText(this, string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionEventSupport.addActionListener(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionEventSupport.removeActionListener(actionListener);
    }

    public void fireActionEvent(String string) {
        this.actionEventSupport.fireActionEvent(string);
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        this.actionEventSupport.fireActionEvent(actionEvent);
    }
}

