/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Point;
import phy.graphe.DrawableSegment;
import phy.graphe.PhyGraphics;
import phy.graphe.PointLineSegment;
import phy.graphe.UserLineSegment;

public class DoubleArrow
extends DrawableSegment {
    public static final int INSIDE = 0;
    public static final int OUTSIDE = 1;
    public static final int AUTO = 2;
    protected int arrowType = 0;
    protected int mode = 1;
    public static final int SINGLE = 0;
    public static final int DOUBLE = 1;
    protected String label;
    protected int size = -1;

    public void setArrowType(int n) {
        this.arrowType = n;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public DoubleArrow() {
    }

    public DoubleArrow(PointLineSegment pointLineSegment) {
        super(pointLineSegment);
    }

    public DoubleArrow(UserLineSegment userLineSegment) {
        super(userLineSegment);
    }

    public void paint(PhyGraphics phyGraphics) {
        Point point;
        Point point2;
        Object object;
        if (this.color != null) {
            phyGraphics.setColor(this.color);
        }
        if (this.segment instanceof PointLineSegment) {
            object = (PointLineSegment)this.segment;
            if (this.getMode() == 1) {
                if (this.isThick()) {
                    phyGraphics.drawDoubleArrowThick(((PointLineSegment)object).a, ((PointLineSegment)object).b, this.size, this.arrowType);
                } else {
                    phyGraphics.drawDoubleArrow(((PointLineSegment)object).a, ((PointLineSegment)object).b, this.size, this.arrowType);
                }
            } else if (this.isThick()) {
                phyGraphics.drawArrowThick(((PointLineSegment)object).a, ((PointLineSegment)object).b, this.size);
            } else {
                phyGraphics.drawArrow(((PointLineSegment)object).a, ((PointLineSegment)object).b, this.size);
            }
            point2 = ((PointLineSegment)object).a;
            point = ((PointLineSegment)object).b;
        } else if (this.segment instanceof UserLineSegment) {
            object = (UserLineSegment)this.segment;
            if (this.getMode() == 1) {
                if (this.isThick()) {
                    phyGraphics.drawDoubleArrowThick(((UserLineSegment)object).a, ((UserLineSegment)object).b, this.size, this.arrowType);
                } else {
                    phyGraphics.drawDoubleArrow(((UserLineSegment)object).a, ((UserLineSegment)object).b, this.size, this.arrowType);
                }
            } else if (this.isThick()) {
                phyGraphics.drawArrowThick(((UserLineSegment)object).a, ((UserLineSegment)object).b, this.size);
            } else {
                phyGraphics.drawArrow(((UserLineSegment)object).a, ((UserLineSegment)object).b, this.size);
            }
            point2 = phyGraphics.screenPoint(((UserLineSegment)object).a);
            point = phyGraphics.screenPoint(((UserLineSegment)object).b);
        } else {
            return;
        }
        if (this.label != null) {
            if (point2.x == point.x) {
                object = new Point(point2.x + 5, (point2.y + point.y) / 2);
                phyGraphics.drawTeX(this.label, (Point)object, 6);
            } else if (point2.y == point.y) {
                object = new Point((point2.x + point.x) / 2, point2.y - 5);
                phyGraphics.drawTeX(this.label, (Point)object, 0);
            } else {
                object = new Point((point2.x + point.x) / 2 + 3, (point2.y + point.y) / 2 - 3);
                phyGraphics.drawTeX(this.label, (Point)object, 1);
            }
        }
    }
}

