/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Color;
import phy.graphe.DrawableObject;
import phy.graphe.PhyGraphics;
import phy.graphe.PointLineSegment;
import phy.graphe.UserLineSegment;

public class DrawableSegment
extends DrawableObject {
    protected Object segment;
    protected boolean thick = false;
    protected int arrowType = 0;

    public void setSegment(PointLineSegment pointLineSegment) {
        this.segment = pointLineSegment;
    }

    public void setSegment(UserLineSegment userLineSegment) {
        this.segment = userLineSegment;
    }

    public void setThick(boolean bl) {
        this.thick = bl;
    }

    public boolean isThick() {
        return this.thick;
    }

    public void setArrowType(int n) {
        this.arrowType = n;
    }

    public int getArrowType() {
        return this.arrowType;
    }

    public DrawableSegment() {
    }

    public DrawableSegment(PointLineSegment pointLineSegment) {
        this();
        this.setSegment(pointLineSegment);
    }

    public DrawableSegment(UserLineSegment userLineSegment) {
        this();
        this.setSegment(userLineSegment);
    }

    public DrawableSegment(PointLineSegment pointLineSegment, Color color) {
        this(pointLineSegment);
        this.setColor(color);
    }

    public DrawableSegment(UserLineSegment userLineSegment, Color color) {
        this(userLineSegment);
        this.setColor(color);
    }

    public void paint(PhyGraphics phyGraphics) {
        if (this.color != null) {
            phyGraphics.setColor(this.color);
        }
        if (this.segment instanceof PointLineSegment) {
            PointLineSegment pointLineSegment = (PointLineSegment)this.segment;
            if (this.getArrowType() == 1) {
                if (this.isThick()) {
                    phyGraphics.drawArrowThick(pointLineSegment.a, pointLineSegment.b);
                } else {
                    phyGraphics.drawArrow(pointLineSegment.a, pointLineSegment.b);
                }
            } else if (this.isThick()) {
                phyGraphics.drawLineThick(pointLineSegment.a, pointLineSegment.b);
            } else {
                phyGraphics.drawLine(pointLineSegment.a, pointLineSegment.b);
            }
        } else if (this.segment instanceof UserLineSegment) {
            UserLineSegment userLineSegment = (UserLineSegment)this.segment;
            if (this.getArrowType() == 1) {
                if (this.isThick()) {
                    phyGraphics.drawArrowThick(userLineSegment.a, userLineSegment.b);
                } else {
                    phyGraphics.drawArrow(userLineSegment.a, userLineSegment.b);
                }
            } else if (this.isThick()) {
                phyGraphics.drawLineThick(userLineSegment.a, userLineSegment.b);
            } else {
                phyGraphics.drawLine(userLineSegment.a, userLineSegment.b);
            }
        } else {
            return;
        }
    }
}

