/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import phy.control.HotSpot;
import phy.control.HotSpotVector;
import phy.graphe.BufferedPanel;
import phy.graphe.PhyGraphics;
import phy.util.CrackedString;
import phy.util.PhysicApplet;
import phy.util.Point3D;

public class MyPanel
extends Panel {
    public PhyGraphics graphics = new PhyGraphics();
    protected Point origin = new Point(0, 0);
    Vector graphicsVector = new Vector();
    protected Hashtable flagTable = new Hashtable();
    protected Font defaultFont = PhysicApplet.getDefaultFont();
    protected int cornerRadius = 0;
    Image backgroundImage = null;
    public PhyGraphics backgroundGraphics;
    protected boolean backgroundInUse = false;
    protected boolean backgroundTransparent = false;
    protected boolean mouseActive = true;
    protected boolean mouse3D = false;
    protected double rotationAngleX = 0.0;
    protected double rotationAngleY = 0.0;
    protected boolean mouseRemote = false;
    protected Image imageMouseRemote;
    protected int xMouse = -1;
    private int xMousePressed = -1;
    protected int yMouse = -1;
    private int yMousePressed = -1;
    protected Point prevMousePoint;
    private boolean flagMouseDown = false;
    boolean helpMode = false;
    HotSpotVector hotSpotVector = new HotSpotVector();
    int currentHotSpot = -1;
    protected boolean sizeBeingChanged = true;

    public PhyGraphics getPhyGraphics() {
        return this.graphics;
    }

    public void setPhyGraphics(PhyGraphics phyGraphics) {
        this.graphics = phyGraphics;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public int getXOrigin() {
        return this.getOrigin().x;
    }

    public int getYOrigin() {
        return this.getOrigin().y;
    }

    public void setOrigin(Point point) {
        this.origin = point;
    }

    public PhyGraphics getGraphics(int n) {
        if (n == 0) {
            return this.graphics;
        }
        for (int i = this.graphicsVector.size(); i < n; ++i) {
            this.graphicsVector.addElement(new PhyGraphics());
        }
        return (PhyGraphics)this.graphicsVector.elementAt(n - 1);
    }

    public int getNGraphics() {
        return this.graphicsVector.size() + 1;
    }

    public void setFlag(String string) {
        if (!this.flagTable.containsKey(string)) {
            this.flagTable.put(string, new Object());
        }
    }

    public void setFlags(String string) {
        CrackedString crackedString = new CrackedString(string, ',');
        for (int i = 0; i < crackedString.getNFields(); ++i) {
            this.setFlag(crackedString.getField(i).trim());
        }
    }

    public void clearFlag(String string) {
        if (this.flagTable.containsKey(string)) {
            this.flagTable.remove(string);
        }
    }

    public void clearFlags(String string) {
        CrackedString crackedString = new CrackedString(string, ',');
        for (int i = 0; i < crackedString.getNFields(); ++i) {
            this.clearFlag(crackedString.getField(i).trim());
        }
    }

    public void clearFlags() {
        this.flagTable.clear();
    }

    public boolean isFlagSet(String string) {
        return this.flagTable.containsKey(string);
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setCornerRadius(int n) {
        this.cornerRadius = n;
        if (this.cornerRadius > 0) {
            this.setBackgroundTransparent(true);
        }
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public void setBackgroundInUse(boolean bl) {
        this.backgroundInUse = bl;
    }

    public boolean isBackgroundInUse() {
        return this.backgroundInUse;
    }

    public void setBackgroundTransparent(boolean bl) {
        this.backgroundTransparent = bl;
    }

    public boolean isBackgroundTransparent() {
        return this.backgroundTransparent;
    }

    public void setMouseActive(boolean bl) {
        this.mouseActive = bl;
        if (this.isMouseActive()) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
            if (this.currentHotSpot >= 0) {
                this.currentHotSpot = -1;
                this.repaint();
            }
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
            ((BufferedPanel)this.getComponent(i)).setMouseActive(bl);
        }
    }

    public boolean isMouseActive() {
        return this.mouseActive && !this.isMouseRemote();
    }

    public void setLightSourcePosition(Point3D point3D) {
        this.graphics.setLightSourcePosition(point3D);
    }

    public void setMouse3D(boolean bl) {
        this.mouse3D = bl;
        this.setMouseActive(true);
    }

    public boolean isMouse3D() {
        return this.mouse3D;
    }

    public void setRotationAngleX(double d) {
        this.rotationAngleX = d;
    }

    public double getRotationAngleX() {
        return this.rotationAngleX;
    }

    public void setRotationAngleY(double d) {
        this.rotationAngleY = d;
    }

    public double getRotationAngleY() {
        return this.rotationAngleY;
    }

    public void xRotateDeg(double d) {
        this.graphics.getRotationMatrix().xRotate(d * Math.PI / (double)180);
    }

    public void yRotateDeg(double d) {
        this.graphics.getRotationMatrix().yRotate(d * Math.PI / (double)180);
    }

    public void clearRotation() {
        this.graphics.getRotationMatrix().init();
        this.setRotationAngleX(0.0);
        this.setRotationAngleY(0.0);
    }

    public void setMouseRotationX(double d) {
    }

    public void setMouseRotationY(double d) {
    }

    public void setMouseRemote(boolean bl) {
        this.mouseRemote = bl;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
            ((BufferedPanel)this.getComponent(i)).setMouseRemote(bl);
        }
    }

    public boolean isMouseRemote() {
        return this.mouseRemote;
    }

    public void setXMouse(int n) {
        this.xMouse = n;
        this.updateMouseComponents();
    }

    public int getXMouse() {
        return this.xMouse;
    }

    public int getXMousePressed() {
        return this.xMousePressed;
    }

    public int getYMousePressed() {
        return this.yMousePressed;
    }

    public void setYMouse(int n) {
        this.yMouse = n;
        this.updateMouseComponents();
    }

    public int getYMouse() {
        return this.yMouse;
    }

    public void setXYMouse(int n, int n2) {
        this.xMouse = n;
        this.yMouse = n2;
        this.updateMouseComponents();
    }

    protected void updateMouseComponents() {
        if (this.isMouseRemote()) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (!(this.getComponent(i) instanceof BufferedPanel)) continue;
                BufferedPanel bufferedPanel = (BufferedPanel)this.getComponent(i);
                bufferedPanel.setXYMouse(this.getXMouse() - bufferedPanel.getBounds().x, this.getYMouse() - bufferedPanel.getBounds().y);
            }
        }
    }

    public Point getMousePoint() {
        return new Point(this.getXMouse(), this.getYMouse());
    }

    public Point getMousePressedPoint() {
        return new Point(this.xMousePressed, this.yMousePressed);
    }

    public void setPrevMousePoint(Point point) {
        this.prevMousePoint = point;
    }

    public Point getPrevMousePoint() {
        return this.prevMousePoint;
    }

    public boolean isMouseDown() {
        return this.flagMouseDown;
    }

    public void setHelpMode(boolean bl) {
        System.out.println("helpMode disapproved");
        if (bl != this.helpMode) {
            this.helpMode = bl;
            this.repaint();
        }
    }

    public boolean getHelpMode() {
        return this.helpMode;
    }

    public MyPanel() {
        System.out.println("MyPanel constructor");
    }

    public int getCurrentHotSpotIndex() {
        return this.currentHotSpot;
    }

    public void setCurrentHotSpotIndex(int n) {
        this.currentHotSpot = n;
    }

    public void addHotSpot(HotSpot hotSpot) {
        this.hotSpotVector.addElement(hotSpot);
    }

    public HotSpotVector getHotSpotVector() {
        return this.hotSpotVector;
    }

    public HotSpot getHotSpot(int n) {
        return this.hotSpotVector.getHotSpot(n);
    }

    public HotSpot getCurrentHotSpot() {
        if (this.currentHotSpot >= 0) {
            return this.hotSpotVector.getHotSpot(this.currentHotSpot);
        }
        return null;
    }

    public void setZoom(double d) {
        this.graphics.setZoom(d);
    }

    public double getZoom() {
        return this.graphics.getZoom();
    }

    public void setWindow(double d, double d2, double d3, double d4) {
        this.graphics.setWindow(d, d2, d3, d4);
    }

    public void setXAxis(double d, double d2) {
        this.graphics.setXAxis(d, d2);
    }

    public double getX1() {
        return this.graphics.getX1();
    }

    public double getX2() {
        return this.graphics.getX2();
    }

    public double getY1() {
        return this.graphics.getY1();
    }

    public double getY2() {
        return this.graphics.getY2();
    }

    public boolean isSizeBeingChanged() {
        return this.sizeBeingChanged;
    }

    public void setSizeBeingChanged(boolean bl) {
        this.sizeBeingChanged = bl;
    }

    public void setOrthonorme(boolean bl) {
        this.graphics.setOrthonorme(bl);
    }

    public boolean isSizeValid() {
        return this.graphics.getWidth() == this.getSize().width && this.graphics.getHeight() == this.getSize().height;
    }
}

