/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import phy.graphe.Scaler;
import phy.util.DoublePoint;
import phy.util.Facet3D;
import phy.util.MathTools;
import phy.util.Object3D;
import phy.util.PhyTools;
import phy.util.Point3D;
import phy.util.Polygon3D;
import phy.util.RotationMatrix;
import phy.util.TeXDimension;
import phy.util.TeXTokenizer;
import phy.util.Vector3D;

public class PhyGraphics {
    boolean orthonorme = false;
    protected Graphics graphics;
    protected double zoom = 1.0;
    protected Scaler xScaler = new Scaler();
    protected Scaler yScaler = new Scaler();
    protected Point lastPoint = new Point(0, 0);
    protected boolean clipping = false;
    protected RotationMatrix rotationMatrix = new RotationMatrix();
    protected Point3D origin3D = new Point3D(0.0, 0.0, 0.0);
    protected Point3D lightSourcePosition = new Point3D(0.0, 0.0, 0.0);
    public static final int CENTER_BOTTOM = 0;
    public static final int LEFT_BOTTOM = 1;
    public static final int RIGHT_BOTTOM = 2;
    public static final int CENTER_TOP = 3;
    public static final int LEFT_TOP = 4;
    public static final int RIGHT_TOP = 5;
    public static final int LEFT_CENTER = 6;
    public static final int CENTER = 7;
    public static final int RIGHT_CENTER = 8;
    public static final int TOP = 9;
    public static final int BOTTOM = 10;

    public void graphics_fillRect(int n, int n2, int n3, int n4) {
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void graphics_drawRect(int n, int n2, int n3, int n4) {
        this.graphics.drawRect(n, n2, n3, n4);
    }

    public void graphics_drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void graphics_fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void graphics_clearRect(int n, int n2, int n3, int n4) {
        this.graphics.clearRect(n, n2, n3, n4);
    }

    public void graphics_drawString(String string, int n, int n2) {
        this.graphics.drawString(string, n, n2);
    }

    public void graphics_drawLine(int n, int n2, int n3, int n4) {
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public void graphics_fillPolygon(Polygon polygon) {
        this.graphics.fillPolygon(polygon);
    }

    public void graphics_fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.fillPolygon(nArray, nArray2, n);
    }

    public void graphics_drawPolygon(Polygon polygon) {
        this.graphics.drawPolygon(polygon);
    }

    public void graphics_drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolygon(nArray, nArray2, n);
    }

    public void graphics_drawOval(int n, int n2, int n3, int n4) {
        this.graphics.drawOval(n, n2, n3, n4);
    }

    public void graphics_fillOval(int n, int n2, int n3, int n4) {
        this.graphics.fillOval(n, n2, n3, n4);
    }

    public void graphics_setFont(Font font) {
        this.graphics.setFont(font);
    }

    public void graphics_drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolyline(nArray, nArray2, n);
    }

    public void graphics_setClip(Rectangle rectangle) {
        this.graphics.setClip(rectangle);
    }

    public void setColor(Color color) {
        this.graphics.setColor(color);
    }

    public Color getColor() {
        return this.graphics.getColor();
    }

    public void setOrthonorme(boolean bl) {
        this.orthonorme = bl;
    }

    public int getWidth() {
        return this.xScaler.getNPixels();
    }

    public int getHeight() {
        return this.yScaler.getNPixels();
    }

    public void setSize(Dimension dimension) {
        this.xScaler.setNPixels(dimension.width);
        this.yScaler.setNPixels(dimension.height);
    }

    public Dimension getSize() {
        return new Dimension(this.xScaler.getNPixels(), this.yScaler.getNPixels());
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    public PhyGraphics() {
    }

    public PhyGraphics(Graphics graphics) {
        this();
        this.graphics = graphics;
    }

    public PhyGraphics(PhyGraphics phyGraphics) {
        this.xScaler = phyGraphics.xScaler;
        this.yScaler = phyGraphics.yScaler;
        this.graphics = phyGraphics.graphics;
    }

    public void setZoom(double d) {
        this.zoom = d;
    }

    public double getZoom() {
        return this.zoom;
    }

    public Scaler getXScaler() {
        return this.xScaler;
    }

    public Scaler getYScaler() {
        return this.yScaler;
    }

    protected void computeWindowParameter() {
        this.xScaler.update();
        this.yScaler.update();
        if (this.orthonorme) {
            if (Math.abs(this.xScaler.getAlpha()) > Math.abs(this.yScaler.getAlpha())) {
                this.xScaler.setAlpha(Math.abs(this.yScaler.getAlpha()) * (double)MathTools.sign(this.xScaler.getAlpha()));
                this.xScaler.setBeta(-((int)Math.rint((this.xScaler.getX1() + this.xScaler.getX2()) / (double)2 * this.xScaler.getAlpha() - (double)(this.xScaler.getNPixelsUsed() / 2))));
            } else if (Math.abs(this.yScaler.getAlpha()) > Math.abs(this.xScaler.getAlpha())) {
                this.yScaler.setAlpha(Math.abs(this.xScaler.getAlpha()) * (double)MathTools.sign(this.yScaler.getAlpha()));
                this.yScaler.setBeta(-((int)Math.rint((this.yScaler.getX1() + this.yScaler.getX2()) / (double)2 * this.yScaler.getAlpha() - (double)(this.yScaler.getNPixelsUsed() / 2))));
            }
        }
    }

    public void setClipping(boolean bl) {
        this.clipping = bl;
        if (this.isClipping()) {
            this.graphics_setClip(new Rectangle(this.getXVuport(), this.getYVuport(), this.getWVuport(), this.getHVuport()));
        } else {
            this.graphics_setClip(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public int xScreen(double d) {
        return this.xScaler.getI(d * this.getZoom());
    }

    public int yScreen(double d) {
        return this.yScaler.getI(d * this.getZoom());
    }

    public Point screenPoint(double d, double d2) {
        return new Point(this.xScreen(d), this.yScreen(d2));
    }

    public Point screenPoint(DoublePoint doublePoint) {
        return this.screenPoint(doublePoint.x, doublePoint.y);
    }

    public int deltaXScreen(double d) {
        return this.xScaler.getDeltaI(d * this.getZoom());
    }

    public int deltaYScreen(double d) {
        return this.yScaler.getDeltaI(d * this.getZoom());
    }

    public double xUser(int n) {
        return this.xScaler.getX(n) / this.getZoom();
    }

    public double yUser(int n) {
        return this.yScaler.getX(n) / this.getZoom();
    }

    public DoublePoint userPoint(Point point) {
        return new DoublePoint(this.xUser(point.x), this.yUser(point.y));
    }

    public double deltaXUser(int n) {
        return this.xUser(n) - this.xUser(0);
    }

    public double deltaYUser(int n) {
        return this.yUser(0) - this.yUser(n);
    }

    public double getHPixel() {
        return this.deltaXUser(1);
    }

    public double getVPixel() {
        return this.deltaYUser(1);
    }

    public double getX1() {
        return this.xScaler.getX1();
    }

    public double getX2() {
        return this.xScaler.getX2();
    }

    public double getY1() {
        return this.yScaler.getX2();
    }

    public double getY2() {
        return this.yScaler.getX1();
    }

    public double getUserWidth() {
        return Math.abs(this.getX2() - this.getX1());
    }

    public double getUserHeight() {
        return Math.abs(this.getY2() - this.getY1());
    }

    public int getXVuport() {
        return this.xScaler.getMargin1();
    }

    public int getWVuport() {
        return this.xScaler.getNPixelsUsed();
    }

    public int getYVuport() {
        return this.yScaler.getMargin1();
    }

    public int getHVuport() {
        return this.yScaler.getNPixelsUsed();
    }

    public Point getOriginVuport() {
        return new Point(this.getXVuport(), this.getYVuport());
    }

    public Dimension getDimensionVuport() {
        return new Dimension(this.getWVuport(), this.getHVuport());
    }

    public double getSlopeRatio() {
        return Math.abs(this.xScaler.getAlpha() / this.yScaler.getAlpha());
    }

    public void setHMargin(int n) {
        this.xScaler.setMargin(n);
    }

    public void setVMargin(int n) {
        this.yScaler.setMargin(n);
    }

    public void setLeftMargin(int n) {
        this.xScaler.setMargin1(n);
    }

    public int getLeftMargin() {
        return this.xScaler.getMargin1();
    }

    public void setRightMargin(int n) {
        this.xScaler.setMargin2(n);
    }

    public int getRightMargin() {
        return this.xScaler.getMargin2();
    }

    public void setTopMargin(int n) {
        this.yScaler.setMargin1(n);
    }

    public int getTopMargin() {
        return this.yScaler.getMargin1();
    }

    public void setBottomMargin(int n) {
        this.yScaler.setMargin2(n);
    }

    public int getBottomMargin() {
        return this.yScaler.getMargin2();
    }

    public void setWindow(double d, double d2, double d3, double d4) {
        this.xScaler.setBounds(d, d3);
        this.yScaler.setBounds(d4, d2);
        this.computeWindowParameter();
    }

    public void shiftWindow(int n, int n2) {
        this.setWindow(this.getX1() - this.deltaXUser(n), this.getY1() - this.deltaYUser(n2), this.getX2() - this.deltaXUser(n), this.getY2() - this.deltaYUser(n2));
    }

    public void setYAxis(double d, double d2) {
        this.yScaler.setBounds(d2, d);
        this.computeWindowParameter();
    }

    public void setXAxis(double d, double d2) {
        this.xScaler.setBounds(d, d2);
        this.computeWindowParameter();
    }

    public void setOrthoWindow(DoublePoint doublePoint, Point point, DoublePoint doublePoint2, Point point2) {
        double d;
        double d2 = doublePoint.distanceTo(doublePoint2);
        double d3 = Math.sqrt(MathTools.sqr(point.x - point2.x) + MathTools.sqr(point.y - point2.y));
        double d4 = d = d2 / d3;
        double d5 = d;
        if ((doublePoint2.x - doublePoint.x) * (double)(point2.x - point.x) < 0.0) {
            d4 = -d4;
        }
        if ((doublePoint2.y - doublePoint.y) * (double)(point2.y - point.y) < 0.0) {
            d5 = -d5;
        }
        this.setXAxis(doublePoint.x - (double)point.x * d4, doublePoint.x + (double)(this.getWVuport() - point.x) * d4);
        this.setYAxis(doublePoint.y + (double)(this.getHVuport() - point.y) * d5, doublePoint.y - (double)point.y * d5);
    }

    public void setRotationMatrix(RotationMatrix rotationMatrix) {
        this.rotationMatrix = rotationMatrix;
    }

    public RotationMatrix getRotationMatrix() {
        return this.rotationMatrix;
    }

    public void setOrigin3D(Point3D point3D) {
        this.origin3D = point3D;
    }

    public void setLightSourcePosition(Point3D point3D) {
        this.lightSourcePosition = point3D;
    }

    public Point3D getLightSourcePosition() {
        return this.lightSourcePosition;
    }

    public DoublePoint project(Point3D point3D) {
        return this.rotationMatrix.project(point3D, this.origin3D);
    }

    public DoublePoint[] project(Polygon3D polygon3D) {
        return this.rotationMatrix.project(polygon3D, this.origin3D);
    }

    public DoublePoint[] project(Point3D[] point3DArray) {
        return this.project(new Polygon3D(point3DArray));
    }

    public Point screenProject(Point3D point3D) {
        return this.screenPoint(this.project(point3D));
    }

    public Polygon screenProject(Polygon3D polygon3D) {
        return this.polyScreen(this.project(polygon3D));
    }

    public Point3D inverseProject(Point point, Point3D point3D) {
        Point3D point3D2 = new Point3D(point3D);
        point3D2.sub(this.origin3D);
        point3D2 = this.rotationMatrix.mul(point3D2);
        DoublePoint doublePoint = this.userPoint(point);
        point3D2.x = doublePoint.x;
        point3D2.y = doublePoint.y;
        return this.rotationMatrix.inverseMul(point3D2);
    }

    public double computeDepth(Point3D point3D) {
        Vector3D vector3D = new Vector3D(this.origin3D, point3D);
        return -this.rotationMatrix.mul((Point3D)point3D).z;
    }

    public void drawObject3D(Object3D object3D) {
        for (int i = 0; i < object3D.getNFacets(); ++i) {
            Facet3D facet3D = object3D.getFacet(i);
            int n = 0;
            while (n + 1 < facet3D.size()) {
                this.drawLine(this.screenProject(object3D.getPoint(facet3D.vertex[n])), this.screenProject(object3D.getPoint(facet3D.vertex[n + 1])));
                ++n;
            }
        }
    }

    public void fillObject3D(Object3D object3D, Color color, Color color2) {
        for (int i = 0; i < object3D.getNFacets(); ++i) {
            Polygon polygon = this.screenProject(object3D.getFacetPolygon(i));
            this.setColor(color2);
            this.fillPolygon(polygon);
            this.setColor(color);
            this.drawPolygon(polygon);
        }
    }

    public void fillConvexObject3D(Object3D object3D, Color color, Color color2, Point point) {
        for (int i = 0; i < object3D.getNFacets(); ++i) {
            Polygon3D polygon3D = object3D.getFacetPolygon(i);
            Vector3D vector3D = new Vector3D(polygon3D.getPoint(0), polygon3D.getPoint(1));
            Vector3D vector3D2 = new Vector3D(polygon3D.getPoint(1), polygon3D.getPoint(2));
            Vector3D vector3D3 = Vector3D.vectorialProduct(vector3D, vector3D2);
            if (!(this.rotationMatrix.mul((Point3D)vector3D3).z >= 0.0)) continue;
            Polygon polygon = this.screenProject(polygon3D);
            if (point != null) {
                polygon.translate(point.x, point.y);
            }
            if (color2 == null) {
                this.setColor(object3D.getFacet(i).getFillColor());
            } else {
                this.setColor(color2);
            }
            this.fillPolygon(polygon);
            if (color == null) {
                this.setColor(object3D.getFacet(i).getColor());
            } else {
                this.setColor(color);
            }
            this.drawPolygon(polygon);
        }
    }

    public void fillConvexObject3D(Object3D object3D, Color color, Color color2) {
        this.fillConvexObject3D(object3D, color, color2, null);
    }

    public void fillConvexObject3D(Object3D object3D) {
        this.fillConvexObject3D(object3D, null, null);
    }

    public void draw3DCurvedArrow(Point3D point3D, double d, Vector3D vector3D, Vector3D vector3D2, double d2, double d3, int n, int n2, int n3) {
        Vector3D vector3D3;
        Vector3D vector3D4;
        Point[] pointArray = new Point[2 * n2];
        Vector3D vector3D5 = Vector3D.vectorialProduct(vector3D, vector3D2);
        Point point = this.screenProject(point3D);
        for (int i = 0; i < n2; ++i) {
            double d4 = (double)i / ((double)n2 - 1.0) * (d3 - d2) + d2;
            vector3D4 = new Vector3D(vector3D2);
            vector3D4.mul(Math.cos(d4));
            vector3D3 = new Vector3D(vector3D5);
            vector3D3.mul(Math.sin(d4));
            vector3D4.add(vector3D3);
            vector3D4.mul(d);
            Point3D point3D2 = new Point3D(vector3D4);
            point3D2.add(point3D);
            Point point2 = this.screenProject(point3D2);
            Point point3 = new Point(point2);
            Point point4 = new Point(point2);
            point4.x -= point.x;
            point4.y -= point.y;
            double d5 = Math.sqrt(MathTools.sqr(point4.x) + MathTools.sqr(point4.y));
            point2.x -= (int)Math.rint((double)point4.x / d5 * (double)n / 2.0);
            point2.y -= (int)Math.rint((double)point4.y / d5 * (double)n / 2.0);
            point3.x += (int)Math.rint((double)point4.x / d5 * (double)n / 2.0);
            point3.y += (int)Math.rint((double)point4.y / d5 * (double)n / 2.0);
            pointArray[i] = point2;
            pointArray[2 * n2 - i - 1] = point3;
        }
        this.fillPolygon(pointArray);
        if (n3 == 1) {
            // empty if block
        }
        vector3D4 = new Vector3D(vector3D2);
        vector3D4.mul(Math.cos(d3 + 0.06283185307179587 * (double)MathTools.sign(d3 - d2)));
        vector3D3 = new Vector3D(vector3D5);
        vector3D3.mul(Math.sin(d3 + 0.06283185307179587 * (double)MathTools.sign(d3 - d2)));
        vector3D4.add(vector3D3);
        vector3D4.mul(d);
        vector3D4.add(point3D);
        this.drawArrow(new Point((pointArray[n2 - 1].x + pointArray[n2].x) / 2, (pointArray[n2 - 1].y + pointArray[n2].y) / 2), this.screenProject(vector3D4), n * 5);
    }

    public void clear() {
        this.graphics_clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void clear(Color color) {
        Color color2 = this.getColor();
        this.setColor(color);
        this.graphics_fillRect(0, 0, this.getWidth(), this.getHeight());
        this.setColor(color2);
    }

    public void clearInside(Color color) {
        Color color2 = this.getColor();
        this.setColor(color);
        this.graphics_fillRect(this.xScaler.getMargin1(), this.yScaler.getMargin1(), this.xScaler.getNPixelsUsed(), this.yScaler.getNPixelsUsed());
        this.setColor(color2);
    }

    public void setFont(Font font) {
        this.graphics_setFont(font);
    }

    public int getStringWidth(String string) {
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        return fontMetrics.stringWidth(string);
    }

    public int getStringHeight() {
        return this.graphics.getFontMetrics().getHeight();
    }

    public int getStringMinHeight() {
        return this.graphics.getFontMetrics().getHeight() * 12 / 17;
    }

    public int getStringHeight(String string) {
        FontMetrics fontMetrics = this.graphics.getFontMetrics();
        return fontMetrics.getHeight();
    }

    public int getCharHeight(char c) {
        String string = "aceimnorsuvwxz=";
        if (string.indexOf(c) >= 0) {
            return 8;
        }
        string = "bdfhklt";
        if (string.indexOf(c) >= 0) {
            return 10;
        }
        string = "gjpqy";
        if (string.indexOf(c) >= 0) {
            return 15;
        }
        return this.getStringHeight();
    }

    public void drawLine(double d, double d2, double d3, double d4) {
        this.graphics_drawLine(this.xScreen(d), this.yScreen(d2), this.xScreen(d3), this.yScreen(d4));
    }

    public void drawLineThick(double d, double d2, double d3, double d4) {
        this.drawLineThick(new Point(this.xScreen(d), this.yScreen(d2)), new Point(this.xScreen(d3), this.yScreen(d4)));
    }

    public void drawLineThick(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.drawLineThick(this.screenPoint(doublePoint), this.screenPoint(doublePoint2));
    }

    public void drawLine(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.drawLine(this.screenPoint(doublePoint), this.screenPoint(doublePoint2));
    }

    public void drawLine(Point point, Point point2) {
        this.graphics_drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void drawLineThick(Point point, Point point2) {
        if (Math.abs(point.x - point2.x) < Math.abs(point.y - point2.y)) {
            this.graphics_fillPolygon(new Polygon(new int[]{point.x - 1, point.x + 1, point2.x + 1, point2.x - 1}, new int[]{point.y, point.y, point2.y, point2.y}, 4));
        } else {
            this.graphics_fillPolygon(new Polygon(new int[]{point.x, point.x, point2.x, point2.x}, new int[]{point.y - 1, point.y + 1, point2.y + 1, point2.y - 1}, 4));
        }
    }

    public static void drawLineThick(Graphics graphics, Point point, Point point2) {
        if (Math.abs(point.x - point2.x) < Math.abs(point.y - point2.y)) {
            graphics.fillPolygon(new Polygon(new int[]{point.x - 1, point.x + 1, point2.x + 1, point2.x - 1}, new int[]{point.y, point.y, point2.y, point2.y}, 4));
        } else {
            graphics.fillPolygon(new Polygon(new int[]{point.x, point.x, point2.x, point2.x}, new int[]{point.y - 1, point.y + 1, point2.y + 1, point2.y - 1}, 4));
        }
    }

    public void drawHorizontalLineThick(double d, double d2, double d3, int n, int n2) {
        int n3 = this.yScreen(d3);
        switch (n2) {
            case 7: {
                n3 -= n / 2;
                break;
            }
            case 10: {
                n3 -= n;
            }
        }
        this.graphics_fillRect(this.xScreen(d), n3, this.xScreen(d2) - this.xScreen(d), n);
    }

    public void moveTo(DoublePoint doublePoint) {
        this.moveTo(this.screenPoint(doublePoint));
    }

    public void moveTo(double d, double d2) {
        this.moveTo(this.screenPoint(d, d2));
    }

    public void moveTo(Point point) {
        this.lastPoint = point;
    }

    public void drawTo(double d, double d2) {
        this.drawTo(this.screenPoint(d, d2));
    }

    public void drawTo(DoublePoint doublePoint) {
        this.drawTo(this.screenPoint(doublePoint));
    }

    public void drawTo(Point point) {
        this.drawLine(this.lastPoint, point);
        this.moveTo(point);
    }

    public void drawToThick(double d, double d2) {
        this.drawToThick(this.screenPoint(d, d2));
    }

    public void drawToThick(Point point) {
        this.drawLineThick(this.lastPoint, point);
        this.moveTo(point);
    }

    public void drawVerticalDashedLine(int n, int n2, int n3, int n4) {
        for (int i = n2; i < n3; i += 2 * n4) {
            this.drawLine(new Point(n, i), new Point(n, i + n4));
        }
    }

    public void drawRect(double d, double d2, double d3, double d4) {
        int n = this.xScreen(d);
        int n2 = this.yScreen(d2);
        int n3 = this.xScreen(d + d3);
        int n4 = this.yScreen(d2 + d4);
        this.graphics_drawRect(Math.min(n, n3), Math.min(n2, n4), Math.abs(n3 - n), Math.abs(n4 - n2));
    }

    public void drawRect(Point point, Dimension dimension) {
        this.graphics_drawRect(point.x, point.y, dimension.width, dimension.height);
    }

    public void drawRect(Point point, Point point2) {
        int n = Math.min(point.x, point2.x);
        int n2 = Math.abs(point2.x - point.x);
        int n3 = Math.min(point.y, point2.y);
        int n4 = Math.abs(point2.y - point.y);
        this.graphics_drawRect(n, n3, n2, n4);
    }

    public void drawRoundRect(Point point, Dimension dimension, Dimension dimension2) {
        this.graphics_drawRoundRect(point.x, point.y, dimension.width, dimension.height, dimension2.width, dimension2.height);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.fillRect(new DoublePoint(d, d2), new DoublePoint(d + d3, d2 + d4));
    }

    public void fillRect(DoublePoint doublePoint, DoublePoint doublePoint2) {
        int n = this.xScreen(doublePoint.x);
        int n2 = this.yScreen(doublePoint.y);
        int n3 = this.xScreen(doublePoint2.x);
        int n4 = this.yScreen(doublePoint2.y);
        this.graphics_fillRect(Math.min(n, n3), Math.min(n2, n4), Math.abs(n3 - n), Math.abs(n4 - n2));
    }

    public void fillRect(Point point, Dimension dimension) {
        this.graphics_fillRect(point.x, point.y, dimension.width, dimension.height);
    }

    public void fillRect(Point point, Point point2) {
        int n = Math.min(point.x, point2.x);
        int n2 = Math.abs(point2.x - point.x);
        int n3 = Math.min(point.y, point2.y);
        int n4 = Math.abs(point2.y - point.y);
        this.graphics_fillRect(n, n3, n2, n4);
    }

    public void fillRoundRect(Point point, Dimension dimension, Dimension dimension2) {
        this.graphics_fillRoundRect(point.x, point.y, dimension.width, dimension.height, dimension2.width, dimension2.height);
    }

    public void drawPolygon(double[] dArray, double[] dArray2) {
        this.graphics_drawPolygon(this.polyScreen(dArray, dArray2));
    }

    public void drawPolygon(DoublePoint[] doublePointArray) {
        this.graphics_drawPolygon(this.polyScreen(doublePointArray));
    }

    public void drawPolygon(Polygon polygon) {
        this.graphics_drawPolygon(polygon);
    }

    public void drawPolyline(DoublePoint[] doublePointArray) {
        Polygon polygon = this.polyScreen(doublePointArray);
        this.graphics_drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawPolyline(double[] dArray, double[] dArray2) {
        Polygon polygon = this.polyScreen(dArray, dArray2);
        this.graphics_drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void drawPolyline(Polygon polygon) {
        this.graphics_drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void fillPolygon(double[] dArray, double[] dArray2) {
        this.graphics_fillPolygon(this.polyScreen(dArray, dArray2));
    }

    public void fillPolygon(DoublePoint[] doublePointArray) {
        this.graphics_fillPolygon(this.polyScreen(doublePointArray));
    }

    public void fillPolygon(Polygon polygon) {
        this.graphics_fillPolygon(polygon);
    }

    public void fillPolygon(Point[] pointArray) {
        int n = pointArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = pointArray[i].x;
            nArray2[i] = pointArray[i].y;
        }
        this.fillPolygon(new Polygon(nArray, nArray2, n));
    }

    public void drawArrowThick(DoublePoint doublePoint, DoublePoint doublePoint2, int n) {
        this.drawLineThick(this.screenPoint(doublePoint), this.screenPoint(doublePoint2));
        this.drawArrow(this.screenPoint(doublePoint), this.screenPoint(doublePoint2), n);
    }

    public void drawArrowThick(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.drawArrowThick(doublePoint, doublePoint2, -1);
    }

    public void drawDoubleArrowThick(DoublePoint doublePoint, DoublePoint doublePoint2, int n, int n2) {
        this.drawLineThick(this.screenPoint(doublePoint), this.screenPoint(doublePoint2));
        this.drawDoubleArrow(doublePoint, doublePoint2, n, n2);
    }

    public void drawDoubleArrowThick(Point point, Point point2, int n, int n2) {
        this.drawLineThick(point, point2);
        this.drawDoubleArrow(point, point2, n, n2);
    }

    public void drawArrow(DoublePoint doublePoint, DoublePoint doublePoint2, int n) {
        this.drawArrow(this.screenPoint(doublePoint), this.screenPoint(doublePoint2), n);
    }

    public void drawArrow(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.drawArrow(doublePoint, doublePoint2, -1);
    }

    public void drawArrow(Point point, Point point2) {
        this.drawArrow(point, point2, -1);
    }

    public void drawArrowThick(Point point, Point point2) {
        this.drawLineThick(point, point2);
        this.drawArrow(point, point2, -1);
    }

    public void drawArrowThick(Point point, Point point2, int n) {
        this.drawLineThick(point, point2);
        this.drawArrow(point, point2, n);
    }

    public void drawArrow(Point point, Point point2, int n) {
        if (n < 15) {
            this.graphics_drawLine(point.x, point.y, point2.x, point2.y);
        } else {
            this.drawLineThick(point, point2);
        }
        float f = point2.x - point.x;
        float f2 = point2.y - point.y;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if (f3 > (float)2) {
            Point point3 = new Point(point2.x, point2.y);
            Point point4 = new Point(point2.x, point2.y);
            int n2 = 15;
            if (this.getWidth() < 250) {
                n2 = 10;
            }
            if (n >= 0) {
                n2 = n;
            }
            float f4 = (float)Math.cos(0.39269908169872414);
            float f5 = (float)Math.sin(0.39269908169872414);
            point3.x += (int)Math.rint((float)n2 * (-f4 * f + f5 * f2) / f3);
            point3.y += (int)Math.rint((float)n2 * (-f5 * f - f4 * f2) / f3);
            point4.x += (int)Math.rint((float)n2 * (-f4 * f - f5 * f2) / f3);
            point4.y += (int)Math.rint((float)n2 * (f5 * f - f4 * f2) / f3);
            int[] nArray = new int[]{point2.x, point3.x, point4.x};
            int[] nArray2 = new int[]{point2.y, point3.y, point4.y};
            this.graphics_fillPolygon(nArray, nArray2, 3);
            this.graphics_drawPolygon(nArray, nArray2, 3);
        }
    }

    public void drawDoubleArrow(DoublePoint doublePoint, DoublePoint doublePoint2, int n) {
        this.drawDoubleArrow(this.screenPoint(doublePoint), this.screenPoint(doublePoint2), n);
    }

    public void drawDoubleArrow(DoublePoint doublePoint, DoublePoint doublePoint2, int n, int n2) {
        this.drawDoubleArrow(this.screenPoint(doublePoint), this.screenPoint(doublePoint2), n, n2);
    }

    public void drawDoubleArrow(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.drawDoubleArrow(doublePoint, doublePoint2, -1);
    }

    public void drawDoubleArrow(Point point, Point point2) {
        this.drawDoubleArrow(point, point2, -1);
    }

    public void drawDoubleArrow(Point point, Point point2, int n) {
        this.drawDoubleArrow(point, point2, n, 0);
    }

    public void drawDoubleArrow(Point point, Point point2, int n, int n2) {
        if (n < 15) {
            this.graphics_drawLine(point.x, point.y, point2.x, point2.y);
        } else {
            this.drawLineThick(point, point2);
        }
        int n3 = 15;
        if (this.getWidth() < 250) {
            n3 = 10;
        }
        if (n >= 0) {
            n3 = n;
        }
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (point.x == point2.x) {
            int n4;
            int n5;
            int n6 = (int)((double)n3 * Math.tan(0.39269908169872414));
            int n7 = point.x;
            if (n2 == 1 || n2 == 2 && d3 < (double)(2 * n3)) {
                n5 = Math.max(point.y, point2.y);
                n4 = Math.min(point.y, point2.y);
            } else {
                n5 = Math.min(point.y, point2.y);
                n4 = Math.max(point.y, point2.y);
            }
            if (n < 15) {
                this.graphics_fillPolygon(new int[]{n7, n7 + n6, n7 - n6}, new int[]{n5, n5 + n3, n5 + n3}, 3);
                this.graphics_fillPolygon(new int[]{n7, n7 + n6, n7 - n6}, new int[]{n4, n4 - n3, n4 - n3}, 3);
            } else {
                this.graphics_fillPolygon(new int[]{n7 - 1, n7, n7 + n6, n7 - n6 - 1}, new int[]{n5, n5, n5 + n3, n5 + n3}, 4);
                this.graphics_fillPolygon(new int[]{n7 - 1, n7, n7 + n6 + 1, n7 - n6 - 1}, new int[]{n4, n4, n4 - n3, n4 - n3}, 4);
            }
            return;
        }
        if (n2 == 1 || n2 == 2 && d3 < (double)(2 * n3)) {
            d = -d;
            d2 = -d2;
        }
        if (d3 > 0.0) {
            n3 = (int)((double)n3 * Math.cos(0.39269908169872414));
            Point point3 = new Point(point2.x, point2.y);
            Point point4 = new Point(point2.x, point2.y);
            double d4 = Math.cos(0.39269908169872414);
            double d5 = Math.sin(0.39269908169872414);
            point3.x += (int)Math.rint((double)n3 * (-d4 * d + d5 * d2) / d3);
            point3.y += (int)Math.rint((double)n3 * (-d5 * d - d4 * d2) / d3);
            point4.x += (int)Math.rint((double)n3 * (-d4 * d - d5 * d2) / d3);
            point4.y += (int)Math.rint((double)n3 * (d5 * d - d4 * d2) / d3);
            this.graphics_fillPolygon(new int[]{point2.x, point3.x, point4.x}, new int[]{point2.y, point3.y, point4.y}, 3);
            point3 = new Point(point.x, point.y);
            point4 = new Point(point.x, point.y);
            d = -d;
            d2 = -d2;
            point3.x += (int)Math.rint((double)n3 * (-d4 * d + d5 * d2) / d3);
            point3.y += (int)Math.rint((double)n3 * (-d5 * d - d4 * d2) / d3);
            point4.x += (int)Math.rint((double)n3 * (-d4 * d - d5 * d2) / d3);
            point4.y += (int)Math.rint((double)n3 * (d5 * d - d4 * d2) / d3);
            this.graphics_fillPolygon(new int[]{point.x, point3.x, point4.x}, new int[]{point.y, point3.y, point4.y}, 3);
        }
    }

    public void drawVerticalDoubleArrow(int n, int n2, int n3) {
        if (Math.abs(n3 - n2) > 20) {
            this.drawVerticalDoubleArrow(n, n2, n3, 0);
        } else {
            this.drawVerticalDoubleArrow(n, n2, n3, 1);
        }
    }

    public void drawVerticalDoubleArrow(int n, int n2, int n3, int n4) {
        this.graphics_drawLine(n, n2, n, n3);
        int n5 = Math.min(n2, n3);
        int n6 = Math.max(n2, n3);
        int n7 = 4;
        if (n4 == 0) {
            this.graphics_fillPolygon(new int[]{n, n - n7, n + n7}, new int[]{n5, n5 + 2 * n7, n5 + 2 * n7}, 3);
            this.graphics_fillPolygon(new int[]{n, n - n7, n + n7, 3}, new int[]{n6, n6 - 2 * n7, n6 - 2 * n7}, 3);
        } else {
            this.graphics_fillPolygon(new int[]{n, n - n7, n + n7}, new int[]{n6, n6 + 2 * n7, n6 + 2 * n7}, 3);
            this.graphics_fillPolygon(new int[]{n, n - n7, n + n7}, new int[]{n5, n5 - 2 * n7, n5 - 2 * n7}, 3);
        }
    }

    public void drawHorizontalDoubleArrow(int n, int n2, int n3) {
        if (Math.abs(n2 - n) > 20) {
            this.drawHorizontalDoubleArrow(n, n2, n3, 0);
        } else {
            this.drawHorizontalDoubleArrow(n, n2, n3, 1);
        }
    }

    public void drawHorizontalDoubleArrow(int n, int n2, int n3, int n4) {
        this.graphics_drawLine(n, n3, n2, n3);
        int n5 = 4;
        if (n4 == 0) {
            this.graphics_fillPolygon(new int[]{n, n + 2 * n5, n + 2 * n5}, new int[]{n3, n3 - n5, n3 + n5}, 3);
            this.graphics_fillPolygon(new int[]{n2, n2 - 2 * n5, n2 - 2 * n5}, new int[]{n3, n3 - n5, n3 + n5}, 3);
        } else {
            this.graphics_fillPolygon(new int[]{n2, n2 + 2 * n5, n2 + 2 * n5}, new int[]{n3, n3 - n5, n3 + n5}, 3);
            this.graphics_fillPolygon(new int[]{n, n - 2 * n5, n - 2 * n5}, new int[]{n3, n3 - n5, n3 + n5}, 3);
        }
    }

    public void drawBigHorizontalDoubleArrow(int n, int n2) {
        this.setColor(Color.magenta);
        this.graphics_fillPolygon(new int[]{n - 10, n - 28, n - 10, n - 10, n + 10, n + 10, n + 28, n + 10, n + 10, n - 10}, new int[]{n2 - 10, n2, n2 + 10, n2 + 4, n2 + 4, n2 + 10, n2, n2 - 10, n2 - 4, n2 - 4}, 10);
    }

    public void drawThinHorizontalArrow(int n, int n2, int n3, int n4) {
        this.graphics_drawLine(n, n3, n2, n3);
        if (n < n2) {
            this.graphics_drawLine(n2, n3, n2 - n4, n3 - n4);
            this.graphics_drawLine(n2, n3, n2 - n4, n3 + n4);
        } else {
            this.graphics_drawLine(n, n3, n + n4, n3 - n4);
            this.graphics_drawLine(n, n3, n - n4, n3 + n4);
        }
    }

    public void drawThin2HorizontalArrow(int n, int n2, int n3, int n4) {
        if (n < n2) {
            this.graphics_drawLine(n, n3 - 1, n2 - 1, n3 - 1);
            this.graphics_drawLine(n, n3 + 1, n2 - 1, n3 + 1);
            this.graphics_drawLine(n2, n3, n2 - n4, n3 - n4);
            this.graphics_drawLine(n2, n3, n2 - n4, n3 + n4);
        } else {
            this.graphics_drawLine(n - 1, n3 - 1, n2, n3 - 1);
            this.graphics_drawLine(n - 1, n3 + 1, n2, n3 + 1);
            this.graphics_drawLine(n, n3, n + n4, n3 - n4);
            this.graphics_drawLine(n, n3, n - n4, n3 + n4);
        }
    }

    public void drawBigHorizontalArrow(int n, int n2, int n3, int n4, int n5) {
        if (n < n2) {
            this.graphics_fillPolygon(new int[]{n, n2 - n5, n2 - n5, n2, n2 - n5, n2 - n5, n, n}, new int[]{n3 - n4, n3 - n4, n3 - n5, n3, n3 + n5, n3 + n4, n3 + n4, n3 - n4}, 8);
        } else {
            this.graphics_fillPolygon(new int[]{n, n2 + n5, n2 + n5, n2, n2 + n5, n2 + n5, n, n}, new int[]{n3 - n4, n3 - n4, n3 - n5, n3, n3 + n5, n3 + n4, n3 + n4, n3 - n4}, 8);
        }
    }

    public void drawBigVerticalDoubleArrow(int n, int n2) {
        this.setColor(Color.magenta);
        this.graphics_fillPolygon(new int[]{n - 10, n, n + 10, n + 4, n + 4, n + 10, n, n - 10, n - 4, n - 4}, new int[]{n2 - 10, n2 - 28, n2 - 10, n2 - 10, n2 + 10, n2 + 10, n2 + 28, n2 + 10, n2 + 10, n2 - 10}, 10);
    }

    public void drawPixel(DoublePoint doublePoint) {
        int n = this.xScreen(doublePoint.x);
        int n2 = this.yScreen(doublePoint.y);
        this.graphics_drawLine(n, n2, n, n2);
    }

    public void drawPixel(Point point) {
        this.graphics_drawLine(point.x, point.y, point.x, point.y);
    }

    public void drawCross(double d, double d2, double d3, double d4) {
        this.drawLine(d - d3 / (double)2, d2, d + d3 / (double)2, d2);
        this.drawLine(d, d2 - d4 / (double)2, d, d2 + d4);
    }

    public void drawCross(DoublePoint doublePoint, Integer n) {
        int n2 = n;
        int n3 = this.xScreen(doublePoint.x);
        int n4 = this.yScreen(doublePoint.y);
        this.graphics_drawLine(n3 - n2 / 2, n4, n3 + n2 / 2, n4);
        this.graphics_drawLine(n3, n4 - n2 / 2, n3, n4 + n2 / 2);
    }

    public void drawDisk(double d, double d2, double d3) {
        this.drawOval(d, d2, (double)2 * d3, (double)2 * d3);
    }

    public void drawOval(double d, double d2, double d3, double d4) {
        int n = this.xScreen(d - d3 / (double)2);
        int n2 = this.yScreen(d2 - d4 / (double)2);
        int n3 = this.xScreen(d + d3 / (double)2);
        int n4 = this.yScreen(d2 + d4 / (double)2);
        this.graphics_drawOval(Math.min(n, n3), Math.min(n2, n4), Math.abs(n3 - n), Math.abs(n4 - n2));
    }

    public void fillDisk(double d, double d2, double d3) {
        this.fillOval(d, d2, (double)2 * d3, (double)2 * d3);
    }

    public void fillDisk(DoublePoint doublePoint, double d) {
        this.fillDisk(doublePoint.x, doublePoint.y, d);
    }

    public void fillOval(double d, double d2, double d3, double d4) {
        int n = this.xScreen(d - d3 / (double)2);
        int n2 = this.yScreen(d2 - d4 / (double)2);
        int n3 = this.xScreen(d + d3 / (double)2);
        int n4 = this.yScreen(d2 + d4 / (double)2);
        this.graphics_fillOval(Math.min(n, n3), Math.min(n2, n4), Math.abs(n3 - n), Math.abs(n4 - n2));
    }

    public void fillDisk(double d, double d2, Integer n) {
        this.fillDisk(this.screenPoint(d, d2), (int)n);
    }

    public void fillDisk(DoublePoint doublePoint, Integer n) {
        this.fillDisk(this.screenPoint(doublePoint), (int)n);
    }

    public void fillDisk(Point point, int n) {
        int n2 = point.x - n;
        int n3 = point.y - n;
        int n4 = point.x + n;
        int n5 = point.y + n;
        this.graphics_fillOval(point.x - n, point.y - n, 2 * n, 2 * n);
    }

    public void drawDisk(double d, double d2, Integer n) {
        this.drawDisk(this.screenPoint(new DoublePoint(d, d2)), (int)n);
    }

    public void drawDisk(Point point, int n) {
        int n2 = point.x - n;
        int n3 = point.y - n;
        int n4 = point.x + n;
        int n5 = point.y + n;
        this.graphics_drawOval(point.x - n, point.y - n, 2 * n, 2 * n);
    }

    public void drawDisk(DoublePoint doublePoint, Integer n) {
        this.drawDisk(doublePoint.x, doublePoint.y, n);
    }

    public void drawBigCross(Point point, int n, int n2) {
        this.graphics_fillRect(point.x - n2, point.y - n, 2 * n2 + 1, 2 * n + 1);
        this.graphics_fillRect(point.x - n, point.y - n2, 2 * n + 1, 2 * n2 + 1);
    }

    public TeXDimension drawTeX(String string, DoublePoint doublePoint, int n) {
        return this.drawTeX(string, this.screenPoint(doublePoint), n);
    }

    public TeXDimension drawTeX(String string, Point point, int n) {
        TeXDimension teXDimension = this.drawTeX(string, point, false);
        Point point2 = new Point(point);
        point2.y -= teXDimension.descent;
        switch (n) {
            case 1: {
                break;
            }
            case 0: {
                point2.x -= teXDimension.width / 2;
                break;
            }
            case 2: {
                point2.x -= teXDimension.width;
                break;
            }
            case 4: {
                point2.y += teXDimension.height;
                break;
            }
            case 3: {
                point2.x -= teXDimension.width / 2;
                point2.y += teXDimension.height;
                break;
            }
            case 5: {
                point2.x -= teXDimension.width;
                point2.y += teXDimension.height;
                break;
            }
            case 6: {
                point2.y += teXDimension.height / 2;
                break;
            }
            case 7: {
                point2.x -= teXDimension.width / 2;
                point2.y += teXDimension.height / 2;
                break;
            }
            case 8: {
                point2.x -= teXDimension.width;
                point2.y += teXDimension.height / 2;
            }
        }
        return this.drawTeX(string, point2, true);
    }

    public TeXDimension drawTeX(String string, Point point, boolean bl) {
        TeXTokenizer teXTokenizer = new TeXTokenizer(string);
        Point point2 = new Point(point);
        Point point3 = new Point(point);
        TeXDimension teXDimension = new TeXDimension(0, 0);
        TeXDimension teXDimension2 = new TeXDimension(0, 0);
        teXDimension.height = this.getStringMinHeight();
        try {
            while (teXTokenizer.hasMoreTokens()) {
                int n;
                teXTokenizer.nextToken();
                switch (teXTokenizer.getType()) {
                    case 0: {
                        teXDimension.width = this.getStringWidth(teXTokenizer.getToken());
                        if (bl) {
                            this.drawString(teXTokenizer.getToken(), point2, 1);
                        }
                        ++teXDimension.width;
                        point2.x += teXDimension.width;
                        break;
                    }
                    case 4: {
                        teXDimension.width = this.getStringWidth(teXTokenizer.getToken());
                        if (bl) {
                            this.drawString(teXTokenizer.getToken(), point2, 1);
                        }
                        point2.x += teXDimension.width;
                        break;
                    }
                    case 3: {
                        if (teXTokenizer.getToken().equals("rightarrow")) {
                            teXDimension.width = 12;
                            teXDimension.height = 10;
                            if (bl) {
                                this.drawThinHorizontalArrow(point2.x + 1, point2.x + 11, point2.y - 5, 2);
                            }
                            point2.x += teXDimension.width + 2;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("Rightarrow")) {
                            teXDimension.width = 12;
                            teXDimension.height = 10;
                            if (bl) {
                                this.drawThin2HorizontalArrow(point2.x + 1, point2.x + 11, point2.y - 5, 2);
                            }
                            point2.x += teXDimension.width + 2;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("hbar")) {
                            teXDimension.width = this.getStringWidth("h");
                            if (bl) {
                                this.drawString("h", point2, 1);
                                this.drawLine(new Point(point2.x, point2.y - 5), new Point(point2.x + 4, point2.y - 9));
                            }
                            ++teXDimension.width;
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("Gcal")) {
                            teXDimension.width = 15;
                            n = point2.x;
                            int n2 = point2.y - 10;
                            if (bl) {
                                this.getGraphics().drawPolyline(new int[]{n + 8, n + 9, n + 8, n + 6, n + 3, n + 2, n + 1, n + 2, n + 4, n + 7, n + 9, n + 7, n + 5, n + 2}, new int[]{n2 + 3, n2 + 2, n2 + 0, n2 + 0, n2 + 2, n2 + 4, n2 + 6, n2 + 9, n2 + 10, n2 + 10, n2 + 7, n2 + 12, n2 + 13, n2 + 13}, 13);
                            }
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("rangle")) {
                            teXDimension.width = this.getStringWidth("h");
                            teXDimension.width /= 2;
                            if (bl) {
                                this.drawLine(new Point(point2.x, point2.y + 1), new Point(point2.x + teXDimension.width, point2.y - teXDimension.height / 4));
                                this.drawLine(new Point(point2.x + teXDimension.width, point2.y - teXDimension.height / 4), new Point(point2.x, point2.y - teXDimension.height / 2 - 2));
                            }
                            teXDimension.width += 2;
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("bullet")) {
                            teXDimension = new TeXDimension(9, 7);
                            if (bl) {
                                this.fillDisk(new Point(point2.x + 3, point2.y - 3), 3);
                            }
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals(",")) {
                            teXDimension = new TeXDimension(5, 2);
                            point2.x += 2;
                            break;
                        }
                        if (teXTokenizer.getToken().equals(":")) {
                            teXDimension = new TeXDimension(5, 4);
                            point2.x += 4;
                            break;
                        }
                        if (teXTokenizer.getToken().equals(";")) {
                            teXDimension = new TeXDimension(5, 6);
                            point2.x += 6;
                            break;
                        }
                        System.out.println(String.valueOf("Symbole inconnu : ").concat(String.valueOf(teXTokenizer.getToken())));
                        break;
                    }
                    case 2: {
                        if (teXTokenizer.getToken().equals("_")) {
                            point2.x += 0;
                            point2.y += 5;
                            teXTokenizer.nextToken();
                            teXDimension = this.drawTeX(teXTokenizer.getTeXToken(), point2, bl);
                            teXDimension.height += 5;
                            teXDimension.descent = 5;
                            point2.x += teXDimension.width;
                            point2.y -= 5;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("^")) {
                            point2.x += 0;
                            point2.y -= 5;
                            teXTokenizer.nextToken();
                            teXDimension = this.drawTeX(teXTokenizer.getTeXToken(), point2, bl);
                            teXDimension.height += 6;
                            point2.x += teXDimension.width;
                            point2.y += 5;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("frac")) {
                            teXTokenizer.nextToken();
                            String string2 = teXTokenizer.getTeXToken();
                            teXTokenizer.nextToken();
                            String string3 = teXTokenizer.getTeXToken();
                            TeXDimension teXDimension3 = this.drawTeX(string2, point2, false);
                            TeXDimension teXDimension4 = this.drawTeX(string3, point2, false);
                            teXDimension.width = Math.max(teXDimension3.width, teXDimension4.width) + 10;
                            teXDimension.height = teXDimension3.height + teXDimension4.height + 5;
                            int n3 = point2.y - this.getStringMinHeight() * 10 / 25;
                            if (bl) {
                                this.drawLine(new Point(point2.x + 1, n3), new Point(point2.x + teXDimension.width - 4, n3));
                                this.drawTeX(string2, new Point(point2.x + (teXDimension.width - teXDimension3.width) / 2, n3 - 2 - teXDimension3.descent), true);
                                this.drawTeX(string3, new Point(point2.x + (teXDimension.width - teXDimension4.width) / 2, n3 + 2 + teXDimension4.height - teXDimension4.descent), true);
                            }
                            teXDimension.descent = Math.max(teXDimension.descent, teXDimension4.height + n3 + 2 - point2.y);
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("sqrt")) {
                            teXTokenizer.nextToken();
                            String string4 = teXTokenizer.getTeXToken();
                            teXDimension = this.drawTeX(string4, point2, false);
                            if (bl) {
                                this.drawTeX(string4, new Point(point2.x + 6, point2.y), true);
                                this.moveTo(new Point(point2.x, point2.y - teXDimension.height / 2 + teXDimension.descent));
                                this.drawTo(new Point(point2.x + 2, point2.y + teXDimension.descent));
                                this.drawTo(new Point(point2.x + 6, point2.y - teXDimension.height + teXDimension.descent));
                                this.drawTo(new Point(point2.x + 6 + teXDimension.width, point2.y - teXDimension.height + teXDimension.descent));
                            }
                            teXDimension.width += 6;
                            teXDimension.height += 3;
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("int")) {
                            teXTokenizer.nextToken();
                            String string5 = teXTokenizer.getTeXToken();
                            teXDimension = this.drawTeX(string5, point2, false);
                            if (bl) {
                                this.drawTeX(string5, new Point(point2.x + 10, point2.y), true);
                                this.moveTo(new Point(point2.x + 4, point2.y + teXDimension.descent - 3));
                                this.drawTo(new Point(point2.x + 6, point2.y + teXDimension.descent - teXDimension.height + 3));
                                this.graphics.drawArc(point2.x - 4, point2.y + teXDimension.descent - 10, 10, 10, 250, 120);
                                this.graphics.drawArc(point2.x + 6, point2.y + teXDimension.descent - teXDimension.height - 1, 10, 10, 190, -120);
                            }
                            teXDimension.width += 10;
                            teXDimension.height += 3;
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("brackett")) {
                            teXTokenizer.nextToken();
                            String string6 = teXTokenizer.getTeXToken();
                            teXDimension = this.drawTeX(string6, point2, false);
                            if (bl) {
                                this.drawTeX(string6, new Point(point2.x + 4, point2.y), true);
                                this.moveTo(new Point(point2.x + 3, point2.y - teXDimension.height + teXDimension.descent + 2));
                                this.drawTo(new Point(point2.x, point2.y - teXDimension.height + teXDimension.descent + 2));
                                this.drawTo(new Point(point2.x, point2.y + teXDimension.descent + 2));
                                this.drawTo(new Point(point2.x + 3, point2.y + teXDimension.descent + 2));
                                this.moveTo(new Point(point2.x + 3 + teXDimension.width, point2.y - teXDimension.height + teXDimension.descent + 2));
                                this.drawTo(new Point(point2.x + 6 + teXDimension.width, point2.y - teXDimension.height + teXDimension.descent + 2));
                                this.drawTo(new Point(point2.x + 6 + teXDimension.width, point2.y + teXDimension.descent + 2));
                                this.drawTo(new Point(point2.x + 3 + teXDimension.width, point2.y + teXDimension.descent + 2));
                            }
                            teXDimension.width += 10;
                            teXDimension.height += 6;
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("vec")) {
                            teXTokenizer.nextToken();
                            String string7 = teXTokenizer.getTeXToken();
                            teXDimension = this.drawTeX(string7, point2, false);
                            if (bl) {
                                this.drawTeX(string7, new Point(point2.x, point2.y), true);
                                this.drawThinHorizontalArrow(point2.x, point2.x + teXDimension.width, point2.y - teXDimension.height + teXDimension.descent - 3, 2);
                            }
                            teXDimension.height += 6;
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("mbox")) {
                            teXTokenizer.nextToken();
                            teXDimension.width = this.getStringWidth(teXTokenizer.getToken());
                            if (bl) {
                                this.drawString(teXTokenizer.getToken(), point2, 1);
                            }
                            ++teXDimension.width;
                            point2.x += teXDimension.width;
                            break;
                        }
                        if (teXTokenizer.getToken().equals("red")) {
                            this.setColor(Color.red);
                            break;
                        }
                        if (teXTokenizer.getToken().equals("yellow")) {
                            this.setColor(Color.yellow);
                            break;
                        }
                        if (teXTokenizer.getToken().equals("white")) {
                            this.setColor(Color.white);
                            break;
                        }
                        if (!teXTokenizer.getToken().equals("black")) break;
                        this.setColor(Color.black);
                        break;
                    }
                    case 1: {
                        teXDimension = this.drawTeX(teXTokenizer.getToken(), point2, bl);
                        point2.x += teXDimension.width;
                    }
                }
                n = teXDimension2.descent;
                teXDimension2.descent = Math.max(teXDimension2.descent, teXDimension.descent);
                teXDimension2.height = Math.max(teXDimension2.height - n, teXDimension.height - teXDimension.descent) + teXDimension2.descent;
            }
        }
        catch (Exception exception) {
            System.out.println(String.valueOf("Exception : ").concat(String.valueOf(exception)));
        }
        teXDimension2.width = point2.x - point3.x;
        return teXDimension2;
    }

    public Dimension drawString(String string, Point point, int n) {
        int n2 = point.x;
        int n3 = point.y;
        Dimension dimension = new Dimension(this.getStringWidth(string), this.getStringHeight());
        switch (n) {
            case 1: {
                this.graphics_drawString(string, n2, n3);
                break;
            }
            case 0: {
                this.graphics_drawString(string, n2 - dimension.width / 2, n3);
                break;
            }
            case 2: {
                this.graphics_drawString(string, n2 - dimension.width, n3);
                break;
            }
            case 4: {
                this.graphics_drawString(string, n2, n3 + dimension.height);
                break;
            }
            case 3: {
                this.graphics_drawString(string, n2 - dimension.width / 2, n3 + dimension.height);
                break;
            }
            case 5: {
                this.graphics_drawString(string, n2 - dimension.width, n3 + dimension.height);
                break;
            }
            case 6: {
                this.graphics_drawString(string, n2, n3 + dimension.height / 2 - 1);
                break;
            }
            case 8: {
                this.graphics_drawString(string, n2 - dimension.width, n3 + dimension.height / 2 - 1);
                break;
            }
            case 7: {
                this.graphics_drawString(string, n2 - dimension.width / 2, n3 + dimension.height / 2 - 1);
            }
        }
        return dimension;
    }

    public void drawString(String string, DoublePoint doublePoint, int n) {
        this.drawString(string, this.screenPoint(doublePoint), n);
    }

    public void drawStringCBPixel(String string, int n, int n2) {
        this.drawString(string, new Point(n, n2), 0);
    }

    public void drawStringCB(String string, double d, double d2) {
        this.drawString(string, new DoublePoint(d, d2), 0);
    }

    public void drawStringLB(String string, Point point) {
        this.drawString(string, point, 1);
    }

    public void drawStringLB(String string, double d, double d2) {
        this.drawString(string, new DoublePoint(d, d2), 1);
    }

    public void drawStringRBPixel(String string, int n, int n2) {
        this.drawString(string, new Point(n, n2), 2);
    }

    public void drawStringRB(String string, double d, double d2) {
        this.drawString(string, new DoublePoint(d, d2), 2);
    }

    public void drawStringRT(String string, double d, double d2) {
        this.drawString(string, new DoublePoint(d, d2), 5);
    }

    public void drawStringLT(String string, double d, double d2) {
        this.drawString(string, new DoublePoint(d, d2), 4);
    }

    public void drawStringCTPixel(String string, int n, int n2) {
        this.drawString(string, new Point(n, n2), 3);
    }

    public void drawStringCT(String string, double d, double d2) {
        this.drawString(string, new DoublePoint(d, d2), 3);
    }

    public void drawStringRCPixel(String string, int n, int n2) {
        this.drawString(string, new Point(n, n2), 8);
    }

    public void drawStringRC(String string, double d, double d2) {
        this.drawString(string, new DoublePoint(d, d2), 8);
    }

    public Polygon polyScreen(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            PhyTools.issueMessage("ERROR : PhyGraphics.polyScreen(). x et y n'ont pas la m\u00eame taille");
        }
        int n = dArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.xScreen(dArray[i]);
            nArray2[i] = this.yScreen(dArray2[i]);
        }
        return new Polygon(nArray, nArray2, n);
    }

    public Polygon polyScreen(DoublePoint[] doublePointArray) {
        int n = doublePointArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.xScreen(doublePointArray[i].x);
            nArray2[i] = this.yScreen(doublePointArray[i].y);
        }
        return new Polygon(nArray, nArray2, n);
    }

    public void drawAttractAttention(DoublePoint doublePoint) {
        this.drawAttractAttention(this.screenPoint(doublePoint));
    }

    public void drawAttractAttention(Point point) {
        this.setColor(Color.red);
        this.drawDisk(new Point(point.x, point.y), 20);
        this.drawDisk(new Point(point.x, point.y), 21);
        this.drawDisk(new Point(point.x, point.y), 22);
    }
}

