/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import phy.control.HotPoint;
import phy.graphe.BufferedPanel;
import phy.util.DoublePoint;

public class BoiteStateChooser
extends BufferedPanel
implements KeyListener {
    private ActionListener actionListener;
    int minIndex = 0;
    int nx = 9;
    int ny = 9;
    int iCurrent = 0;
    int jCurrent = 0;

    public void setMinIndex(int n) {
        this.minIndex = n;
        this.iCurrent = Math.max(this.minIndex, this.iCurrent);
        this.jCurrent = Math.max(this.minIndex, this.jCurrent);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public BoiteStateChooser() {
        this.graphics.setWindow(-2.0, -2.0, 11.0, 11.0);
        this.setCursor(new Cursor(12));
        this.addKeyListener(this);
        this.setForeground(Color.white);
    }

    public void paintCore() {
        super.paintCore();
        this.requestFocus();
        this.graphics.setColor(this.getForeground());
        this.graphics.drawArrow(this.graphics.screenPoint(-1.0, 0.0), this.graphics.screenPoint(10.0, 0.0));
        this.graphics.drawArrow(this.graphics.screenPoint(0.0, -1.0), this.graphics.screenPoint(0.0, 10.0));
        for (int i = this.minIndex; i <= this.nx; ++i) {
            for (int j = this.minIndex; j <= this.ny; ++j) {
                if (i == this.iCurrent && j == this.jCurrent) {
                    this.graphics.setColor(Color.yellow);
                    this.graphics.fillDisk((double)i, (double)j, new Integer(5));
                    this.graphics.setColor(this.getForeground());
                    continue;
                }
                this.graphics.fillDisk((double)i, (double)j, new Integer(3));
            }
        }
        this.graphics.setColor(this.getForeground());
        this.graphics.drawTeX("n_1", new DoublePoint(9.0, -0.5), 6);
        this.graphics.drawTeX("n_2", new DoublePoint(-0.5, 9.0), 2);
        this.graphics.drawTeX(String.valueOf(String.valueOf(String.valueOf("n_1 = ").concat(String.valueOf(this.getX()))).concat(String.valueOf("; n_2 = "))).concat(String.valueOf(this.getY())), new DoublePoint(5.0, 10.0), 0);
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        int n = (this.nx - this.minIndex + 1) * (this.ny - this.minIndex + 1);
        boolean bl = false;
        for (int i = this.minIndex; i <= this.nx; ++i) {
            for (int j = this.minIndex; j <= this.ny; ++j) {
                this.getHotSpotVector().addElement(new HotPoint(this.xScreen(i), this.yScreen(j), 3));
            }
        }
    }

    public void hotSpotAction(int n) {
        this.iCurrent = n / (this.ny - this.minIndex + 1) + this.minIndex;
        this.jCurrent = n % (this.nx - this.minIndex + 1) + this.minIndex;
        this.repaint();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    public int getX() {
        return this.iCurrent;
    }

    public int getY() {
        return this.jCurrent;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                ++this.jCurrent;
                break;
            }
            case 40: {
                --this.jCurrent;
                break;
            }
            case 39: {
                ++this.iCurrent;
                break;
            }
            case 37: {
                --this.iCurrent;
                break;
            }
            default: {
                return;
            }
        }
        if (this.iCurrent < this.minIndex) {
            this.iCurrent = this.minIndex;
        } else if (this.iCurrent > this.nx) {
            this.iCurrent = this.nx;
        } else if (this.jCurrent < this.minIndex) {
            this.jCurrent = this.minIndex;
        } else if (this.jCurrent > this.ny) {
            this.jCurrent = this.ny;
        } else {
            this.repaint();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, ""));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

