/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.HotPoint;
import phy.graphe.BufferedPanel;
import phy.graphe.Scaler;
import phy.quanta.StationaryState;

public class CartesianViewer
extends BufferedPanel
implements ActionListener {
    boolean rotated = false;
    StationaryState state;
    Scaler scalerX = new Scaler();
    Scaler scalerY = new Scaler();

    public CartesianViewer(StationaryState stationaryState) {
        this.setCursor(new Cursor(12));
        this.state = stationaryState;
        this.scalerY.setBounds(1.3, -1.3);
        this.scalerX.setBounds(-6.0, 6.0);
    }

    public void setRotated(boolean bl) {
        this.rotated = bl;
    }

    public void sizeHasChanged() {
        if (this.rotated) {
            this.scalerX.setNPixels(this.getHeight());
            this.scalerY.setNPixels(this.getWidth());
        } else {
            this.scalerX.setNPixels(this.getWidth());
            this.scalerY.setNPixels(this.getHeight());
        }
    }

    public void paintCore() {
        int n = this.scalerY.getI(0.0);
        this.graphics.setColor(Color.white);
        if (this.rotated) {
            this.graphics.getGraphics().drawLine(n, this.scalerX.getI(-2.0), n, this.scalerX.getI(2.0));
        } else {
            this.graphics.getGraphics().drawLine(this.scalerX.getI(-2.0), n, this.scalerX.getI(2.0), n);
        }
        this.graphics.setColor(Color.green);
        int n2 = this.scalerY.getI(this.state.getRe());
        if (this.rotated) {
            this.graphics.getGraphics().fillRect(Math.min(n, n2), this.scalerX.getI(-1.0), Math.abs(n2 - n), this.scalerX.getDeltaI(1.0));
        } else {
            this.graphics.getGraphics().fillRect(this.scalerX.getI(-1.0), Math.min(n, n2), this.scalerX.getDeltaI(1.0), Math.abs(n2 - n));
        }
        this.graphics.setColor(Color.orange);
        n2 = this.scalerY.getI(this.state.getIm());
        if (this.rotated) {
            this.graphics.getGraphics().fillRect(Math.min(n, n2), this.scalerX.getI(0.0), Math.abs(n2 - n), this.scalerX.getDeltaI(1.0));
        } else {
            this.graphics.getGraphics().fillRect(this.scalerX.getI(0.0), Math.min(n, n2), this.scalerX.getDeltaI(1.0), Math.abs(n2 - n));
        }
        this.initHotSpots();
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        if (this.rotated) {
            this.getHotSpotVector().addElement(new HotPoint(this.scalerY.getI(this.state.getRe()), this.scalerX.getI(-0.5), 1));
            this.getHotSpotVector().addElement(new HotPoint(this.scalerY.getI(this.state.getIm()), this.scalerX.getI(0.5), 1));
        } else {
            this.getHotSpotVector().addElement(new HotPoint(this.scalerX.getI(-0.5), this.scalerY.getI(this.state.getRe()), 2));
            this.getHotSpotVector().addElement(new HotPoint(this.scalerX.getI(0.5), this.scalerY.getI(this.state.getIm()), 2));
        }
    }

    public void hotSpotHasMoved(int n) {
        int n2 = this.rotated ? this.getCurrentHotSpot().getX() : this.getCurrentHotSpot().getY();
        switch (n) {
            case 0: {
                this.state.setRe(this.scalerY.getX(n2));
                break;
            }
            case 1: {
                this.state.setIm(this.scalerY.getX(n2));
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
        super.actionPerformed(actionEvent);
    }
}

