/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Cursor;
import phy.dynaplot.PlotDataSet;
import phy.dynaplot.PlotWindow;
import phy.util.MathTools;

class DPLevelWindow
extends PlotWindow {
    double averageEnergy = 2.5;
    double barrierWidth = 0.2;
    double barrierHeight = 3.0;
    int nPoints = 50;
    double eta = 1.0;

    DPLevelWindow() {
        this.graphics.setWindow(-1.0, 0.0, 1.0, 6.0);
        this.showAxis = false;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.dataSet = new PlotDataSet(1, this.nPoints);
        this.dataSet.FillX(-1.0, 1.0);
        this.computeDataSet();
        this.setCurvePainted(true);
    }

    public void paintCore() {
        super.paintCore();
        this.graphics.setColor(Color.white);
        this.graphics.moveTo(this.graphics.getX1(), this.graphics.getY2());
        this.graphics.drawTo(this.graphics.getX1(), this.graphics.getY1() + 1.0E-4);
        this.graphics.drawTo(-this.barrierWidth / (double)2, this.graphics.getY1() + 1.0E-4);
        this.graphics.drawTo(-this.barrierWidth / (double)2, this.barrierHeight);
        this.graphics.drawTo(this.barrierWidth / (double)2, this.barrierHeight);
        this.graphics.drawTo(this.barrierWidth / (double)2, this.graphics.getY1() + 1.0E-4);
        this.graphics.drawTo(this.graphics.getX2() - 1.0E-4, this.graphics.getY1() + 1.0E-4);
        this.graphics.drawTo(this.graphics.getX2() - 1.0E-4, this.graphics.getY2());
    }

    public void initHotSpots() {
    }

    public void hotSpotHasMoved(int n) {
        double d = this.xUser(this.getCurrentHotSpot().getX());
        double d2 = this.yUser(this.getCurrentHotSpot().getY());
        this.barrierHeight = Math.min(5.0, Math.max(0.0, d2));
        this.barrierWidth = (double)2 * Math.max(0.0, Math.min(d, 0.9));
        this.computeDataSet();
        this.initHotSpots();
        this.refresh();
    }

    void setEta(double d) {
        this.eta = d;
    }

    void computeDataSet() {
        for (int i = 0; i < this.nPoints; ++i) {
            double d = this.dataSet.X(i);
            double d2 = d > 0.0 ? this.eta : 1.0 - this.eta;
            d = Math.abs(d);
            double d3 = this.barrierWidth;
            d3 = 0.0;
            if (d < d3 / (double)2) {
                this.dataSet.zData[0][i] = 0.0;
                continue;
            }
            d = (d - d3 / (double)2) / (1.0 - d3 / (double)2) * Math.PI;
            this.dataSet.zData[0][i] = (double)2 * MathTools.sqr(Math.sin(d)) * d2 / Math.sqrt(1.0 - d3 / (double)2);
        }
    }
}

